package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dao.FilerecordOutDao;
import com.bcxin.ars.dao.FilerecordStatusDao;
import com.bcxin.ars.dto.sb.FilerecordStatusSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.model.FilerecordOut;
import com.bcxin.ars.model.FilerecordStatus;
import com.bcxin.ars.service.FilerecordStatusService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@Service
@Transactional
public class FilerecordStatusServiceImpl implements FilerecordStatusService {

	@Autowired
	private FilerecordStatusDao filerecordStatusDao;

	@Autowired
	private FilerecordOutDao filerecordOutDao;

	@Autowired
	private FilerecordDao filerecordDao;


	@Autowired
	private ConfigUtils configUtils;

	/**
	 * 保存或更新
	 * @param filerecordStatus
	 */
	@Override
	public void saveOrUpdate(FilerecordStatus filerecordStatus) {
			filerecordStatusDao.save(filerecordStatus);
		}


	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public FilerecordStatus findById(long id){
		return filerecordStatusDao.findById(id);
	}



	@Override
	public void save(FilerecordStatus filerecordStatus) {
		filerecordStatusDao.save(filerecordStatus);
	}



	@Override
	public List<FilerecordStatus> findFilerecordStatusByTime(List<FilerecordStatus> filerecordStatusList,String startDate, String endDate){
		return filerecordStatusDao.findFilerecordStatusByTime(filerecordStatusList, startDate,  endDate);
	}
	@Override
	public void importBatchFilerecordStatus(List<Filerecord> filerecordList){

		List<FilerecordStatus> filerecordStatusList = new ArrayList<>();
		List<FilerecordOut> filerecordOutList = filerecordOutDao.findFilerecordOutByTime(DateUtil.getDateStrAfterToday(-2),DateUtil.getTomorrow());

		List<Filerecord> dbfilerecordList = filerecordDao.findFilerecordGroupByTime(DateUtil.getDateStrAfterToday(-2),DateUtil.getTomorrow());


		//已确认同步记录的集合
		for (Filerecord filerecord:dbfilerecordList) {
			FilerecordStatus filerecordStatus = new FilerecordStatus();
			filerecordStatus.setSynchstatus(Constants.SYNCHSTATUS_SUCESS);
			filerecordStatus.setSynchtype(filerecord.getSynchtype());
			filerecordStatus.setSynchdate(filerecord.getFilename().substring(filerecord.getFilename().lastIndexOf("_")+1,filerecord.getFilename().indexOf(".data")).substring(0,8));
			filerecordStatus.setCreateTime(new Date());
			filerecordStatus.setUpdateTime(filerecordStatus.getCreateTime());
			filerecordStatusList.add(filerecordStatus);

		}


		//未确认同步记录的集合
		for (Filerecord filerecord : dbfilerecordList) {
			int filerecordOutListSize = filerecordOutList.size();
			for (int i = 0; i < filerecordOutListSize; i++) {
				if (filerecord.getSynchtype().equals(filerecordOutList.get(i).getSynchtype()) &&
						(filerecord.getFilename().substring(0, filerecord.getFilename().length() - 11).equals
								(filerecordOutList.get(i).getFilename().substring(0, filerecordOutList.get(i).getFilename().length() - 11)))) {
					filerecordOutList.remove(i);
					i--;
					break;
				}
			}
		}
		for (FilerecordOut filerecordout:filerecordOutList) {
			FilerecordStatus filerecordStatus = new FilerecordStatus();
			filerecordStatus.setSynchstatus(Constants.SYNCHSTATUS_UNDO);
			filerecordStatus.setSynchtype(filerecordout.getSynchtype());
			filerecordStatus.setSynchdate(filerecordout.getFilename().substring(filerecordout.getFilename().lastIndexOf("_")+1,filerecordout.getFilename().indexOf(".data")).substring(0,8));
			filerecordStatus.setCreateTime(new Date());
			filerecordStatus.setUpdateTime(filerecordStatus.getCreateTime());
			filerecordStatusList.add(filerecordStatus);

		}

		List updateFilerecordStatusList = new ArrayList();

		//查询记录表中已经存在的
		List<FilerecordStatus> dbExistIDList = this.findFilerecordStatusByTime(filerecordStatusList,DateUtil.getDateStrAfterToday(-2),DateUtil.getTomorrow());
		//去除已经存在的部分
		for (FilerecordStatus dbExistfilerecordStatus: dbExistIDList) {
			int logListSize=  filerecordStatusList.size();
			for (int i = 0; i < logListSize; i++) {
				if (dbExistfilerecordStatus.getSynchtype().equals(filerecordStatusList.get(i).getSynchtype()) && dbExistfilerecordStatus.getSynchdate().equals(filerecordStatusList.get(i).getSynchdate())) {
					updateFilerecordStatusList.add(	filerecordStatusList.get(i));
					filerecordStatusList.remove(i);
					i--;
					break;
				}
			}
		}

		if(filerecordStatusList.size()>0){
			filerecordStatusDao.saveBatch(filerecordStatusList);
		}
		if(updateFilerecordStatusList.size()>0){
			filerecordStatusDao.updateBatch(updateFilerecordStatusList);
		}

	}

	@Override
	public FilerecordStatusSearchDto search(FilerecordStatusSearchDto dto) {
		FilerecordStatusSearchDto resultDto = new FilerecordStatusSearchDto();
		if(StringUtil.isNotEmpty(dto.getSynchdate())){
			dto.setSynchdate(dto.getSynchdate().replaceAll("-",""));
		}

		List<FilerecordStatus> list =  filerecordStatusDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(filerecordStatusDao.count(dto));
		return resultDto;
	}

}


