package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.approval.ApprovalState;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Method;
import java.util.Date;

/****
 * 审批业务基础
 */
public abstract class ApprovalBusinessBaseService extends BaseService {
    /***
     * 审批通过执行方法
     */
    public abstract void passPost(Approval approval);
    @Autowired
    private ApprovalLogDao approvalLogDao;

    @Autowired
    private ArsUtil arsUtil;
//    /***
//     * 获取业务表信息
//     * @param id 主键
//     * @param <T>
//     * @return
//     */
//    public abstract   <T> T findById(long id);
//    /***
//     * 更新业务表
//     * @param obj
//     */
//    public abstract  void saveOrUpdateForApproval(Object obj);
    /***
     * 更新审批状态
     */
    public void updateState(Approval approval) {
        /***
         * 1、审批信息赋值
         */
        //Object o =findById(approval.getBusinessid());
        Method findByIdMethod =  ReflectionUtils.findMethod(this.getClass(),"findById");
        Object  o = ReflectionUtils.invokeMethod(findByIdMethod,this,approval.getBusinessid());
        BeanUtils.copyPropertiesIgnore(o,approval,true);
        /***
         * 2、更新业务表的审批信息
         */
        Method saveOrUpdateForApprovalMethod =  ReflectionUtils.findMethod(this.getClass(),"saveOrUpdateForApproval");
        ReflectionUtils.invokeMethod(saveOrUpdateForApprovalMethod,this,approval.getBusinessid());
        /***
         *  3、执行各个业务审批通过执行的方法
         */
        if(ApprovalState.SHTG.equals(approval.getApprovalstate())) {
            passPost(approval);
        }
        /***
         * 4、审批日志，公安端
         */
        User currentUser=arsUtil.getCurrentUser();
        ApprovalLog approvalLog = new ApprovalLog();
        if (currentUser == null) {
            approvalLog.setUpdateBy("system");
            approvalLog.setApprovalorg("系统自动");
        } else {
            approvalLog.setUpdateBy(currentUser.getUsername());
            approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
        }
        approvalLog.setActive(true);
        approvalLog.setType(Constants.APPROVAL_LOG_IN);
        approvalLog.setCreateTime(new Date());
        approvalLog.setUpdateTime(new Date());
        approvalLog.setApprovaldate(new Date());
        approvalLog.setApprovalperson(approval.getApprovalperson());
        approvalLog.setApprovalreason(approval.getApprovalreason());
        approvalLog.setApprovalstate(ApprovalState.convertCode(approval.getApprovalstate()));
        approvalLog.setProcessInstanceId(approval.getProcessInstanceId());
        approvalLog.setApprovalid(approval.getId().toString());
        approvalLogDao.save(approvalLog);
    }
}
