package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.act.ActivitiCommentDao;
import com.bcxin.ars.model.act.ActivitiComment;
import com.bcxin.ars.service.act.ActivitiCommentService;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class ActivitiCommentServiceImpl implements ActivitiCommentService {

	@Autowired
	private ActivitiCommentDao commentDao;
	
	@Override
	public void saveOrUpdate(ActivitiComment comment) {
		if(StringUtil.isEmpty(comment.getId())) {
			commentDao.save(comment);
		}else {
			ActivitiComment dbComment = commentDao.findById(comment.getId());
			if(dbComment == null){
				commentDao.save(comment);
			}else{
//				commentDao.update(comment);
			}
		}
	}

	@Override
	public ActivitiComment findById(String id) {
		return commentDao.findById(id);
	}

	@Override
	public List<ActivitiComment> findAll() {
		return commentDao.findAll();
	}

	@Override
	public List<ActivitiComment> findByProcessInstanceId(String processInstanceId) {
		return commentDao.findByProcessInstanceId(processInstanceId);
	}

}
