package com.bcxin.ars.service.gx;

import com.bcxin.ars.dao.gx.FingerDao;
import com.bcxin.ars.dto.gx.FingerDTO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
/**
 * 广西现场采集指纹服务层
 * @author subh
 * @since jdk1.8
 */
@Service
public class FingerServiceImpl implements  FingerService {
    @Autowired
    private FingerDao fingerDao;
    @Override
    public void save(FingerDTO dto) {
        //1.检查key是否正常
        if(!Constants.FINGER_KEY.equals(dto.getKey())){
            throw  new ArsException("key无效");
        }
        //2.表单检查
        //设置默认值
        dto.setActive(true);
        dto.setCreateTime(new Date());
        dto.setUpdateTime(new Date());
        dto.setUpdateBy(Constants.SYSTEM);
        fingerDao.save(dto);
    }
}
