package com.bcxin.ars.service;

import com.bcxin.ars.dao.PersonAddDao;
import com.bcxin.ars.model.PersonAdd;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
@Service
public class PersonAddServiceImpl implements   PersonAddService {

    @Autowired
    private PersonAddDao personAddDao;
    private static BackGroupCensorService backGroupCensorService;
    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    @Override
    public List<PersonAdd> findAll() {
        return personAddDao.findAll();
    }

    @Override
    public void updateHandleData(PersonAdd p) {
        personAddDao.update(p);
    }
}
