package com.bcxin.ars.service;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.MSGConstants;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

/***
 * 主页服务层实现类
 */
@Service
public class IndexServiceImpl implements  IndexService {

    @Autowired
    private MessageLogDao messageLogDao;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    /**
     * 保安人员
     */
    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Override
    public void sendException() {
        //保安人员，身份证号有问题保安员，发送短信，在职、身份证有问题
        List<SecurityPerson> securityPersonList = securityPersonDao.findExceptionData();
        //使用线程池
        CountDownLatch workCount = ThreadUtil.newCountDownLatch(securityPersonList.size());
        ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(15, 15);
        for (SecurityPerson person: securityPersonList) {
            //发送短信
            /****************华为短信*****************/
            //百保盾内部发送
            threadPoolExecutor.execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        if(StringUtil.isNotEmpty(person.getPhone())) {
                            MessageUtil.sendMessageHuaWei(person.getPhone(), Constants.ERROR_DATA_CONTENT, messageLogDao, new String[]{}, MSGConstants.SMSCODE_B77);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        workCount.countDown();
                    }

                }
            });
        }
        try {
            //线程等待全部数据文件生成完成
            workCount.await();
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }finally {
            threadPoolExecutor.shutdown();
        }
    }

}
