package com.bcxin.ars.service.util.thread;

import com.bcxin.ars.service.sb.ActivityRepairService;

/**
 * 保安员证流程重启
 * @author linqinglin
 * @date 2018/09/27 0027 10:36
 */
public class PersoncertificateRunnable implements Runnable {

    public static final String TYPE_RESETPROCESS="1";

    public static final String TYPE_RESTARTPROCESS="2";

    public static final String TYPE_GETFINGER="3";


    private ActivityRepairService activityRepairService;

    private Long personId;

    private String type;

    public PersoncertificateRunnable(ActivityRepairService activityRepairService, Long personId, String type){
        this.activityRepairService = activityRepairService;
        this.personId = personId;
        this.type = type;
    }

    @Override
    public void run() {
        switch (type){
            case TYPE_RESETPROCESS:
                activityRepairService.resetProcess(personId);
                break;
            case TYPE_RESTARTPROCESS:
                activityRepairService.restartProcess(personId);
                break;
            case TYPE_GETFINGER:
                activityRepairService.getFinger(personId);
                break;
            default:
                break;
        }
    }
}
