package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sys.ModuleMenuDao;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.Sha1Util;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.gx.encry.AES;
import com.bcxin.ars.util.gx.encry.CreatRandomStr;
import com.bcxin.ars.util.gx.encry.Md5;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;

/**
 *
 * 广西单点登录 及菜单权限
 * @author linqinglin
 * @date 2021/03/16 0016 9:27
 */
@Service
public class GXSingleLoginUtil {

    private final static Logger logger = LoggerFactory.getLogger(GXSingleLoginUtil.class);

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private UserDao userDao;

    @Autowired
    private ModuleMenuDao moduleMenuDao;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private SysAreaUtil sysAreaUtil;

    /**
     * AES加密、解密Key
     */
    private String key = "fjtctchsoft";

    private String clientId = "3505001000000063";

    private String clientSecret = "5c24fbc70164df0893d8bb7d141a8b1a";

    /**
     * 获得用户信息
     */
    private String getjhuser = "getjhuser";

    /**
     * 获得机构信息
     */
    private String getorgcode = "getorgcode";

    /**
     * 获得下级机构信息
     */
    private String fjorg = "fjorg";

    /**
     * 获得菜单
     */
    private String getmenu = "getmenu";

    private String url = "http://10.148.68.27:9001/api/";
    /**
     * 系统编码 （子系统顶级菜单id）
     */
    private String zxtqxgw = "27211";

    private Map getParamMap(){
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("clientId",clientId);
        paramMap.put("randomStr", CreatRandomStr.CreatenNonce_str());
        paramMap.put("timeStamp", System.currentTimeMillis());
        String signTemp= CreatRandomStr.createStr(paramMap,clientSecret);
        String signStr= Md5.encoderMD5(signTemp);
        paramMap.put("signStr",signStr);
        return paramMap;
    }

    /**
     *根据警号获取用户信息
     * @param username 用户信息
     * @return
     */
    public User getUserInfo(String username) throws Exception {
        String urlPath = url +getjhuser;
        User user = new User();
        user.setUsername(username);
        user.setCodeNo(username);
        Map<String,Object> paramMap = getParamMap();
        paramMap.put("jh", AES.encrypt(user.getCodeNo(),key));
        logger.error("根据警号获取用户信息,请求地址：{}",urlPath);
        logger.error("根据警号获取用户信息,请求参数：{}",JSON.toJSONString(paramMap));

        String result = HttpUtil.post(urlPath, paramMap,30000);
        logger.error("根据警号获取用户信息,返回结果:{}",result);

        JSONObject resultJSON = JSON.parseObject(result);
        String code = resultJSON.getString("code");
        if("0".equals(code)){
            String userObject = resultJSON.getString("userObject");
            JSONObject userJSON = JSON.parseObject(AES.decrypt(userObject,key));

            logger.error("根据警号获取用户信息,解密结果:{}", JSON.toJSONString(userJSON));

            Police police = this.getPolice(userJSON.getString("SUNIT_CODE"));

            user.setOrgid(police.getId());
            user.setPolice(police);
            user.setRealname(userJSON.getString("NAME"));
            user.setPhone(userJSON.getString("SOTHER_INFO"));
            user.setOrgName(userJSON.getString("ORGNAME"));//所属单位_公安组织机构名称
            user.setIdNumber(userJSON.getString("PID"));//身份证号
            user.setUpdateTime(new Date());
            user.setUpdateflag(true);
            User dbUser = userDao.findByUsername(user.getUsername(), Constants.PLATFORM_POLICE+"");

            if(dbUser != null){
                BeanUtils.copyPropertiesIgnore(user,dbUser,true);
                BeanUtils.copyPropertiesIgnore(dbUser,user,true);
                userDao.update(dbUser);
            }else {
                user.setId(idGeneratorUtil.createID());
                user.setCreateTime(new Date());
                user.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
                user.setUpdateBy(user.getUsername());
                user.setInit(true);
                user.setPlatform(Constants.PLATFORM_POLICE);
                user.setActive(true);
                user.setNativeCode(arsUtil.getCurrentNatvie());
                userDao.save(user);
            }
            String roleId = userJSON.getString("NSTATION_NO");
            if(StringUtil.isEmpty(roleId)){
                logger.error("没有岗位id");
            }else{
                user.setPermissionList(getMenuList(roleId));
            }
        }else{
            throw new ArsException(resultJSON.getString("msg"));
        }
        return user;
    }

    /**
     * 根据岗位id 获取菜单
     * @param zxtbm
     * @return
     * @throws Exception
     */
    public List<ModuleMenu> getMenuList(String zxtbm) throws Exception {
        String urlPath = url +getmenu;
        List<ModuleMenu> list = new ArrayList<>();
        ModuleMenu moduleMenu = null;
        Map<String,Object> paramMap = getParamMap();
        paramMap.put("zxtbm", AES.encrypt(zxtbm,key));
        paramMap.put("zxtqxgw", AES.encrypt(zxtqxgw,key));
        logger.error("获取菜单信息,请求地址：{}",urlPath);
        logger.error("获取菜单信息,请求参数：{}",JSON.toJSONString(paramMap));

        String result = HttpUtil.post(urlPath, paramMap,30000);
        logger.error("获取菜单信息,返回结果:{}",result);
        JSONObject resultJSON = JSON.parseObject(result);
        String code = resultJSON.getString("code");
        if("0".equals(code)){
            String dwObject = resultJSON.getString("menuObject");
            JSONObject menusJSON = JSON.parseObject(AES.decrypt(dwObject,key));


            JSONArray menuArr = JSONArray.parseArray(menusJSON.getString("list"));
            logger.error(menusJSON.getString("list"));
            for (Object menuObj : menuArr) {
                JSONObject menu = JSON.parseObject(menuObj.toString());
                if(StringUtil.isNotEmpty(menu.getString("MENU_ZYMS"))) {
                    moduleMenu = JSON.parseObject(menu.getString("MENU_ZYMS"), ModuleMenu.class);
                    list.add(moduleMenu);
                }
            }

            list = moduleMenuDao.findByBatchId(list);
            //menu_id	字符型	12	菜单资源ID
            //menu_name	字符型	120	菜单资源名称
            //menu_layer	字符型	12	菜单层级
            //menu_parent	字符型	12	菜单父节点
            //menu_icon	字符型	120	菜单图标
            //menu_href	字符型	240	菜单链接地址
            //menu_sort	字符型	12	菜单排序号
            //MENU_ZYLX 字符型	12	资源类型
            //MENU_ZYMS 字符型	12	资源描述

        }else{
            throw new ArsException(resultJSON.getString("msg"));
        }
        return list;
    }

    private Police getPolice(String jgdm) throws Exception {
        Police police = policeDao.findByCode(jgdm);
        if(police == null) {
            String urlPath = url + getorgcode;
            police = new Police();
            Map<String, Object> paramMap = getParamMap();
            paramMap.put("jgdm", AES.encrypt(jgdm, key));
            logger.error("根据机构编号获取机构信息,请求地址：{}",urlPath);
            logger.error("根据机构编号获取机构信息,请求参数：{}", JSON.toJSONString(paramMap));

            String result = HttpUtil.post(urlPath, paramMap, 30000);
            logger.error("根据机构编号获取机构信息,返回结果:{}", result);
            JSONObject resultJSON = JSON.parseObject(result);
            String code = resultJSON.getString("code");
            if ("0".equals(code)) {
                String dwObject = resultJSON.getString("dwObject");
                JSONObject orgJSON = JSON.parseObject(AES.decrypt(dwObject, key));
                logger.error("根据机构编号获取机构信息,解密结果:{}", JSON.toJSONString(orgJSON));

                String parentCode = orgJSON.getString("SLS_UNIT_CODE");
                String parentPath = "";
                if(StringUtil.isNotEmpty(parentCode)){
                    Police parentPolice = policeDao.findByCode(parentCode);
                    if(parentPolice == null){
                        parentPolice = getPolice(parentCode);
                    }
                    police.setParentorg(parentPolice.getId());
                    police.setOrgtype((Integer.parseInt(parentPolice.getOrgtype())+1)+"");
                    parentPath = parentPolice.getPath();
                }

                if(StringUtil.isEmpty(parentPath)){
                    Police parentPolice = policeDao.findByCode("450000000000");
                    police.setParentorg(parentPolice.getId());
                    police.setOrgtype((Integer.parseInt(parentPolice.getOrgtype())+1)+"");
                    parentPath = parentPolice.getPath();
                }

                police.setCode(jgdm);
                police.setOrgname(orgJSON.getString("ORGNAME"));
                police.setActive(true);
                police.setNativeCode(45L);
                police.setCreateTime(new Date());
                police.setUpdateTime(new Date());
                police.setUpdateBy("system");

                String areaCode = jgdm.substring(0,6);
                TreeView tree = sysAreaUtil.getRegionByCode(areaCode);
                police.setAreacode(areaCode);
                police.setArea(tree.getText());

                policeDao.save(police);

                police.setPath(parentPath+police.getId() + "/");
                police.setUpdateflag(true);
                policeDao.update(police);

            } else {
                throw new ArsException(resultJSON.getString("msg"));
            }
        }

        return police;
    }

    public String getPoliceOrg(String jgdm) throws Exception {
        String urlPath = url + getorgcode;
        Police police = new Police();
        Map<String,Object> paramMap = getParamMap();
        paramMap.put("jgdm", AES.encrypt(jgdm,key));
        logger.error("根据机构编号获取机构信息,请求地址：{}",urlPath);
        logger.error("根据机构编号获取机构信息,请求参数：{}",JSON.toJSONString(paramMap));

        String result = HttpUtil.post(urlPath, paramMap,30000);
        logger.error("根据机构编号获取机构信息,返回结果:{}",result);
        JSONObject resultJSON = JSON.parseObject(result);
        String code = resultJSON.getString("code");
        if("0".equals(code)){
            String dwObject = resultJSON.getString("dwObject");
            JSONObject orgJSON = JSON.parseObject(AES.decrypt(dwObject,key));
            logger.error("根据机构编号获取机构信息,解密结果:{}", JSON.toJSONString(orgJSON));
        }else{
            throw new ArsException(resultJSON.getString("msg"));
        }

        return result;
    }

    /**
     * 根据上级机构编号获取机构信息
     * @param sjjgbm
     * @throws Exception
     */
    public String getPoliceOrgsByParent(String sjjgbm) throws Exception {
        String urlPath = url + fjorg;
        Map<String,Object> paramMap = getParamMap();
        paramMap.put("sjjgbm", AES.encrypt(sjjgbm,key));
        logger.error("根据上级机构编号获取机构信息,请求地址：{}",urlPath);
        logger.error("根据上级机构编号获取机构信息,请求参数：{}",JSON.toJSONString(paramMap));

        String result = HttpUtil.post(urlPath, paramMap,30000);
        logger.error("根据上级机构编号获取机构信息,返回结果:{}",result);

        //JSONObject resultJSON = JSON.parseObject(result);
        //String code = resultJSON.getString("code");
        //if("0".equals(code)){
        //    String dwObject = resultJSON.getString("dwObject");
        //    JSONObject orgJSON = JSON.parseObject(AES.decrypt(dwObject,key));
        //
        //    //police.setRealname(orgJSON.getString("NAME"));
        //    //police.setPhone(orgJSON.getString("SOTHER_INFO"));
        //    //police.setOrgName(orgJSON.getString("orgname"));//所属单位_公安组织机构名称
        //    //police.setRoleName(orgJSON.getString("NSTATION_NO"));//系统权限_岗位ID
        //}else{
        //    throw new ArsException(resultJSON.getString("msg"));
        //}
        return result;
    }


    public static void main(String[] args) {
        getUserInfo();
        //JSONObject json = new JSONObject();
        //json.put("uniqueId","1");
        //json.put("rankAuth","1");
        //json.put("permission","todoList:query");
        //System.out.println(JSON.toJSONString(json));
        //
        //String userObject = "380D7254E01CBB9BD3B954815B88F50039D789017C70FA07DCCF68350479AE229FE60658F6C2E023D2BCC878881A363F4280A20AE41BF31F9795429750F1DE686F5DC1AABA81C4960DB03FD81F6366AD1C26E1E23CB1A096E587DACFD00BC9B36355CCFD16A34E2B05A371823F7B3D5C87EFC3F3A1167CEED609F039F1C7593095898C556A42C4AB1A7A9E30A4DFA71BD6FCD71D6B325B19FB2BD7A7D24D3B6689874D51F25F58AA956B4808217E66B5F335C1EFE2B76F7EE7448C28F4B08AC4A015D307A0418D67024048180995F6AA04558FA23BFEA09B1199338FAC5C263C52B0F8F7B128E7BA4E4B2752D0BCA71CEB5CDFDFBF1D469CC79B70F75351818B5CD0B7257A55DD502E18D6DADF6D6FF812790A27336E3E55A0CFC40074A20FC16DD861A801C47190A2949B082029A59E48F15C6D99FCA0814F1AC57F85EDF889F1B26BB2C40FE5A13A962DBB19631BD8B0D30F43FE4FFB64D4D7799876415C97FAD0F7F5FB946D81CE442994794B7B1E8DCF2A730FE5BA070759EC1E0A1E4DC2";
        //
        //System.out.println(AES.decrypt(userObject,"fjtctchsoft"));
        //JSONObject userJSON = JSON.parseObject(AES.decrypt(userObject,"fjtctchsoft"));
        //System.out.println(userJSON.getString("NAME"));
        //System.out.println(userJSON.getString("NSTATION_NO"));
        //
        String dwObject = "AC5B31BE0275416921B10DC678BA4B1B95145B20B26A7A0A79FBB8337BB84900347E2C478AB2BD203308D2DF92C895F3EEE50D304612381C89E80A5B3A85CC7F0FA6627009E6E8AA9B3EB389DDB3CB3F01ED1416820A6D7C25491AB90B540607EB4724AB33609F704E076856E48277754C5A1F410DC62C153289852E6F8A9F74047CEAE332943F25082852336B086279C3CA16A206D918DFD00EA04718A90B6CB070CEF28A1521815E0634871B2EC22808B229AAAA56CC46FD47CAB7F0BF080893B49C7DA1706F96AC75EAE849836655135FCB927248999A86AE0C054903EFAC3695DD409848F30803CE59E9FB292336F6D93BE437C5A6E86E8A0E99AAAB857BFACF3BB69B309AB675B000FB9EDC797A";

        System.out.println(AES.decrypt(dwObject,"fjtctchsoft"));
        JSONObject dwJSON = JSON.parseObject(AES.decrypt(dwObject,"fjtctchsoft"));
        System.out.println(dwJSON.getString("ORGNAME"));
        //
        //
        //String menuObject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

        //System.out.println(AES.decrypt(menuObject,"fjtctchsoft"));

        String userInfo = "5CulOcVBt1xg29xMxyKnwFjy1EVwYFyJHLvSiM+5ksnVYBpCwBlDzNgwB88EJdWMIb3Hvnp1hbQ=";
        try {
            System.out.println(URLEncoder.encode(userInfo,"utf-8"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }


            JSONObject userJSON = JSON.parseObject("{\"NSTATION_NO\":3263,\"SLOGIN_ID\":\"zhbacs\",\"SPOLICE_NO\":\"45154489454\",\"SUNIT_CODE\":\"450000030700\",\"ORGNAME\":\"广西公安厅治安警察总队保安管理支队\",\"PID\":\"4508021854565488\",\"DATA_ORGNAME\":\"广西壮族自治区公安厅\",\"WHEN_LOGGED\":1617266245000,\"NAME\":\"智慧保安测试\",\"WHO_LOGGED\":\"350000120000000000001\",\"NPOLICE_ID\":\"450000130000000000933\",\"SSTATION_NAME\":\"智慧保安监管领导\",\"DATA_ORGID\":\"450000000000\"}");

            logger.error("根据警号获取用户信息,解密结果:{}", JSON.toJSONString(userJSON));
            System.out.println(userJSON.getString("SUNIT_CODE"));
            System.out.println(userJSON.getString("NAME"));
            System.out.println(userJSON.getString("SOTHER_INFO"));
            System.out.println(userJSON.getString("ORGNAME"));//所属单位_公安组织机构名称
            System.out.println(userJSON.getString("PID"));//身份证号
            System.out.println(userJSON.getString("NSTATION_NO"));//岗位id

            //Police police = policeDao.findByCode(userJSON.getString("SUNIT_CODE"));
            //
            //if(police != null) {
            //    user.setOrgid(police.getId());
            //    user.setPolice(police);
            //}
            //user.setRealname(userJSON.getString("NAME"));
            //user.setPhone(userJSON.getString("SOTHER_INFO"));
            //user.setOrgName(userJSON.getString("ORGNAME"));//所属单位_公安组织机构名称
            //user.setIdNumber(userJSON.getString("PID"));//身份证号
            //user.setUpdateTime(new Date());
            //user.setUpdateflag(true);
            //User dbUser = userDao.findByUsername(user.getUsername(), Constants.PLATFORM_POLICE+"");


    }



    public static void getUserInfo(){
        User user = new User();

            JSONObject userJSON = JSON.parseObject("{\"NSTATION_NO\":3263,\"SLOGIN_ID\":\"zhbacs\",\"SPOLICE_NO\":\"45154489454\",\"SUNIT_CODE\":\"450000030700\",\"ORGNAME\":\"广西公安厅治安警察总队保安管理支队\",\"PID\":\"4508021854565488\",\"DATA_ORGNAME\":\"广西壮族自治区公安厅\",\"WHEN_LOGGED\":1617266245000,\"NAME\":\"智慧保安测试\",\"WHO_LOGGED\":\"350000120000000000001\",\"NPOLICE_ID\":\"450000130000000000933\",\"SSTATION_NAME\":\"智慧保安监管领导\",\"DATA_ORGID\":\"450000000000\"}");

            logger.error("根据警号获取用户信息,解密结果:{}", JSON.toJSONString(userJSON));

            Police police = null;

            if(police != null) {
                user.setOrgid(police.getId());
                user.setPolice(police);
            }
            user.setRealname(userJSON.getString("NAME"));
            user.setPhone(userJSON.getString("SOTHER_INFO"));
            user.setOrgName(userJSON.getString("ORGNAME"));//所属单位_公安组织机构名称
            user.setIdNumber(userJSON.getString("PID"));//身份证号
            user.setUpdateTime(new Date());
            user.setUpdateflag(true);
            User dbUser = null;

            if(dbUser != null){
                BeanUtils.copyPropertiesIgnore(user,dbUser,true);
                BeanUtils.copyPropertiesIgnore(dbUser,user,true);
            }else {
                user.setCreateTime(new Date());
                user.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
                user.setUpdateBy(user.getUsername());
                user.setInit(true);
                user.setPlatform(Constants.PLATFORM_POLICE);
            }
            System.out.println(userJSON.getString("NSTATION_NO"));
        System.out.println(JSON.toJSONString(user));
    }
}
