package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.DatasyncDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.*;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.dto.task.TaskFeedBackDto;
import com.bcxin.ars.dto.task.TaskPersonDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.task.*;
import com.bcxin.ars.service.SearchHistoryService;
import com.bcxin.ars.service.SecurityCompanyScheduleService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.impl.UrgentTaskThread;
import com.bcxin.ars.service.sys.impl.ApprovalServiceImpl;
import com.bcxin.ars.service.task.AppNoticeService;
import com.bcxin.ars.service.task.TaskFeedbackService;
import com.bcxin.ars.service.task.TaskService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.poi.ExcelUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.*;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Task.class)
public class TaskServiceImpl implements TaskService {

    @Autowired
    private TaskDao taskDao;

    @Autowired
    private TaskScheduleDao taskScheduleDao;

    @Autowired
    private TaskPersonDao taskPersonDao;

    @Autowired
    private TaskPersonScheduleDao taskPersonScheduleDao;

    @Autowired
    private SecurityCompanyDao companyDao;

    @Autowired
    private SecurityPersonDao personDao;

    @Autowired
    private TaskFeedbackDao feedbackDao;

    @Autowired
    private TaskFeedbackService feedbackService;

    @Autowired
    private UserDao userDao;

    @Autowired
    private AppNoticeService appNoticeService;

    @Autowired
    private SecurityCompanyScheduleService securityCompanyScheduleService;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private SearchHistoryService searchHistoryService;

    @Autowired
    private SecurityCompanyService companyService;

    @Autowired
    private UrgentTeamPersonDAO urgentTeamPersonDAO;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private DatasyncDao datasyncDao;


    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    private Logger logger = LoggerFactory.getLogger(ApprovalServiceImpl.class);

    @Override
    public Task findById(Long id) {
        Task task = taskDao.findById(id);
        if(task !=null) {
            if (task.getStartDate() != null) {
                String dateStatrtTime[] = task.getStartDate().split(" ");
                task.setStartDate(dateStatrtTime[0]);
            }
            if (task.getEndDate() != null) {
                String dateEndTime[] = task.getEndDate().split(" ");
                task.setEndDate(dateEndTime[0]);
            }
            task.getPersonList();
            task.getScheduleList();
        }
        return task;
    }


    @Override
    public Task findUrgentById(Long id) {
        Task task = taskDao.findUrgentById(id);
        List<TaskPerson> personList = new ArrayList<TaskPerson>();
        List<TaskPerson> list = taskPersonDao.findByTaskId(id);
        //紧急任务人员列表可能会为空
        if (list != null && list.size() > 0) {
            for (TaskPerson t :
                    list) {
                //只列出接受任务的人员
                if (t.getAcceptStatus().equals(1) || t.getAcceptStatus().equals(3)) {
                    UrgentPerson urgentPerson = urgentTeamPersonDAO.queryUrgentPersonByPersonId(t.getPerson().getId());
                    if (urgentPerson != null) {
                        t.setInCharge(urgentPerson.isInCharge());
                    }
                    t.setPerson(personDao.findById(t.getPerson().getId()));
                    personList.add(t);
                }
            }
        }
        task.setPersonList(personList);
        return task;
    }


    @Override
    public List<Task> findUrgentByPersnId(UrgentTaskDTO dto) {
        List<Task> task = taskDao.findUrgentByPersnId(dto);
        return task;
    }

    @Override
    public TaskSearchDto search(TaskSearchDto dto) {
        User user = arsUtil.getCurrentUser();

        //保存搜索记录
        if (StringUtil.isNotEmpty(dto.getKeyword())) {
            searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_TASK, user);
        }

        if (user.getPlatform().intValue() == 2) {
            if (StringUtil.isEmpty(dto.getTaskTypeName()) || (StringUtil.isNotEmpty(dto.getTaskTypeName()) && !dto.getTaskTypeName().equals("紧急"))) {
                SecurityCompany company = companyDao.findByUserid(user.getId());
                dto.setCompanyId(company.getId());
            }
        } else if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }

        List<Task> data = taskDao.search(dto);
        for (Task task : data) {
            task.getScheduleList();
        }
        Long count = taskDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public TaskSearchDto searchForPersonManage(TaskSearchDto dto) {
        User user = arsUtil.getCurrentUser();

        //保存搜索记录
        if (StringUtil.isNotEmpty(dto.getKeyword())) {
            searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_TASK, user);
        }

        SecurityCompany company = companyService.getCurrentUserCompany();

        if (company != null) {
            dto.setCompanyId(company.getId());
        } else if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }

        List<Task> data = taskDao.search(dto);
        for (Task task : data) {
            task.getScheduleList();
        }
        Long count = taskDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public List<Task> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return taskDao.searchForDataSynchronization(dto);
    }

    @Override
    public void saveOrUpdate(Task task) {
        User user = arsUtil.getCurrentUser();
        Task dbTask = taskDao.findSaasTaskById(task.getId());
        if (dbTask == null) {
            TaskStatus status = new TaskStatus();
            //如果是紧急任务是公安角色的话
            if (user.getPlatform().equals(1)) {
                // TODO 固定值
                //状态进行中
                status.setId(2L);
                Date date = new Date();
                Timestamp nousedate = new Timestamp(date.getTime());
                task.setStartDate(nousedate.toString().substring(0, 19));
                //任务种类
                TaskCatalog taskCatalog = new TaskCatalog();
                taskCatalog.setId(6L);
                task.setTaskCatalog(taskCatalog);
                //任务等级
                TaskLevel level = new TaskLevel();
                level.setId(4L);
                task.setTaskLevel(level);
                //公司
                SecurityCompany securityCompany = new SecurityCompany();
                securityCompany.setId(1L);
                task.setCompany(securityCompany);

            } else if (user.getPlatform() == 2 || user.getPlatform() == 3) {//保安公司
                status.setId(1L);

                SecurityCompany company = null;
                if (user.getPlatform() == 2) {
                    company = companyDao.findByUserid(user.getId());
                }

                if (company == null) {
                    throw new RuntimeException("当前登录ID无法找到对应公司信息：Userid:" + user.getId());
                }
                //区域
                task.setAreacode(company.getAreaCode());
                task.setCompany(company);
            }
            //状态
            task.setTaskStatus(status);
            task.setCreateTime(new Date());
            //区域
            task.setNativeCode(arsUtil.getCurrentNatvie());
            //创建人
            task.setCreater(user.getId().toString());
            task.setUpdateBy(user.getRealname());
            task.setUpdateTime(task.getCreateTime());
            task.setActive(true);
            task.setSendcount(0);

            if (task.getId() == null) {
                //设置ID
                task.setId(idGeneratorUtil.createID());
            }
            taskDao.save(task);
            //如果是公司或者保安员且非紧急任务
            if ((user.getPlatform() == 2 || user.getPlatform() == 3) && task.getTaskType().getId() != 4) {
                saveScheduleList(task);
                savePersonList(task);
            }
            //如果是公安向保安人员推送紧急任务信息
            if (user.getPlatform() == 1 && task.getTaskType().getId() == 4) {
                SecurityCompanySchedule securityCompanySchedule = new SecurityCompanySchedule();
                securityCompanySchedule.setId(1l);
                TaskSchedule taskSchedule = new TaskSchedule();
                taskSchedule.setNativeCode(arsUtil.getCurrentNatvie());
                taskSchedule.setCreateTime(new Date());
                taskSchedule.setSchedule(securityCompanySchedule);
                taskSchedule.setTaskId(task.getId());
                taskScheduleDao.save(taskSchedule);
                new Thread(() -> { //异步处理
                    try {
                        UrgentTaskThread taskThread = new UrgentTaskThread();
                        taskThread.setMinute(6000);
                        taskThread.setTaskDao(taskDao);
                        taskThread.setPersonDao(personDao);
                        taskThread.setTaskService(this);
                        taskThread.setTaskId(task.getId());
                        taskThread.run();
                    } catch (Exception e) {

                    }
                }).start();

            }
        } else {


            dbTask.setUpdateTime(new Date());
            dbTask.setUpdateBy(user.getRealname());
            if (task.getName() != null && task.getName().trim().length() > 0) {
                dbTask.setName(task.getName());
            }
            if (task.getTaskLevel() != null && task.getTaskLevel().getId() != null && task.getTaskLevel().getId() > 0) {
                dbTask.setTaskLevel(task.getTaskLevel());
            }
            //不能修改任务类型
//				if(task.getTaskType() != null && task.getTaskType().getId() != null && task.getTaskType().getId() > 0) {
//					dbTask.setTaskType(task.getTaskType());
//				}
            if (task.getTaskCatalog() != null && task.getTaskCatalog().getId() != null && task.getTaskCatalog().getId() > 0) {
                dbTask.setTaskCatalog(task.getTaskCatalog());
            }
            if (task.getTaskStatus() != null && task.getTaskStatus().getId() != null && task.getTaskStatus().getId() > 0) {
                dbTask.setTaskStatus(task.getTaskStatus());
            }
            if (task.getAddress() != null && task.getAddress().trim().length() > 0) {
                dbTask.setAddress(task.getAddress().trim());
            }
            if (task.getArea() != null && task.getArea().trim().length() > 0) {
                dbTask.setArea(task.getArea().trim());
            }

            if (task.getLongitude() != null && task.getLongitude().trim().length() > 0) {
                dbTask.setLongitude(task.getLongitude());
            }
            if (task.getLatitude() != null && task.getLatitude().trim().length() > 0) {
                dbTask.setLatitude(task.getLatitude());
            }
            if (task.getScope() != null && task.getScope() > 0) {
                dbTask.setScope(task.getScope());
            }
            if (task.getDetail() != null && task.getDetail().length() > 0) {
                dbTask.setDetail(task.getDetail());
            }
            if (task.getSendcount() != null && task.getSendcount() > 0) {
                dbTask.setSendcount(task.getSendcount());
            }
            if (StringUtil.isNotEmpty(task.getStartDate())) {
                dbTask.setStartDate(task.getStartDate());
            }
            if (StringUtil.isNotEmpty(task.getEndDate())) {
                dbTask.setEndDate(task.getEndDate());
            }
            dbTask.setPersonList(task.getPersonList());

            dbTask.setScheduleList(task.getScheduleList());

            dbTask.setRepeat(task.isRepeat());

            dbTask.setTaskType(task.getTaskType());

            taskDao.update(dbTask);
            //如果是公司或者保安员且非紧急任务
            if ((user.getPlatform() == 2 || user.getPlatform() == 3) && task.getTaskType().getId() != 4) {
                deletePersonList(dbTask);
                savePersonList(dbTask);
                deleteScheduleList(dbTask);
                saveScheduleList(dbTask);
            }

        }
    }

    @Override
    public void saveOrUpdateForDS(Task task) {
        //先从内网获取查看是否有存在记录
        Task dbTask = findById(task.getId());
        if (task.getActive() == null) {
            task.setActive(true);
        }

        if (!task.getActive()) {
            delete(task);
        } else {

            if (dbTask == null) {
                taskDao.save(task);
                if (task.getTaskType().getId() != 4) {
                    saveScheduleList(task);
                    savePersonListForDS(task);
                }
            } else {
                if (dbTask != null) {
                    if (task.getUpdateTime().getTime() > dbTask.getUpdateTime().getTime()) {
                        taskDao.update(task);
                        if (task.getTaskType().getId() != 4) {
                            deletePersonList(task);
                            savePersonListForDS(task);
                            deleteScheduleList(task);
                            saveScheduleList(task);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void delete(Task task) {
        deletePersonList(task);
        task.setUpdateTime(new Date());
        taskDao.delete(task);
    }

    public void deleteScheduleList(Task task) {
        taskScheduleDao.deleteByTask(task);
    }

    public void saveScheduleList(Task task) {
        for (SecurityCompanySchedule cs : task.getScheduleList()) {
            TaskSchedule ts = new TaskSchedule();
            ts.setCreateTime(task.getCreateTime());
            ts.setNativeCode(task.getNativeCode());
            ts.setTaskId(task.getId());
            ts.setSchedule(cs);
            taskScheduleDao.save(ts);
        }
    }

    @Override
    public void deletePersonList(Task task) {
        List<TaskPerson> taskPersonList = taskPersonDao.findByTaskId(task.getId());
        for (TaskPerson tp : taskPersonList) {
            List<TaskPersonSchedule> tpsList = taskPersonScheduleDao.findByTaskPersonIdStatus(tp.getId(), null);
            for (TaskPersonSchedule tps : tpsList) {
                taskPersonScheduleDao.deleteDetailByPersonSchedule(tps);
            }
            taskPersonScheduleDao.deleteByTaskPersonId(tp.getId());
        }
        taskPersonDao.deleteByTask(task);
    }

    /**
     * @author zhangye
     * v1.0.9 修改推送紧急通知新增返回值taskId和urgentMark
     */
    public void savePersonList(Task task) {
        for (TaskPerson tp : task.getPersonList()) {
            tp.setCreateTime(task.getCreateTime());
            tp.setNativeCode(task.getNativeCode());
            tp.setTaskId(task.getId());
            tp.setAcceptStatus(1);//2017-11-08 创建即接收状态
            taskPersonDao.save(tp);
            SecurityPerson person = personDao.findById(tp.getPerson().getId());

            for (TaskPersonSchedule tps : tp.getScheduleList()) {
                tps.setNativeCode(tp.getNativeCode());
                tps.setTaskPersonId(tp.getId());
                taskPersonScheduleDao.save(tps);
                for (SecurityCompanySchedule scs : tps.getScheduleDetail()) {
                    TaskPersonScheduleDetail personScheduleDetail = new TaskPersonScheduleDetail();
                    personScheduleDetail.setNativeCode(tps.getNativeCode());
                    personScheduleDetail.setPersonScheduleId(tps.getId());
                    personScheduleDetail.setScheduleId(scs.getId());
                    taskPersonScheduleDao.saveDetail(personScheduleDetail);
                }
            }

            appNoticeService.saveByTaskPerson(task, tp);

            updateAcceptStatus(tp);
        }
    }

    public void savePersonListForDS(Task task) {
        for (TaskPerson tp : task.getPersonList()) {
            tp.setCreateTime(task.getCreateTime());
            tp.setNativeCode(task.getNativeCode());
            tp.setTaskId(task.getId());
            tp.setAcceptStatus(0);
            taskPersonDao.save(tp);

            for (TaskPersonSchedule tps : tp.getScheduleList()) {
                tps.setNativeCode(tp.getNativeCode());
                tps.setTaskPersonId(tp.getId());
                taskPersonScheduleDao.save(tps);
                for (SecurityCompanySchedule scs : tps.getScheduleDetail()) {
                    TaskPersonScheduleDetail personScheduleDetail = new TaskPersonScheduleDetail();
                    personScheduleDetail.setNativeCode(tps.getNativeCode());
                    personScheduleDetail.setPersonScheduleId(tps.getId());
                    personScheduleDetail.setScheduleId(scs.getId());
                    taskPersonScheduleDao.saveDetail(personScheduleDetail);
                }
            }
        }
    }

    @Override
    public List<Task> findByPerson(SecurityPerson person) {
        Date now = new Date();
        String weekDay = DateUtil.getWeekOfDate(now);
        String today = DateUtil.systemDate.format(now);
        List<Task> weekList = taskDao.findByPerson(person.getId(), weekDay, today, Constants.TASK_ALERT_MIN);
        List<Task> dateList = taskDao.findByPerson(person.getId(), today, today, Constants.TASK_ALERT_MIN);
        List<Task> data = new ArrayList<Task>();
        if (weekList.size() > 0) {
            data.addAll(weekList);
        }
        if (dateList.size() > 0) {
            data.addAll(dateList);
        }
        return data;
    }

    @Override
    public List<ReportData> findAreaReport() {
        User user = arsUtil.getCurrentUser();
        SecurityCompany sc = companyService.getCurrentUserCompany();
        TaskSearchDto dto = new TaskSearchDto();
        if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        } else if (sc == null) {
            return null;
        } else {
            dto.setCompanyId(sc.getId());
        }

        return taskDao.findAreaReport(dto);
    }

    @Override
    public Map<String, String[]> findCatalogReport() {
        User user = arsUtil.getCurrentUser();

        SecurityCompany sc = companyService.getCurrentUserCompany();
        TaskSearchDto dto = new TaskSearchDto();
        if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        } else if (sc == null) {
            return null;
        } else {
            dto.setCompanyId(sc.getId());
        }

        List<ReportData> list = taskDao.findCatalogReport(dto);
        Map<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ReportData rd = list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    @Override
    public List<ReportData> findLevelReport() {
        User user = arsUtil.getCurrentUser();
        SecurityCompany sc = companyService.getCurrentUserCompany();
        TaskSearchDto dto = new TaskSearchDto();
        if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        } else if (sc == null) {
            return null;
        } else {
            dto.setCompanyId(sc.getId());
        }
        return taskDao.findLevelReport(dto);
    }

    @Override
    public void updateStatus() {
        taskDao.updateStatus();
        /*Date now = new Date();
        String weekday = DateUtil.getWeekOfDate(now);
        String today = DateUtil.systemDate.format(now);
        //更新到未执行
        List<Task> beforeList = new ArrayList<Task>();
        List<Task> before1 = taskDao.findBefore(weekday, today, Constants.TASK_ALERT_MIN);
        beforeList.addAll(before1);
        List<Task> before2 = taskDao.findBefore(today, today, Constants.TASK_ALERT_MIN);
        beforeList.addAll(before2);
        if (beforeList.size() > 0) {
            taskDao.updateStatus(1l, beforeList);
        }
        //更新到执行中
        List<Task> ingList = new ArrayList<Task>();
        List<Task> ing1 = taskDao.findING(weekday, today);
        ingList.addAll(ing1);
        List<Task> ing2 = taskDao.findING(today, today);
        ingList.addAll(ing2);
        if (ingList.size() > 0) {
            taskDao.updateStatus(2l, ingList);
        }*/
    }

    @Override
    public void updateEndStatus() {/*
        //更新到已结束
        List<Task> endList = taskDao.findEndTask();
        if (endList.size() > 0) {
            taskDao.updateStatus(3l, endList);

            //更新子任务状态
            for (Task t : endList) {
                //更新保安的任务状态
                List<TaskFeedback> list = feedbackDao.findByTaskId(t.getId());
                for (TaskFeedback taskfeedback : list) {
                    if (StringUtil.isEmpty(taskfeedback.getFeedbackStatus()) && StringUtil.isNotEmpty(taskfeedback.getSignStatus())) {
                        //任务状态
                        taskfeedback.setFeedbackStatus("3");
                        //更新日期
                        taskfeedback.setEndTime(new Date());
                        taskfeedback.setUpdateTime(new Date());
                        feedbackDao.update(taskfeedback);
                    }
                }
            }
        }
        //更新人员已完成任务状态
        taskPersonDao.updateFinish();
        //更新人员对任务接受状态已过期
        taskPersonDao.updateUnAccept();
        //紧急任务结束
        List<Task> urgentlist = taskDao.findUrgentAll();
        if (urgentlist != null && urgentlist.size() > 0) {
            TaskStatus status = new TaskStatus();
            status.setId(3l);
            for (Task t : urgentlist) {
                List<TaskPerson> taskperson = taskPersonDao.findByTaskId(t.getId());
                //结束之后对未接受紧急任务人员，改个状态。
                if (taskperson != null && taskperson.size() > 0) {
                    for (TaskPerson tp : taskperson) {
                        if (tp.getAcceptStatus() == 0) {
                            tp.setAcceptStatus(4);//紧急任务超时
                            tp.setRejectReason("紧急任务超时接受状态！！！");
                            tp.setUpdateTime(new Date());
                            taskPersonDao.update(tp);
                        } else if (tp.getAcceptStatus() == 1) {
                            tp.setAcceptStatus(3);//紧急任务结束
                            tp.setUpdateTime(new Date());
                            taskPersonDao.update(tp);
                        }
                    }
                }
                //更新保安的任务状态
                List<TaskFeedback> list = feedbackDao.findByTaskId(t.getId());
                for (TaskFeedback taskfeedback : list) {
                    if (taskfeedback.getTaskStatus().getId() == 3l) {
                        //任务状态
                        taskfeedback.setTaskStatus(status);
                        //任务结束时间
                        //更新日期
                        if (StringUtil.isNotEmpty(t.getEndDate())) {
                            taskfeedback.setEndTime(DateUtil.convertStringToDate(t.getEndDate()));
                        }
                        taskfeedback.setUpdateTime(new Date());
                        feedbackDao.update(taskfeedback);
                    }
                }
            }
        }*/
    }

    @Override
    public void updateAcceptStatus(TaskPerson taskPerson) {

        logger.info((taskPerson != null && taskPerson.getTaskId() != null && taskPerson.getPerson() != null) + "");

        if (taskPerson != null && taskPerson.getTaskId() != null && taskPerson.getPerson() != null) {
            logger.info((taskPerson.getPerson().getId() != null && taskPerson.getAcceptStatus() != null) + "");


            if (taskPerson.getPerson().getId() != null && taskPerson.getAcceptStatus() != null) {
                TaskPerson dbTaskPerson = taskPersonDao.findByTaskIdPersonId(taskPerson.getTaskId(), taskPerson.getPerson().getId());
                if (dbTaskPerson.getAcceptStatus().equals(4)) {
                    throw new ArsException("任务已过期！");
                }
                if (taskPerson.getAcceptStatus().equals(2)) {//拒绝任务
                    if (dbTaskPerson.isInCharge()) {
                        throw new ArsException("负责人不能拒绝接受任务！");
                    }
                }
                dbTaskPerson.setAcceptStatus(taskPerson.getAcceptStatus());
                dbTaskPerson.setRejectReason(taskPerson.getRejectReason());
                dbTaskPerson.setUpdateTime(new Date());
                taskPersonDao.update(dbTaskPerson);
                if (taskPerson.getAcceptStatus().equals(1)) {
                    Task task = taskDao.findSaasTaskById(taskPerson.getTaskId());
                    if (task == null) {
                        task = taskDao.findUrgentById(taskPerson.getTaskId());
                    }
                    //如果是紧急任务
                    if (task != null && task.getTaskType().getId() == 4l) {
                        //紧急任务接受后，删除其他未接受的紧急任务
                        //判断人员当前是否有紧急任务，如果有则不推送
                        List<TaskPerson> list = taskPersonDao.findUnAcceptByPersonId(taskPerson.getPerson().getId());
                        for (TaskPerson tPerson : list) {
                            List<TaskPersonSchedule> tpsList = taskPersonScheduleDao.findByTaskPersonIdStatus(tPerson.getId(), null);
                            for (TaskPersonSchedule tps : tpsList) {
                                taskPersonScheduleDao.deleteDetailByPersonSchedule(tps);
                            }
                            taskPersonScheduleDao.deleteByTaskPersonId(tPerson.getId());
                            taskPersonDao.delete(tPerson);
                        }

                        //通知本人
                        String urgentTaskMsg = Constants.URGENTTASK_MSG;
                        urgentTaskMsg = urgentTaskMsg.replace("%TASKNAME%", task.getName());
                        urgentTaskMsg = urgentTaskMsg.replace("%ADDRESS%", task.getAddress());
                        SecurityPerson person = personDao.findById(taskPerson.getPerson().getId());
                        //短信通知
                        MessageUtil.sendMessage(person.getPhone(), urgentTaskMsg.replace("%PERSONNAME%", person.getRealName()), messageLogDao);
                        //获取单位信息
                        SecurityCompany company = person.getRelation().getCompany();
                        //MessageUtil.sendMessage(companyUser.getPhone(), urgentTaskMsg.replace("%PERSONNAME%", companyUser.getRealname()));
                        /*	SecurityCompany company = taskPerson.getPerson().getRelation().getCompany();
						//通知法人
						User companyUser = company.getUser();
						*/
                        //通知应急小队负责人
                        List<UrgentPerson> personList = urgentTeamPersonDAO.queryUrgentPersonByCompnyId(company.getId());
                        if (personList != null) {
                            for (UrgentPerson urgentPerson : personList) {
                                if (urgentPerson.isInCharge()) {
                                    String urgentChargeTaskMsg = Constants.URGENTTASK_MSG;
                                    urgentChargeTaskMsg = urgentChargeTaskMsg.replace("%TASKNAME%", task.getName());
                                    urgentChargeTaskMsg = urgentChargeTaskMsg.replace("%ADDRESS%", task.getAddress());
                                    MessageUtil.sendMessage(urgentPerson.getPhone(), urgentChargeTaskMsg.replace("%PERSONNAME%", person.getRealName()), messageLogDao);
                                }
                            }
                        }
                    }

                    //任务被接受后，创建具体的任务
//					new Thread(()->{ //异步处理
                    try {
                        createTaskFeedbackByTask(task, taskPerson.getPerson().getId());
                    } catch (Exception e) {

                    }
//					}).start();
                }
            } else {
                throw new ArsException("数据异常");
            }
        } else {
            throw new ArsException("数据异常");
        }
    }

    @Override
    public List<Task> findByPersonAcceptStatus(Long personId, Integer acceptStatus) {
        return taskDao.findByPersonAcceptStatus(personId, acceptStatus);
    }

    /*@Override
    public List<Task> findTaskListByPersonid(Long personId){
        return taskDao.findTaskListByPersonid(personId);
    }*/
    @Override
    public void autoCreateTaskFeedback() {
        TaskSearchDto dto = new TaskSearchDto();
        dto.setIsRepeat(1);
        dto.setTaskType(1);
        dto.setPaging(false);
        List<Task> taskList = taskDao.search(dto);
        for (Task task : taskList) {
            autoCreateTaskFeedbackByTask(task);
        }
    }

    private void autoCreateTaskFeedbackByTask(Task task) {
        Long nativeCode = task.getNativeCode();
        if (nativeCode == null) {
            nativeCode = Long.parseLong("3502");
        }
        List<TaskPerson> personList = task.getPersonList();
        for (TaskPerson taskPerson : personList) {
            if (taskPerson.getAcceptStatus() != null && taskPerson.getAcceptStatus().equals(1)) {
                List<TaskPersonSchedule> scheduleList = taskPerson.getScheduleList();
                for (TaskPersonSchedule taskPersonSchedule : scheduleList) {
                    List<SecurityCompanySchedule> scheduleDetails = taskPersonSchedule.getScheduleDetail();
                    String taskDate = taskPersonSchedule.getTaskDate();
                    if (task.getTaskType().getId().equals(1l) && task.isRepeat()) {//周期任务-固定班次

                        List<String> nextweeks = DateUtil.getNextWeekDates();
                        for (String nextweek : nextweeks) {
                            if (DateUtil.getWeekOfDate(nextweek).equals(taskDate)) {
                                feedbackDao.deleteByTaskIdPersonIdTaskDate(task.getId(), taskPerson.getPerson().getId(), nextweek);
                                for (SecurityCompanySchedule securityCompanySchedule : scheduleDetails) {
                                    //TODO
                                    TaskFeedback feedback = new TaskFeedback();
                                    feedback.setNativeCode(nativeCode);
                                    feedback.setPerson(taskPerson.getPerson());
                                    feedback.setTask(task);
                                    feedback.setTaskDate(nextweek);
                                    feedback.setScheduleId(securityCompanySchedule.getId());
                                    feedback.setScheduleName(securityCompanySchedule.getName());
                                    feedback.setTaskStart(securityCompanySchedule.getStartTime());
                                    feedback.setTaskEnd(securityCompanySchedule.getEndTime());
                                    TaskStatus taskStatus = new TaskStatus();
                                    taskStatus.setId(1l);
                                    feedback.setTaskStatus(taskStatus);
                                    feedback.setCreateTime(new Date());
                                    feedback.setUpdateTime(new Date());

                                    //设置ID
                                    feedback.setId(idGeneratorUtil.createID());

                                    feedbackDao.save(feedback);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void createTaskFeedbackByTask(Task task, long personId) {
        Long nativeCode = arsUtil.getCurrentNatvie();
        String now = DateUtil.systemDate.format(new Date());
        if (nativeCode == null)
            nativeCode = task.getNativeCode();
        TaskPerson taskPerson = taskPersonDao.findByTaskIdPersonId(task.getId(), personId);
        if (taskPerson != null && taskPerson.getAcceptStatus() != null && taskPerson.getAcceptStatus().equals(1)) {

            if (task.getTaskType().getId().equals(4l)) {
                //紧急任务
                //TODO
                TaskFeedback feedback = new TaskFeedback();
                feedback.setNativeCode(nativeCode);
                feedback.setPerson(taskPerson.getPerson());
                feedback.setTask(task);
                //feedback.setTaskDate( );
                feedback.setTaskStart(DateUtil.convertDateToString(DateUtil.convertStringToDate(task.getStartDate()), DateUtil.FORMAT5));
                //		feedback.setTaskEnd(task.getEndDate());
                TaskStatus taskStatus = new TaskStatus();
                taskStatus.setId(2l);
                feedback.setTaskStatus(taskStatus);
                feedback.setScheduleId(1l);
                feedback.setTaskDate(DateUtil.getCurrentDate());
                feedback.setScheduleName("紧急任务");
                feedback.setStartTime(new Date());
                feedback.setCreateTime(new Date());
                feedback.setUpdateTime(new Date());

                //设置ID
                feedback.setId(idGeneratorUtil.createID());
                feedbackDao.save(feedback);
                return;
            }

            List<TaskPersonSchedule> scheduleList = taskPerson.getScheduleList();
            for (TaskPersonSchedule taskPersonSchedule : scheduleList) {
                List<SecurityCompanySchedule> scheduleDetails = taskPersonSchedule.getScheduleDetail();
                String taskDate = taskPersonSchedule.getTaskDate();
                if (task.getTaskType().getId().equals(2l) || (task.getTaskType().getId().equals(1l) && !task.isRepeat())) {
                    //临时任务或者周期任务--排班制
                    try {
                        Date tDate = DateUtil.systemDate.parse(taskDate);
                        Date currentDate = DateUtil.systemDate.parse(now);
                        if (tDate.getTime() < currentDate.getTime()) {
                            continue;
                        }
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    //TODO
                    feedbackDao.deleteByTaskIdPersonIdTaskDate(task.getId(), taskPerson.getPerson().getId(), taskDate);
                    for (SecurityCompanySchedule securityCompanySchedule : scheduleDetails) {
                        TaskFeedback feedback = new TaskFeedback();
                        feedback.setNativeCode(nativeCode);
                        feedback.setPerson(taskPerson.getPerson());
                        feedback.setTask(task);
                        feedback.setTaskDate(taskDate);
                        feedback.setScheduleId(securityCompanySchedule.getId());
                        feedback.setScheduleName(securityCompanySchedule.getName());
                        feedback.setTaskStart(securityCompanySchedule.getStartTime());
                        feedback.setTaskEnd(securityCompanySchedule.getEndTime());
                        TaskStatus taskStatus = new TaskStatus();
                        taskStatus.setId(1l);
                        feedback.setTaskStatus(taskStatus);
                        feedback.setCreateTime(new Date());
                        feedback.setUpdateTime(new Date());


                        //设置ID
                        feedback.setId(idGeneratorUtil.createID());
                        feedbackDao.save(feedback);
                    }
                } else if (task.getTaskType().getId().equals(1l) && task.isRepeat()) {//周期任务-固定班次
                    List<String> thisweeks = DateUtil.getThisWeekDates();
                    for (String thisweek : thisweeks) {
                        if (DateUtil.getWeekOfDate(thisweek).equals(taskDate)) {
                            //TODO
                            try {
                                Date tDate = DateUtil.systemDate.parse(thisweek);
                                Date currentDate = DateUtil.systemDate.parse(now);
                                if (tDate.getTime() < currentDate.getTime()) {
                                    continue;
                                }
                            } catch (ParseException e) {
                                logger.error(e.getMessage(), e);
                            }
                            feedbackDao.deleteByTaskIdPersonIdTaskDate(task.getId(), taskPerson.getPerson().getId(), thisweek);
                            for (SecurityCompanySchedule securityCompanySchedule : scheduleDetails) {
                                TaskFeedback feedback = new TaskFeedback();
                                feedback.setNativeCode(nativeCode);
                                feedback.setPerson(taskPerson.getPerson());
                                feedback.setTask(task);
                                feedback.setTaskDate(thisweek);
                                feedback.setScheduleId(securityCompanySchedule.getId());
                                feedback.setScheduleName(securityCompanySchedule.getName());
                                feedback.setTaskStart(securityCompanySchedule.getStartTime());
                                feedback.setTaskEnd(securityCompanySchedule.getEndTime());
                                TaskStatus taskStatus = new TaskStatus();
                                taskStatus.setId(1l);
                                feedback.setTaskStatus(taskStatus);
                                feedback.setCreateTime(new Date());
                                feedback.setUpdateTime(new Date());


                                //设置ID
                                feedback.setId(idGeneratorUtil.createID());
                                feedbackDao.save(feedback);
                            }
                        }
                    }

                    List<String> nextweeks = DateUtil.getNextWeekDates();
                    for (String nextweek : nextweeks) {
                        if (DateUtil.getWeekOfDate(nextweek).equals(taskDate)) {
                            //TODO
                            feedbackDao.deleteByTaskIdPersonIdTaskDate(task.getId(), taskPerson.getPerson().getId(), nextweek);
                            for (SecurityCompanySchedule securityCompanySchedule : scheduleDetails) {
                                TaskFeedback feedback = new TaskFeedback();
                                feedback.setNativeCode(nativeCode);
                                feedback.setPerson(taskPerson.getPerson());
                                feedback.setTask(task);
                                feedback.setTaskDate(nextweek);
                                feedback.setScheduleId(securityCompanySchedule.getId());
                                feedback.setScheduleName(securityCompanySchedule.getName());
                                feedback.setTaskStart(securityCompanySchedule.getStartTime());
                                feedback.setTaskEnd(securityCompanySchedule.getEndTime());
                                TaskStatus taskStatus = new TaskStatus();
                                taskStatus.setId(1l);
                                feedback.setTaskStatus(taskStatus);
                                feedback.setCreateTime(new Date());
                                feedback.setUpdateTime(new Date());


                                //设置ID
                                feedback.setId(idGeneratorUtil.createID());
                                feedbackDao.save(feedback);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void checkTaskDateSchedule(Long taskId, Long personId, Long scheduleId, Long taskTypeId, String taskDate) {
        List<TaskPerson> taskPersons = taskPersonDao.findByPersonId(personId);

        SecurityCompanySchedule choiseSchedule = securityCompanyScheduleService.findById(scheduleId);
        Long choiseStartTime = Long.parseLong(choiseSchedule.getStartTime().replaceAll("[-\\s:]", ""));
        Long choiseEndTime = Long.parseLong(choiseSchedule.getEndTime().replaceAll("[-\\s:]", ""));
        for (TaskPerson taskPerson : taskPersons) {
            for (TaskPersonSchedule taskPersonSchedule : taskPerson.getScheduleList()) {
                String checkDate = taskPersonSchedule.getTaskDate();
                String webDate = taskDate;
                if (taskTypeId == 2L) {//临时任务
                    if (checkDate.indexOf("周") > -1) {
                        webDate = DateUtil.getWeekOfDate(taskDate);
                    }
                } else {
                    if (taskDate.indexOf("周") > -1) {//周期固定班次
                        if (checkDate.indexOf("周") < 0) {//非星期的周期
                            checkDate = DateUtil.getWeekOfDate(checkDate);//转成星期再比对
                        }
                    } else {//周期排班
                        if (checkDate.indexOf("周") > -1) {
                            webDate = DateUtil.getWeekOfDate(taskDate);
                        }
                    }
                }
                if (checkDate.equals(webDate)) {
                    List<SecurityCompanySchedule> schedules = taskPersonSchedule.getScheduleDetail();
                    for (SecurityCompanySchedule securityCompanySchedule : schedules) {
                        Long startTime = Long.parseLong(securityCompanySchedule.getStartTime().replaceAll("[-\\s:]", ""));
                        Long endTime = Long.parseLong(securityCompanySchedule.getEndTime().replaceAll("[-\\s:]", ""));
                        //modify zjh time:2018年8月2日 11:28:45 逻辑写反了,加个非
                        // ID未空代表新任务，需要跟其他任务进行校验，人员的任务id跟本次的id1相等说明是自己修改本次任务也无需校验
                        if (taskId == null || !taskPerson.getTaskId().equals(taskId)) {
                            if ((choiseStartTime >= startTime && choiseStartTime <= endTime) || (choiseEndTime >= startTime && choiseEndTime <= endTime)
                                    || (startTime >= choiseStartTime && startTime <= choiseEndTime) || (endTime >= choiseStartTime && endTime <= choiseEndTime)) {
                                Task task = findById(taskPerson.getTaskId());
                                throw new ArsException("与任务：" + task.getName() + "<br>日期：" + taskPersonSchedule.getTaskDate() + "<br>班次："
                                        + securityCompanySchedule.getName() + "<br>时间:" + securityCompanySchedule.getStartTime() + "-" + securityCompanySchedule.getEndTime() + "冲突");
                            }
                        }
                    }
                }
            }
        }

    }

    @Override
    public List<Task> findTaskList(Long personId, Long taskStatus, Integer minutes) {
        return taskDao.findTaskList(personId, taskStatus, minutes);
    }

    @Override
    public Task findDetailByIdPerson(Long taskId, Long personId) {
        return taskDao.findDetailByIdPerson(taskId, personId);
    }

    @Override
    public TaskSearchDto searchForFeedback(TaskSearchDto dto) {
		/*User user = arsUtil.getCurrentUser();
		if(user == null || user.getPlatform().intValue() == 3) {
			SecurityPerson person = personDao.findByUserid(user.getId());
			dto.setPersonId(person.getId());
		}else {
			return null;
		}*/
        List<Task> data = taskDao.searchForFeedback(dto);
        Long count = taskDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public UrgentTaskDTO findUrgentTask(UrgentTaskDTO dto) {
        List<UrgentTaskDTO> data = taskDao.findUrgentTask(dto);
        Long count = taskDao.countUrgentTask(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public void saveUrgentTaskPerson(Long taskid, Long personid) {
        Task task = taskDao.findById(taskid);
        if (task.getPersonList() != null && task.getPersonList().size() == task.getNeednum()) {
            throw new ArsException("任务接受人数已满！");
        }
        SecurityPerson person = personDao.findById(personid);
        TaskPerson taskPerson = new TaskPerson();
        taskPerson.setTaskId(taskid);
        taskPerson.setPerson(person);
        taskPerson.setCreateTime(new Date());
        taskPerson.setNativeCode(arsUtil.getCurrentNatvie());
        taskPerson.setUpdateTime(task.getCreateTime());
        taskPersonDao.save(taskPerson);

        appNoticeService.saveByTaskPerson(task, taskPerson);
    }

    /**
     * @author zhangye
     * v1.0.9 修改推送紧急通知新增返回值taskId和urgentMark
     */
    @Override
    public boolean saveUrgentTaskPerson(Task task, SecurityPerson person) {
        //计算接受人员
        List<TaskPerson> personList = taskPersonDao.findByTaskId(task.getId());
        if (personList != null && personList.size() > 0) {
            int neednum = 0;
            for (TaskPerson taskPerson : personList) {
                if (taskPerson.getAcceptStatus() != null && taskPerson.getAcceptStatus() == 1) {
                    neednum++;
                }
            }
            if (neednum == task.getNeednum()) {//"任务接受人数已满！"
                return false;
            }
        }
        //判断是否有推送
        TaskPerson taskPerson = taskPersonDao.findByTaskIdPersonId(task.getId(), person.getId());
        if (taskPerson != null) {
            //如果已经推送了，没有接受再推送一次，提醒 TODO
            if (taskPerson.getAcceptStatus() == 0) {
                new Thread(() -> { //异步处理
                    try {
                        User u = userDao.findById(person.getId());
                        //推送ID
                        String registrationID = "";
                        if (StringUtil.isNotEmpty(u.getRegistrationID())) {
                            registrationID = u.getRegistrationID();
                        } else {
                            registrationID = u.getId().toString();
                        }
                        //紧急通知
                        if (task != null && task.getTaskType() != null && task.getTaskType().getId() != null && task.getTaskType().getId() == 4L) {
                            Map<String, String> map = new HashMap<String, String>();
                            map.put("taskId", task.getId().toString());
                            map.put("urgentMark", "true");
                            JPushUtil.sendMessage(Constants.ALERT_TITLE, Constants.ALERT_TASKNAME + task.getName(), registrationID, map);
                        } else {
                            JPushUtil.sendMessage(Constants.ALERT_TITLE, Constants.ALERT_TASKNAME + task.getName(), registrationID);
                        }
                    } catch (Exception e) {

                    }
                }).start();
            }
            return true;
        }
        taskPerson = new TaskPerson();
        //任务
        taskPerson.setTaskId(task.getId());
        //人员
        taskPerson.setPerson(person);
        //未接受
        taskPerson.setAcceptStatus(0);
        //创建日期
        taskPerson.setCreateTime(new Date());
        //区域编号
        taskPerson.setNativeCode(task.getNativeCode());
        //创建日期
        taskPerson.setUpdateTime(task.getCreateTime());
        taskPersonDao.save(taskPerson);

        appNoticeService.saveByTaskPerson(task, taskPerson);

        //安保任务人员排班
        TaskPersonSchedule taskPersonSchedule = new TaskPersonSchedule();
        taskPersonSchedule.setTaskDate(task.getStartDate());
        taskPersonSchedule.setTaskPersonId(taskPerson.getId());
        taskPersonSchedule.setNativeCode(task.getNativeCode());
        taskPersonScheduleDao.save(taskPersonSchedule);
        //班次
        SecurityCompanySchedule securityCompanySchedule = new SecurityCompanySchedule();
        securityCompanySchedule.setId(1l);
        //安保任务人员排班明细
        TaskPersonScheduleDetail taskPersonScheduleDetail = new TaskPersonScheduleDetail();
        taskPersonScheduleDetail.setNativeCode(task.getNativeCode());
        taskPersonScheduleDetail.setPersonScheduleId(taskPersonSchedule.getId());
        taskPersonScheduleDetail.setSchedule(securityCompanySchedule);
        taskPersonScheduleDetail.setScheduleId(1l);
        taskPersonScheduleDao.saveDetail(taskPersonScheduleDetail);
        //创建或者修改任务计划 向app推送任务消息
        new Thread(() -> { //异步处理
            try {
                User u = userDao.findById(person.getId());
                //推送ID
                String registrationID = "";
                if (StringUtil.isNotEmpty(u.getRegistrationID())) {
                    registrationID = u.getRegistrationID();
                } else {
                    registrationID = u.getId().toString();
                }

                //紧急通知
                if (task != null && task.getTaskType() != null && task.getTaskType().getId() != null && task.getTaskType().getId() == 4L) {
                    Map<String, String> map = new HashMap<String, String>();
                    map.put("taskId", task.getId().toString());
                    map.put("urgentMark", "true");
                    JPushUtil.sendMessage(Constants.ALERT_TITLE, Constants.ALERT_TASKNAME + task.getName(), registrationID, map);
                } else {
                    JPushUtil.sendMessage(Constants.ALERT_TITLE, Constants.ALERT_TASKNAME + task.getName(), registrationID);
                }

            } catch (Exception e) {

            }
        }).start();
        return true;
    }


    @Override
    public void endUrgentTaskMessage(Long taskid) {
        Task task = taskDao.findById(taskid);
        if (task == null) {
            throw new RuntimeException("任务不存在，ID:" + taskid);
        }
        //更新保安的任务状态
        List<TaskFeedback> list = feedbackDao.findByTaskId(taskid);
    }

    @Override
    public void endUrgentTask(Long taskid) {
        Task task = taskDao.findById(taskid);
        if (task == null) {
            throw new RuntimeException("任务不存在，ID:" + taskid);
        }
        TaskStatus status = new TaskStatus();
        status.setId(3l);
        task.setTaskStatus(status);
        Date date = new Date();
        Timestamp nousedate = new Timestamp(date.getTime());
        task.setEndDate(nousedate.toString().substring(0, 19));
        task.setUpdateTime(new Date());
        taskDao.update(task);
        List<TaskPerson> taskperson = taskPersonDao.findByTaskId(taskid);
        //结束之后对未接受紧急任务人员，改个状态,已接受的任务人员也改状态。
        if (taskperson != null && taskperson.size() > 0) {
            for (TaskPerson tp : taskperson) {
                if (tp.getAcceptStatus() == 0) {
                    tp.setAcceptStatus(4);//紧急任务超时
                    tp.setRejectReason("紧急任务超时授受状态！！！");
                    tp.setUpdateTime(new Date());
                } else if (tp.getAcceptStatus() == 1) {
                    tp.setAcceptStatus(3);//紧急任务结束
                    tp.setUpdateTime(new Date());
                }
                taskPersonDao.update(tp);
            }
        }

        //更新保安的任务状态
        List<TaskFeedback> list = feedbackDao.findByTaskId(taskid);
        for (TaskFeedback taskfeedback : list) {
            //任务状态
            taskfeedback.setTaskStatus(status);
            taskfeedback.setEndTime(DateUtil.convertStringToDate(task.getEndDate()));
            //任务结束时间
            taskfeedback.setEndTime(new Date());
            taskfeedback.setUpdateTime(new Date());
            feedbackDao.update(taskfeedback);


        }
    }

    @Override
    public TaskPerson findByPersonIdAndTaskId(Long personId, Long taskId) {
        return taskPersonDao.findByTaskIdPersonId(taskId, personId);
    }

    @Override
    public List<HotMap> findCompanyHot(Long companyid) {
        return taskDao.findCompanyHot(companyid);
    }

    @Override
    public List<HotMap> findPersonHot(Long personid) {
        return taskDao.findPersonHot(personid);
    }

    @Override
    public TaskSearchDto searchForManage(TaskSearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user.getPlatform().intValue() == 2) {
            SecurityCompany company = companyDao.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        }
        List<Task> data = taskDao.searchForManage(dto);
//		for(Task task : data) {
//			task.getScheduleList();
//		}
        Long count = taskDao.searchCountForManage(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public void sendUrgentTask() {
        List<Task> taskList = taskDao.findForSendUrgentMsg();
        for (Task task : taskList) {
            UrgentTaskThread taskThread = new UrgentTaskThread();
            taskThread.setMinute(6000);
            taskThread.setTaskDao(taskDao);
            taskThread.setPersonDao(personDao);
            taskThread.setTaskService(this);
            taskThread.setTaskId(task.getId());
            taskThread.run();
        }
    }

    @Override
    public void exportTask(Task task, File file) {
        // TODO Auto-generated method stub
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("任务信息");
//			wb.setSheetHidden(1, true);
            //标题
            String[] handers = {"id", "active", "create_time", "update_time", "update_by", "native_code", "company_id", "task_level",
                    "task_type", "task_catalog", "creater", "area", "address", "longitude", "latitude", "scope", "detail",
                    "task_status", "start_date", "end_date", "is_repeat", "auto_holiday", "urgenttype", "neednum", "urgentdegree", "peopletype",
                    "sendcount", "areacode", "rawid", "inrawid", "name"
            }; //列标题

            //生成sheet1内容
            HSSFRow rowFirst = sheet1.createRow(0);//第一个sheet的第一行为标题
            //样式
            CellStyle style = ExcelUtil.getCommonTitleStyle(wb);
            //文本格式
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            //写标题

            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); //设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle);//设置单元格格式 --文本格式
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]); //往单元格里写数据
            }
            int index = 1;
            HSSFRow row = null;

            CellStyle contentStyle = ExcelUtil.getStringStyle(wb);
            if (null != task) {
                row = sheet1.createRow(index++);
                HSSFCell nameCell0 = row.createCell(0);
                nameCell0.setCellStyle(contentStyle);
                nameCell0.setCellValue(task.getId()); //往单元格里写数据

                HSSFCell nameCell1 = row.createCell(1);
                nameCell1.setCellStyle(contentStyle);
                if (task.getActive() != null) {
                    nameCell1.setCellValue(task.getActive()); //往单元格里写数据
                }

                HSSFCell nameCell2 = row.createCell(2);
                nameCell2.setCellStyle(contentStyle);
                if (task.getCreateTime() != null) {
                    nameCell2.setCellValue(DateUtil.convertDateToString(task.getCreateTime(), "yyyy-MM-dd HH:mm:ss")); //往单元格里写数据
                }

                HSSFCell nameCell3 = row.createCell(3);
                nameCell3.setCellStyle(contentStyle);
                if (task.getUpdateTime() != null) {
                    nameCell3.setCellValue(DateUtil.convertDateToString(task.getUpdateTime(), "yyyy-MM-dd HH:mm:ss")); //往单元格里写数据
                }

                HSSFCell nameCell4 = row.createCell(4);
                nameCell4.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getUpdateBy())) {
                    nameCell4.setCellValue(task.getUpdateBy()); //往单元格里写数据
                }
                HSSFCell nameCell5 = row.createCell(5);
                nameCell5.setCellStyle(contentStyle);
                if (task.getNativeCode() != null) {
                    nameCell5.setCellValue(task.getNativeCode()); //往单元格里写数据
                }
                HSSFCell nameCell6 = row.createCell(6);
                nameCell6.setCellStyle(contentStyle);
                if (task.getCompany().getId() != null) {
                    nameCell6.setCellValue(task.getCompany().getId()); //往单元格里写数据
                }
                HSSFCell nameCell7 = row.createCell(7);
                nameCell7.setCellStyle(contentStyle);
                if (task.getTaskLevel() != null) {
                    nameCell7.setCellValue(task.getTaskLevel().getId()); //往单元格里写数据
                }
                HSSFCell nameCell8 = row.createCell(8);
                nameCell8.setCellStyle(contentStyle);
                if (task.getTaskType() != null) {
                    nameCell8.setCellValue(task.getTaskType().getId()); //往单元格里写数据
                }
                HSSFCell nameCell9 = row.createCell(9);
                nameCell9.setCellStyle(contentStyle);
                if (task.getTaskCatalog() != null) {
                    nameCell9.setCellValue(task.getTaskCatalog().getId()); //往单元格里写数据
                }
                HSSFCell nameCell10 = row.createCell(10);
                nameCell10.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getCreater())) {
                    nameCell10.setCellValue(task.getCreater()); //往单元格里写数据
                }
                HSSFCell nameCell11 = row.createCell(11);
                nameCell11.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getArea())) {
                    nameCell11.setCellValue(task.getArea()); //往单元格里写数据
                }

                HSSFCell nameCell12 = row.createCell(12);
                nameCell12.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getAddress())) {
                    nameCell12.setCellValue(task.getAddress()); //往单元格里写数据
                }
                HSSFCell nameCell13 = row.createCell(13);
                nameCell13.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getLongitude())) {
                    nameCell13.setCellValue(task.getLongitude()); //往单元格里写数据
                }
                HSSFCell nameCell14 = row.createCell(14);
                nameCell14.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getLatitude())) {
                    nameCell14.setCellValue(task.getLatitude()); //往单元格里写数据
                }

                HSSFCell nameCell15 = row.createCell(15);
                nameCell15.setCellStyle(contentStyle);
                if (task.getScope() != null) {
                    nameCell15.setCellValue(task.getScope()); //往单元格里写数据
                }

                HSSFCell nameCell16 = row.createCell(16);
                nameCell16.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getDetail())) {
                    nameCell16.setCellValue(task.getDetail()); //往单元格里写数据
                }


                HSSFCell nameCell17 = row.createCell(17);
                nameCell17.setCellStyle(contentStyle);
                if (task.getTaskStatus() != null) {
                    nameCell17.setCellValue(task.getTaskStatus().getId()); //往单元格里写数据
                }

                HSSFCell nameCell18 = row.createCell(18);
                nameCell18.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getStartDate())) {
                    nameCell18.setCellValue(task.getStartDate()); //往单元格里写数据
                }

                HSSFCell nameCell19 = row.createCell(19);
                nameCell19.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getEndDate())) {
                    nameCell19.setCellValue(task.getEndDate()); //往单元格里写数据
                }

                HSSFCell nameCell20 = row.createCell(20);
                nameCell20.setCellStyle(contentStyle);
                nameCell20.setCellValue(task.isRepeat()); //往单元格里写数据

                HSSFCell nameCell21 = row.createCell(21);
                nameCell21.setCellStyle(contentStyle);
                nameCell21.setCellValue(task.isAutoHoliday()); //往单元格里写数据

                HSSFCell nameCell22 = row.createCell(22);
                nameCell22.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getUrgenttype())) {
                    nameCell22.setCellValue(task.getUrgenttype()); //往单元格里写数据
                }
                HSSFCell nameCell23 = row.createCell(23);
                nameCell23.setCellStyle(contentStyle);
                if (task.getNeednum() != null) {
                    nameCell23.setCellValue(task.getNeednum()); //往单元格里写数据
                }
                HSSFCell nameCell24 = row.createCell(24);
                nameCell24.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getUrgentdegree())) {
                    nameCell24.setCellValue(task.getUrgentdegree()); //往单元格里写数据
                }
                HSSFCell nameCell25 = row.createCell(25);
                nameCell25.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getPeopletype())) {
                    nameCell25.setCellValue(task.getPeopletype()); //往单元格里写数据
                }
                HSSFCell nameCell26 = row.createCell(26);
                nameCell26.setCellStyle(contentStyle);
                if (task.getSendcount() != null) {
                    nameCell26.setCellValue(task.getSendcount()); //往单元格里写数据
                }
                HSSFCell nameCell27 = row.createCell(27);
                nameCell27.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(task.getAreacode())) {
                    nameCell27.setCellValue(task.getAreacode()); //往单元格里写数据
                }

                HSSFCell nameCell28 = row.createCell(28);
                nameCell28.setCellStyle(contentStyle);

                if (StringUtil.isNotEmpty(task.getName())) {
                    nameCell28.setCellValue(task.getName()); //往单元格里写数据
                }

            }
            //输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> importTask(File excel) throws Exception {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        User loginUser = arsUtil.getCurrentUser();
        if (loginUser != null && loginUser.getPlatform() == 1) {
            List<Long> saveList = new ArrayList<Long>();
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>();
            FileInputStream inStream = new FileInputStream(excel);
            Workbook workBook = WorkbookFactory.create(inStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 1;
            while (flag) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    Map<String, String> data = new HashMap<String, String>();
                    try {
                        Long id = Long.valueOf(ExcelUtil.getCellValue(row.getCell(0)));
                        data.put("id", id.toString());

                        String active = ExcelUtil.getCellValue(row.getCell(1));
                        data.put("active", active);

                        String create_time = ExcelUtil.getCellValue(row.getCell(2));
                        data.put("create_time", create_time);

                        String update_time = ExcelUtil.getCellValue(row.getCell(3));
                        data.put("update_time", update_time);

                        String update_by = ExcelUtil.getCellValue(row.getCell(4));
                        data.put("update_by", update_by);

                        String native_code = ExcelUtil.getCellValue(row.getCell(5));
                        data.put("native_code", native_code);

                        String company_id = ExcelUtil.getCellValue(row.getCell(6));
                        data.put("company_id", company_id);

                        String task_level = ExcelUtil.getCellValue(row.getCell(7));
                        data.put("task_level", task_level);

                        String task_type = ExcelUtil.getCellValue(row.getCell(8));
                        data.put("task_type", task_type);

                        String task_catalog = ExcelUtil.getCellValue(row.getCell(9));
                        data.put("task_catalog", task_catalog);

                        String creater = ExcelUtil.getCellValue(row.getCell(10));
                        data.put("creater", creater);

                        String area = ExcelUtil.getCellValue(row.getCell(11));
                        data.put("area", area);

                        String address = ExcelUtil.getCellValue(row.getCell(12));
                        data.put("address", address);

                        String longitude = ExcelUtil.getCellValue(row.getCell(13));
                        data.put("longitude", longitude);

                        String latitude = ExcelUtil.getCellValue(row.getCell(14));
                        data.put("latitude", latitude);

                        String scope = ExcelUtil.getCellValue(row.getCell(15));
                        data.put("scope", scope);

                        String detail = ExcelUtil.getCellValue(row.getCell(16));
                        data.put("detail", detail);


                        String task_status = ExcelUtil.getCellValue(row.getCell(17));
                        data.put("task_status", task_status);

                        String start_date = ExcelUtil.getCellValue(row.getCell(18));
                        data.put("start_date", start_date);

                        String end_date = ExcelUtil.getCellValue(row.getCell(19));
                        data.put("end_date", end_date);

                        String is_repeat = ExcelUtil.getCellValue(row.getCell(20));
                        data.put("is_repeat", is_repeat);

                        String auto_holiday = ExcelUtil.getCellValue(row.getCell(21));
                        data.put("auto_holiday", auto_holiday);

                        String urgenttype = ExcelUtil.getCellValue(row.getCell(22));
                        data.put("urgenttype", urgenttype);

                        String neednum = ExcelUtil.getCellValue(row.getCell(23));
                        data.put("neednum", neednum);

                        String urgentdegree = ExcelUtil.getCellValue(row.getCell(24));
                        data.put("urgentdegree", urgentdegree);

                        String peopletype = ExcelUtil.getCellValue(row.getCell(25));
                        data.put("peopletype", peopletype);

                        String sendcount = ExcelUtil.getCellValue(row.getCell(26));
                        data.put("sendcount", sendcount);

                        String areacode = ExcelUtil.getCellValue(row.getCell(27));
                        data.put("areacode", areacode);


                        String name = ExcelUtil.getCellValue(row.getCell(30));
                        data.put("name", name);


                        Task task = new Task();

                        task.setId(id);

                        if (StringUtil.isNotEmpty(active)) {
                            task.setActive(active.equals("FALSE") ? false : true);
                        }
                        if (StringUtil.isNotEmpty(create_time)) {
                            task.setCreateTime(DateUtil.convertStringToDate(create_time));
                        }
                        if (StringUtil.isNotEmpty(update_by)) {
                            task.setUpdateBy(update_by);
                        }
                        if (StringUtil.isNotEmpty(update_time)) {
                            task.setUpdateTime(DateUtil.convertStringToDate(update_time));
                        }
                        if (StringUtil.isNotEmpty(native_code)) {
                            task.setNativeCode(Long.parseLong(native_code));
                        }
                        if (StringUtil.isNotEmpty(company_id)) {
                            task.setCompany_id(Integer.parseInt(company_id));
                        }

                        if (StringUtil.isNotEmpty(task_level)) {
                            TaskLevel taskLevel = new TaskLevel();
                            taskLevel.setId(Long.parseLong(task_level));
                            task.setTaskLevel(taskLevel);
                        }
                        if (StringUtil.isNotEmpty(task_type)) {
                            TaskType taskType = new TaskType();
                            taskType.setId(Long.parseLong(task_type));
                            task.setTaskType(taskType);
                        }
                        if (StringUtil.isNotEmpty(task_catalog)) {
                            TaskCatalog TaskCatalog = new TaskCatalog();
                            TaskCatalog.setId(Long.parseLong(task_catalog));
                            task.setTaskCatalog(TaskCatalog);
                        }

                        if (StringUtil.isNotEmpty(creater)) {
                            task.setCreater(creater);
                        }
                        if (StringUtil.isNotEmpty(area)) {
                            task.setArea(area);
                        }
                        if (StringUtil.isNotEmpty(address)) {
                            task.setAddress(address);
                        }
                        if (StringUtil.isNotEmpty(longitude)) {
                            task.setLongitude(longitude);
                        }

                        if (StringUtil.isNotEmpty(latitude)) {
                            task.setLatitude(latitude);
                        }
                        if (StringUtil.isNotEmpty(scope)) {
                            task.setScope(Integer.parseInt(scope));
                        }

                        if (StringUtil.isNotEmpty(detail)) {
                            task.setDetail(detail);
                        }


                        if (StringUtil.isNotEmpty(task_status)) {
                            TaskStatus taskStatus = new TaskStatus();
                            taskStatus.setId(Long.parseLong(task_status));
                            task.setTaskStatus(taskStatus);
                        }

                        if (StringUtil.isNotEmpty(start_date)) {
                            task.setStartDate(start_date);
                        }
                        if (StringUtil.isNotEmpty(end_date)) {
                            task.setEndDate(end_date);
                        }
                        if (StringUtil.isNotEmpty(is_repeat)) {
                            task.setRepeat(is_repeat.equals("FALSE") ? false : true);
                        }
                        if (StringUtil.isNotEmpty(auto_holiday)) {
                            task.setAutoHoliday(auto_holiday.equals("FALSE") ? false : true);
                        }
                        if (StringUtil.isNotEmpty(urgenttype)) {
                            task.setUrgenttype(urgenttype);
                        }


                        if (StringUtil.isNotEmpty(neednum)) {
                            task.setNeednum(Integer.parseInt(neednum));
                        }
                        if (StringUtil.isNotEmpty(urgentdegree)) {
                            task.setUrgentdegree(urgentdegree);
                        }
                        if (StringUtil.isNotEmpty(peopletype)) {
                            task.setPeopletype(peopletype);
                        }
                        if (StringUtil.isNotEmpty(sendcount)) {
                            task.setSendcount(Integer.parseInt(sendcount));
                        }
                        if (StringUtil.isNotEmpty(areacode)) {
                            task.setAreacode(areacode);
                        }

                        if (StringUtil.isNotEmpty(name)) {
                            task.setName(name);
                        }


                        logger.info("saveOrupdate... " + task);
                        boolean isSave = false;
                        if (task.getId() == null) {
                            throw new ArsException("id缺失");
                        } else {

                            Task dbTask = taskDao.findById(task.getId());
                            if (dbTask == null) {
                                taskDao.save(task);
                            } else {
                                if (task.getUpdateTime().getTime() > dbTask.getUpdateTime().getTime()) {
                                    task.setId(dbTask.getId());
                                    taskDao.update(task);
                                    isSave = true;
                                }
                            }
                        }

                        if (isSave) {
                            Datasync dbdatasync = datasyncDao.findByBid(id);
                            if (dbdatasync != null) {
                                //状态已同步
                                dbdatasync.setState("2");
                                dbdatasync.setUpdateTime(new Date());
                                datasyncDao.update(dbdatasync);
                            }
                        }
                    } catch (Exception e) {
                        faildList.add(data);
                        logger.error("导入错误：" + data.get("id"), e);
                    }
                } else {
                    flag = false;
                }
                i++;
            }
//			if(faildList.size() > 0) {
//				resultMap.put("faildFilePath", buildFaildList(faildList));
//			}
            resultMap.put("successIds", saveList);
        } else {
            throw new RuntimeException("当前登录信息错误, user:" + loginUser);
        }
        return resultMap;

    }


    @Override
    public TaskDto findTaskDetail(TaskDetailSearchDto taskDetailDto) {
        TaskDto taskDto = taskDao.findTaskDetail(taskDetailDto);

        if (taskDto != null) {

            if (taskDto.getTaskType().getId() == 1l) {
                if (taskDto.isRepeat()) {
                    taskDto.setStartDate(taskDto.getCreateTime());
                } else {
                    TaskPerson taskPerson = taskPersonDao.findByTaskIdPersonId(taskDetailDto.getTaskid(), taskDetailDto.getPersonid());
                    if (taskPerson.getScheduleList() != null && taskPerson.getScheduleList().size() > 0) {
                        String taskDateStr = taskPerson.getScheduleList().get(0).getTaskDate();
                        Date taskDate = DateUtil.convertStringToDate(taskDateStr);
                        taskDateStr = DateUtil.convertDateToString(taskDate, DateUtil.FORMAT9) + "-01 00:00:00";
                        taskDate = DateUtil.convertStringToDate(taskDateStr);
                        int monthDays = DateUtil.getDaysOfMonth(taskDate);
                        Date createTime = DateUtil.convertStringToDate(taskDto.getCreateTime());
                        if (taskDate.getTime() > createTime.getTime()) {
                            taskDto.setStartDate(taskDateStr);
                        } else {
                            taskDto.setStartDate(taskDto.getCreateTime());
                        }
                        taskDto.setEndDate(DateUtil.convertDateToString(taskDate, DateUtil.FORMAT9) + "-" + (monthDays > 9 ? monthDays : ("0" + monthDays)) + " 00:00:00");
                    }
                }
            }

            TaskFeedBackDto nearFeedBack = feedbackDao.findNearFeedBack_back(taskDetailDto);
            if (nearFeedBack == null) {
                nearFeedBack = feedbackDao.findNearFeedBack_before(taskDetailDto);
            }
            taskDto.setNearfeedback(nearFeedBack);

            if (taskDto.getPersons() != null && taskDto.getPersons().size() > 0) {
                for (TaskPersonDto taskPersonDto : taskDto.getPersons()) {
                    taskPersonDto.setInitialname(FirstLetterUtil.getFirstLetter(taskPersonDto.getRealname().substring(0, 1)));
                }
            }

            if (nearFeedBack != null) {
                taskDetailDto.setTaskdate(DateUtil.convertDateToString(DateUtil.convertStringToDate(nearFeedBack.getTaskDate()), DateUtil.FORMAT9));
                List<TaskFeedBackDto> feedbacks = feedbackService.findTaskFeedbasksByTask(taskDetailDto, taskDto);
                taskDto.setFeedbacks(feedbacks);
            } else if (taskDto.getAcceptStatus().equals("0") || taskDto.getAcceptStatus().equals("2") || taskDto.getAcceptStatus().equals("4")) {
                taskDetailDto.setTaskdate(DateUtil.convertDateToString(new Date(), DateUtil.FORMAT9));
                List<TaskFeedBackDto> feedbacks = feedbackService.findTaskFeedbasksByTask(taskDetailDto, taskDto);
                if (feedbacks != null && feedbacks.size() > 0) {
                    taskDto.setFeedbacks(feedbacks);
                    TaskFeedBackDto nearMinFeedBackDto = null;
                    TaskFeedBackDto nearMaxFeedBackDto = null;
                    for (TaskFeedBackDto taskFeedBackDto : feedbacks) {
                        if (DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()).getTime() >= DateUtil.convertStringToDate(DateUtil.getCurrentDate()).getTime()) {
                            if (nearMinFeedBackDto == null) {
                                nearMinFeedBackDto = taskFeedBackDto;
                            } else if (DateUtil.convertStringToDate(nearMinFeedBackDto.getTaskDate()).getTime() >= DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()).getTime()) {
                                nearMinFeedBackDto = taskFeedBackDto;
                            }
                        } else {
                            if (nearMaxFeedBackDto == null) {
                                nearMaxFeedBackDto = taskFeedBackDto;
                            } else if (DateUtil.convertStringToDate(nearMaxFeedBackDto.getTaskDate()).getTime() <= DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()).getTime()) {
                                nearMaxFeedBackDto = taskFeedBackDto;
                            }
                        }
                    }
                    taskDto.setNearfeedback(nearMinFeedBackDto);
                    if (nearMinFeedBackDto == null) {
                        taskDto.setNearfeedback(nearMaxFeedBackDto);
                    }
                }

            }
        }

        return taskDto;
    }

    /**
     * app任务列表查询
     *
     * @param taskSearchDto
     * @return
     */
    @Override
    public TaskSearchDto findTaskListByPersonid(TaskSearchDto taskSearchDto) {
        TaskSearchDto resultDto = new TaskSearchDto();
        List<Task> list = taskDao.findTaskListByPersonid(taskSearchDto);
        resultDto.setData(list);
        resultDto.setTotalCount(taskDao.countTaskListByPersonid(taskSearchDto));
        return resultDto;

    }

    /**************************************V1.0.9APP版本****************************************************/
    /**
     * app任务列表查询
     *
     * @param taskSearchDto
     * @return
     */
    @Override
    public TaskSearchDto findTaskListByPersonid_V109(TaskSearchDto taskSearchDto) {
        TaskSearchDto resultDto = new TaskSearchDto();
        List<Task> list = taskDao.findTaskListByPersonid_V109(taskSearchDto);
        resultDto.setData(list);
        resultDto.setTotalCount(taskDao.countTaskListByPersonid_V109(taskSearchDto));
        return resultDto;

    }

    @Override
    public TaskDto findTaskDetailV109(TaskDetailSearchDto taskDetailDto) {
        TaskDto taskDto = taskDao.findTaskDetail_V109(taskDetailDto);
        if (taskDto != null) {
            taskDto.setPersons(taskPersonDao.findTaskPersonsByTaskId(taskDto.getTaskid()));
            if (taskDto.getTaskType().getId() == 1l) {
                if (taskDto.isRepeat()) {
                    taskDto.setStartDate(taskDto.getCreateTime());
                } else {
                    TaskPerson taskPerson = taskPersonDao.findByTaskIdPersonId(taskDetailDto.getTaskid(), taskDetailDto.getPersonid());
                    if (taskPerson.getScheduleList() != null && taskPerson.getScheduleList().size() > 0) {
                        String taskDateStr = taskPerson.getScheduleList().get(0).getTaskDate();
                        Date taskDate = DateUtil.convertStringToDate(taskDateStr);
                        taskDateStr = DateUtil.convertDateToString(taskDate, DateUtil.FORMAT9) + "-01 00:00:00";
                        taskDate = DateUtil.convertStringToDate(taskDateStr);
                        int monthDays = DateUtil.getDaysOfMonth(taskDate);
                        Date createTime = DateUtil.convertStringToDate(taskDto.getCreateTime());
                        if (taskDate.getTime() > createTime.getTime()) {
                            taskDto.setStartDate(taskDateStr);
                        } else {
                            taskDto.setStartDate(taskDto.getCreateTime());
                        }
                        taskDto.setEndDate(DateUtil.convertDateToString(taskDate, DateUtil.FORMAT9) + "-" + (monthDays > 9 ? monthDays : ("0" + monthDays)) + " 00:00:00");
                    }
                }
            }
            if (taskDto.getTaskType().getId() == 4l) {
                //紧急任务
                taskDto.setUrgent(true);
            } else {
                //非紧急任务
                taskDto.setUrgent(false);
            }
            TaskFeedBackDto nearFeedBack = feedbackDao.findNearFeedBack_back(taskDetailDto);
            if (nearFeedBack == null) {
                nearFeedBack = feedbackDao.findNearFeedBack_before(taskDetailDto);
            }
            taskDto.setNearfeedback(nearFeedBack);
            if (taskDto.getPersons() != null && taskDto.getPersons().size() > 0) {
                for (TaskPersonDto taskPersonDto : taskDto.getPersons()) {
                    taskPersonDto.setInitialname(FirstLetterUtil.getFirstLetter(taskPersonDto.getRealname().substring(0, 1)));
                }
            }
            if (nearFeedBack != null) {
                taskDetailDto.setTaskdate(DateUtil.convertDateToString(DateUtil.convertStringToDate(nearFeedBack.getTaskDate()), DateUtil.FORMAT9));
                List<TaskFeedBackDto> feedbacks = feedbackService.findTaskFeedbasksByTask_V109(taskDetailDto);
                taskDto.setFeedbacks(feedbacks);
            }
        }
        return taskDto;
    }
}
