package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.sys.ModulePermissionDao;
import com.bcxin.ars.model.sys.ModulePermission;
import com.bcxin.ars.service.sys.ModulePermissionService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/10/30 0030 9:34
 */
@Service
@Transactional
@DataSyncOutAnnotation(getClazz = ModulePermission.class)
public class ModulePermissionServiceImpl implements ModulePermissionService {

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ModulePermissionDao modulePermissionDao;

    @Override
    public void importBatch(List<ModulePermission> list) {
        List<ModulePermission> dbList = modulePermissionDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ModulePermission modulePermission : list) {
                modulePermission.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        modulePermission.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, modulePermission.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            modulePermissionDao.saveBatch(list);
        }
    }

    @Override
    public List<ModulePermission> findDSOutList(String startDate) {
        return modulePermissionDao.findDSOutList(startDate);
    }
}
