package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.subsidy.ExportConfigDaoAop;
import com.bcxin.ars.dao.sys.ExportConfigDao;
import com.bcxin.ars.dto.sys.ExportConfigDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ExportConfig;
import com.bcxin.ars.service.sys.ExportConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
@Transactional
public class ExportConfigServiceImpl implements ExportConfigService {

    @Autowired
    private ExportConfigDao exportConfigDao;
    @Autowired
    private ExportConfigDaoAop exportConfigDaoAop;
    @Autowired
    private ArsUtil arsUtil;

    @Override
    public void search(ExportConfigDto exportConfigDto, AjaxPageResponse<ExportConfig> page) {
        exportConfigDao.search(exportConfigDto,page);
    }

    @Override
    public ExportConfig findById(Long id) {
        return exportConfigDao.findById(id);
    }

    @Override
    public void save(ExportConfig exportConfig) {
        User currentUser = arsUtil.getCurrentUser();
        if(exportConfig.getId() == null){
            exportConfig.setCreateTime(new Date());
        }
        exportConfig.setActive(true);
        exportConfig.setUpdateBy(currentUser.getUsername());
        exportConfig.setUpdateTime(new Date());
        exportConfigDaoAop.save(exportConfig);
    }
}
