package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.service.sys.ApprovalLogService;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/04/08 0008.
 */
@Service
@Transactional
@DataSyncOutAnnotation(getClazz = ApprovalLog.class,getMethodName = "importBatchLog")
public class ApprovalLogServiceImpl implements ApprovalLogService {


    @Autowired
    private ApprovalLogDao approvalLogDao;

    @Autowired
    private ConfigDao configDao;


    @Override
    public List<ApprovalLog> findByProcessInstanceId(String processInstanceId) {
         Config config = configDao.findByKey(Constants.APPROVAL_VERSION_SWITCH);
        if(config != null && Constants.APPROVAL_VERSION_NEW.equals(config.getValue())){
            return approvalLogDao.findByProcessInstanceId_new(processInstanceId);
        }else{
            return approvalLogDao.findByProcessInstanceId(processInstanceId);
        }
      //return approvalLogDao.findByProcessInstanceId_new_old(processInstanceId);
    }

    @Override
    public List<ApprovalLog> findByApprovalId(String approvalId) {
        Config config = configDao.findByKey(Constants.APPROVAL_VERSION_SWITCH);
        if(config != null && Constants.APPROVAL_VERSION_NEW.equals(config.getValue())){
            return approvalLogDao.findByApprovalId_new(approvalId);
        }else{
            return approvalLogDao.findByApprovalId_old(approvalId);
        }
     // return approvalLogDao.findByApprovalId_new_old(approvalId);
    }
    @Override
    public Map findPrintfMessageByApprovalId(Map map) {
            return approvalLogDao.findPrintfMessageByApprovalId(map);
    }
    @Override
    public List<ApprovalLog> findApprovalLogByTime(String startDate,String endDate){
        return approvalLogDao.findApprovalLogByTime(startDate);
    }
    @Override
    public List<ApprovalLog> findByBatchId(List<ApprovalLog> approvalLogList){
        return approvalLogDao.findByBatchId(approvalLogList);
    }
    @Override
    public void importBatchLog(List<ApprovalLog> logList){
        List<ApprovalLog> dbExistIDList = this.findByBatchId(logList);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id判断是否需要更新。
        logList.removeAll(dbExistIDList);
        if (logList.size()>0){
            approvalLogDao.saveBatch(logList);
        }
    }

    @Override
    public List<ApprovalLog> findDSOutList(String startDate) {
        return approvalLogDao.findApprovalLogByTime(startDate);
    }

}
