package com.bcxin.ars.service.singleLogin.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.impl.SingleUserLoginBaseServiceImpl;
import com.bcxin.ars.service.singleLogin.SingleLoginService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import com.bjtoon.uia.sdk.UiaConstants;
import com.bjtoon.uia.sdk.client.DefaultUiaClient;
import com.bjtoon.uia.sdk.client.UiaClient;
import com.bjtoon.uia.sdk.domain.AccessTokenVo;
import com.bjtoon.uia.sdk.domain.UserInfoVo;
import com.bjtoon.uia.sdk.exception.UiaException;
import com.bjtoon.uia.sdk.request.UiaOauthAccessTokenRequest;
import com.bjtoon.uia.sdk.request.UiaOauthUserInfoRequest;
import com.bjtoon.uia.sdk.response.UiaOauthAccessTokenResponse;
import com.bjtoon.uia.sdk.response.UiaOauthUserInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;

/***
 * 北京单点登陆实现层
 */
@Service("singleLoginServiceBJImpl")
@Transactional
public class SingleLoginServiceBJImpl extends SingleUserLoginBaseServiceImpl implements SingleLoginService {
    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(SingleLoginServiceBJImpl.class);

    @Autowired
    private ConfigUtils configUtils;



    @Override
    public User getUserInfo(SingleUserDTO userInfo) {
        //查询是否存在sql中 不存在添加
        User user = null;
        /**
         * 消息
         */
        String tokenMsg = userInfo.getAccessToken();
        //核心请求客户端，构建后可复用
        UiaClient uiaClient = new DefaultUiaClient(configUtils.bj_zrr_singleLogin_url);
        try {
            //获取token
            if(StringUtil.isEmpty(tokenMsg)) {
                tokenMsg = getAccessToken(userInfo.getCode());
            }
            if ( !"getAccessTokenError".equals(tokenMsg)){
                logger.error("bj_zrr_client_secret:"+configUtils.bj_zrr_client_secret);
                UiaOauthUserInfoRequest uiaOauthUserInfoRequest = new UiaOauthUserInfoRequest("/api/info/getUserInfo",tokenMsg,configUtils.bj_zrr_client_secret);
                //解密返回的身份证号
                UiaOauthUserInfoResponse userInfoResponse = uiaClient.execute(uiaOauthUserInfoRequest, true);
                if (null != userInfoResponse && userInfoResponse.isSuccess()) {
                    UserInfoVo userInfoVo = userInfoResponse.getUserInfoVo();
                    //获取到用户之后
                    user  = new User();
                    user.setToken(tokenMsg);
                    user.setUniqueId(userInfoVo.getUniqueId());
                    user.setIdNumber(userInfoVo.getCertNo());
                    user.setPhone(userInfoVo.getMobile());
                    user.setPassword(userInfoVo.getMobile().substring(userInfoVo.getMobile().length()-6,userInfoVo.getMobile().length()));
                    user.setRealname(userInfoVo.getCertName());
                    user.setUsername(userInfoVo.getMobile());
                }else if(null != userInfoResponse){
                    logger.error(JSON.toJSONString(userInfoResponse));
                }
            }
        } catch (UiaException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return user;
    }
    /***
     * 获取access的tonken信息
     * @param code
     * @return
     */
    @Override
    public String getAccessToken(String code){
        String tokenMsg ="";
        //核心请求客户端，构建后可复用
        UiaClient uiaClient = new DefaultUiaClient(configUtils.bj_zrr_singleLogin_url);
        try {
            //获取 access_token
            UiaOauthAccessTokenRequest request =
                    new UiaOauthAccessTokenRequest("/api/oauth/getAccessToken",configUtils.bj_zrr_client_id,configUtils.bj_zrr_client_secret,code, UiaConstants.GRANT_TYPE_CODE, UiaConstants.SCOPE_USER_INFO);
            UiaOauthAccessTokenResponse tokenResponse = uiaClient.execute(request);

            if (tokenResponse.isSuccess()) {
                //调用成功
                AccessTokenVo accessTokenVo=tokenResponse.getAccessTokenVo();
                tokenMsg = accessTokenVo.getAccess_token();
            }else {
                tokenMsg = "getAccessTokenError";
                logger.error(JSON.toJSONString(tokenResponse));
            }
        } catch (UiaException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return tokenMsg;

    }
    @Override
    public AjaxResult handle(SingleUserDTO dto,HttpServletRequest request) {
        return login(dto,request);
    }
}
