package com.bcxin.ars.service.sb.impl;


import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sb.PerCerGrantDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.PerCerGrantPageSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.PerCerGrant;

import com.bcxin.ars.service.sb.PerCerGrantService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.approval.BusinessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

import java.util.List;

/**
 * 保安员证核发Service业务层处理
 * 
 * @author lin
 * @date 2022-09-01
 */
@Service
@Transactional
public class PerCerGrantServiceImpl implements PerCerGrantService {
    
    Logger logger = LoggerFactory.getLogger(PerCerGrantServiceImpl.class);
    
    @Autowired
    private PerCerGrantDao perCerGrantDao;

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private ApprovalUtil approvalUtil;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Override
    public int delete(PerCerGrant perCerGrant) {
        User currentUser = arsUtil.getCurrentUser();
        perCerGrant.setUpdateTime(new Date());
        perCerGrant.setUpdateBy(currentUser.getUsername());
        return perCerGrantDao.delete(perCerGrant);
    }

    @Override
    public int save(PerCerGrant perCerGrant) {
        User currentUser = arsUtil.getCurrentUser();
        if(perCerGrant.getId() == null){
            perCerGrant.setCreateTime(new Date());
        }else{
            PerCerGrant dbPerCerGrant = perCerGrantDao.findById(perCerGrant.getId());
            BeanUtils.copyPropertiesIgnore(perCerGrant,dbPerCerGrant,true);
            BeanUtils.copyPropertiesIgnore(dbPerCerGrant,perCerGrant,false);
        }

        perCerGrant.setActive(true);
        perCerGrant.setUpdateBy(currentUser.getUsername());
        perCerGrant.setUpdateTime(new Date());
        perCerGrant.setUpdateflag(true);
        perCerGrant.setUserid(currentUser.getId());
        return perCerGrantDao.save(perCerGrant);
    }

    @Override
    public PerCerGrant findById(Long id) {
        PerCerGrant result = perCerGrantDao.findById(id);
        if (result != null) {
            //查询审批日志信息
            result.setApproval(approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.BAYZHF));

            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }

        return result;
    }

    @Override
    public void searchForPage(PerCerGrantPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        perCerGrantDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<PerCerGrant> list) {
        List<PerCerGrant> dbList = perCerGrantDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (PerCerGrant perCerGrant : list) {
                perCerGrant.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        perCerGrant.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, perCerGrant.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            perCerGrantDao.saveBatch(list);
        }
    }

    @Override
    public List<PerCerGrant> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return perCerGrantDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<PerCerGrant> findDSOutList(String startDate) {
        return perCerGrantDao.findDSOutList(startDate);
    }

    @Override
    public List<PerCerGrant> findByBatchId(List<PerCerGrant> list) {
        return perCerGrantDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(PerCerGrant perCerGrant) {
        User currentUser = arsUtil.getCurrentUser();
        perCerGrant.setUpdateTime(new Date());
        perCerGrant.setUpdateBy(currentUser.getUsername());
        perCerGrantDao.updateSelective(perCerGrant);
    }

    @Override
    public void saveOrUpdateForIntegrate(PerCerGrant perCerGrant,User currentUser) {
        perCerGrant.setId(idGeneratorUtil.createID());
        perCerGrant.setActive(true);
        perCerGrant.setCreateTime(new Date());
        perCerGrant.setUpdateTime(new Date());
        perCerGrantDao.save(perCerGrant);
        approvalUtil.saveApprovalForIntegrate(BusinessType.BAYZHF, perCerGrant.getId(), Constants.ACTIVITI_PROCESS_PERCERGRANT,currentUser);
    }
}
