package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sb.ManagementInfoDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ManagementInfoPageSearchDto;
import com.bcxin.ars.dto.sb.ManagementInfoSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.ManagementInfo;
import com.bcxin.ars.service.sb.ManagementInfoService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.EntityForWebServiceUtil;
import com.bcxin.ars.util.KeyAndDefauleVal;
import com.bcxin.ars.webservice.Bafwgsglry;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = ManagementInfo.class)
public class ManagementInfoServiceImpl implements ManagementInfoService {



    private static Logger logger = LoggerFactory.getLogger(ManagementInfoServiceImpl.class);
    @Autowired
    private ManagementInfoDao managementInfoDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    
    @Autowired
    private SecurityPersonDao personDao;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ClientUtil clientUtil;

    @Autowired
    private UserDao userDao;

    @Override
    public ManagementInfo findById(long id) {
        return managementInfoDao.findById(id);
    }

    @Override
    public void saveOrUpdate(ManagementInfo managementInfo) {
    	User currentUser = arsUtil.getCurrentUser();
        if (managementInfo.getId() == null) {
            managementInfo.setActive(true);
            managementInfo.setCreateTime(new Date());
            managementInfo.setUpdateTime(new Date());
            managementInfo.setUpdateBy(currentUser.getUsername());
            managementInfo.setUserid(currentUser.getId());
            managementInfoDao.save(managementInfo);
        } else {
            ManagementInfo dbManagementInfo = managementInfoDao.findById(managementInfo.getId());
            dbManagementInfo.setUpdateTime(new Date());
            dbManagementInfo.setUpdateBy(currentUser.getUsername());
            dbManagementInfo.setUpdateTime(new Date());
            dbManagementInfo.setEducation(managementInfo.getEducation());
            dbManagementInfo.setJobLevel(managementInfo.getJobLevel());
            dbManagementInfo.setJobName(managementInfo.getJobName());
            dbManagementInfo.setManagerId(managementInfo.getManagerId());
            dbManagementInfo.setManagerLicenseType(managementInfo.getManagerLicenseType());
            dbManagementInfo.setPhone(managementInfo.getPhone());
            dbManagementInfo.setShareRatio(managementInfo.getShareRatio());
            dbManagementInfo.setName(managementInfo.getName());
            dbManagementInfo.setAbroadaddress(managementInfo.getAbroadaddress());
            dbManagementInfo.setAddress(managementInfo.getAddress());
            dbManagementInfo.setSex(managementInfo.getSex());
            dbManagementInfo.setManageNation(managementInfo.getManageNation());
            dbManagementInfo.setIsVeteran(managementInfo.getIsVeteran());
            dbManagementInfo.setDepartName(managementInfo.getDepartName());
            managementInfoDao.update(dbManagementInfo);
        }
    }

    @Override
    public ManagementInfoSearchDto search(ManagementInfoSearchDto dto) {
        ManagementInfoSearchDto resultDto = new ManagementInfoSearchDto();
        List<ManagementInfo> list = managementInfoDao.search(dto);
        resultDto.setData(list);
        if(dto.isPaging()) {
            resultDto.setTotalCount(managementInfoDao.searchCount(dto));
        }
        return resultDto;
    }

    @Override
    public void delete(ManagementInfo managementInfo) {
        User currentUser = arsUtil.getCurrentUser();
        managementInfo.setUpdateBy(currentUser.getUsername());
        managementInfo.setUpdateTime(new Date());
        managementInfoDao.delete(managementInfo);
    }

    @Override
    public List<ManagementInfo> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return managementInfoDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public void saveOrUpdateForDS(ManagementInfo managementInfo) {
        if (managementInfo.getActive() == null) {
            managementInfo.setActive(true);
        }
        if (!managementInfo.getActive()) {
            managementInfoDao.delete(managementInfo);


            /****************************************************部级接口调用 start*****************************/
            new Thread(()->{ //异步处理
                try {
                   User user = userDao.findById(managementInfo.getId());
                    buildWebServiceEntity(managementInfo,user);
                } catch(Exception e) {
                    logger.error(e.getMessage(),e);
                }
            }).start();
            /****************************************************部级接口调用 end*****************************/
        } else {
            ManagementInfo dbManagementInfo = managementInfoDao.findById(managementInfo.getId());
            if (dbManagementInfo == null) {
                managementInfoDao.saveForDS(managementInfo);
            } else {
                if (managementInfo.getUpdateTime().getTime() > dbManagementInfo.getUpdateTime().getTime()) {
                    managementInfoDao.update(managementInfo);
                }
            }
        }
    }

    @Override
    public void saveOrUpdateForSaas(ManagementInfo managementInfo) {

        User currentUser = arsUtil.getCurrentUser();
        ManagementInfo dbManagementInfo = managementInfoDao.findById(managementInfo.getId());

        if (null == dbManagementInfo) {
            managementInfo.setActive(true);
            managementInfo.setCreateTime(new Date());
            managementInfo.setUpdateTime(new Date());
            managementInfo.setUpdateBy(currentUser.getUsername());
            managementInfo.setUserid(currentUser.getId());
            managementInfoDao.save(managementInfo);
        } else {
            dbManagementInfo.setUpdateTime(new Date());
            dbManagementInfo.setUpdateBy(currentUser.getUsername());
            dbManagementInfo.setEducation(managementInfo.getEducation());
            dbManagementInfo.setJobLevel(managementInfo.getJobLevel());
            dbManagementInfo.setJobName(managementInfo.getJobName());
            dbManagementInfo.setManagerId(managementInfo.getManagerId());
            dbManagementInfo.setManagerLicenseType(managementInfo.getManagerLicenseType());
            dbManagementInfo.setPhone(managementInfo.getPhone());
            dbManagementInfo.setShareRatio(managementInfo.getShareRatio());
            dbManagementInfo.setName(managementInfo.getName());
            dbManagementInfo.setAbroadaddress(managementInfo.getAbroadaddress());
            dbManagementInfo.setAddress(managementInfo.getAddress());
            dbManagementInfo.setSex(managementInfo.getSex());
            dbManagementInfo.setManageNation(managementInfo.getManageNation());
            dbManagementInfo.setIsVeteran(managementInfo.getIsVeteran());
            dbManagementInfo.setDepartName(managementInfo.getDepartName());
            managementInfoDao.update(dbManagementInfo);
        }

    }

    /**
     * 创建WebService数据实体类
     *
     * @param managementInfo
     */
    private void buildWebServiceEntity(ManagementInfo managementInfo,User user
    ) throws Exception {
        Bafwgsglry bafwgsglry = new Bafwgsglry();
        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        SecurityCompany securityCompany = securityCompanyDao.findByUserid(user.getId());
        //公司编号
        bafwgsglry.setBagsbm(securityCompany.getCompanyCode());
        map.put("bagsbm", new KeyAndDefauleVal("bagsbm",bafwgsglry.getBagsbm() ));
        map.put("sfzh", new KeyAndDefauleVal("managerId", managementInfo.getManagerId()));
        //  map.put("csrq", new KeyAndDefauleVal("idNumber", IdNumUtil.getBirthByIdCard(managementInfo.getManagerId())));
        map.put("xm", new KeyAndDefauleVal("name", null));
        map.put("xb", new KeyAndDefauleVal("sex", managementInfo.getSex() == "男" ? 1 : 0));
        map.put("mz", new KeyAndDefauleVal("manageNation", null));
        map.put("zw", new KeyAndDefauleVal("jobName", null));
        map.put("baydj", new KeyAndDefauleVal("jobLevel", null));
        map.put("lxdh", new KeyAndDefauleVal("phone", null));
        map.put("gatlx", new KeyAndDefauleVal("managerLicenseType", "0"+managementInfo.getManagerLicenseType()));

        //无
        map.put("gj", new KeyAndDefauleVal("manageNation", ""));
        map.put("bz1", new KeyAndDefauleVal("manageNation", ""));
        map.put("bz2", new KeyAndDefauleVal("manageNation", ""));
        map.put("bz3", new KeyAndDefauleVal("manageNation", ""));

        try {
            EntityForWebServiceUtil.copy(map, managementInfo, bafwgsglry);
            clientUtil.send(Constants.XXBA_BAFWGSGLRY, bafwgsglry);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
    }

    @Override
    public void searchForPage(ManagementInfoPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        managementInfoDao.searchForPage(dto,page);
    }
}
