package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.InvestorDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.InvestorPageSearchDto;
import com.bcxin.ars.dto.sb.InvestorSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Investor;
import com.bcxin.ars.service.sb.InvestorService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.EntityForWebServiceUtil;
import com.bcxin.ars.util.KeyAndDefauleVal;
import com.bcxin.ars.webservice.Bafwgsczrxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Investor.class)
public class InvestorServiceImpl implements InvestorService {



    private static Logger logger = LoggerFactory.getLogger(InvestorServiceImpl.class);
    @Autowired
    private InvestorDao investorDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    
    @Autowired
    private SecurityPersonDao personDao;

    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Override
    public Investor findById(long id) {
        return investorDao.findById(id);
    }

    @Override
    public void saveOrUpdate(Investor investor) {
        User currentUser = arsUtil.getCurrentUser();
		boolean IsNull=true;
        if (investor.getId() != null){
            Investor dbInvestor = investorDao.findById(investor.getId());
            if (dbInvestor!=null){
                IsNull=false;
                dbInvestor.setUpdateBy(currentUser.getUsername());
                dbInvestor.setUpdateTime(new Date());
                BeanUtils.copyPropertiesIgnore(investor,dbInvestor,true);
                investorDao.update(dbInvestor);
            }
        }
        if (investor.getId() == null||IsNull) {
            investor.setActive(true);
            investor.setCreateTime(new Date());
            investor.setUpdateTime(new Date());
            investor.setUpdateBy(currentUser.getUsername());
            investor.setUserid(currentUser.getId());
            if (investor.getId()==null){
                investor.setId(idGeneratorUtil.createID());
            }
            investorDao.saveById(investor);
        }

    }

    @Override
    public InvestorSearchDto search(InvestorSearchDto dto) {
        InvestorSearchDto resultDto = new InvestorSearchDto();
        List<Investor> list = investorDao.search(dto);
        resultDto.setData(list);
        if(dto.isPaging()) {
            resultDto.setTotalCount(investorDao.searchCount(dto));
        }
        return resultDto;
    }

    @Override
    public void delete(Investor investor) {
        User currentUser = arsUtil.getCurrentUser();
        investor.setUpdateBy(currentUser.getUsername());
        investor.setUpdateTime(new Date());
        investorDao.delete(investor);
    }

    @Override
    public List<Investor> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return investorDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public void saveOrUpdateForDS(Investor investor) {

        if (investor.getActive() == null) {
            investor.setActive(true);
        }

        if (!investor.getActive()) {
            investorDao.delete(investor);
        } else {
            Investor dbInvestor = investorDao.findById(investor.getId());
            if (dbInvestor == null) {
                investorDao.saveForDS(investor);
                /****************************************************部级接口调用 start*****************************/
                new Thread(()->{ //异步处理
                    try {
                        buildWebServiceEntity(investor);
                    } catch(Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }).start();
                /****************************************************部级接口调用 end*****************************/
            } else {
                if (investor.getUpdateTime().getTime() > dbInvestor.getUpdateTime().getTime()) {
                    investorDao.update(investor);
                }
            }
        }
    }

    @Override
    public List<Investor> findByUserId(Long userId) {
        return investorDao.findByUserId(userId);
    }

    /**
     * 创建WebService数据实体类
     *
     * @param investor
     */
    private void buildWebServiceEntity(Investor investor) throws Exception {
        Bafwgsczrxx bafwgsczrxx = new Bafwgsczrxx();

        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        map.put("gj", new KeyAndDefauleVal("national", null));
        map.put("xb", new KeyAndDefauleVal("sex", investor.getSex()!=null?investor.getSex().equals("男") ? "1" : "2":"2"));
        map.put("xxdz", new KeyAndDefauleVal("nowaddress", null));
        map.put("zzje", new KeyAndDefauleVal("nowaddress", null));
        map.put("szbl", new KeyAndDefauleVal("stockProportion", null));
        //无
        map.put("sffr", new KeyAndDefauleVal("investorsType", investor.getInvestorsType().equals("2")?"1":"0"));
        map.put("zjlx", new KeyAndDefauleVal("investorsType", investor.getInvestorsType().equals("2")?"02":"01"));
        //从外部获取
        SecurityCompany securityCompany = securityCompanyDao.findByUserid(investor.getUserid());
        investor.setPublicSecurityLicenseNumber(securityCompany.getCompanyCode());
        map.put("bagsbm", new KeyAndDefauleVal("publicSecurityLicenseNumber", investor.getPublicSecurityLicenseNumber()));
        map.put("frmc", new KeyAndDefauleVal("companyCode", securityCompany.getLegalPerson()));
        map.put("gdsfzh", new KeyAndDefauleVal("idNumber", investor.getIdNumber()));
        try {
            EntityForWebServiceUtil.copy(map, investor, bafwgsczrxx);
            clientUtil.send(Constants.XXBA_BAFWGSCZRXX, bafwgsczrxx);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
    }

    @Override
    public void searchForPage(InvestorPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        investorDao.searchForPage(dto,page);
    }

}
