package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchRosterDao;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchRosterDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradeSubsidyBatchRoster;
import com.bcxin.ars.service.sb.GradeSubsidyBatchRosterService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
/**
 * 等级证补贴批次关联花名册Service实现类
 *
 * @author linqinglin
 * @Date 2020-05-20 09:11:59
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = GradeSubsidyBatchRoster.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
public class GradeSubsidyBatchRosterServiceImpl implements GradeSubsidyBatchRosterService {

    Logger logger = LoggerFactory.getLogger(GradeSubsidyBatchRosterServiceImpl.class);

    @Autowired
    private GradeSubsidyBatchRosterDao gradeSubsidyBatchRosterDao;

    @Autowired
    private GradeSubsidyBatchRosterDaoAop gradeSubsidyBatchRosterDaoAop;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
   
    @Override
    public int delete(GradeSubsidyBatchRoster gradeSubsidyBatchRoster) {
        User currentUser = arsUtil.getCurrentUser();
        gradeSubsidyBatchRoster.setUpdateTime(new Date());
        gradeSubsidyBatchRoster.setUpdateBy(currentUser.getUsername());
        return gradeSubsidyBatchRosterDaoAop.delete(gradeSubsidyBatchRoster);
    }

    @Override
    public int save(GradeSubsidyBatchRoster gradeSubsidyBatchRoster) {
        User currentUser = arsUtil.getCurrentUser();
        if(gradeSubsidyBatchRoster.getId() == null){
            gradeSubsidyBatchRoster.setCreateTime(new Date());
        }else{
            GradeSubsidyBatchRoster dbGradeSubsidyBatchRoster = gradeSubsidyBatchRosterDao.findById(gradeSubsidyBatchRoster.getId());
            BeanUtils.copyPropertiesIgnore(gradeSubsidyBatchRoster,dbGradeSubsidyBatchRoster,true);
            BeanUtils.copyPropertiesIgnore(dbGradeSubsidyBatchRoster,gradeSubsidyBatchRoster,false);
        }

        gradeSubsidyBatchRoster.setActive(true);
        gradeSubsidyBatchRoster.setUpdateBy(currentUser.getUsername());
        gradeSubsidyBatchRoster.setUpdateTime(new Date());
        gradeSubsidyBatchRoster.setUpdateflag(true);
        gradeSubsidyBatchRoster.setAreaCode(currentUser.getPolice().getAreacode());
        return gradeSubsidyBatchRosterDaoAop.save(gradeSubsidyBatchRoster);
    }

    @Override
    public GradeSubsidyBatchRoster findById(Long id) {
        return gradeSubsidyBatchRosterDao.findById(id);
    }

    @Override
    public void importBatch(List<GradeSubsidyBatchRoster> list) {
        List<GradeSubsidyBatchRoster> dbList = gradeSubsidyBatchRosterDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (GradeSubsidyBatchRoster gradeSubsidyBatchRoster : list) {
                gradeSubsidyBatchRoster.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                       gradeSubsidyBatchRoster.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, gradeSubsidyBatchRoster.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gradeSubsidyBatchRosterDaoAop.saveBatch(list);
        }
    }

    @Override
    public List<GradeSubsidyBatchRoster> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return gradeSubsidyBatchRosterDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<GradeSubsidyBatchRoster> findDSOutList(String startDate) {
        return gradeSubsidyBatchRosterDao.findDSOutList(startDate);
    }

    @Override
    public List<GradeSubsidyBatchRoster> findByBatchId(List<GradeSubsidyBatchRoster> list) {
        return gradeSubsidyBatchRosterDao.findByBatchId(list);
    }

}
