package com.bcxin.ars.service.sb.custompersoncertificate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.ActivityRepairDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.SecurityPersonSearchRerurnDTO;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/***
 * 广西保安员资格证打回实现类
 */
@Service
public class GxCustomPersoncertificateServiceImpl extends DefaultCustomPersoncertificateServiceImpl {

    @Autowired
    private ActivityRepairDao activityRepairDao;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    ApprovalService approvalService;

    /**
     * 查询哪些数据不能打回
     * @param
     * @return
     */
    @Override
    public AjaxResult checkReturn(Long[] perIds) {
        AjaxResult result = new AjaxResult();
        List<Personcertificate>   mapList =  activityRepairDao.checkReturnForGx(perIds);
        result.setMsg("流程打回-人员信息查询-返回成功");
        result.setSuccessful(true);
        if (mapList.size() > 0) {
            String personsInfo = "";
            for (Personcertificate detail : mapList) {
                if (StringUtil.isNotEmpty(detail.getName())) {
                    personsInfo += detail.getName();
                }
                personsInfo += "|";
                if (StringUtil.isNotEmpty(detail.getCardnumber())) {
                    personsInfo += detail.getCardnumber();
                }
                personsInfo += " ,";
            }
            if (personsInfo.length()>0){
                personsInfo=   personsInfo.substring(0, personsInfo.length() - 1);
            }
            result.setData("下列人员已经确认缴费，避免公安网内外网数据冲突无法打回，其余人可以继续打回，无法打回具体名单如下："+personsInfo);
            int mapSize=mapList.size();
            int personIdSize=     perIds.length;
            if (personIdSize==mapSize){
                result.setMsg("流程打回失败，所选人员都不可打回");
                result.setSuccessful(false);
                result.setData("");
                return result;
            }
        } else {
            result.setData("");
        }
        return result;
    }

    @Override
    public List<Personcertificate> getNoReturnList(Long[] perIds) {
        return activityRepairDao.checkReturnForGx(perIds);
    }

    @Override
    public JSONArray checkReturnList(List<Personcertificate> list) {
        JSONArray failList = new JSONArray();
        if(list.size() > 0) {
            list.forEach(detail->{
                JSONObject obj = new JSONObject();
                obj.put("id", detail.getId());
                obj.put("successful", false);
                obj.put("message", "已经确认缴费，避免公安网内外网数据冲突无法打回");
                failList.add(obj);
            });
        }

        return failList;
    }

    @Override
    public SecurityPersonSearchRerurnDTO findPersonByCompanyIdSearchReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO) {
        return null;
    }

    @Override
    public String getMsgTemp(String tempType, String testState) {
        if(Constants.TEST_STATE_TG.equals(testState)) {
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_MSG;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_CONTENT;

            }
        }else{
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_FAIL_MSG;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_FAIL_CONTENT;
            }
        }
    }

    @Override
    public String getMsgTemp_V1171(String tempType, String testState) {
        if(Constants.TEST_STATE_TG.equals(testState)) {
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_CONTENT_MSG_V1171;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_CONTENT_APP_V1171;
            }
        }else{
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_TEST_FAIL_CONTENT_MSG_V1171;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_TEST_FAIL_CONTENT_APP_V1171;
            }
        }
    }

    @Override
    public String getMsgTemp_V1172(String tempType, String testState) {
        if(Constants.TEST_STATE_TG.equals(testState)) {
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_MSG;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_CONTENT;
            }
        }else{
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_TEST_FAIL_MSG;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_TEST_FAIL_CONTENT;
            }
        }
    }

    /**
     * 保安员证内外网同步
     * 广西触发流程
     * @param personcertificate
     */
    @Override
    public void updateForDSByDiffArea(Personcertificate personcertificate) {

        if(!personcertificate.getNeedApprove()){
            updateForUnNeedApprove(personcertificate);
            return;
        }

        Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());
        if (
            //外网考试通过，内外网考试状态不一致
                (Constants.TEST_STATE_TG.equals(personcertificate.getTestState()) && !personcertificate.getTestState().equals(dbPersoncertificate.getTestState()))
                        ||
                        //外网结束考试标识为结束，内网结束考试标识不一致
                        (Constants.PROSTATE_YES.equals(personcertificate.getProState()) && !personcertificate.getProState().equals(dbPersoncertificate.getProState()))
                ) {
            ApprovalDTO approvalDTO = new ApprovalDTO();
            approvalDTO.setBusinesstype(BusinessType.BAYZ);
            approvalDTO.setBusinessid(personcertificate.getId());
            //考试通过
            if (Constants.TEST_STATE_TG.equals(personcertificate.getTestState())) {
                //补考通过
                if (Constants.MAKEUP_YES.equals(personcertificate.getIsMakeUp())) {
                    personcertificate.setMakeUpstate(Constants.MAKEUP_STATE_TG);
                    personcertificate.setApprovalstate(ApprovalState.SPZ);
                }
                // 审核通过,调用方法
                approvalDTO.setApprovalstate(ApprovalState.SHTG);
                approvalDTO.setApprovalreason("自动审批通过");
                approvalDTO.setConfirmOrder(personcertificate.getConfirmOrder());
            } else {
                // 考试不通过,调用方法
                //补考不通过
                if (Constants.MAKEUP_YES.equals(personcertificate.getIsMakeUp())) {
                    personcertificate.setMakeUpstate(Constants.MAKEUP_STATE_BTG);
                }
                //考试不通过
                personcertificate.setApprovalstate(ApprovalState.SHBTG);
                approvalDTO.setApprovalstate(ApprovalState.SHBTG);
                approvalDTO.setApprovalreason("自动审批不通过");
                approvalDTO.setOutreason("自动审批不通过");
            }
            approvalService.saveApprovalForZZ(approvalDTO);
        }
        super.updateForDSByDiffArea(personcertificate);
    }

    private void updateForUnNeedApprove(Personcertificate personcertificate){
        Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());
        if(Constants.TEST_STATE_TG.equals(personcertificate.getTestState()) && !personcertificate.getTestState().equals(dbPersoncertificate.getTestState())){
            Approval approval = approvalService.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
            if(!approval.getApprovalstate().equals(personcertificate.getApprovalstate())){
                approval.setApprovalstate(personcertificate.getApprovalstate());
            }
            approvalService.createCard(approval, Constants.IS_NEED_ACTIVITY_NO);
        }
    }
}
