package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SecurityPersonPractitionerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityPersonPractitionerDto;
import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.SecurityPersonPractitioner;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityPersonPractitionerService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.Baycyqkxx;
import com.bcxin.ars.webservice.ClientUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
public class SecurityPersonPractitionerServiceImpl implements SecurityPersonPractitionerService {

    private static Logger logger = LoggerFactory.getLogger(SecurityPersonPractitionerServiceImpl.class);

    @Autowired
    private SecurityPersonPractitionerDao securityPersonPractitionerDao;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ClientUtil clientUtil;
    @Override
    public List<SecurityPersonPractitioner> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return null;
    }

    @Override
    public void saveOrUpdate(SecurityPersonPractitioner securityPersonPractitioner) {
        User user = arsUtil.getCurrentUser();
        //判断是否存在，如果存在则为更新否则为保存
        SecurityPersonPractitioner dbSecurityPersonPractitioner = securityPersonPractitionerDao.findById(securityPersonPractitioner.getId());
        if (dbSecurityPersonPractitioner != null) {
            dbSecurityPersonPractitioner.setUser_id(user.getId());
            //设置修改时间
            dbSecurityPersonPractitioner.setUpdateTime(new Date());
            //设置修改者
            dbSecurityPersonPractitioner.setUpdateBy(user.getRealname());
            //如果不为空，则更新相应字段的值
            if (!StringUtils.isEmpty(securityPersonPractitioner.getBz1())) {
                dbSecurityPersonPractitioner.setBz1(securityPersonPractitioner.getBz1());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getBz2())) {
                dbSecurityPersonPractitioner.setBz2(securityPersonPractitioner.getBz2());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getBz3())) {
                dbSecurityPersonPractitioner.setBz3(securityPersonPractitioner.getBz3());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getCydwszd())) {
                dbSecurityPersonPractitioner.setCydwszd(securityPersonPractitioner.getCydwszd());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getLzyy())) {
                dbSecurityPersonPractitioner.setLzyy(securityPersonPractitioner.getLzyy());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getLzrq())) {
                dbSecurityPersonPractitioner.setLzrq(securityPersonPractitioner.getLzrq());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getRzrq())) {
                dbSecurityPersonPractitioner.setRzrq(securityPersonPractitioner.getRzrq());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getBafwlx())) {
                dbSecurityPersonPractitioner.setBafwlx(securityPersonPractitioner.getBafwlx());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getJnshbxxz())) {
                dbSecurityPersonPractitioner.setJnshbxxz(securityPersonPractitioner.getJnshbxxz());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getQdldhtdqr())) {
                dbSecurityPersonPractitioner.setQdldhtdqr(securityPersonPractitioner.getQdldhtdqr());
            }

            if (!StringUtils.isEmpty(securityPersonPractitioner.getQdldhtrq())) {
                dbSecurityPersonPractitioner.setQdldhtrq(securityPersonPractitioner.getQdldhtrq());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getCydwbh())) {
                dbSecurityPersonPractitioner.setCydwbh(securityPersonPractitioner.getCydwbh());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getCydwmc())) {
                dbSecurityPersonPractitioner.setCydwmc(securityPersonPractitioner.getCydwmc());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getCydwlx())) {
                dbSecurityPersonPractitioner.setCydwlx(securityPersonPractitioner.getCydwlx());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getSfzh())) {
                dbSecurityPersonPractitioner.setSfzh(securityPersonPractitioner.getSfzh());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getXb())) {
                dbSecurityPersonPractitioner.setXb(securityPersonPractitioner.getXb());
            }
            if (!StringUtils.isEmpty(securityPersonPractitioner.getXm())) {
                dbSecurityPersonPractitioner.setXm(securityPersonPractitioner.getXm());
            }
            securityPersonPractitionerDao.update(dbSecurityPersonPractitioner);
        } else {
            securityPersonPractitioner.setUser(user);
            securityPersonPractitioner.setUser_id(user.getId());
            //修改时间，创建时间在保存的时候一样
            securityPersonPractitioner.setCreateTime(new Date());
            securityPersonPractitioner.setUpdateTime(securityPersonPractitioner.getCreateTime());
            //默认可用
            securityPersonPractitioner.setActive(true);
            securityPersonPractitioner.setUpdateBy(user.getUsername());
            securityPersonPractitionerDao.save(securityPersonPractitioner);

            //部级接口对接  --保安员从业情况基本信息上报
           /* new Thread(()->{ //异步处理
				try {
					//确定对接的属性对应关系
					//源实体类的列，目标实体类的列
					String[] srccol = {"xm","xb","sfzh","cydwlx","cydwmc","cydwbh","qdldhtrq","qdldhtdqr","jnshbxxz","bafwlx","rzrq","lzrq"
							,"lzyy","cydwszd","bz1","bz2","bz3"};
					String[] desccol = {"xm","xb","sfzh","cydwlx","cydwmc","cydwbh","qdldhtrq","qdldhtdqr","jnshbxxz","bafwlx","rzrq","lzrq"
							,"lzyy","cydwszd","bz1","bz2","bz3"};
					//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
					String[] key = {};
					String[] value = {};
					//生成实体
					Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,securityPersonPractitioner,new Baycyqkxx(),key,value);
					Baycyqkxx baycyqkxx =(Baycyqkxx)desc;
					//调用send方法完成对接
					clientUtil.send(Constants.XXBA_BAYCYQKXX,baycyqkxx);

				} catch(Exception e) {
                    logger.error(e.getMessage(),e);
				}
			}).start();*/
            
        }

    }

    @Override
    public void delete(SecurityPersonPractitioner securityPersonPractitioner) {
        securityPersonPractitioner.setUpdateTime(new Date());
        securityPersonPractitionerDao.delete(securityPersonPractitioner);
    }

    @Override
    public SecurityPersonPractitioner findById(long id) {
        return securityPersonPractitionerDao.findById(id);
    }

    @Override
    public List<Organization> findBySfzh(String sfzh) {
        return null;
    }

    @Override
    public SecurityPersonPractitionerDto search(SecurityPersonPractitionerDto dto) {
        SecurityPersonPractitionerDto resultDto = new SecurityPersonPractitionerDto();
        List<SecurityPersonPractitioner> list = securityPersonPractitionerDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(securityPersonPractitionerDao.count(dto));
        return resultDto;
    }

    @Override
    public void saveOrUpdateForDS(SecurityPersonPractitioner securityPersonPractitioner) {

    }
}
