package com.bcxin.ars.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.InvoiceDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Invoice;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.service.InvoiceService;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.HttpClientUtils;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class InvoiceServiceImpl extends BaseService implements InvoiceService {
    private Logger logger = LoggerFactory.getLogger(InvoiceService.class);
    @Autowired
    private InvoiceDao invoiceDao;
    @Autowired
    private LogMessageDao logMessageDao;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;


    @Override
    public void save(Invoice invoice) {
        invoiceDao.save(invoice);
    }

    /**
     * 百课堂返回状态--成功
     */
    static public String IS_SUCCESS = "0";

    @Override
    public List<Invoice> getInvoiceList() {
        List<Invoice> lis = invoiceDao.getInvoiceList();
        return lis;
    }

    @Override
    public Invoice getMsg(Long userid) {
        Invoice lis = invoiceDao.getMsg(userid);
        return lis;
    }
    @Override
    public Invoice getMsgByUserName(String userName) {
        return invoiceDao.getMsgByUserName(userName);
    }

    @Override
    public void update(Invoice invoice) {
        invoice.setUpdateTime(new Date());
        invoiceDao.update(invoice);
        this.sentToBTK(invoice);
    }

    /**
     * @return void
     * @Decription:将更改的发票信息发送给百课堂
     * @author：zhongjianhui
     * @method sentToBTK
     * @date：2018/6/25 11:20
     * @params： * @param invoice
     */
    private void sentToBTK(Invoice invoice) {
        //获取数据库公安配置
        Config config = configDao.findByKey(Constants.POLICE);
        //是否为外网，外网才需要同步
        if (config != null && config.getValue() != null && !Constants.ISPOLICE_YES.equals(config.getValue())) {
            LogMessage logMessage = new LogMessage();
            Map dataMap = new HashMap();
            Map map = new HashMap();
            map.put("bbdSynId",invoice.getId().toString());
            map.put("invoiceName",invoice.getCompanyname());
            map.put("taxPayerNo",invoice.getTaxnumber());
            map.put("bankName",invoice.getBank());
            map.put("bankCode",invoice.getBankaccount());
            map.put("registphone",invoice.getTel());
            map.put("registAddress",invoice.getRegister());
            map.put("mailAddress",invoice.getSendaddress());
            map.put("personCertificate",invoice.getTaxprove());
            map.put("businessLicense",invoice.getBusinesslicense());
            map.put("tax",invoice.getCertificate());

            dataMap.put("data",JSON.toJSONString(map));
            logMessage.setLogger_title("百课堂账单同步");
            logMessage.setCreateTime(new Date());
            try {
                //获取百课堂配置地址
                Config configURL = configDao.findByKey(Constants.BKT_DATA_URL);

                if (configURL != null && configURL.getValue() != null) {
                    //"http://192.168.30.99:8888/"
                    String url = configURL.getValue() + Constants.BTKINVOICE_UPDATE;
                    //地址访问
                    String btkRtn = HttpClientUtils.doPost(url,dataMap,"utf-8");
                    if (btkRtn != null) {
                        //转成json
                        JSONObject jsonObject = JSONObject.parseObject(btkRtn);
                        //获取状态值
                        String retType = jsonObject.get("retType").toString();
                        String data = jsonObject.get("data").toString();
                        //判断非空且
                        if (!StringUtils.isEmpty(retType) && Constants.BTK_IS_SUCCESS.equals(retType)) {
                            logger.info("百课堂账单同步成功");
                        } else {
                            logger.info("百课堂账单同步失败");
                        }
                        if (!StringUtils.isEmpty(data)) {
                            logMessage.setLogger_context(data);
                            //保存错误日志
                            logMessageDao.save(logMessage);
                        }
                    }
                }
            } catch (Exception e) {
                logMessage.setLogger_context(e.toString());
                //保持错误日志
                logMessageDao.save(logMessage);
                logger.error(e.getMessage(),e);
            }
        }
    }

    @Override
    public Invoice findById(Long id) {
        return invoiceDao.findById(id);
    }

    @Override
    public AjaxResult saveOrUpdate(Invoice invoice, User user){
        AjaxResult ajaxResult=new AjaxResult();
        /***************************根据SaaS传过来的 税务登记证、营业执照副本、银行开户许可证 地址转换成 百保盾的地址 start add subh 2019-04-11 ************************************/
        //税务登记证
        if(StringUtil.isNotEmpty(invoice.getCertificate())) {
            //调用基类getPhotoPathl转换地址
            invoice.setCertificate(getPhotoPath(invoice.getCertificate()));
        }
        //营业执照副本
        if(StringUtil.isNotEmpty(invoice.getBusinesslicense())) {
            //调用基类getPhotoPathl转换地址
            invoice.setBusinesslicense(getPhotoPath(invoice.getBusinesslicense()));
        }
        //银行开户许可证
        if(StringUtil.isNotEmpty(invoice.getLicence())) {
            //调用基类getPhotoPathl转换地址
            invoice.setLicence(getPhotoPath(invoice.getLicence()));
        }
        /***************************根据SaaS传过来的 税务登记证、营业执照副本、银行开户许可证 地址转换成 百保盾的地址 end add subh 2019-04-11 ************************************/
        boolean IsNull=true;
        if (invoice.getId() != null){
            Invoice dbInvoice = invoiceDao.findById(invoice.getId());
            if (dbInvoice!=null){
                IsNull=false;
                dbInvoice.setUpdateTime(new Date());
                dbInvoice.setUpdateBy(user.getUsername());
                BeanUtils.copyPropertiesIgnore(invoice,dbInvoice,true);
                invoiceDao.update(dbInvoice);
            }
        }
        if (invoice.getId() == null||IsNull) {
            invoice.setCreateTime(new Date());
            invoice.setUpdateTime(new Date());
            invoice.setUserid(user.getId());
            invoice.setUpdateBy(user.getUsername());

            if (invoice.getId()==null){
                invoice.setId(idGeneratorUtil.createID());
            }
            invoiceDao.saveById(invoice);
        }
        return  ajaxResult;
    }

}
