package com.bcxin.ars.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.GuardStatusDao;
import com.bcxin.ars.model.GuardStatus;
import com.bcxin.ars.service.GuardStatusService;

@Service
@Transactional
public class GuardStatusServiceImpl implements GuardStatusService {

	@Autowired
	private GuardStatusDao guardStatusDao;
	
	@Override
	public List<GuardStatus> findAll() {
		return guardStatusDao.findAll();
	}

	@Override
	public GuardStatus findById(Long id) {
		return guardStatusDao.findById(id);
	}
	
	@Override
	public Map<Long, GuardStatus> findMap() {
		List<GuardStatus> statusList = guardStatusDao.findAll();
		Map<Long, GuardStatus> result = new HashMap<Long, GuardStatus>();
		for(GuardStatus status : statusList) {
			result.put(status.getId(), status);
		}
		return result;
	}
}
