package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.CyServerhtDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.CyServerhtSearchDto;
import com.bcxin.ars.model.CyServerht;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.CyServerhtService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = CyServerht.class)
public class CyServerhtServiceImpl implements CyServerhtService {

	@Autowired
	private CyServerhtDao cyServerhtDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Autowired
	private ArsUtil arsUtil;
	@Autowired
	private IdGeneratorUtil idGeneratorUtil;
	@Override
	public void saveOrUpdate(CyServerht cyServerht) {
        User user = arsUtil.getCurrentUser();
		CyServerht dbCyServerht = cyServerhtDao.findById(cyServerht.getId());
		//不是续签的合同
		if(dbCyServerht != null) {
			if(!cyServerht.getHtstate().equals(Constants.HTSTATE_XQ)){
				if(!StringUtils.isEmpty(cyServerht.getHtEndDate())) {
					dbCyServerht.setHtEndDate(cyServerht.getHtEndDate());
				}
				if(!StringUtils.isEmpty(cyServerht.getHtLife())) {
					dbCyServerht.setHtLife(cyServerht.getHtLife());
				}
				if(!StringUtils.isEmpty(cyServerht.getHtName())) {
					dbCyServerht.setHtName(cyServerht.getHtName());
				}
				if(!StringUtils.isEmpty(cyServerht.getHtNum())) {
					dbCyServerht.setHtNum(cyServerht.getHtNum());
				}
				if(!StringUtils.isEmpty(cyServerht.getHtStartDate())) {
					dbCyServerht.setHtStartDate(cyServerht.getHtStartDate());
				}
				if(!StringUtils.isEmpty(cyServerht.getServerObj())) {
					dbCyServerht.setServerObj(cyServerht.getServerObj());
				}
				if(!StringUtils.isEmpty(cyServerht.getHtstate())) {
					dbCyServerht.setHtstate(cyServerht.getHtstate());
				}
				if(!StringUtils.isEmpty(cyServerht.getHtqdStartDate())) {
					dbCyServerht.setHtqdStartDate(cyServerht.getHtqdStartDate());
				}
				if(!StringUtils.isEmpty(cyServerht.getSecurityNum())) {
					dbCyServerht.setSecurityNum(cyServerht.getSecurityNum());
				}
			}else{
				//续签之前的合同信息状态变为已完成
				dbCyServerht.setHtstate(Constants.HTSTATE_YWC);
                //生成新的合同记录，状态为已续签
				cyServerht.setUserid(user.getId());
				cyServerht.setCreateTime(new Date());
				cyServerht.setUpdateTime(cyServerht.getCreateTime());
				cyServerht.setActive(true);
				cyServerht.setUpdateBy(user.getUsername());
				cyServerht.setHtstate(Constants.HTSTATE_XQ);
				cyServerhtDao.save(cyServerht);
			}

			dbCyServerht.setUpdateTime(new Date());
			dbCyServerht.setUpdateBy(user.getRealname());
		    cyServerhtDao.update(dbCyServerht);
		}else{

			//生成新的合同记录，状态为已续签
			cyServerht.setUserid(user.getId());

			cyServerht.setCreateTime(new Date());
			cyServerht.setUpdateTime(cyServerht.getCreateTime());
			cyServerht.setActive(true);
			cyServerht.setUpdateBy(user.getUsername());
			cyServerht.setHtstate(Constants.HTSTATE_QD);
			if (cyServerht.getId()==null){
				cyServerht.setId(idGeneratorUtil.createID());
			}
			cyServerhtDao.saveById(cyServerht);
		}
		}

	@Override
	public void delete(CyServerht cyServerht) {
		cyServerht.setUpdateTime(new Date());
		cyServerhtDao.delete(cyServerht);
	}
	@Override
	public CyServerht findById(long id){
		return cyServerhtDao.findById(id);
	}



	@Override
	public CyServerhtSearchDto search(CyServerhtSearchDto dto) {
		List<CyServerht> list =  cyServerhtDao.search(dto);
		dto.setData(list);
		dto.setTotalCount(cyServerhtDao.count(dto));
		return dto;
	}

	@Override
	public AjaxResult relieveHt(Long htId) {
		AjaxResult result = new AjaxResult();
		User user = arsUtil.getCurrentUser();
		if(user == null || user.getPlatform().intValue() != 2) {
			result.setSuccessful(false);
		}else{
			CyServerht cyServerht = cyServerhtDao.findById(htId);
			cyServerht.setHtstate(Constants.HTSTATE_JC);
			cyServerht.setUpdateBy(user.getUsername());
			cyServerht.setUpdateTime(new Date());
			cyServerhtDao.update(cyServerht);
			result.setSuccessful(true);
		}
		return result;
	}

	@Override
	public List<CyServerht> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return cyServerhtDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(CyServerht cyServerht) {
		
		if(cyServerht.getActive() == null){
			cyServerht.setActive(true);
		}
		
		if(!cyServerht.getActive()){
			cyServerhtDao.delete(cyServerht);
		}else{
			CyServerht dbCyServerht = cyServerhtDao.findById(cyServerht.getId());
			if(dbCyServerht == null){
				cyServerhtDao.saveForDS(cyServerht);
			}else{
				if(cyServerht.getUpdateTime().getTime() > dbCyServerht.getUpdateTime().getTime()){
					cyServerhtDao.update(cyServerht);
				}
			}
		}
	}
}


