package com.bcxin.ars.service.epidemic;

import com.bcxin.ars.dao.epidemic.RiskAreaDao;
import com.bcxin.ars.dto.epidemic.RiskAreaDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.epidemic.RiskArea;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
public class RiskAreaServiceImpl implements RiskAreaService {
    @Autowired
    private RiskAreaDao riskAreaDao;
    @Autowired
    private ArsUtil arsUtil;
    @Override
    public void search(RiskAreaDto riskAreaDto, AjaxPageResponse<RiskArea> page) {
        arsUtil.setPoliceSearch(riskAreaDto);
        riskAreaDao.search(riskAreaDto,page);
    }

    @Override
    public RiskArea findById(Long id) {
        return riskAreaDao.findById(id);
    }

    @Override
    public void save(RiskArea riskArea) {
        User currentUser = arsUtil.getCurrentUser();
        if(currentUser==null){
            throw new ArsException("用户信息缺失，请刷新页面！");
        }
        if(riskArea.getId() == null){
            riskArea.setCreateTime(new Date());
            riskArea.setAreaCode(currentUser.getPolice().getAreacode());
        }
        riskArea.setActive(true);
        riskArea.setUpdateBy(currentUser.getUsername());
        riskArea.setUpdateTime(new Date());
        riskAreaDao.save(riskArea);
    }

    @Override
    public List<RiskArea> findAll() {
        return riskAreaDao.findAll();
    }
}
