package com.bcxin.ars.service.bean.factory;

import com.bcxin.ars.service.subsidy.ExportBusiness;
import com.bcxin.ars.service.util.SpringContextUtil;
import org.springframework.context.annotation.Configuration;
import java.util.HashMap;
import java.util.Map;

@Configuration
public class ExportBusinessBeanFactory {
    /***
     * 实现类
     */
    public  static Map<String,String> classNameMap = new HashMap<>();
    static {
        classNameMap.put("01","com.bcxin.ars.service.subsidy.impl.SubsibyComparedExport");
        classNameMap.put("02","com.bcxin.ars.service.subsidy.impl.SignComparedExport");
        classNameMap.put("03","com.bcxin.ars.service.subsidy.impl.RosterExport");
        classNameMap.put("04","com.bcxin.ars.service.subsidy.impl.CommonExport");
    }
    /**
     * 根据比对类型获取实现类
     * @param exportType
     * @return
     */
    public static ExportBusiness getExportBusinessBean(String exportType){
        ExportBusiness result = null;
        //获背景筛查spring容器的ExportBusiness接口实现类列表
        Map<String, ExportBusiness>  map =  SpringContextUtil.getBeansOfType(ExportBusiness.class);
        //循环判断是否和当前环境实现类
        for(Map.Entry<String, ExportBusiness> entry : map.entrySet()){
            result = entry.getValue();
            //匹配，找到各个环境的实在
            if(result.getClass().getName().equals(classNameMap.get(exportType))){
                break;
            }
        }
        return result;

    }
}
