package com.bcxin.ars.aspect;

import com.abcxin.smart.validator.annotation.RedissonAnnotation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/***
 * 分布式锁切面
 * @author subh
 */
@Component
@Aspect
public class RedissonAspect {
    /**
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(RedissonAspect.class);

    /***
     * redis锁客户端
     */
    //@Autowired
    private RedissonClient redisson;

    @Around("@annotation(com.abcxin.smart.validator.annotation.RedissonAnnotation)")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        //前置增强开始
        Signature sig = pjp.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            logger.error("该注解只能用于方法");
            return pjp.proceed();
        }
        msig = (MethodSignature) sig;
        Object target = pjp.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        RedissonAnnotation annotation = currentMethod.getAnnotation(RedissonAnnotation.class);
        //执行方法
        Object obj = null;
        RLock lock= null;
        boolean res = false;
        try {
            //获取redissson分布式锁
            lock = redisson.getLock(annotation.getLockName());
            res = lock.tryLock(annotation.getWaitTime(), annotation.getLeaseTime(),annotation.getUnit());
            if(res){
                obj = pjp.proceed();
            }
        }catch (Exception e){
            logger.error(e.getMessage(), e);
        }finally {
            //释放锁
            if(lock!=null && lock.isLocked() && res)
                lock.forceUnlock();
        }
        return obj;
    }

}
