package com.bcxin.ars.service.zw.impl;

import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.zw.dao.BazwDao;
import com.bcxin.zw.dao.PctinfoDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class PctinfoServiceImpl implements PctinfoService {


	private static Logger logger = LoggerFactory.getLogger(PctinfoServiceImpl.class);
	@Autowired
	private PctinfoDao pctinfoDao;

	@Autowired
	private ArsUtil arsUtil;
	@Autowired
	private BazwDao bazwDao;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private ClientUtil clientUtil;

	@Autowired
	private PersoncertificateDao personcertificateDao;

	@Autowired
	private PersoncertificateDaoAop personcertificateDaoAop;

	@Autowired
	private ApprovalDAO approvalDAO;

	@Autowired
	private ApprovalUtil approvalUtil;

	@Override
	public Pctinfo findByIdnumber(String idnumber) {
		Pctinfo result = null;
		Config config = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
		//北京
		if(config!=null && config.getValue().equals(Constants.BEIJING)){
			List list  = pctinfoDao.findByIdnumber(idnumber);
			if(list!=null && list.size()>0){
				result = (Pctinfo)list.get(0);
			}
			//陕西
		}else if(config!=null && config.getValue().equals(Constants.SHANGXI)){
			List list  = pctinfoDao.findByIdnumber(idnumber);
			if(list!=null && list.size()>0){
				result = (Pctinfo)list.get(0);
			}
		}else if(config!=null && config.getValue().equals(Constants.GUANGXI)){//广西
			//指纹库
			List list  = bazwDao.findByIdnumber(idnumber);
			if(list!=null && list.size()>0){
				result = (Pctinfo)list.get(0);
			}else{
				//人口库
				Personcertificate  personcertificate =  new Personcertificate();
				personcertificate.setPoliceCode("450000030000");
				personcertificate.setPoliceName("广西公安厅治安警察总队");
				personcertificate.setCardnumber(idnumber);
				//判断指纹是否配置线上查询
				Config onlineZwSerchConfig = configUtils.getConfigByKey(Constants.ONLINE_ZW_SEARCH);
				if(onlineZwSerchConfig!=null && Constants.ONLINE_ZW_SEARCH_YES.equals(onlineZwSerchConfig.getValue())){
					String zw = clientUtil.queryZWForIdNumber(personcertificate);
					if(StringUtil.isNotEmpty(zw)) {
						result = new Pctinfo();
						result.setBarcode(zw);
						result.setIdnumber(idnumber);
					}
				}
			}
		}
		return result;
	}

	@Override
	public List<Pctinfo> findByCardNumberList(List<String> cardNumberList) {
		Config config = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
		//陕西
		List<Pctinfo> list = new ArrayList<>();
		if(config!=null && config.getValue().equals(Constants.SHANGXI)){
			 list  = pctinfoDao.findByCardNumberList(cardNumberList);
		}else if(config!=null && config.getValue().equals(Constants.GUANGXI)){//广西
			 list  = bazwDao.findByCardNumberList(cardNumberList);
		}
		return list;
	}
	@Override
	public void autoUpdateFingerprint(Personcertificate personcertificate) {
		//背景筛查通过才获取指纹
		if(StringUtil.isNotEmpty(personcertificate.getCensorStatus()) &&
				(Constants.CENSORSTATUS_PASS.equals(personcertificate.getCensorStatus())||
						Constants.CENSORSTATUS_APPEAL_PASS.equals(personcertificate.getCensorStatus()))) {
			Pctinfo pctinfo = findByIdnumber(personcertificate.getCardnumber());
			if (pctinfo != null && pctinfo.getBarcode() != null && !"".equals(pctinfo.getBarcode())) {
				try {
					//配置 是否需要流程
					Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
					//判断是否有流程，如有流程获取指纹之后启动流程
					if (null == isNeedActivity || (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue()))) {
						approvalUtil.savePersonApproval(BusinessType.BAYZ, personcertificate.getId(), Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
					}else{
						//审批状态为审批中
						personcertificate.setApprovalstate(Constants.APPROVALSTATE_SHZ);
					}
					//指纹
					personcertificate.setFingerprint(pctinfo.getBarcode());
					//采集状态，已采集
					personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
					//更新日期
					personcertificate.setUpdateTime(new Date());
					//更新标识
					personcertificate.setUpdateflag(true);
					personcertificateDaoAop.updateSelective(personcertificate);


					Approval approval= approvalDAO.findBybusinessidAndType(personcertificate.getId(),BusinessType.BAYZ);
					approval.setApprovalstate(personcertificate.getApprovalstate());
					approval.setUpdateflag(true);
					approval.setUpdateTime(personcertificate.getUpdateTime());
					approvalDAO.update(approval);
				}catch(Exception e){
					logger.error("身份证号："+personcertificate.getCardnumber()+"获取指纹异常");
					/****如果是ArsException则是流程启动异常，设置为审批不通过***/
					if(e instanceof ArsException){
						Approval approval= approvalDAO.findBybusinessidAndType(personcertificate.getId(),BusinessType.BAYZ);
						approval.setApprovaldate(new Date());
						approval.setUpdateflag(true);
						approval.setUpdateTime(new Date());
						//审批状态
						approval.setApprovalstate(Constants.APPROVALSTATE_BTG);
						//审批原因
						approval.setApprovalreason("重新选择办事区域！");
						//审批人
						approval.setApprovalperson("系统自动审批");
						//对外审批意见
						approval.setOutreason("重新选择办事区域！");
						approvalDAO.update(approval);
						personcertificate.setApprovaldate(new Date());
						personcertificate.setApprovalstate(Constants.APPROVALSTATE_BTG);
						//审批原因
						personcertificate.setApprovalreason("请重新选择办事区域！");
						//审批人
						personcertificate.setApprovalperson("系统自动审批");
						//审批时间
						personcertificate.setUpdateTime(new Date());
						approval.setUpdateflag(true);
						personcertificateDaoAop.update(personcertificate);
					}
					logger.error(e.getMessage(),e);
				}

			}
		}
	}
    @Override
    public List<Personcertificate> findNofinger(){
	    return personcertificateDao.findNofinger();
    }
}
