package com.bcxin.ars.service.util;

import com.abcxin.smart.core.persistence.utils.Constants;
import com.abcxin.smart.validator.util.SingletonMapCopyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.ResourceBundle;


/**
 * Created by Administrator on 2019/2/21.
 */
@Component("BeanDefineConfigue")
public class SingletonMapUtils implements ApplicationListener<ContextRefreshedEvent> {

    private static final Logger logger = LoggerFactory.getLogger(SingletonMapUtils.class);

    @Autowired
    private SysDictUtils sysDictUtils;


    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        //加载编码信息
        sysDictUtils.initDictMap(SingletonMapCopyUtils.mapCode);
        //加载配置文件信息
        loadProperties(Constants.PATH);


    }

    /**
     * 根据路径将配置文件的内容保存到Map中 如：user={"modelPath":"com.bcxin.ars.model.User"}，key为user，value为com.bcxin.ars.model.User
     * @param path 配置文件路径
     */
    public void loadProperties(String path) {
        SingletonMapCopyUtils.mapProperties = new HashMap<>();
        //ars-rest不需要trilog配置，启动会报错
        try {
            ResourceBundle configRb = ResourceBundle.getBundle(path);
            for (String key : configRb.keySet()) {
                SingletonMapCopyUtils.mapProperties.put(key.replaceAll("-","_"),(String)configRb.getObject(key));
            }
        }catch (Exception e){
            logger.error("缺少配置文件");
        }
    }
}
