package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.model.GXSSO;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.gx.GXSSOService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.gx.encry.AES;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

@Service
public class GXSSOUtil {
    private final  Logger logger = LoggerFactory.getLogger(GXSSOUtil.class);
    private  String url="http://gafw.gat.gxzf.gov.cn/gxga/oauthSingleLogin";

    private  String getuser="/getUserObj";

    private  String destroyProject="/destroyProjectNo";

    private   String report="/reportData";



    @Autowired
    private GXSSOService gxssoService;


    /**
     * 根据token获取用户信息
     * @return
     * @throws IOException
     */
    public String getUserObj(String token) throws IOException {
        String urlPath = url+getuser;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("token",token);
        String userinfo="";
        JSONObject result = JSONObject.parseObject(doPost(jsonObject.toString(), urlPath));
        String num=result.getString("code");
        logger.error("广西单点登录获取用户信息"+userinfo);
        if (num.equals("100000")){
            String date=result.getString("data");
            JSONObject dateObject = JSONObject.parseObject(date);
            userinfo=dateObject.getString("userObj");
            System.out.println(userinfo);
        }
        return userinfo;
    }


    /**
     * 核销办件流水号
     * @return
     * @throws IOException
     */
    public  void destroyProjectNo(String projectNo) throws IOException {
        String urlPath = url+destroyProject;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectNo",projectNo);
        String str=doPost(jsonObject.toString(), urlPath);
        JSONObject result=JSONObject.parseObject(str);
        String num=result.getString("code");
        logger.error("广西单点登录核销办件流水号结果"+str);
        if (num.equals("100000")){
            GXSSO gxsso=gxssoService.findByProjectNo(projectNo);
            gxsso.setComplete(true);
            gxsso.setEndTime(new Date());
            gxssoService.update(gxsso);
        }
    }

    /**
     * 上报办件状态数据
     * @return
     * @throws IOException
     */
    public  void reportData(String token,String projectNo) throws IOException {
        String urlPath = url+report;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("token",token);
        jsonObject.put("projectNo",projectNo);
        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        jsonObject.put("applyDate",simpleDateFormat.format(new Date()));//时间格式yyyy-MM-dd HH:mm:ss
        jsonObject.put("handleState","受理");
        String str=doPost(jsonObject.toString(), urlPath);
        JSONObject result=JSONObject.parseObject(str);
        String num=result.getString("code");
        logger.error("广西单点登录上传办件结果"+str);
        if (num.equals("100000")){
            GXSSO gxsso=gxssoService.findByProjectNo(projectNo);
            gxsso.setEndTime(new Date());
            gxsso.setComplete(true);
            gxssoService.update(gxsso);
        }

    }

    /**
     *
     * post（应使用连接池）
     * @param param
     * @param urlPath
     * @return
     * @throws IOException
     */
    public  String doPost(String param, String urlPath) throws IOException {
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        MediaType mediaType = MediaType.parse("application/json");
        RequestBody body = RequestBody.create(mediaType, param);
        Request request = new Request.Builder()
                .url(urlPath)
                .method("POST", body)
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        return responseBody.string();
    }

    public String getPathFour(String taskCode) {

        String path="/iframe/apply-login.jsp";
        if (taskCode.equals("34000000GA-XK-BA0047")){//设立保安服务公司许可
            path=path+"?butype=001";
        }else if (taskCode.equals("34000000GA-XK-BA0051")){//保安培训单位备案
            path=path+"?butype=002";
        }else if (taskCode.equals("34000000GA-XK-BA0001")){//保安员资格证考试报名
            path=path+"?butype=004";
        }else if (taskCode.equals("34000000GA-FW-BA0003")){//自行招用保安员单位备案
            path=path+"?butype=006";
        }else if (taskCode.equals("34000000GA-FW-BA0001")){//保安服务公司跨区域经营保安服务备案
            path=path+"?butype=005";
        }else if (taskCode.equals("34000000GA-FW-BA0002")){//保安服务公司跨区设立分公司备案
            path=path+"?butype=003";
        }else if (taskCode.equals("34000000GA-XK-BA0048")){//保安服务许可证项目变更审核
            path=path+"?butype=007";
        }
        return path;
    }

    public String getPathTwo(String taskCode,String sessionId) {

        String path="/approval/approveMenu.do?sid="+sessionId;
        if (taskCode.equals("34000000GA-XK-BA0047")){//设立保安服务公司许可

        }else if (taskCode.equals("34000000GA-XK-BA0051")){//保安培训单位备案
            path=path+"&butype=002";
        }else if (taskCode.equals("34000000GA-XK-BA0001")){//保安员资格证考试报名
            path=path+"&butype=004";
        }else if (taskCode.equals("34000000GA-FW-BA0003")){//自行招用保安员单位备案

        }else if (taskCode.equals("34000000GA-FW-BA0001")){//保安服务公司跨区域经营保安服务备案

        }else if (taskCode.equals("34000000GA-FW-BA0002")){//保安服务公司跨区设立分公司备案
            path=path+"&butype=003";
        }else if (taskCode.equals("34000000GA-XK-BA0048")){//保安服务许可证项目变更审核
            path=path+"&butype=007";
        }
        return path;
    }



    public  void main(String[] args) {
        String un=AES.encrypt("对对对","76172485e4b7c82f02a7ce96214ee3e6");
        System.out.println(un);

        String str="{\n" +
                "    \"success\":true,\n" +
                "    \"code\":\"10000\",\n" +
                "    \"msg\":\"成功\",\n" +
                "    \"data\":{\n" +
                "        \"token\":\"90618a46659708a5ee6de508e25064ba\",\n" +
                "        \"userObj\":{\n" +
                "            \"authLevel\":0,\n" +
                "            \"identityId\":\"3E4C316A63F17B1A112BBC7DADF38039E6A6CEB1F428146A1D1D93D3510F34C9\",\n" +
                "            \"mobile\":\"C38F0C14288086BEF48FBA7B22102776\",\n" +
                "            \"userName\":\"5474A014B81E8E6864A0DADCCDE6D04F\"\n" +
                "        }\n" +
                "    }\n" +
                "}";

        JSONObject result = JSONObject.parseObject(str);
        if (result.getString("code").equals("10000")){
            String date=result.getString("data");
            JSONObject dateObject = JSONObject.parseObject(date);
            String userinfo=dateObject.getString("userObj");
            JSONObject js=JSONObject.parseObject(userinfo);
            //获取用户名
            System.out.println(js.getString("userName"));
            String username = AES.decrypt(js.getString("userName"), "76172485e4b7c82f02a7ce96214ee3e6");
            System.out.println(username);
        }else {
            System.out.println("dddd");
        }

    }


}
