package com.bcxin.ars.service.task.impl;

import java.util.Date;
import java.util.List;

import com.bcxin.ars.dao.task.TaskPersonDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bcxin.ars.dao.task.AppNoticeDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dto.AppNoticeSearchDto;
import com.bcxin.ars.dto.task.TaskAppNoticeDto;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.model.task.AppNotice;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.service.task.AppNoticeService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;

@Service
public class AppNoticeServiceImpl implements AppNoticeService {

	@Autowired
	private AppNoticeDao appNoticeDao;

	@Autowired
	private TaskDao taskDao;
	@Autowired
	private TaskPersonDao taskPersonDao;
	@Override
	public AppNoticeSearchDto findAppNoticeList(AppNoticeSearchDto appNoticeSearchDto) {
		AppNoticeSearchDto resultDto = new AppNoticeSearchDto();
		List<AppNotice> list = appNoticeDao.findAppNoticeList(appNoticeSearchDto);
		if (list != null && list.size() > 0) {
			TaskDetailSearchDto taskDetailDto = new TaskDetailSearchDto();
			for (AppNotice item : list) {
				if (item.getTaskID() != null) {
					taskDetailDto.setPersonid(appNoticeSearchDto.getPersonId());
					taskDetailDto.setTaskid(item.getTaskID());
					TaskDto taskDto = taskDao.findTaskDetail_V109(taskDetailDto);
					if (taskDto != null) {
						taskDto.setPersons(taskPersonDao.findTaskPersonsByTaskId(taskDto.getTaskid()));
						TaskAppNoticeDto taskAppNoticeDto = new TaskAppNoticeDto();
						taskAppNoticeDto.setCurrentTaskStatus(taskDto.getCurrentTaskStatus());
						taskAppNoticeDto.setTaskId(taskDto.getTaskid());
						item.setTask(taskAppNoticeDto);
					}
				}
			}
		}
		resultDto.setTotalCount(appNoticeDao.countAppNotice(appNoticeSearchDto));
		resultDto.setData(list);
		return resultDto;
	}

	@Override
	public void updateReadStatus(Long id) {
		appNoticeDao.updateReadStatus(id);
	}

	@Override
	public void save(AppNotice appNotice) {
		appNoticeDao.save(appNotice);
	}

	@Override
	public void saveByTaskPerson(Task task, TaskPerson taskPerson) {
		AppNotice appNotice = new AppNotice();
		appNotice.setCreateTime(new Date());
		appNotice.setActive(true);
		appNotice.setNoticeContent(Constants.TASK_NOTICE_CONTENT.replace("{taskName}", task.getName())
				.replace("{taskDate}", DateUtil.getCurrentDate(DateUtil.FORMAT1))
				.replace("{taskContent}", task.getDetail()));
		appNotice.setNoticeTitle(Constants.ALERT_TITLE);
		appNotice.setNoticeTypeID(3l);
		appNotice.setPersonId(taskPerson.getPerson().getId());
		appNotice.setReadStatus("0");
		appNotice.setTaskID(taskPerson.getTaskId());
		// appNotice.setUpdateBy();
		appNotice.setUpdateTime(new Date());
		appNoticeDao.save(appNotice);
	}
}
