package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.VehicleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.VehicleSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Vehicle;
import com.bcxin.ars.service.sb.VehicleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.Bacydwclpbxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Vehicle.class)
public class VehicleServiceImpl implements VehicleService{
	@Autowired
	private SecurityCompanyDao securityCompanyDao;
	@Autowired
	private VehicleDao vehicleDao;
	/***
	 * 日志
	 */
	private static Logger logger = LoggerFactory.getLogger(ClientUtil.class);
	@Autowired
	private ArsUtil arsUtil;

    @Autowired
    private SecurityPersonDao personDao;
	@Autowired
	private ClientUtil clientUtil;
	@Override
	public Vehicle findById(long id) {
		return vehicleDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Vehicle vehicle) {
		
		User currentUser = arsUtil.getCurrentUser();

		if(vehicle.getId() == null){
			vehicle.setActive(true);
			vehicle.setCreateTime(new Date());
			vehicle.setUpdateTime(new Date());
			vehicle.setUpdateBy(currentUser.getUsername());
			vehicle.setUserid(currentUser.getId());
			vehicle.setClstate(Constants.VEHICLETYPE_RETURN);//初始未使用
			vehicleDao.save(vehicle);
		}else{
			Vehicle dbVehicle = vehicleDao.findById(vehicle.getId());
			if(null!=vehicle.getReturndate()&& !"".equals(vehicle.getReturndate())){
				//归还
				vehicle.setClstate(Constants.VEHICLETYPE_RETURN);
			}else if(null!=vehicle.getSenddate()&& !"".equals(vehicle.getSenddate())){
				//派出
				vehicle.setClstate(Constants.VEHICLETYPE_LOAN);
			}
			dbVehicle.setUpdateBy(currentUser.getUsername());
			dbVehicle.setUpdateTime(new Date());
			if(vehicle.getBuydate() != null){
				dbVehicle.setBuydate(vehicle.getBuydate());
			}
			if(StringUtil.isNotEmpty(vehicle.getChargeperson())){
				dbVehicle.setChargeperson(vehicle.getChargeperson());
			}
			if(StringUtil.isNotEmpty(vehicle.getDisplacement())){
				dbVehicle.setDisplacement(vehicle.getDisplacement());
			}
			if(StringUtil.isNotEmpty(vehicle.getEnginenum())){
				dbVehicle.setEnginenum(vehicle.getEnginenum());
			}
			if(StringUtil.isNotEmpty(vehicle.getFramenum())){
				dbVehicle.setFramenum(vehicle.getFramenum());
			}
			if(StringUtil.isNotEmpty(vehicle.getFueltype())){
				dbVehicle.setFueltype(vehicle.getFueltype());
			}
			if(vehicle.getProductiondate() != null){
				dbVehicle.setProductiondate(vehicle.getProductiondate());
			}
			if(vehicle.getRegdate() != null){
				dbVehicle.setRegdate(vehicle.getRegdate());
			}
			if(StringUtil.isNotEmpty(vehicle.getRegorg())){
				dbVehicle.setRegorg(vehicle.getRegorg());
			}
			if(StringUtil.isNotEmpty(vehicle.getRemarks())){
				dbVehicle.setRemarks(vehicle.getRemarks());
			}
			if(StringUtil.isNotEmpty(vehicle.getVehiclebrand())){
				dbVehicle.setVehiclebrand(vehicle.getVehiclebrand());
			}
			if(StringUtil.isNotEmpty(vehicle.getVehiclecolor())){
				dbVehicle.setVehiclecolor(vehicle.getVehiclecolor());
			}
			if(vehicle.getBuyaccout() != null){
				dbVehicle.setBuyaccout(vehicle.getBuyaccout());
			}
			if(StringUtil.isNotEmpty(vehicle.getVehiclemodel())){
				dbVehicle.setVehiclemodel(vehicle.getVehiclemodel());
			}
			if(StringUtil.isNotEmpty(vehicle.getVehiclenum())){
				dbVehicle.setVehiclenum(vehicle.getVehiclenum());
			}
			if(StringUtil.isNotEmpty(vehicle.getVehiclesource())){
				dbVehicle.setVehiclesource(vehicle.getVehiclesource());
			}
			if(StringUtil.isNotEmpty(vehicle.getVehicletype())){
				dbVehicle.setVehicletype(vehicle.getVehicletype());
			}
			if(vehicle.getBuyaccout() != null){
				dbVehicle.setBuyaccout(vehicle.getBuyaccout());
			}
			if(StringUtil.isNotEmpty(vehicle.getClstate())){
				dbVehicle.setClstate(vehicle.getClstate());
			}
			if(vehicle.getReturndate() != null){
				dbVehicle.setReturndate(vehicle.getReturndate());
			}
			if(vehicle.getScrapdate() != null){
				dbVehicle.setScrapdate(vehicle.getScrapdate());
			}
			if(vehicle.getSenddate() != null){
				dbVehicle.setSenddate(vehicle.getSenddate());
			}
			vehicleDao.update(dbVehicle);
		}
		
	}

	@Override
	public VehicleSearchDto search(VehicleSearchDto dto) {
		VehicleSearchDto resultDto = new VehicleSearchDto();
		List<Vehicle> list =  vehicleDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(vehicleDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public void delete(Vehicle vehicle) {
		User currentUser = arsUtil.getCurrentUser();
		vehicle.setUpdateBy(currentUser.getUsername());
		vehicle.setUpdateTime(new Date());
		vehicleDao.delete(vehicle);
	}

	@Override
	public List<Vehicle> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return vehicleDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(Vehicle vehicle) {
		if(vehicle.getActive() == null){
			vehicle.setActive(true);
		}
		
		if(!vehicle.getActive()){
			vehicleDao.delete(vehicle);
		}else{
			Vehicle dbVehicle = vehicleDao.findById(vehicle.getId());
			if(dbVehicle == null){
				vehicleDao.saveForDS(vehicle);
				//上报保安从业单位押运车辆配备情况基本信息
				new Thread(()-> {
					try{
						Bacydwclpbxx bacydwclpbxx = new Bacydwclpbxx();
						SecurityCompany securityCompany = securityCompanyDao.findByUserid(dbVehicle.getUserid());
						bacydwclpbxx.setBagsbm(securityCompany.getCompanyCode());
						//车辆识别代号
						bacydwclpbxx.setVin(dbVehicle.getFramenum());
						//车牌号
						bacydwclpbxx.setCph(dbVehicle.getVehiclenum());
						//发动机号
						bacydwclpbxx.setFdzh(dbVehicle.getEnginenum());
						//购买日期
						if(dbVehicle.getProductiondate()!=null) {
							bacydwclpbxx.setGmrq(DateUtil.convertDateToString(dbVehicle.getProductiondate(), DateUtil.FORMAT11));
						}
						//报废日期
						if(dbVehicle.getScrapdate()!=null) {
							bacydwclpbxx.setBfrq(DateUtil.convertDateToString(dbVehicle.getScrapdate(), DateUtil.FORMAT11));
						}
						clientUtil.send(Constants.XXBA_BACYDWCLPBXX, bacydwclpbxx);
					}catch (Exception e){
						logger.error(e.getMessage(),e);
					}
				}).start();
			}else{
				if(vehicle.getUpdateTime().getTime() > dbVehicle.getUpdateTime().getTime()){
					vehicleDao.update(vehicle);
				}
			}
		}
	}

	@Override
	public void searchForPage(VehicleSearchDto searchDto, AjaxPageResponse<Vehicle> page) {
		arsUtil.setPoliceSearch(searchDto);
		vehicleDao.searchForPage(searchDto,page);

	}

}
