package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.GradePracticeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.GradePracticeSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.GradePractice;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.GradePracticeService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/****
 * 等级证实习记录
 * @author  subh
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = GradePractice.class)
public class GradePracticeServiceImpl extends BaseService implements GradePracticeService {
    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(GradePracticeServiceImpl.class);
    @Autowired
    private GradePracticeDao gradePracticeDao;

    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Override
    public List<GradePractice> query(GradePracticeSearchDto dto, AjaxPageResponse<GradePractice> ajaxPageResponse) {
        arsUtil.setPoliceSearch(dto);
        return gradePracticeDao.query(dto,ajaxPageResponse);
    }



    /**
     * 更新内网数据 --保存或者更新（更新到内网数据库）
     * @param gradePractice
     */
    @Override
    public void saveOrUpdateForDS(GradePractice gradePractice){
        GradePractice dbGradePractice = gradePracticeDao.findById(gradePractice.getId());
        if (dbGradePractice != null) {
            if(gradePractice.getUpdateTime().getTime() > dbGradePractice.getUpdateTime().getTime()) {
                gradePracticeDao.update(gradePractice);
            }
        }else {
            gradePracticeDao.insert(gradePractice);
        }
    }
    /**
     * 查询需要生成同步文件的等级证实习记录
     * @param dto
     * @return
     */
    @Override
    public List<GradePractice> searchForDataSynchronization(DataSynchronizationSearchDto dto){
        return gradePracticeDao.searchForDataSynchronization(dto);
    }

    @Override
    public void saveOrUpdate(GradePractice dto) {
        //当前用户信息
        //User user  =arsUtil  .getCurrentUser();
        dto.setActive(true);
        dto.setUpdateBy("System");
        dto.setUpdateTime(new Date());

        Config config = configUtils.getConfigByKey(Constants.COVERT_PRACTOCE_LOCATION);

        //判断开关是否开启
        if(config == null || config.getValue().equals(Constants.COVERT_PRACTOCE)){
            //1.穿戴保安服照
            if (StringUtil.isNotEmpty(dto.getUniformImg())) {
                dto.setUniformImg(getPhotoPath(dto.getUniformImg())) ;
            }
            //2.实习地点照片
            if (StringUtil.isNotEmpty(dto.getAddressImg())) {
                dto.setAddressImg(getPhotoPath(dto.getAddressImg())) ;
            }
            /***
             * 3.实习过程照片
             */
            if (StringUtil.isNotEmpty(dto.getProcessImg())){
                dto.setProcessImg(getPhotoPath(dto.getProcessImg())) ;
            }

            /***
             * 4.实习过程视频
             */
            if (StringUtil.isNotEmpty(dto.getVideo())) {
                dto.setVideo(getPhotoPath(dto.getVideo())) ;
            }
        }

        //等级默认五级
        if(StringUtil.isEmpty(dto.getGradeLevel())){
            dto.setGradeLevel(Constants.GRADE_LEVEL_DEFAULT);
        }
        if(dto.getId() == null){
            //新增
            dto.setCreateTime(new Date());
            gradePracticeDao.insert(dto);
        }else{
            GradePractice dbGradePractice = gradePracticeDao.findById(dto.getId());
            //2.更新或保存记录
            if (dbGradePractice != null) {
                //复制值
                BeanUtils.copyPropertiesIgnore(dto,dbGradePractice,true);
                gradePracticeDao.update(dbGradePractice);
            }else {
                //新增
                dto.setCreateTime(new Date());
                gradePracticeDao.insert(dto);
            }
        }
    }

    @Override
    public void del(GradePractice record) {
        //更新时间
        record.setUpdateTime(new Date());
        //失效
        record.setActive(false);
        gradePracticeDao.del(record);
    }

    @Override
    public List<GradePractice> findByPersonIdAndGradeLevel(Long personId, String gradeLevel) {
        return gradePracticeDao.findByPersonIdAndGradeLevel(personId,gradeLevel);
    }
}
