package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.dao.sb.UserBusinessTypeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.UserSearchDto;
import com.bcxin.ars.dto.page.PoliceUserDto;
import com.bcxin.ars.dto.page.UserPageSearchDto;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.model.sb.UserBusinessType;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.huawei.HttpBuildUtil;
import com.bcxin.ars.util.huawei.HuaweiMeetConst;
import com.bcxin.ars.util.huawei.RestRequest;
import com.bcxin.ars.util.huawei.RestResponse;
import com.bcxin.ars.webservice.Bajgll;
import com.bcxin.ars.webservice.ClientUtil;
import com.beust.jcommander.internal.Maps;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.io.File;
import java.util.*;

@Service
@Transactional
@DataSyncAnnotation(getClazz = User.class)
@DataSyncOutAnnotation(getClazz = User.class)
public class UserServiceImpl extends BaseService implements UserService {
	private static Logger logger = LoggerFactory.getLogger(SecurityCompanyServiceImpl.class);
	@Autowired
	private UserDao userDao;
	@Autowired
	private UserDaoAop userDaoAop;
	@Autowired
	private LogMessageDao logMessageDao;
	@Autowired
	private SecurityCompanyPersonDao companyPersonDao;

	@Autowired
	private ConfigUtils configUtils;
	@Autowired
	private UserBusinessTypeDao userBusinessTypeDao;

	@Autowired
	private SecurityPersonDao personDao;

	@Autowired
	private SecurityPersonDaoAop personDaoAop;

	@Autowired
	private PoliceService policeService;
	
	@Autowired
	private PoliceRoleDao policeRoleDao;

	@Autowired
	private UserRoleDao userRoleDao;


	@Autowired
	private ConferenceAccountDao conferenceAccountDao;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ClientUtil clientUtil;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private IdGeneratorUtil idGeneratorUtil;

	@Value("${personcertificate-download-folder}")
	private String tempftpFolder;
	@Value("${heiweiPrefixKey}")
	private String heiweiPrefixKey;

	@Override
	public List<Map> searchAllCompanyUser(String lastDate,String now){
		return userDao.searchAllCompanyUser(lastDate,now);
	}
	@Override
	public List<User> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
		List<User> userList= userDao.searchForDataSynchronization(dto);
		for (User user : userList) {
			user.setUserRoles(userRoleDao.findByUserId(user.getId()));
		}
		return userList;
	}

	@Override
	public UserSearchDto searchApproveUser(UserSearchDto dto) {
		User user = arsUtil.getCurrentUser();
		if(user == null || user.getPlatform().intValue() != 1) {
			return null;
		}
		dto.setPlatform("1");
		if(dto.getOrgid() == null && user.getOrgid() != null){
			dto.setOrgid(user.getOrgid());
		}
		List<User> data = userDao.searchApproveUser(dto);
		Long count = userDao.searchCountApproveUser(dto);
		dto.setData(data);
		dto.setTotalCount(count);
		return dto;
	}
	@Override
	public User findByUsername(String username,String platform) {
		return userDao.findByUsername(username,platform);
	}

	@Override
	public User findByIdNum(String idNum, String platform) {
		return userDao.findByIdNum(idNum,platform);
	}

	@Override
	public User findByUsernameForPolice(String username) {
		return userDao.findByUsernameForPolice(username);
	}
	@Override
	public User findByUsernameStatus(String username,Boolean active) {
		return userDao.findByUsernameStatus(username, active);
	}

	@Override
	public void delete(User user) {
		//读取配置文件
		Config config = configDao.findByKey("police");
		//公安人员删除
		//TODO 如果该员已经发布过紧急任务、有进行审批过许可备案申请单子则不允许删除账号。
		User checkUser = userDao.checkUseById(user.getId());
		if(checkUser != null){
			throw new ArsException("该账号在使用中，无法删除！");
		}
		checkUser = findByIdForManager(user.getId());
		if(checkUser != null) {
			List<PoliceRole> roles = checkUser.getRoles();
			for (PoliceRole policeRole : roles) {
				policeRole.setUsernum(policeRole.getUsernum() != null ? policeRole.getUsernum()-1 : null);
				policeRole.setUpdateTime(new Date());
				if (config.getValue().equals("1")) {
					policeRole.setUpdateflag(true);
				}
				policeRoleDao.update(policeRole);
			}
		}
		if(checkUser.getOrgid() != null){
			Police police = policeService.findById(checkUser.getOrgid());
			if(police != null){
				police.setUsernum(police.getUsernum() != null ? police.getUsernum()-1 : null);
				if (config.getValue().equals("1")) {
					police.setUpdateflag(true);
				}
				policeService.updatenum(police);
			}
		}

		user.setUpdateTime(new Date());
		user.setUpdateBy(arsUtil.getCurrentUser().getUsername());
		if (config.getValue().equals("1")) {
			user.setUpdateflag(true);
		}
		userDaoAop.delete(user);
	}

	@Override
	public void updatePassword(User user) {
		//读取配置文件
		Config config = configDao.findByKey("police");
		user.setPassword(user.getPassword().trim());
		User dbUser = userDao.findById(user.getId());
		if(Sha1Util.validatePassword(user.getPassword(),dbUser.getPassword())){
			throw new ArsException("新密码不应该与旧密码相同!");
		}else{
			dbUser.setPassword(user.getPassword().trim());
			dbUser.setUpdateTime(new Date());
			if(arsUtil.getCurrentUser() != null){
				dbUser.setUpdateBy(arsUtil.getCurrentUser().getUsername());
			}else{
				dbUser.setUpdateBy(user.getUsername());
			}
			if(!dbUser.getInit()){
				dbUser.setInitstep("001");
			}
			if (config.getValue().equals("1")) {
				dbUser.setUpdateflag(true);
			}
			userDaoAop.updatePassword(dbUser);
		}
	}

	@Override
	public void updatePasswordBypolice(User user) {
		//读取配置文件
		Config config = configDao.findByKey("police");
		user.setUpdateTime(new Date());
		if(arsUtil.getCurrentUser() != null){
			user.setUpdateBy(arsUtil.getCurrentUser().getUsername());
		}else{
			user.setUpdateBy(user.getUsername());
		}
		if (config.getValue().equals("1")) {
			user.setUpdateflag(true);
		}
		userDaoAop.updatePassword(user);

	}

	@Override
	public void updateLoginState(User user) {
		//读取配置文件
		Config config = configDao.findByKey("police");
		if (config.getValue().equals("1")) {
			user.setUpdateflag(true);
		}
		//更新登陆状态
		userDaoAop.updateLoginState(user);
	}

	private Long searchCountApproveUser(User user){
		UserSearchDto userSearchDto = new UserSearchDto();
		if(null!=user.getCodeNo()&& !"".equals(user.getCodeNo())){
			userSearchDto.setCodeNo(user.getCodeNo());
			userSearchDto.setUserid(user.getId());
			return userDao.searchCountByCodeNo(userSearchDto);
		}

		return 0L;

	}

	@Override
	public void saveOrUpdate(User user,String platform) {

		User currentUser = arsUtil.getCurrentUser();
		if(searchCountApproveUser(user).longValue()>=1){
			throw new ArsException("警号已存在！");
		}
		//读取配置文件
		Config config = configDao.findByKey(Constants.POLICE);
		user.setUsername(user.getUsername().trim().replaceAll(" ", ""));
		if(StringUtils.isEmpty(user.getPhoto())) {
			if(user.getPlatform().intValue() == 1) {
				user.setPhoto("assets/images/defaultHead/police.png");
			}
		}
		if(user.getId() == null) {
			User existUser = userDao.findByUsername(user.getUsername(),platform);
			if(existUser != null) {
				if("1".equals(platform)){
					throw new ArsException("警号已存在！");
				}else{
                    throw new ArsException("用户名已存在！");
                }
			}

			if(StringUtil.isNotEmpty(user.getPhone())) {
				user.setPhone(user.getPhone().trim());
			}


			if(!StringUtil.isNotEmpty(user.getPassword())) {
				user.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
			}
			if(user.getRealname()!=null) {
				user.setRealname(user.getRealname().trim().replaceAll(" ", ""));
			}

			user.setNativeCode(arsUtil.getCurrentNatvie());
			user.setInit(false);
			user.setActive(true);
			user.setCreateTime(new Date());
			user.setUpdateTime(user.getCreateTime());
			if(currentUser != null){
				user.setUpdateBy(currentUser.getUsername());
			}
			user.setLoginNum(0);

			if (config.getValue().equals("1")) {
				user.setUpdateflag(true);
			}

			//设置ID
			user.setId(idGeneratorUtil.createID());
			userDao.save(user);

			if(user.getOrgid() != null){
				Long count = userDao.findCountByorgid(user.getOrgid());
				Police org = policeService.findById(user.getOrgid());
				if(org != null){
					//更新机构用户数
					org.setUsernum(count);
					if (config.getValue().equals("1")) {
						org.setUpdateflag(true);
					}
					policeService.updatenum(org);

					//部级接口对接  --保安监管力量
					new Thread(()->{ //异步处理
						try {
							Bajgll bajgll = new Bajgll();
							if(StringUtil.isNotEmpty(user.getIdNumber())) {
								//姓名
								bajgll.setXm(user.getRealname());

								String sex = IdNumUtil.getGenderByIdCard(user.getIdNumber());
								if(StringUtil.isNotEmpty(sex)){
									bajgll.setXb((sex.equals("男") ? "1" : "0"));
								}
								bajgll.setJgjgbh(org.getCode());
								bajgll.setJgjgmc(org.getOrgname());
								bajgll.setJgjgdz(org.getAreacode());
								bajgll.setJgjgxz(org.getAddress());
								bajgll.setJgzt("1");
								bajgll.setSfzh(user.getIdNumber());
								bajgll.setSj(user.getPhone());
								//调用send方法完成对接
								clientUtil.send(Constants.XXBA_BAJGLL, bajgll);
							}
						} catch(Exception e) {
							e.printStackTrace();
						}
					}).start();
				}
			}

		} else {
			/***
			 * 判断用户名和手机号码是否有重复edit subh 2018-03-29
			 */
			User existUser = userDao.findByUsernameAndId(user);
            if(existUser != null) {
                if("1".equals(platform)){
                    throw new ArsException("警号已存在！");
                }else{
                    throw new ArsException("用户名已存在！");
                }
            }

			User dbUser = userDao.findById(user.getId());
			if(dbUser != null){
				dbUser.setUpdateTime(new Date());
				dbUser.setUpdateBy(currentUser.getUsername());
				if(user.getActive() != null && user.getActive()){
					dbUser.setActive(true);
				}
				if(user.getPoliceman() != null){
					dbUser.setPoliceman(user.getPoliceman());
				}
				if(user.getInit() != null && user.getInit()){
					dbUser.setInit(true);
				}
				if(!StringUtils.isEmpty(user.getRealname())) {
					dbUser.setRealname(user.getRealname().trim().replaceAll(" ", ""));
				}
				if(!StringUtils.isEmpty(user.getPhone())) {
					dbUser.setPhone(user.getPhone().trim());
				}
				if(!StringUtils.isEmpty(user.getPhoto())) {
					dbUser.setPhoto(user.getPhoto());
				}
				if(!StringUtils.isEmpty(user.getCodeNo())) {
					dbUser.setCodeNo(user.getCodeNo());
				}
				if(!StringUtils.isEmpty(user.getOrgName())) {
					dbUser.setOrgName(user.getOrgName());
				}
				if(!StringUtils.isEmpty(user.getRoleName())) {
					dbUser.setRoleName(user.getRoleName());
				}
				if(user.getOrgid()!= null) {
					dbUser.setOrgid(user.getOrgid());
				}
				if(user.getLoginNum() != null) {
					dbUser.setLoginNum(user.getLoginNum());
				}
				if(!StringUtils.isEmpty(user.getLoginDate())) {
					dbUser.setLoginDate(user.getLoginDate());
				}
				if(!StringUtils.isEmpty(user.getIsAdmin())) {
					dbUser.setIsAdmin(user.getIsAdmin());
				}
				dbUser.setIdNumber(user.getIdNumber());

				if(!StringUtils.isEmpty(user.getUsername())) {
					dbUser.setUsername(user.getUsername());
				}
				if (config.getValue().equals("1")) {
					dbUser.setUpdateflag(true);
				}
				userDaoAop.update(dbUser);
			}
		}

		//用户信息处理
		switch (user.getPlatform()) {
			case Constants.PLATFORM_POLICE:
				//删除公安用户与角色关联表
				userRoleDao.deleteByUserIdAndRoleId(user.getId(),Constants.ROLETYPE_POLICEROLE);
				if (user.getRoles() != null && user.getRoles().size() > 0) {
					UserRole userRole = null;
					for (PoliceRole policeRole : user.getRoles()) {
						userRole = new UserRole();
						userRole.setActive(true);
						userRole.setCreateTime(new Date());
						userRole.setNativeCode(arsUtil.getCurrentNatvie());
						userRole.setRoleid(policeRole.getId());
						userRole.setUserid(user.getId());
						userRole.setUpdateBy(currentUser.getUsername());
						userRole.setUpdateTime(new Date());
						userRole.setRoleType(Constants.ROLETYPE_POLICEROLE);
						userRoleDao.save(userRole);
						//更新角色用户数
						Long count = userDao.findCountByroleid(policeRole.getId());
						PoliceRole dbRole = policeRoleDao.findById(policeRole.getId());
						if (dbRole != null) {
							dbRole.setUsernum(count);
							dbRole.setUpdateTime(new Date());
							if (config.getValue().equals(Constants.ISPOLICE_YES)) {
								dbRole.setUpdateflag(true);
							}
							policeRoleDao.update(dbRole);
						}
					}
				}
				//保存角色和业务类型关系
				userBusinessTypeDao.delByUserId(user.getId());
				if (user.getUserBusinessTypeList() != null && user.getUserBusinessTypeList().size() > 0) {
					for (UserBusinessType temp :
							user.getUserBusinessTypeList()) {
						temp.setActive(true);
						temp.setCreateTime(new Date());
						temp.setUpdateBy(currentUser.getUsername());
						temp.setUpdateTime(new Date());
						temp.setUserId(user.getId());
						userBusinessTypeDao.save(temp);
					}
				}
				break;
			default:
				break;
		}






	}

	@Override
	public UserSearchDto search(UserSearchDto dto) {
		User user = arsUtil.getCurrentUser();
		if(user == null || user.getPlatform().intValue() != 1) {
			return null;
		}
		dto.setPlatform("1");
		if(StringUtil.isEmpty(dto.getOrgIds()) && user.getOrgid() != null){
			dto.setOrgIds(user.getOrgid()+"");
		}
		List<User> data = userDao.search(dto);
		Long count = userDao.searchCount(dto);
		dto.setData(data);
		dto.setTotalCount(count);
		return dto;
	}

	@Override
	public User findById(Long userid) {
		return userDao.findById(userid);
	}
	@Override
	public User findByComId(Long comId) {
		return userDao.findByComId(comId);
	}
	@Override
	public User findByIdForManager( Long userid) {
		User result = userDao.findByIdForManager(userid);
		result.setUserBusinessTypeList(userBusinessTypeDao.findByUserId(userid));
		return result;
	}

	@Override
	public void saveOrUpdateForDS(User user) {
		//根据ID获取内网用户信息，如果没有新增，有则更新
		User dbUser = findById(user.getId());
		if(user.getActive() == null){
			user.setActive(true);
		}

		if(!user.getActive()){
			userDaoAop.delete(user);
		}else{
			if(dbUser == null){
				userDao.saveForDS(user);
				List<UserRole> userRoles = user.getUserRoles();
				//删除用户与角色的关系
				deleteByUserIdAndRoleId(user);
				if(userRoles != null){
					for (UserRole userRole : userRoles) {
						userRole.setUserid(user.getId());
						userRoleDao.save(userRole);
					}
				}
				
			}else{
				if(user.getUpdateTime().getTime() > dbUser.getUpdateTime().getTime()){
					userDaoAop.update(user);
					List<UserRole> userRoles = user.getUserRoles();
					//删除用户与角色的关系
					deleteByUserIdAndRoleId(user);
					if(userRoles != null){
						for (UserRole userRole : userRoles) {
							userRole.setUserid(user.getId());
							userRoleDao.save(userRole);
						}
					}
				}
			}
		}
	}


	@Override
	public List<User> findAll() {
		return userDao.findAll();
	}

	@Override
	public void saveOrUpdateCompanyUserForSAAS(User user) {
		User currentUser = arsUtil.getCurrentUser();
		user.setUsername(user.getUsername().trim().replaceAll(" ", ""));


		if(StringUtils.isEmpty(user.getPhoto())) {
			if(user.getPlatform().intValue() == 1) {
				user.setPhoto("assets/images/defaultHead/police.png");
			}
		}else {
			user.setPhoto(getPhotoPath(user.getPhoto()));
		}
		if(user.getRealname()!=null) {
			user.setRealname(user.getRealname().trim().replaceAll(" ", ""));
		}
		user.setPhone(user.getPhone().trim());
		user.setUpdateTime(new Date());

		if(currentUser != null){
			user.setUpdateBy(currentUser.getUsername());
		}else{
			user.setUpdateBy(user.getUsername());
		}

		if(null != arsUtil.getCurrentNatvie()) {
			user.setNativeCode(arsUtil.getCurrentNatvie());
		}

		if(user.getId() == null) {
			//新增
			User existUser = userDao.findByUsername(user.getUsername(),user.getPlatform().toString());
			//保安公司不需要验证身份证号和手机号
			if(existUser != null && Constants.PLATFORM_COMPANY != user.getPlatform()) {
				throw new ArsException("身份证号或者手机号码已存在！");
			}

			if(!StringUtil.isNotEmpty(user.getPassword())) {
				user.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
			}

			user.setInit(false);
			user.setActive(true);
			user.setCreateTime(new Date());
			user.setLoginNum(0);
			//设置ID
			user.setId(idGeneratorUtil.createID());
			userDao.save(user);
		} else {
			//修改
			User existUser = userDao.findByUsernameAndId(user);
			if(existUser != null && user.getId().equals(existUser.getId()) ) {
				throw new ArsException("身份证号已存在！");
			}
			User dbUser = userDao.findById(user.getId());
			if(dbUser != null){
				BeanUtils.copyPropertiesIgnore(user,dbUser,true);
				userDaoAop.update(dbUser);
			}
		}
	}
	@Override
	public void saveOrUpdateCompanyUser(User user,String platform) {
		//读取配置文件
		Config config = configDao.findByKey(Constants.POLICE);
		User currentUser = arsUtil.getCurrentUser();

		user.setUsername(user.getUsername().trim().replaceAll(" ", ""));
		if(StringUtils.isEmpty(user.getPhoto())) {
			if(user.getPlatform().intValue() == 1) {
				user.setPhoto("assets/images/defaultHead/police.png");
			}
		}
		if(user.getId() == null) {

			User existUser = userDao.findByUsername(user.getUsername(),platform);
			if(existUser != null) {
				throw new ArsException("身份证号或者手机号码已存在！");
			}

			if(!StringUtil.isNotEmpty(user.getPassword())) {
				user.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
			}

			if(user.getRealname()!=null) {
				user.setRealname(user.getRealname().trim().replaceAll(" ", ""));
			}
			if(StringUtil.isNotEmpty(user.getPhone())) {
				user.setPhone(user.getPhone().trim());
			}
			user.setNativeCode(arsUtil.getCurrentNatvie());
			user.setInit(false);
			user.setActive(true);
			user.setCreateTime(new Date());
			user.setUpdateTime(user.getCreateTime());
			if(currentUser != null){
				user.setUpdateBy(currentUser.getUsername());
			}else{
				user.setUpdateBy(user.getUsername());
			}
			user.setLoginNum(0);

			if (config.getValue().equals("1")) {
				user.setUpdateflag(true);
			}

			//设置ID
			user.setId(idGeneratorUtil.createID());
			userDao.save(user);

			if(user.getOrgid() != null){
				Long count = userDao.findCountByorgid(user.getOrgid());
				Police org = policeService.findById(user.getOrgid());
				if(org != null){
					//更新机构用户数
					org.setUsernum(count);
					if (config.getValue().equals("1")) {
						org.setUpdateflag(true);
					}
					policeService.updatenum(org);

					//部级接口对接  --保安监管力量
					new Thread(()->{ //异步处理
						try {
							//确定对接的属性对应关系
							//源实体类的列，目标实体类的列
							String[] srccol = {"realname","phone","idNumber"};
							String[] desccol = {"xm","sj","sfzh"};
							//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
							String[] key = {"jgzt","bz1","jgjgbh","jgjgmc","jgjgdz","jgjgxz"};
							String[] value = {"1","身份证",org.getCode(),org.getOrgname(),org.getArea(),org.getAddress()};
							//生成实体
							Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,user,new Bajgll(),key,value);
							Bajgll bajgll =(Bajgll)desc;
							//调用send方法完成对接
							clientUtil.send(Constants.XXBA_BAJGLL,bajgll);
						} catch(Exception e) {
							e.printStackTrace();
						}
					}).start();
				}
			}

		} else {

			User existUser = userDao.findByUsernameAndId(user);
			if(existUser != null && user.getId().equals(existUser.getId()) ) {
				throw new ArsException("身份证号已存在！");
			}


			User dbUser = userDao.findById(user.getId());
		//数据库手机号码
		String dbphone=	dbUser.getPhone();
			if(dbUser != null){
				dbUser.setUpdateTime(new Date());
				dbUser.setUpdateBy(currentUser.getUsername());
				if(user.getActive() != null && user.getActive()){
					dbUser.setActive(true);
				}
				if(user.getPoliceman() != null){
					dbUser.setPoliceman(user.getPoliceman());
				}
				if(user.getInit() != null && user.getInit()){
					dbUser.setInit(true);
				}
				if(!StringUtils.isEmpty(user.getRealname())) {
					dbUser.setRealname(user.getRealname().trim().replaceAll(" ", ""));
				}
				if(!StringUtils.isEmpty(user.getPhone())) {
					dbUser.setPhone(user.getPhone().trim());
				}
				if(!StringUtils.isEmpty(user.getPhoto())) {
					dbUser.setPhoto(user.getPhoto());
				}
				if(!StringUtils.isEmpty(user.getCodeNo())) {
					dbUser.setCodeNo(user.getCodeNo());
				}
				if(!StringUtils.isEmpty(user.getOrgName())) {
					dbUser.setOrgName(user.getOrgName());
				}
				if(!StringUtils.isEmpty(user.getRoleName())) {
					dbUser.setRoleName(user.getRoleName());
				}
				if(user.getOrgid()!= null) {
					dbUser.setOrgid(user.getOrgid());
				}
				if(user.getLoginNum() != null) {
					dbUser.setLoginNum(user.getLoginNum());
				}
				if(user.getUpdateflag()!=null && user.getUpdateflag() ) {
					dbUser.setUpdateflag(user.getUpdateflag());
				}
				if(!StringUtils.isEmpty(user.getLoginDate())) {
					dbUser.setLoginDate(user.getLoginDate());
				}
				if(!StringUtils.isEmpty(user.getIdNumber())) {
					dbUser.setIdNumber(user.getIdNumber());
				}

				if (config.getValue().equals("1")) {
					dbUser.setUpdateflag(true);
				}
				//如果登录用户名为空，则不更新user信息
				if(!StringUtils.isEmpty(user.getUsername())){
					dbUser.setUsername(user.getUsername());
				}
				userDaoAop.update(dbUser);
				//如果数据库的手机号跟传入的手机号不一致，判定为修改手机号，则发送给百课堂
				//if (StringUtil.isNotEmpty(user.getPhone())) {
				//	if (!user.getPhone().equals(dbphone)) {
				//		this.sentToBTK(user);
				//	}
				//}
			}
		}

	}

	/**
	 * @return void
	 * @Decription:将更改用户信息--手机号发送给百课堂
	 * @author：zhongjianhui
	 * @method sentToBTK
	 * @date：2018/6/25 11:20
	 * @params： * @param invoice
	 */
	private void sentToBTK(User user) {
		//获取数据库公安配置
		Config config = configDao.findByKey(Constants.POLICE);

		//是否为外网，外网才需要同步
		if (config != null && config.getValue() != null && !Constants.ISPOLICE_YES.equals(config.getValue())) {
			LogMessage logMessage = new LogMessage();
			Map dataMap = new HashMap();
			Map map = new HashMap();
			map.put("phone",user.getUsername());
			map.put("pwd",user.getPhone());

			dataMap.put("data",JSON.toJSONString(map));
			logMessage.setLogger_title("百课堂修改手机号同步");
			String message="修改手机号同步:";
			logMessage.setCreateTime(new Date());
			try {
				//获取百课堂配置地址
				Config configURL = configDao.findByKey(Constants.BKT_DATA_URL);

				if (configURL != null && configURL.getValue() != null) {
					//"http://192.168.30.99:8888/"
					String url = configURL.getValue() + Constants.BTK_UPDPWD;
					message="访问地址"+url+"|";
					//地址访问
					String btkRtn = HttpClientUtils.doPost(url,dataMap,"utf-8");
					message+=message+"返回结果："+btkRtn+"|";
					if (btkRtn != null) {
						//转成json
						JSONObject jsonObject = JSONObject.parseObject(btkRtn);
						//获取状态值
						String retType = jsonObject.get("retType").toString();
						String data = jsonObject.get("data").toString();
						//判断非空且
						if (!StringUtils.isEmpty(retType) && "1".equals(retType)) {
							message+=message+"同步成功";
							logger.info("百课堂修改手机号同步成功");
						} else {
							message+=message+"同步失败";
							logger.info("百课堂修改手机号同步失败");
						}
						if (!StringUtils.isEmpty(data)) {
							message+=message+data;
							logMessage.setLogger_context(message);
							//保存错误日志
							logMessageDao.save(logMessage);
						}
					}
				}
			} catch (Exception e) {
				logMessage.setLogger_context("抛出异常："+e.toString()+"过程信息："+message);
				//保持错误日志
				logMessageDao.save(logMessage);
				logger.error(e.getMessage(),e);
			}
		}
	}
	/**
	 * 更新初始化状态
	 * @param user
	 */
	@Override
	public void updateInitstep(User user) {
		//读取配置文件
		Config config = configDao.findByKey("police");
		if (config.getValue().equals("1")) {
			user.setUpdateflag(true);
		}
		user.setUpdateTime(new Date());
		userDaoAop.updateInitstep(user);
	}

	@Override
	public void updateXjdUserId(User user) {
		//读取配置文件
		Config config = configDao.findByKey("police");
		if (config.getValue().equals("1")) {
			user.setUpdateflag(true);
		}
		userDaoAop.updateXjdUserId(user);
	}

	@Override
	public List<User> findXjdUserList() {
		return userDao.findXjdUserList();
	}

	/**
	 * APP更新用户登陆步骤
	 * @param user
	 */
	@Override
	public void updateFlag(User user) {
		//读取配置文件
		Config config = configDao.findByKey("police");
		if (config.getValue().equals("1")) {
			user.setUpdateflag(true);
		}
		userDaoAop.updateFlag(user);
	}
	
	/**
	 * APP更新用户认证标识
	 * @param user
	 */
	@Override
	public void updateAuthMark(User user) {
		//读取配置文件
		Config config = configDao.findByKey("police");
		if (config.getValue().equals("1")) {
			user.setUpdateflag(true);
		}
		userDaoAop.updateAuthMark(user);
	}

	 
	@Override
	public List<ReportData> findByAreaReport(ReportDataSearchDto searchDto) {
		User currentUser = arsUtil.getCurrentUser();

		searchDto.setPath(currentUser.getPolice().getPath());
		searchDto.setUserid(currentUser.getId());
		return userDao.findByAreaReport(searchDto);
	}

	private void writeTxtFile(String readStr, String type) {
//    	System.out.println(type);
		try {
			String basePath = tempftpFolder;    //路径
			String filePath = basePath + DateUtil.getCurrentDate() + File.separator;//保存路径

			String fileName = type;
			String fileType = ".data";
			File file = new File(filePath);
			if (!file.exists()) {
				file.mkdirs();
				System.out.println("文件夹已创建");
			}
			String fullFilePath = filePath + fileName + "_"+ DateUtil.getCurrentDateTime(DateUtil.FORMAT8) + fileType;

			//文件处理：写入文件
			File newFile = new File(fullFilePath);
			Files.write(readStr.getBytes(), newFile);
		} catch (Exception e) {
			System.out.println("导出失败！");
		}
	}


	@Override
	public void autoExportUser() {

		List<User> userList = userDao.searchForExport();

		if (userList != null && userList.size() > 0) {
			try {
				for (User u:userList) {

					u.setUpdateflag(false);
					String userStr = JSONArray.toJSONString(u);
					System.out.println(userStr);
					String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(userStr.getBytes(), Constants.APPROVAL_KEY));
					writeTxtFile(content, "user");


					List<UserRole> userRoleList = userRoleDao.findByUserId(u.getId());
					String userRoleListStr = JSONArray.toJSONString(userRoleList);
					String userRoleListcontent = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(userRoleListStr.getBytes(), Constants.APPROVAL_KEY));
					writeTxtFile(userRoleListcontent, "userrole");

					userDaoAop.updateExportFlag(u);


				}

			} catch (Exception e) {
				System.out.println("导出失败！");
			}
		}
	}


	/***
	 * 删除用户与角色的关系
	 * @param user 用户信息
	 */
	public void deleteByUserIdAndRoleId(User user){
		//根据用户类型删除角色与用户关系
		String roleType = "";
		switch (user.getPlatform()){
			case Constants.PLATFORM_POLICE:
				roleType =  Constants.ROLETYPE_POLICEROLE;
				break;
			case Constants.PLATFORM_PERSON:
				roleType =  Constants.ROLETYPE_ROLE;
				break;
			default:
				break;
		}
		if(StringUtil.isNotEmpty(roleType)) {
			userRoleDao.deleteByUserIdAndRoleId(user.getId(),roleType);
		}
	}


	@Override
	@Deprecated
	public void saveOrUpdateForImport(User user) {
		user.setUpdateflag(false);
		if(user.getActive() == null){
			user.setActive(true);
		}

		User dbUser = findById(user.getId());
		if(dbUser == null){
			user.setUpdateTime(new Date());
			//设置ID
		//	user.setId(idGeneratorUtil.createID());
			userDao.save(user);
			List<UserRole> userRoles = user.getUserRoles();
			//删除用户与角色的关系
			deleteByUserIdAndRoleId(user);
			if(userRoles != null){
				for (UserRole userRole : userRoles) {
					userRole.setUserid(user.getId());
					userRoleDao.save(userRole);
				}
			}
		}else{

			if(user.getUpdateTime().getTime() > dbUser.getUpdateTime().getTime()){
				user.setUpdateTime(new Date());
				userDaoAop.update(user);
				List<UserRole> userRoles = user.getUserRoles();
				//删除用户与角色的关系
				deleteByUserIdAndRoleId(user);
				if(userRoles != null){
					for (UserRole userRole : userRoles) {
						userRole.setUserid(user.getId());
						userRoleDao.save(userRole);
					}
				}
			}
		}
	}

	@Override
	public User findByPhone(String phone) {
		return userDao.findByPhone(phone);
	}

	@Override
	public User findByUsernameAndPlatform(String username) {
		return userDao.findByUsernameAndPlatform(username);
	}

	/**
	 * 判断是否有指定权限
	 * @param user
	 * @param roleId
	 * @return
	 */
	@Override
	public Boolean checkRole(User user, Object roleId) {
		List<PoliceRole> roles = user.getRoles();
		if(roles != null && roles.size() > 0 && roleId != null){
			for (PoliceRole role : roles){
				if(role.getId().toString().equals(roleId.toString())){
					return true;
				}
			}
		}

		return false;
	}

	/**
	 * 账号管理
	 * @param dto
	 * @param dto
	 * @return
	 * @throws Exception
	 */
	@Override
	public UserSearchDto searchAccount(UserSearchDto dto) {
		User user = arsUtil.getCurrentUser();
		if(user == null) {
			return null;
		}
		List<User> data = userDao.search(dto);
		Long count = userDao.searchCount(dto);
		dto.setData(data);
		dto.setTotalCount(count);
		return dto;
	}

	@Override
	public List<User> findDSOutList(String startDate) {
		return userDao.searchFromInToOutForExport(startDate);
	}

	/**
	 * 批量导入
	 * @param list
	 */
	@Override
	public void importBatch(List<User> list){
		List<User> dbList = userDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);

		if (list.size()>0){
			for(User detail:list){
				detail.setUpdateflag(false);
				try {
					detail.setUpdateTime(com.bcxin.ars.util.DateUtil.dateAdd(com.bcxin.ars.util.DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
				}catch (Exception e){
				    logger.error(e.getMessage(),e);
				}
				List<UserRole> userRoles = detail.getUserRoles();
				//删除用户与角色的关系
				deleteByUserIdAndRoleId(detail);
				userRoleDao.deleteByUserId(detail.getId());
				if(userRoles != null && userRoles.size() > 0){
					userRoleDao.batchSave(userRoles);
				}
			}
			//批量保存
			userDaoAop.saveBatch(list);
		}
	}

	@Override
	public void searchForPage(UserPageSearchDto dto, AjaxPageResponse<PoliceUserDto> ajaxPageResponse) {
		userDao.searchForPage(dto,ajaxPageResponse);
	}
	/**
	 * 新增华为云用户
	 * @param dto 用户信息
	 * @return 无
	 */
	public void addUserConference(User dto) {
		if (dto.getId() == null) {
			throw  new ArsException("人员ID不能为空");
		}
		//当前用户
		User currentUser =  arsUtil.getCurrentUser();
		//开通用户
		User user =  userDao.findById(dto.getId());
		//检查是否开通
		ConferenceAccount  dbConferenceAccount = conferenceAccountDao.selectByUserId(dto.getId());
		if (dbConferenceAccount != null) {
			throw  new ArsException("已开通用户不需要再开通");
		}
		// 获取华为云会议的accessToken，创建公安会议的顶级用户
		String accessToken =arsUtil.getHuaweiMeetAccessToken(configUtils.getValueByKey(Constants.HeiweiconferenceAccount),configUtils.getValueByKey(Constants.HeiweiconferencePassword), Constants.HeiweiconferenceUserId);
		String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());
		//帐号信息
		String account =  heiweiPrefixKey + user.getId();
		//密码
		String pwd =   heiweiPrefixKey +"_pwd" + user.getId();
		//调用华为云会议接口
		Map<String, Object> map = new HashMap<>();
		//名称
		map.put("name", user.getRealname());
		map.put("account",account);
		map.put("pwd", pwd);
		//手机号码
		map.put("phone", user.getPhone());
		//是否发送短信，0为否
		map.put("sendNotify", "0");
		map.put("country", "chinaPR");  // 当填写手机号时 “country”参数必填。
		/**********调用华为云接口填加用户，00000000 代表接口返回成功 start **********/
		String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.ADD_USER;
		Map<String, String> headMap = new HashMap<>();
		headMap.put("Authorization", "Basic " + authorization);
		RestRequest restRequest = HttpBuildUtil.buildRestRequest(Constants.METHOD_POST, headMap, JSON.toJSONString(map), null);
		RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
		// 返回200成功
		if (response.getHttpCode() == HuaweiMeetConst.HUAWEI_SUCCESS_CODE) {
			Map<String, Object> data = JSON.parseObject(response.getEntity(), Map.class);
			user.setHuaweiUserId(data.get("id").toString());
			user.setHuaweiSipName(data.get("sipNum").toString());
		} else {
			logger.error(response.getEntity());
			throw new ArsException("开通失败");
		}
		/**********调用华为云接口填加用户，00000000 代表接口返回成功 end **********/
		/*** 插入人员华为云会议映射表 start***/
		ConferenceAccount conferenceAccount =  new ConferenceAccount();
		conferenceAccount.setActive(true);
		conferenceAccount.setCreateBy(currentUser.getUsername());
		conferenceAccount.setCreateTime(new Date());
		conferenceAccount.setUpdateTime(new Date());
		// 用户ID
		conferenceAccount.setUserid(user.getId());
		//帐号
		conferenceAccount.setAccount(account);
		//密码
		conferenceAccount.setPassword(pwd);
		conferenceAccount.setHuaweiUserId(user.getHuaweiUserId());
		conferenceAccount.setHuaweiSipName(user.getHuaweiSipName());
		conferenceAccountDao.insert(conferenceAccount);
		/*** 插入人员华为云会议映射表 end***/
	}
	/**
	 * 批量删除用户
	 * @param dto 用户信息
	 * @return 无
	 */
	public void delUserConference(User dto) {
		if (StringUtils.isEmpty(dto.getId())) {
			throw  new ArsException("人员ID不能为空");
		}
		/***
		 * 根据用户获取
		 */
		ConferenceAccount  conferenceAccount = conferenceAccountDao.selectByUserId(dto.getId());
		if (conferenceAccount==null) {
			return;
		}
		// 获取华为云会议的accessToken
		String accessToken =arsUtil.getHuaweiMeetAccessToken(configUtils.getValueByKey(Constants.HeiweiconferenceAccount),configUtils.getValueByKey(Constants.HeiweiconferencePassword), Constants.HeiweiconferenceUserId);
		String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());
		/**********调用华为云接口删除用户，200 代表接口返回成功 start **********/
		List<String> huaweiUserNameList = new ArrayList<>();
		//用户帐号
		huaweiUserNameList.add(conferenceAccount.getAccount());
		// 调用华为云会议接口 **
		Map<String, String> headMap = new HashMap<>();
		headMap.put("Authorization", "Basic " + authorization);
		String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.BATCH_DELETE_USER;
		RestRequest restRequest = HttpBuildUtil.buildRestRequest(Constants.METHOD_POST, headMap, JSON.toJSONString(huaweiUserNameList), null);
		RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
		// 200 代表接口返回成功 **
		if (response.getHttpCode() == HuaweiMeetConst.HUAWEI_SUCCESS_CODE) {
			//成功更新状态
			conferenceAccount.setUpdateTime(new Date());
			conferenceAccount.setActive(false);
			conferenceAccountDao.updateByUserId(conferenceAccount);
		} else {
			throw new ArsException("关闭失败");
		}

		/**********调用华为云接口删除用户，00000000 代表接口返回成功 start **********/
	}
	@Override
	public void updateConferenceState(User user) {
		//判断是开通还是注销
		if(Constants.CONFERENCESTATE_YES.equals(user.getConferenceState())){
			//开通云会议帐号
			addUserConference(user);
		}else{
			//注销云会议帐号
			delUserConference(user);
		}
		//更新状态
		userDaoAop.updateConferenceState(user);
	}

	/***
	 * 设置数据大屏链接
	 * @param user 用户信息
	 */
	@Override
	public void setDateView(User user){
		//数据大屏权限过滤
		String areaCode = user.getPolice().getAreacode();
		if (areaCode.endsWith("0000")) {// 省
			areaCode = areaCode.substring(0, 2) + "____" ;
		} else if (areaCode.endsWith("00")) {// 市
			areaCode = areaCode.substring(0, 4) + "__" ;
		}
		//数据大屏地址
		Map<String,String> param= Maps.newHashMap();
		//人员态势
		param.put("viewCode",configUtils.getValueByKey("BBD_RYTS"));
		param.put("areaCode","'"+areaCode+"'");
		user.setPersonDataURL( JwtUtil.createJWT(param));
		//企业态势
		param.put("viewCode",configUtils.getValueByKey("BBD_QYTS"));
		user.setCompanyDataURL( JwtUtil.createJWT(param));
		//监管态势
		param.put("viewCode",configUtils.getValueByKey("BBD_JGTSYJ"));
		user.setPoliceDataURL( JwtUtil.createJWT(param));

	}

	@Override
	public User findGSAndZRRByUsername(String username) {
		User user=userDao.findByUsername(username,Constants.PLATFORM_COMPANY+"");
		if (StringUtils.isEmpty(user)){
			user=userDao.findByUsername(username,Constants.PLATFORM_NATURAL_PERSON+"");
		}
		return user;
	}

}
