package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.*;
import com.bcxin.ars.model.*;
import com.bcxin.ars.service.SecurityPersonExperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Transactional
public class SecurityPersonExperienceServiceImpl implements SecurityPersonExperienceService {

	@Autowired
	private SecurityPersonExperienceDao securityPersonExperienceDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Autowired
	private SecurityCompanyDao companyDao;

	@Autowired
	private SecurityGoodThingDao goodThingDao;

	@Autowired
	private SbPunishDao punishDao;

	@Autowired
	private SbRewardDao rewardDao;

	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public void delete(SecurityPersonExperience personExperience) {
		User currentUser = arsUtil.getCurrentUser();
		personExperience.setUpdateBy(currentUser.getUsername());
		personExperience.setUpdateTime(new Date());
		securityPersonExperienceDao.delete(personExperience);
	}

	@Override
	public SecurityPersonExperience findById(Long experienceId) {
		return securityPersonExperienceDao.findById(experienceId);
	}

	@Override
	public List<SecurityPersonExperience> findByPersonId(Long personId) {
		return securityPersonExperienceDao.findByPersonId(personId);
	}

	@Override
	public void saveOrUpdate(SecurityPersonExperience securityPersonExperience) {
		User currentUser = arsUtil.getCurrentUser();
		if(securityPersonExperience.getId() != null) {
			SecurityPersonExperience dbSecurityPersonExperience = securityPersonExperienceDao.findById(securityPersonExperience.getId());
			dbSecurityPersonExperience.setCompanyAddress(securityPersonExperience.getCompanyAddress());
			dbSecurityPersonExperience.setCompanyName(securityPersonExperience.getCompanyName());
			dbSecurityPersonExperience.setDepartment(securityPersonExperience.getDepartment());
			dbSecurityPersonExperience.setEndDate(securityPersonExperience.getEndDate());
			dbSecurityPersonExperience.setPost(securityPersonExperience.getPost());
			dbSecurityPersonExperience.setStartDate(securityPersonExperience.getStartDate());
			dbSecurityPersonExperience.setUpdateBy(currentUser.getUsername());
			dbSecurityPersonExperience.setUpdateTime(new Date());
			dbSecurityPersonExperience.setWorkContent(securityPersonExperience.getWorkContent());
			dbSecurityPersonExperience.setOrgId(securityPersonExperience.getOrgId());
			securityPersonExperienceDao.update(dbSecurityPersonExperience);
		}else {
			securityPersonExperience.setActive(true);
			securityPersonExperience.setUpdateBy(currentUser.getUsername());
			securityPersonExperience.setCreateTime(new Date());
			securityPersonExperience.setUpdateTime(new Date());
			securityPersonExperienceDao.save(securityPersonExperience);
		}
	}

	@Override
	public List<SecurityPersonExperience> findByIdNum(String idNum) {
		return securityPersonExperienceDao.findByIdNum(idNum);
	}

	@Override
	public List<SecurityPersonExperience> searchForPage(SecurityPersonExperience dto, AjaxPageResponse<SecurityGoodThing> ajaxPageResponse) {
		return null;
	}

	@Override
	public List<SecurityPersonExperience> findByPersonIdForPunishAndReward(Long personId) {
		SecurityPerson person = securityPersonDao.findById(personId);
		if(null==person){
			return  null;
		}
		List<SecurityPersonExperience> experiences = securityPersonExperienceDao.findByIdNum(person.getIdNumber());

		List<SecurityGoodThing> goodThings = goodThingDao.findByIdNum(person.getIdNumber());
		List<SbPunish> punishs = punishDao.findByIdNum(person.getIdNumber());
		List<SbReward> rewards = rewardDao.findByIdNum(person.getIdNumber());

		experiences.forEach(experience->{
			if(experience.getCompanyId() != null){
				SecurityCompany company = companyDao.findById(experience.getCompanyId());
				if(company != null){
					List<SecurityGoodThing> goodThingList = goodThings.stream().filter((goodThing)->ObjectUtil.equal(company.getUserid(),goodThing.getUserid())).collect(Collectors.toList());
					List<SbPunish> punishList = punishs.stream().filter((punish)->ObjectUtil.equal(company.getUserid(),punish.getUserid())).collect(Collectors.toList());
					List<SbReward> rewardList = rewards.stream().filter((reward)->ObjectUtil.equal(company.getUserid(),reward.getUserid())).collect(Collectors.toList());
					experience.setGoodThingList(goodThingList);
					experience.setPunishList(punishList);
					experience.setRewardList(rewardList);
				}
			}
		});
		return experiences;
	}
}
