package com.bcxin.ars.service.impl;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.CompanyDto;
import com.bcxin.ars.dto.page.CompanyPageSearchDto;
import com.bcxin.ars.dto.report.*;
import com.bcxin.ars.dto.sys.SysareaSearchDTO;
import com.bcxin.ars.dto.v5.CompanyV5Dto;
import com.bcxin.ars.dto.v5.SecurityCertificateV5Dto;
import com.bcxin.ars.dto.v5.V5PageDto;
import com.bcxin.ars.dto.v5.V5ResultDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.message.messageUtils;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.bcxin.ars.webservice.Bagsxxb;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Zpxxb;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.gson.JsonParser;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SecurityCompany.class)
@DataSyncOutAnnotation(getClazz = SecurityCompany.class,getImportType = ImportType.FOREACH,getMethodName="saveForImport")
public class SecurityCompanyServiceImpl extends BaseService implements SecurityCompanyService {

    private static Logger logger = LoggerFactory.getLogger(SecurityCompanyServiceImpl.class);

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private SecurityCompanyDaoAop securityCompanyDaoAop;

    @Autowired
    private OrganizationDao orgDao;

    @Autowired
    private RoleDao roleDao;

    @Autowired
    private UserDao userDao;

    @Autowired
    private UserDaoAop userDaoAop;

    @Autowired
    private SecurityPersonDao personDao;

    @Autowired
    private ApprovalDAO approvalDao;

    @Autowired
    private TaskDao taskDao;

    @Autowired
    private SecurityCompanyInsuranceDao securityCompanyInsuranceDao;

    @Autowired
    private ProblemPersonDao problemPersonDao;
    @Autowired
    private UserService userService;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    private SearchHistoryService searchHistoryService;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private SysareaService sysareaService;

    @Autowired
    private ConfigService configService;

    @Autowired
    private OrderPersonDao orderPersonDao;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private SecurityPersonService personService;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private ComStateChangeLogDao comStateChangeLogDao;

    @Autowired
    private ClientUtil clientUtil;
    @Value("${temp-folder}")
    private String tempFolder;

    @Value("${base-folder}")
    private String baseFolder;
    @Autowired
    private ConfigDao configDao;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private ConfigUtils configUtils;
    /**
     * 保全公司分页查询
     */
    @Override
    public PageResult querysecurityCompanyList(Map<Object, Object> p) {
        return new PageResult(securityCompanyDao.queryAllCnt(p), securityCompanyDao.querySercurityCompanyList(p));
    }

    @Override
    public int getAllCount(Map<Object, Object> p) {
        return securityCompanyDao.queryAllCnt(p);
    }

    @Override
    public Map queryCompanyStatistics(Map<Object, Object> p) {
        return securityCompanyDao.queryCompanyStatistics(p);
    }

    @Override
    public int getInitCount(Map<Object, Object> p) {
        return securityCompanyDao.queryInitCnt(p);
    }

    @Override
    public int getNotInitCount(Map<Object, Object> p) {
        return securityCompanyDao.queryNotInitCnt(p);
    }

    @Override
    public int getNewAddCount(Map<Object, Object> p) {
        return securityCompanyDao.queryNewAddCnt(p);
    }


    @Override
    public SecurityCompany queryCompanyDetail(Long id) {
        return securityCompanyDao.queryCompanyDetail(id);
    }

    @Override
    public List<SecurityCompany> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return securityCompanyDao.searchForDataSynchronization(dto);
    }

    @Override
    public SecurityCompany findById(Long id) {
        return securityCompanyDao.findById(id);
    }
    @Override
    public SecurityCompany findByComId(Long id) {
        return securityCompanyDao.findByComId(id);
    }
    @Override
    public SecurityCompany findByComTaskId(Long id) {
        return securityCompanyDao.findByComTaskId(id);
    }
    @Override
    public void searchConfessComForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page) {
        arsUtil.setPoliceSearch(dto);
        securityCompanyDao.searchConfessComForPage(dto,page);
    }

    @Override
    public SecurityCompany findByUserid(Long userid) {
        return securityCompanyDao.findByUserid(userid);

    }

    @Override
    public SecurityCompany findByUserName(String userName) {
        return securityCompanyDao.findByUserName(userName);

    }
    @Override
    public List<SecurityCompany> findByAll(String type) {
        return securityCompanyDao.findByAll(type);

    }

    @Override
    public List<SecurityCompany> findByAllExceptHaveCer(String type) {
        return securityCompanyDao.findByAllExceptHaveCer(type);
    }

    @Override
    public List<SecurityCompany> findByAllForBj(String type) {
        return securityCompanyDao.findByAllForBj(type);

    }
    @Override
    public SecurityCompany findBySocialCode(String socialCode) {
        return securityCompanyDao.findBySocialCode(socialCode);
    }

    @Override
    public CompanySearchDto search(CompanySearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 1) {
            return null;
        }

        if (user != null && user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }

        String areacode = user.getPolice().getAreacode();
        if (areacode.endsWith("0000")) {//省
            dto.setOrgLevel("1");
        } else if (areacode.endsWith("00")) {//市
            dto.setOrgLevel("2");
        } else {//区
            dto.setOrgLevel("3");
        }

        //保存搜索记录
        if (StringUtil.isNotEmpty(dto.getKeyword())) {
            searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_COMPANY, user);
        }

        List<SecurityCompany> data = securityCompanyDao.search(dto);
        Long count = securityCompanyDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public CompanySearchDto searchForPersonInsuredState(CompanySearchDto dto) {
        List<SecurityCompany> data = securityCompanyDao.search(dto);
        Long count = securityCompanyDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    /**
     * 公司新增与Saas对接使用
     * */
    private AjaxResult sendToSaas(SecurityCompany securityCompany){
        ComInfoDto comInfoDto = new ComInfoDto();
        //保安公司名称
        comInfoDto.setComName(securityCompany.getName());
        //注册省份
        if(StringUtil.isNotEmpty(securityCompany.getAreaCode())) {
            comInfoDto.setRegProvince(securityCompany.getAreaCode().substring(0, 2) + "0000");
            //注册城市
            comInfoDto.setRegCity(securityCompany.getAreaCode().substring(0, 4) + "00");
        }
        //注册区域
        comInfoDto.setRegArea(securityCompany.getAreaCode());
        //注册地址
        comInfoDto.setRegAddress(securityCompany.getAddress());

        if(StringUtil.isNotEmpty(securityCompany.getOfficeAreaCode())) {
            //办公省份
            comInfoDto.setWorkProvince(securityCompany.getOfficeAreaCode().substring(0, 2) + "0000");
            //办公城市
            comInfoDto.setWorkCity(securityCompany.getOfficeAreaCode().substring(0, 4) + "00");
        }
        //办公区域
        comInfoDto.setWorkArea(securityCompany.getOfficeAreaCode());
        //办公地址
        comInfoDto.setWorkAddress(securityCompany.getLocation());
        //注册手机号码
        comInfoDto.setLegalRepPhone(securityCompany.getUser().getPhone());
        //用户名
        comInfoDto.setUserName(securityCompany.getUser().getUsername());
        //经济类型
        comInfoDto.setEconomicType(securityCompany.getEconomicType());
        //行业类型
        comInfoDto.setIndustryType("01");
        //公司类型
        comInfoDto.setComType(securityCompany.getCompanyType());
        //机构类型
        comInfoDto.setInstitutionType(securityCompany.getInstitutionType());
        //是否百保盾注册
        comInfoDto.setIsBbdRegister("1");
        //服务范围
        comInfoDto.setSafeRange(securityCompany.getSecurityScopeType());
        //注册资金（万元）
        comInfoDto.setRegAmount(securityCompany.getRegisteredMoney()!=null?securityCompany.getRegisteredMoney()+"":null);
        //法人
        comInfoDto.setLegalRepName(securityCompany.getLegalPerson());
        //法人身份证号
        comInfoDto.setIdCardNo(securityCompany.getLegalPersonNo());

        comInfoDto.setLicenceOrg(securityCompany.getGiveLicenseName());
        if(securityCompany.getGiveLicenseDate() != null) {
            comInfoDto.setLicenceDate(DateUtil.convertDateToString(securityCompany.getGiveLicenseDate(), DateUtil.FORMAT2));
        }
        //将公司信息推送给SaaS
        AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_SECURITY_UPDATE, comInfoDto);
        if(!result.isSuccessful()){
            throw new ArsException(securityCompany.getName() + result.getMsg() );
        }
        //判断返回data数据是否为空
        if(result.getData() != null){
            //主管理员ID
            Long perId =  ((JSONObject)result.getData()).getLong(Constants.SAAS_PERID);
            //企业ID
            String comId =  ((JSONObject)result.getData()).getString(Constants.SAAS_COMID);
            securityCompany.setComId(comId);
            securityCompany.setPerId(perId);
            //主管理员手机号码
            securityCompany.setMobilePhone(securityCompany.getUser().getPhone());
            this.createManageAccount(securityCompany);
        }
        //公司编号
        securityCompany.setCompanyCode(createCompanyCode(securityCompany.getInstitutionType()));
        return result;
    }

    @Override
    public void resetCompanyCode(){
        List<SecurityCompany> companyList = securityCompanyDao.findByErrorCompanyCode();
        if(companyList.size() > 0){
            for (SecurityCompany company : companyList) {
                company.setCompanyCode(createCompanyCode(company.getInstitutionType()));
                company.setUpdateTime(new Date());
                securityCompanyDao.update(company);
            }

        }


    }


    /***
     * 生成公司编号
     * @param  institutionType 公司类型
     * @return
     */
    private String createCompanyCode(String institutionType){
        /***
         * 公司编号
         */
        String maxCompanyCode = "";
        //获取省份
        Config nativeConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
        if(nativeConfig==null){
            new ArsException("缺少省份配置信息" );
        }
        StringBuffer companyCode =new StringBuffer();
        //保安服务公司
        if(Constants.BKT_ORGTYPE_GS.equals(institutionType)){
            /***
             * 公司编号
             */
            maxCompanyCode = securityCompanyDao.searchMaxCompanyCode(Constants.COMPANYCODE_PREFIX);
            //公司编号
            if (StringUtils.isEmpty(maxCompanyCode)) {
                //首个编号
                companyCode.append(Constants.COMPANYCODE_PREFIX).append(nativeConfig.getValue()).append(Constants.COMPANYCODE_PREFIX_FIRST);
            } else {
                //最大编号+1
                companyCode.append(maxCompanyCode.substring(0, 5));
                companyCode.append(StringUtil.addZeroForNum(String.valueOf((Long.valueOf(maxCompanyCode.substring(6)) + 1)),8));
            }
        }else if(Constants.BKT_ORGTYPE_JG.equals(institutionType)){
            //培训学校
            maxCompanyCode = securityCompanyDao.searchMaxCompanyCode(Constants.COMPANYCODE_P_PREFIX);
            //公司编号
            if (StringUtils.isEmpty(maxCompanyCode)) {
                //首个编号
                companyCode.append(Constants.COMPANYCODE_P_PREFIX).append(nativeConfig.getValue()).append(Constants.COMPANYCODE_PREFIX_FIRST);
            } else {
                //最大编号+1
                companyCode.append(maxCompanyCode.substring(0, 5));
                companyCode.append(StringUtil.addZeroForNum(String.valueOf((Long.valueOf(maxCompanyCode.substring(6)) + 1)),8));
            }

        }else if(Constants.BKT_ORGTYPE_WY.equals(institutionType)){
            maxCompanyCode = securityCompanyDao.searchMaxCompanyCode(Constants.COMPANYCODE_Z_PREFIX);

            //公司编号
            if (StringUtils.isEmpty(maxCompanyCode)) {
                //首个编号
                companyCode.append(Constants.COMPANYCODE_Z_PREFIX).append(nativeConfig.getValue()).append(Constants.COMPANYCODE_PREFIX_FIRST);
            } else {
                //最大编号+1
                companyCode.append(maxCompanyCode.substring(0, 5));
                companyCode.append(StringUtil.addZeroForNum(String.valueOf((Long.valueOf(maxCompanyCode.substring(6)) + 1)),8));
            }
        }
        return companyCode.toString();
    }


    @Override
    public void saveOrUpdateForFX(SecurityCompany company) {
        if (company != null) {
            company.setUpdateTime(new Date());
            securityCompanyDaoAop.update(company);
        } else {
            throw new ArsException("安保公司不存在");
        }
    }

    /**
     * 保存保险信息
     * @param company
     */
    @Deprecated
    public void saveInsuranceCompany(SecurityCompany company) {
        //获得保安公司保险信息
        User currentUser = arsUtil.getCurrentUser();
        SecurityCompany dbcompany = null;

        if (currentUser.getPlatform() == 2) {
            dbcompany = findByUserid(currentUser.getId());
        } else if (currentUser.getPlatform() == 1) {
            dbcompany = company;
        }

        if (dbcompany == null) {
            throw new ArsException("安保公司信息错误。");
        }

        User user = dbcompany.getUser();

        if (company.getSecurityCompanyInsurance() != null) {
            String[] insurance_company = company.getSecurityCompanyInsurance().getInsurance_company().split(",");
            String[] insurance_product = company.getSecurityCompanyInsurance().getInsurance_product().split(",");
            String[] protection_date = company.getSecurityCompanyInsurance().getProtection_date().split(",");
            String[] insured_num = company.getSecurityCompanyInsurance().getInsured_num().split(",");
            String[] premium_person = company.getSecurityCompanyInsurance().getPremium_person().split(",");

            String[] ywsg = company.getSecurityCompanyInsurance().getYwsg().split(",");

            String[] jtyw = company.getSecurityCompanyInsurance().getJtyw().split(",");

            String[] ywyl = company.getSecurityCompanyInsurance().getYwyl().split(",");

            String[] zdcj = company.getSecurityCompanyInsurance().getZdcj().split(",");

            String[] jyjt = company.getSecurityCompanyInsurance().getJyjt().split(",");

            String[] flfy = company.getSecurityCompanyInsurance().getFlfy().split(",");

            String[] end_date = company.getSecurityCompanyInsurance().getEnd_date().split(",");

            String[] insurance_number = company.getSecurityCompanyInsurance().getInsurance_number().split(",");

            String[] insurance_pic = company.getSecurityCompanyInsurance().getInsurance_pic().split(",");

            int[] a = {insurance_company.length, insurance_product.length, protection_date.length, insured_num.length, premium_person.length, ywsg.length, jtyw.length, ywyl.length, zdcj.length, jyjt.length, flfy.length, end_date.length, insurance_number.length};
            int count = StringUtil.getMax(a);
            //保存保安公司保险信息
            if (insurance_company != null && insurance_company.length > 0) {
                //1先删除原有的
                securityCompanyInsuranceDao.deleteBySid(user.getId());
                for (int i = 0; i < count; i++) {
                    SecurityCompanyInsurance securityCompanyInsurance = new SecurityCompanyInsurance();
                    securityCompanyInsurance.setActive(true);
                    securityCompanyInsurance.setCreateTime(new Date());
                    securityCompanyInsurance.setUpdateTime(new Date());
                    securityCompanyInsurance.setUpdateBy(arsUtil.getCurrentUser().getUsername());
                    securityCompanyInsurance.setCompany_id(user.getId());
                    //判断是否非空，非空则保存
                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getProtection_date())) {
                        if (protection_date.length > i && !protection_date[i].equals("")) {
                            securityCompanyInsurance.setProtection_date(protection_date[i]);
                        }
                    }
                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getPremium_person())) {
                        if (premium_person.length > i) {
                            if (!premium_person[i].equals("")) {
                                securityCompanyInsurance.setPremium_person(premium_person[i]);
                            }
                        }
                    }
                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getInsured_num())) {
                        if (insured_num.length > i) {
                            if (!insured_num[i].equals("")) {
                                securityCompanyInsurance.setInsured_num(insured_num[i]);
                            }
                        }
                    }
                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getInsurance_product())) {
                        if (insurance_product.length > i) {
                            securityCompanyInsurance.setInsurance_product(insurance_product[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getInsurance_company())) {
                        if (insurance_company.length > i) {
                            securityCompanyInsurance.setInsurance_company(insurance_company[i]);
                        }
                    }
                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getYwsg())) {
                        if (ywsg.length > i) {
                            securityCompanyInsurance.setYwsg(ywsg[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getJtyw())) {
                        if (jtyw.length > i) {
                            securityCompanyInsurance.setJtyw(jtyw[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getYwyl())) {
                        if (ywyl.length > i) {
                            securityCompanyInsurance.setYwyl(ywyl[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getZdcj())) {
                        if (zdcj.length > i) {
                            securityCompanyInsurance.setZdcj(zdcj[i]);
                        }
                    }


                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getJyjt())) {
                        if (jyjt.length > i) {
                            securityCompanyInsurance.setJyjt(jyjt[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getFlfy())) {
                        if (flfy.length > i) {
                            securityCompanyInsurance.setFlfy(flfy[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getEnd_date())) {
                        if (end_date.length > i) {
                            securityCompanyInsurance.setEnd_date(end_date[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getInsurance_number())) {
                        if (insurance_number.length > i) {
                            securityCompanyInsurance.setInsurance_number(insurance_number[i]);
                        }
                    }
                    if (!StringUtils.isEmpty(company.getSecurityCompanyInsurance().getInsurance_pic())) {
                        if (insurance_pic.length > i) {
                            securityCompanyInsurance.setInsurance_pic(insurance_pic[i]);
                        }
                    }
                    if ("0".equals(company.getPolicyLine())) {
                        securityCompanyInsurance.setActive(false);
                    }
                    securityCompanyInsuranceDao.save(securityCompanyInsurance);
                }
            }
        }
    }

    @Override
    public void saveOrUpdateForSAAS(SecurityCompany company) {
        User currentUser = arsUtil.getCurrentUser();
        if(null != currentUser) {
            company.setUpdateBy(currentUser.getUsername());
        }else{
            company.setUpdateBy(company.getUser().getUsername());
        }
        company.setUpdateTime(new Date());
        if (company.getId()==null){
            if (securityCompanyDao.findByName(company.getName())!= null) {
                throw new ArsException("公司名称已存在！");
            }
            company.setId(idGeneratorUtil.createID());
        }

        //北京企业监管机构显示只到分局
        if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            if (StringUtil.isNotEmpty(company.getOrgId())) {
                Police police = policeDao.findById(Long.parseLong(company.getOrgId()));
                if (police != null) {
                    if (Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())) {
                        Police parentPolice = policeDao.findByOrgIdsAndOrgType(police.getPath().split("/"), Constants.POLICE_ORGTYPE_QX);
                        if (parentPolice != null) {
                            company.setDistrictOrgId(parentPolice.getId().toString());
                            company.setDistrictOrgName(parentPolice.getOrgname());
                        }
                    }else{
                        company.setDistrictOrgId(company.getOrgId());
                        company.setDistrictOrgName(company.getOrgName());
                    }
                }
            }
        }

        SecurityCompany dbCompany =securityCompanyDao.findById(company.getId());
        if (dbCompany == null) {
            company.setCreateTime(new Date());
            company.setActive(true);
            company.setExported(true);
            if(null != arsUtil.getCurrentNatvie()) {
                company.setNativeCode(arsUtil.getCurrentNatvie());
            }
            company.setSecurityAmount(0);
            //编号
            company.setCompanyCode(createCompanyCode(company.getInstitutionType()));
            securityCompanyDao.save(company);
            //生成主管理员
            this.createManageAccount(company);

        } else {

            if (dbCompany != null && company.getId().longValue() != dbCompany.getId().longValue()) {
                throw new ArsException("公司名称已存在！");
            }

            if(Constants.COMPANY_STATE_4.equals(dbCompany.getCompanyState())){
                company.setCompanyState(dbCompany.getCompanyState());
            }
            //值复制
            BeanUtils.copyPropertiesIgnore(company,dbCompany,true);
            //营业执照地址
            if (!StringUtils.isEmpty(company.getBusinessLicense())) {
                dbCompany.setBusinessLicense(getPhotoPath(company.getBusinessLicense()));
            }
            //公安许可证地址
            if (!StringUtils.isEmpty(company.getPublicSecurityLicense())) {
                dbCompany.setPublicSecurityLicense(getPhotoPath(company.getPublicSecurityLicense()));
            }
            securityCompanyDaoAop.update(dbCompany);
        }
    }

    /**
     * saas新增的公司 新建主管理账号
     * @param company
     */
    private void createManageAccount(SecurityCompany company){
        if(company.getPerId() != null && StringUtil.isNotEmpty(company.getMobilePhone())) {
            SecurityPersonDTO personDTO = new SecurityPersonDTO();
            personDTO.setPhone(company.getMobilePhone());
            personDTO.setRealName("主管理员");
            personDTO.setInsured(Constants.INSURED_NO);
            personDTO.setIncumbencyStatus(Constants.INCUMBENCYSTATUS_Y);
            personDTO.setAreacode(company.getAreaCode());
            personDTO.setPhone(company.getMobilePhone());
            personDTO.setId(company.getPerId());
            personDTO.setActive(true);
            personDTO.setCreateTime(new Date());
            personDTO.setUpdateTime(new Date());
            personDTO.setEntrydate(new Date());
            personDTO.setUpdateBy("system");
            personDTO.setUpdateflag(false);
            //主管理员 默认内勤人员
            personDTO.setPersonType(Constants.PERSONTYPE_INFO);
            personService.saveOrUpdateForSaas(personDTO,company);
        }

    }

    @Override
    public void saveOrUpdate(SecurityCompany company) {
        if (company.getId()==null){
            if (securityCompanyDao.findByName(company.getName())!= null) {
                throw new ArsException("公司名称已存在！");
            }
            company.setId(idGeneratorUtil.createID());
        }

        //北京企业监管机构显示只到分局
        if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            if (StringUtil.isNotEmpty(company.getOrgId())) {
                Police police = policeDao.findById(Long.parseLong(company.getOrgId()));
                if (police != null) {
                    if (Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())) {
                        Police parentPolice = policeDao.findByOrgIdsAndOrgType(police.getPath().split("/"), Constants.POLICE_ORGTYPE_QX);
                        if (parentPolice != null) {
                            company.setDistrictOrgId(parentPolice.getId().toString());
                            company.setDistrictOrgName(parentPolice.getOrgname());
                        }
                    }else{
                        company.setDistrictOrgId(company.getOrgId());
                        company.setDistrictOrgName(company.getOrgName());
                    }
                }
            }
        }

        SecurityCompany dbCompany =securityCompanyDao.findById(company.getId());
        if (dbCompany == null) {
            //判断是否外网
            Config policeConfig = configUtils.getConfigByKey(Constants.POLICE);
            if(null!=policeConfig && Constants.POLICE_OUT.equals(policeConfig.getValue())){
                company.setExported(true);
                company.setUpdateflag(false);
            }else{
                company.setExported(false);
                company.setUpdateflag(true);
            }
            company.setCreateTime(new Date());
            company.setUpdateTime(company.getCreateTime());
            company.setActive(true);
            company.setNativeCode(arsUtil.getCurrentNatvie());
            company.setUpdateBy(arsUtil.getCurrentUser().getUsername());
            company.setSecurityAmount(0);
            //判断是否外网
            if(!configUtils.isIntranet()){
                    //将公司信息推送给SaaS
               this.sendToSaas(company);
            }
            securityCompanyDao.save(company);
        } else {
            /**
             * 唯一性判断
             */
            if (dbCompany != null && company.getId().longValue() != dbCompany.getId().longValue()) {
                throw new ArsException("公司名称已存在！");
            }
            SecurityCompany dbCom = securityCompanyDao.findById(company.getId());
            if (dbCom != null) {

                /**
                 * 值复制
                 * */
                BeanUtils.copyPropertiesIgnore(company, dbCom, true);
                //判断是否外网
                if(!configUtils.isIntranet()){
                    //将公司信息推送给SaaS
                    this.updateToSAAS(dbCom);
                }
                dbCom.setUpdateBy(arsUtil.getCurrentUser().getUsername());
                dbCom.setUpdateTime(new Date());
                //营业执照地址
                if (!StringUtils.isEmpty(company.getBusinessLicense())) {
                    dbCom.setBusinessLicense(getPhotoPath(company.getBusinessLicense()));
                }
                //公安许可证地址
                if (!StringUtils.isEmpty(company.getPublicSecurityLicense())) {
                    dbCom.setPublicSecurityLicense(getPhotoPath(company.getPublicSecurityLicense()));
                }
                if (company.getUpdateflag() != null) {
                    dbCom.setUpdateflag(company.getUpdateflag());
                } else {
                    dbCom.setUpdateflag(false);
                }
                securityCompanyDaoAop.update(dbCom);
            } else {
                throw new RuntimeException("安保公司不存在，ID:" + company.getId());
            }
        }
    }

    private void updateToSAAS(SecurityCompany securityCompany){
        ComInfoDto comInfoDto = new ComInfoDto();
        //保安公司名称
        comInfoDto.setComName(securityCompany.getName());
        //注册省份
        comInfoDto.setRegProvince(securityCompany.getAreaCode().substring(0,2)+"0000");
        //注册城市
        comInfoDto.setRegCity(securityCompany.getAreaCode().substring(0,4)+"00");
        //注册区域
        comInfoDto.setRegArea(securityCompany.getAreaCode());
        //注册地址
        comInfoDto.setRegAddress(securityCompany.getAddress());

        if(StringUtil.isNotEmpty(securityCompany.getOfficeAreaCode())) {
            //办公省份
            comInfoDto.setWorkProvince(securityCompany.getOfficeAreaCode().substring(0, 2) + "0000");
            //办公城市
            comInfoDto.setWorkCity(securityCompany.getOfficeAreaCode().substring(0, 4) + "00");
            //办公区域
            comInfoDto.setWorkArea(securityCompany.getOfficeAreaCode());
        }
        //办公地址
        comInfoDto.setWorkAddress(securityCompany.getLocation());
        //注册手机号码
        comInfoDto.setLegalRepPhone(securityCompany.getUser().getPhone());
        //用户名
        comInfoDto.setUserName(securityCompany.getUser().getUsername());
        //判断SaaS的comId是否存在
        if(StringUtil.isEmpty(securityCompany.getComId())){
            throw new ArsException(securityCompany.getName()+"ComID数据异常" );
        }
        comInfoDto.setComId(Long.valueOf(securityCompany.getComId()));
        //经济类型
        comInfoDto.setEconomicType(securityCompany.getEconomicType());
        //公司类型
        comInfoDto.setComType(securityCompany.getCompanyType());
        //机构类型
        comInfoDto.setInstitutionType(securityCompany.getInstitutionType());
        //服务范围
        comInfoDto.setSafeRange(securityCompany.getSecurityScopeType());
        //注册资金（万元）
        comInfoDto.setRegAmount(securityCompany.getRegisteredMoney()!=null?securityCompany.getRegisteredMoney()+"":null);
        //法人
        comInfoDto.setLegalRepName(securityCompany.getLegalPerson());
        //法人身份证号
        comInfoDto.setIdCardNo(securityCompany.getLegalPersonNo());
        comInfoDto.setLicenceOrg(securityCompany.getGiveLicenseName());
        if(securityCompany.getGiveLicenseDate() != null) {
            comInfoDto.setLicenceDate(DateUtil.convertDateToString(securityCompany.getGiveLicenseDate(), DateUtil.FORMAT2));
        }
        //将公司信息推送给SaaS
        AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_LEGALCHANGE_UPDATE, comInfoDto);
        if(!result.isSuccessful()){
            throw new ArsException(securityCompany.getName() + result.getMsg() );
        }
    }

    private String changeToSAASSafeRange(String securityScopeType){
        if(StringUtil.isNotEmpty(securityScopeType)) {
         /*
            转成saas码表
            complete-xmbg-approve
            safeRange 安全范围
                北京：1:门卫,2:巡逻,3:守护,4:随身护卫,6:武装押运,7:安全检查,8:安全风险评估,9:安全风险评估
                陕西：1:门卫,2:巡逻,3:守护,4:随身护卫,5:押运,6:区域秩序维护,7:安全检查,8:安全风险评估,9:安全技术防范
            */
            Map<String, String> safeRangeMap = new HashMap<>();
            if(Constants.SHANGXI.equals(configUtils.getCurrentNative())){
                safeRangeMap.put("1", "1");
                safeRangeMap.put("2", "2");
                safeRangeMap.put("3", "3");
                safeRangeMap.put("4", "4");
                safeRangeMap.put("6", "10");
                safeRangeMap.put("5", "6");
                safeRangeMap.put("7", "7");
                safeRangeMap.put("8", "8");
                safeRangeMap.put("9", "9");
            }else{
                //北京、广西、宁夏
                safeRangeMap.put("1", "1");
                safeRangeMap.put("2", "2");
                safeRangeMap.put("3", "3");
                safeRangeMap.put("4", "4");
                safeRangeMap.put("6", "6");
                safeRangeMap.put("7", "7");
                safeRangeMap.put("8", "8");
                safeRangeMap.put("9", "9");
            }

            StringBuffer safeRange = new StringBuffer();
            for (String scopeId : securityScopeType.split(Constants.COMMA)) {
                safeRange.append(safeRangeMap.get(scopeId) + Constants.COMMA);
            }
            return safeRange.toString().substring(0, safeRange.toString().length() - 1);
        }
        return null;
    }

    @Override
    public String changeToARSSafeRange(String securityScopeType){
        if(StringUtil.isNotEmpty(securityScopeType)) {
         /*
            转成saas码表
            complete-xmbg-approve
            safeRange 安全范围
                北京：1:门卫,2:巡逻,3:守护,4:随身护卫,6:武装押运,7:安全检查,8:安全风险评估,9:安全风险评估
                陕西：1:门卫,2:巡逻,3:守护,4:随身护卫,5:押运,6:区域秩序维护,7:安全检查,8:安全风险评估,9:安全技术防范
            */
            Map<String, String> safeRangeMap = new HashMap<>();
            if(Constants.SHANGXI.equals(configUtils.getCurrentNative())){
                safeRangeMap.put("1", "1");
                safeRangeMap.put("2", "2");
                safeRangeMap.put("3", "3");
                safeRangeMap.put("4", "4");
                safeRangeMap.put("6", "5");
                safeRangeMap.put("10", "6");
                safeRangeMap.put("7", "7");
                safeRangeMap.put("8", "8");
                safeRangeMap.put("9", "9");

            }else{
                //北京、广西、宁夏
                safeRangeMap.put("1", "1");
                safeRangeMap.put("2", "2");
                safeRangeMap.put("3", "3");
                safeRangeMap.put("4", "4");
                safeRangeMap.put("6", "6");
                safeRangeMap.put("7", "7");
                safeRangeMap.put("8", "8");
                safeRangeMap.put("9", "9");
            }

            StringBuffer safeRange = new StringBuffer();
            for (String scopeId : securityScopeType.split(Constants.COMMA)) {
                safeRange.append(safeRangeMap.get(scopeId) + Constants.COMMA);
            }
            return safeRange.toString().substring(0, safeRange.toString().length() - 1);
        }
        return null;
    }

    @Override
    public void saveForImport(SecurityCompany company) {
        //导入的时候，如果已存在则不导入。不抛异常，否则其他的都不能导入  2018年8月28日10:19:36 wjb
        boolean flag = true;
        SecurityCompany dbCompany = securityCompanyDao.findById(company.getId());
        //判断数据库是否有
        if (dbCompany != null) {
            flag = false;
        }
        if (flag) {
                //内网是否导出的标记，导出后内网不允许修改
                company.setExported(true);
               //编号
                company.setCompanyCode(createCompanyCode(company.getInstitutionType()));
                company.setLocal(true);
                //将公司信息推送给公共服务平台
                this.sendToSaas(company);
                //保存公司信息
                securityCompanyDao.save(company);
                //部级接口对接  ---保安服务公司信息
                //调用webService服务
                /*new Thread(() -> { //异步处理
                    try {
                        buildWebServiceEntity(company);
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }).start();
                new Thread(() -> { //异步处理
                    try {
                        String photo = company.getUser().getPhoto();
                        if (StringUtil.isNotEmpty(photo) && photo.startsWith("getResource.do?path=") && StringUtil.isNotEmpty(company.getCompanyCode())) {
                            //部级接口对接--照片信息上传
                            //证件号码(公民身份号码/保安服务公司编码/自招单位编码/保安培训机构编码)	sfzh	50	Y	字符	证件号码+照片名称是联合主键
                            //照片名称	zpxx	50	Y	字符
                            //1、命名规则：证件号码.jpg，或者证件号码_编号.jpg。
                            //2、保安员照片名称身份证号一样。
                            //3、其他照片分类，如如果照片名称一样，更新原记录，照片名称不一样作为新记录处理。

                            //照片内容	zpnr	500K	Y	字符	Base64,最大不能超过500K
                            //照片分类	zpfl	2	Y	字符	01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                            String fileType = photo.substring(photo.lastIndexOf("."));
                            //图片转BASE64字符串
                            photo = Base64Img.encodeBase64File(photo, baseFolder);
                            //BASE64字符串转图片 --测试用
                            //Base64Img.GenerateImage(photo);//测试用
                            Zpxxb zpxxb = new Zpxxb();
                            //TODO 保安服务公司编码 没有此字段，暂用营业执照号
                            zpxxb.setSfzh(company.getCompanyCode());
                            zpxxb.setZpxx(company.getCompanyCode() + fileType);
                            zpxxb.setZpnr(photo);
                            zpxxb.setZpfl("02");//01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                            //调用send方法完成对接
                            clientUtil.send(Constants.XXBA_ZPXXB, zpxxb);
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }).start();*/

            }
    }
    /**
     * 递归获取缩进的组织列表
     *
     * @param orgList
     * @param org
     */
    public void getOrgChildren(List<Organization> orgList, Organization org, int level) {
        String es = "";
        for (int i = 1; i < level; i++) {
            es += "  ";
        }
        org.setName(es + org.getName());
        orgList.add(org);
        if (org.getChildren().size() > 0) {
            level++;
            for (Organization o : org.getChildren()) {
                getOrgChildren(orgList, o, level);
            }
        }
    }

    /**
     * 递归获取缩进的地区列表
     *
     * @param nativeList
     * @param treeView
     */
    public void getNativeChildren(List<TreeView> nativeList, TreeView treeView, int level) {
        String es = "";
        for (int i = 1; i < level; i++) {
            es += "  ";
        }
        boolean flag = true;
        for (TreeView naView : nativeList) {
            if (naView.getCode().equals(treeView.getCode())) {
                flag = false;
            }
        }
        if (flag) {
            treeView.setText(es + treeView.getText());
            nativeList.add(treeView);
            if (treeView.getNodes() != null && treeView.getNodes().size() > 0) {
                level++;
                for (TreeView o : treeView.getNodes()) {
                    getNativeChildren(nativeList, o, level);
                }
            }
        }
    }

    /**
     * 生成保安员导入模板
     */
    @Override
    public void buildTemplate(SecurityCompany company, File file) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet1 = wb.createSheet("填写范例说明");
        HSSFSheet sheet2 = wb.createSheet("人员信息");
        HSSFSheet sheet3 = wb.createSheet("参考数据");
        wb.setSheetHidden(2, true);
        //获取根组织列表
        List<Organization> orgList = orgDao.findByCompany(company.getId());
        //递归获取子组织列表
        List<Organization> orgs = new ArrayList<Organization>();
        int level = 1;
        for (Organization org : orgList) {
            getOrgChildren(orgs, org, level);
        }
        //放入组织数组
        String[] orgArr = new String[orgs.size()];
        for (int i = 0; i < orgs.size(); i++) {
            orgArr[i] = orgs.get(i).getName() + "-" + orgs.get(i).getId();
        }
        //获取角色列表
        List<Role> roles = roleDao.findByCompany(company.getId());
        //放入角色数组
        String[] roleArr = new String[roles.size()];
        for (int i = 0; i < roles.size(); i++) {
            roleArr[i] = roles.get(i).getName() + "-" + roles.get(i).getId();
        }
        //学历数组
        String[] edu = {"初中-1", "中职-2", "技校-3", "普通高中-4", "专科-5", "本科-6", "硕士-7", "博士-8"};
        //
        //  String[] profession_level = {"初级保安员-1", "中级保安员-2", "高级保安员-3", "保安师-4", "高级保安师-5"};
        String[] profession_level = {"初级保安员-1", "中级保安员-2", "高级保安员-3", "保安师-4", "高级保安师-5"};
        //
        String[] politics = {"党员-1", "团员-2", "群众-3"};
        //
        String[] marriage = {"已婚-1", "未婚-2", "离异-3"};
        //性别数组
//        String[] sex = {"男", "女"};

        //血型数组
        String[] blood = {"A-A", "B-B", "AB-AB", "O-O", "Rh阳-Rh阳", "Rh阴-Rh阴"};

        //人员类别数组
        String[] personType = {"内勤人员-1", "普通保安员-2", "武装押运人员-3"};

        //国籍数组
        String[] nationality = {"中国-中国", "阿鲁巴-阿鲁巴", "阿富汗-阿富汗", "安哥拉-安哥拉", "安圭拉-安圭拉", "阿尔巴尼亚-阿尔巴尼亚", "安道尔-安道尔", "荷属安的列斯-荷属安的列斯", "阿联酋-阿联酋", "阿根廷-阿根廷", "亚美尼亚-亚美尼亚", "美属萨摩亚-美属萨摩亚", "南极洲-南极洲", "法属南部领土-法属南部领土", "安提瓜和巴布达-安提瓜和巴布达", "澳大利亚-澳大利亚", "奥地利-奥地利", "阿塞拜疆-阿塞拜疆", "布隆迪-布隆迪", "比利时-比利时", "贝宁-贝宁", "布基纳法索-布基纳法索", "孟加拉国-孟加拉国", "保加利亚-保加利亚", "巴林-巴林", "巴哈马-巴哈马", "波斯尼亚和黑塞哥维那-波斯尼亚和黑塞哥维那", "白俄罗斯-白俄罗斯", "伯利兹-伯利兹", "百幕大-百幕大", "玻利维亚-玻利维亚", "巴西-巴西", "巴巴多斯-巴巴多斯", "文莱-文莱", "不丹-不丹", "布维岛-布维岛", "博茨瓦纳-博茨瓦纳", "中非-中非", "加拿大-加拿大", "科科斯群岛-科科斯群岛", "瑞士-瑞士", "智利-智利", "科特迪瓦-科特迪瓦", "喀麦隆-喀麦隆", "刚果民主共和国-刚果民主共和国", "刚果-刚果", "库克群岛-库克群岛", "哥伦比亚-哥伦比亚", "科摩罗-科摩罗", "佛得角-佛得角", "哥斯达黎加-哥斯达黎加", "古巴-古巴", "圣诞岛-圣诞岛", "开曼群岛-开曼群岛", "塞浦路斯-塞浦路斯", "捷克-捷克", "德国-德国", "吉布提-吉布提", "多米尼加-多米尼加", "丹麦-丹麦", "多米尼家共和国-多米尼家共和国", "阿尔及利亚-阿尔及利亚", "厄瓜多尔-厄瓜多尔", "埃及-埃及", "厄立特里亚-厄立特里亚", "西撒哈拉-西撒哈拉", "西班牙-西班牙", "爱沙尼亚-爱沙尼亚", "埃塞俄比亚-埃塞俄比亚", "芬兰-芬兰", "斐济-斐济", "马尔维纳斯群岛-马尔维纳斯群岛", "法国-法国", "法罗群岛-法罗群岛", "密克罗尼西亚-密克罗尼西亚", "加蓬-加蓬", "英国（独立领土公民、出国不用）-英国（独立领土公民、出国不用）", "英国（海外国民，出国不用）-英国（海外国民，出国不用）", "英国（海外公民，出国不用）-英国（海外公民，出国不用）", "英国（保护公民，出国不用）-英国（保护公民，出国不用）", "英国-英国", "英国（隶属，出国不用）-英国（隶属，出国不用）", "格鲁吉亚-格鲁吉亚", "加纳-加纳", "直布罗陀-直布罗陀", "几内亚-几内亚", "瓜德罗普-瓜德罗普", "冈比亚-冈比亚", "几内亚比绍-几内亚比绍", "赤道几内亚-赤道几内亚", "希腊-希腊", "格林纳达-格林纳达", "格陵兰-格陵兰", "危地马拉-危地马拉", "法属圭亚那-法属圭亚那", "关岛-关岛", "圭亚那-圭亚那", "香港-香港", "赫德岛和麦克唐纳岛-赫德岛和麦克唐纳岛", "洪都拉斯-洪都拉斯", "克罗地亚-克罗地亚", "海地-海地", "匈牙利-匈牙利", "印度尼西亚-印度尼西亚", "印度-印度", "英属印度洋领土-英属印度洋领土", "爱尔兰-爱尔兰", "伊朗-伊朗", "伊拉克-伊拉克", "冰岛-冰岛", "以色列-以色列", "意大利-意大利", "牙买加-牙买加", "约旦-约旦", "日本-日本", "约翰斯顿岛-约翰斯顿岛", "哈萨克斯坦-哈萨克斯坦", "肯尼亚-肯尼亚", "吉尔吉斯斯坦-吉尔吉斯斯坦", "柬埔寨-柬埔寨", "基里巴斯-基里巴斯", "圣基茨和尼维斯-圣基茨和尼维斯", "韩国（南朝鲜）-韩国（南朝鲜）", "科威特-科威特", "老挝-老挝", "黎巴嫩-黎巴嫩", "利比里亚-利比里亚", "利比亚-利比亚", "圣卢西亚-圣卢西亚", "列支敦土登-列支敦土登", "斯里兰卡-斯里兰卡", "莱索托-莱索托", "立陶宛-立陶宛", "卢森堡-卢森堡", "拉脱维亚-拉脱维亚", "澳门-澳门", "摩洛哥-摩洛哥", "摩纳哥-摩纳哥", "摩尔多瓦-摩尔多瓦", "马达加斯加-马达加斯加", "马尔代夫-马尔代夫", "墨西哥-墨西哥", "马绍尔群岛-马绍尔群岛", "中途岛-中途岛", "马其顿-马其顿", "马里-马里", "马耳他-马耳他", "缅甸-缅甸", "蒙古-蒙古", "北马里亚纳-北马里亚纳", "莫桑比克-莫桑比克", "毛里塔尼亚-毛里塔尼亚", "蒙特塞拉特-蒙特塞拉特", "马提尼克-马提尼克", "毛里求斯-毛里求斯", "马拉维-马拉维", "马来西亚-马来西亚", "马约特-马约特", "纳米比亚-纳米比亚", "新喀里多尼亚-新喀里多尼亚", "尼日尔-尼日尔", "诺福克岛-诺福克岛", "尼日利亚-尼日利亚", "尼加拉瓜-尼加拉瓜", "纽埃-纽埃", "荷兰-荷兰", "挪威-挪威", "尼波尔-尼波尔", "瑙鲁-瑙鲁", "中间地带-中间地带", "新西兰-新西兰", "阿曼-阿曼", "巴基斯坦-巴基斯坦", "巴拿马-巴拿马", "皮特凯恩群岛-皮特凯恩群岛", "秘鲁-秘鲁", "菲律宾-菲律宾", "贝劳-贝劳", "巴布亚新几内亚-巴布亚新几内亚", "波兰-波兰", "波多黎各-波多黎各", "朝鲜-朝鲜", "葡萄牙-葡萄牙", "巴拉圭-巴拉圭", "巴勒斯坦-巴勒斯坦", "法属菠利尼西亚-法属菠利尼西亚", "卡塔尔-卡塔尔", "留尼汪-留尼汪", "罗马尼亚-罗马尼亚", "俄罗斯-俄罗斯", "卢旺达-卢旺达", "沙特阿拉伯-沙特阿拉伯", "苏丹-苏丹", "塞内加尔-塞内加尔", "塞尔维亚-塞尔维亚", "新加坡-新加坡", "南乔治亚岛和南桑德韦奇岛-南乔治亚岛和南桑德韦奇岛", "圣赫勒拿-圣赫勒拿", "斯瓦尔巴群岛-斯瓦尔巴群岛", "所罗门群岛-所罗门群岛", "塞拉利昂-塞拉利昂", "萨尔瓦多-萨尔瓦多", "圣马力诺-圣马力诺", "索马里-索马里", "圣皮埃尔和密克隆-圣皮埃尔和密克隆", "塞班-塞班", "圣多美和普林西比-圣多美和普林西比", "苏里南-苏里南", "斯洛伐克-斯洛伐克", "斯洛文尼亚-斯洛文尼亚", "瑞典-瑞典", "斯威士兰-斯威士兰", "锡金-锡金", "塞舌尔-塞舌尔", "叙利亚-叙利亚", "特克斯和凯科斯群岛-特克斯和凯科斯群岛", "乍得-乍得", "多哥-多哥", "泰国-泰国", "塔吉克斯坦-塔吉克斯坦", "托克劳-托克劳", "土库曼斯坦-土库曼斯坦", "东帝汶-东帝汶", "汤加-汤加", "特立尼达和多巴哥-特立尼达和多巴哥", "突尼斯-突尼斯", "土耳其-土耳其", "图瓦卢-图瓦卢", "台湾-台湾", "坦桑尼亚-坦桑尼亚", "乌干达-乌干达", "乌克兰-乌克兰", "美属太平洋各群岛-美属太平洋各群岛", "联合国-联合国", "联合国-联合国", "联合国-联合国", "乌拉圭-乌拉圭", "美国-美国", "乌兹别克斯坦-乌兹别克斯坦", "梵蒂冈-梵蒂冈", "圣文森特和格林纳丁斯-圣文森特和格林纳丁斯", "委内瑞拉-委内瑞拉", "英属维尔京群岛-英属维尔京群岛", "美属维尔京群岛-美属维尔京群岛", "越南-越南", "瓦努阿图-瓦努阿图", "威克岛-威克岛", "瓦利斯和富图纳群岛-瓦利斯和富图纳群岛", "西萨摩亚-西萨摩亚", "无国籍（无国籍人）-无国籍（无国籍人）", "无国籍（难民）-无国籍（难民）", "无国籍（未声明国籍）-无国籍（未声明国籍）", "也门-也门", "南斯拉夫-南斯拉夫", "南非-南非", "扎伊尔-扎伊尔", "赞比亚-赞比亚", "津巴布韦-津巴布韦", "国籍不详-国籍不详"};
        //标题
        String[] handers = {"部门名称", "姓名", "手机号码", "身份证", "角色名称", "人员类别", "学历", "国籍", "身高", "职业证书", "证书号", "政治面貌", "婚姻状态", "血型", "保安员资格证号", "家庭住址", "现住地址"}; //列标题

        String[] example = {"范例1", "保安一部", "张三	", "15962368569	", "250216188512021234", "大队长", "普通保安员", "初中", "中国", "185", "初级保安员", "C0015253", "党员", "未婚", "A", "C123456", "福建省三明市尤溪县大田镇尖砂村25号", "福建省厦门市思明区莲前路23号"};

        String[] note = {"填写说明\r\n",
                " 下拉选择\r\n" + "*必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制\r\n" + " \r\n",
                " 直接填写\r\n" + "*必填字段\r\n" + "注：请留意不要输入空格，否则会导致后续人员身份验证不通过\r\n" + " \r\n",
                " 直接填写\r\n" + "*必填字段\r\n" + "注：如果从Word或其他文档拷贝粘贴到Excel，请注意格式”\r\n" + "\t \r\n	",
                " 直接填写\r\n" + "*必填字段\r\n" + "注：如果从Word或其他文档拷贝粘贴到Excel，请使用右键选择性粘贴“数值”\r\n",
                " 下拉选择\r\n" + "*必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制\r\n",
                " 下拉选择\r\n" + "*必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制\r\n",
                " 下拉选择\r\n" + "必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制\r\n",
                " 下拉选择\r\n" + "必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制\r\n",
                " 直接填写\r\n" + "非必填字段\r\n" + "注：只允许填写数字\r\n",
                " 下拉选择\r\n" + "非必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制 \r\n",
                " 直接填写\r\n" + "非必填字段 \r\n",
                " 下拉选择\r\n" + "非必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制 \r\n",
                " 下拉选择\r\n" + "非必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制 \r\n",
                " 下拉选择\r\n" + "非必填字段\r\n" + "注：按表中选项下拉选择，不可手动填写，否则会导致导入不成功；如需将某行已选择的信息向下复制，请留意同时按住ctrl键和“+”再向下复制 \r\n",
                " 直接填写\r\n" + "非必填字段 \r\n",
                " 直接填写\r\n" + "非必填字段 \r\n",
                " 直接填写\r\n" + "非必填字段 \r\n"};


        //下拉框数据
        List<String[]> downData = new ArrayList<String[]>();
        downData.add(orgArr);
        downData.add(roleArr);
        downData.add(personType);
        downData.add(edu);
        downData.add(nationality);
        downData.add(profession_level);
        downData.add(politics);
        downData.add(marriage);
        downData.add(blood);
//        downData.add(sex);

        //必填样式
        CellStyle style1 = ExcelUtil.getNecessaryTitleStyle(wb);
        //非必填样式
        CellStyle style2 = ExcelUtil.getCommonTitleStyle(wb);
        //填写范例说明样式
        CellStyle style3 = ExcelUtil.getExampleStyle(wb);

        //填写范例说明样式
        CellStyle style4 = ExcelUtil.getExample1Style(wb);

        //文本格式
        CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

        Integer[] downRows = {0, 4, 5, 6, 7, 9, 11, 12, 13}; //下拉的列序号数组(序号从0开始)
        //生成sheet1内容
        ExcelUtil.region(0, 0, 0, 0, 18, wb);
        HSSFRow row0 = sheet1.createRow(0);
        row0.setHeight((short) 500);
        ExcelUtil.setValueAt(style4, 0, 0, "填写范例说明（注：具体人员信息，请在右侧表格填写）\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n", wb, row0);

        HSSFRow row1 = sheet1.createRow(1);
        row1.setHeight((short) 500);
        ExcelUtil.region(0, 1, 2, 0, 0, wb);
        ExcelUtil.setValueAt(style3, 1, 0, "字段", wb, row1);

        ExcelUtil.region(0, 1, 1, 1, 8, wb);
        ExcelUtil.setValueAt(style3, 1, 1, "必填项", wb, row1);

        ExcelUtil.region(0, 1, 1, 9, 18, wb);
        ExcelUtil.setValueAt(style3, 1, 7, "非必填", wb, row1);

        HSSFRow row2 = sheet1.createRow(2);
        row2.setHeight((short) 500);
        HSSFRow row3 = sheet1.createRow(3);
        row3.setHeight((short) 700);
        HSSFRow row4 = sheet1.createRow(4);
        row4.setHeight((short) 3800);


        //生成sheet2内容
        HSSFRow rowFirst = sheet2.createRow(0);//第一个sheet的第一行为标题
        //写标题
        for (int i = 0; i < handers.length; i++) {
            HSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格

            HSSFCell cell2 = row2.createCell(i + 1); //获取第二行的每个单元格
            sheet2.setColumnWidth(i, 5000); //设置每列的列宽
            sheet2.setDefaultColumnStyle(i, stringStyle);//设置单元格格式 --文本格式

            sheet1.setColumnWidth(i, 5000); //设置每列的列宽
            sheet1.setDefaultColumnStyle(i, stringStyle);//设置单元格格式 --文本格式

            if (i <= 7) {
                cell.setCellStyle(style1);
                cell2.setCellStyle(style1);

            } else {
                cell.setCellStyle(style2);
                cell2.setCellStyle(style2);

            }
            cell.setCellValue(handers[i]); //往单元格里写数据
            cell2.setCellValue(handers[i]);

        }

        for (int i = 0; i < example.length; i++) {
            HSSFCell cell3 = row3.createCell(i); //获取第三行的每个单元格
            HSSFCell cell4 = row4.createCell(i); //获取第四行的每个单元格

            sheet1.setColumnWidth(i, 5000); //设置每列的列宽
            sheet1.setDefaultColumnStyle(i, stringStyle);//设置单元格格式 --文本格式

            cell3.setCellStyle(style3);
            cell4.setCellStyle(style3);
            cell3.setCellValue(example[i]);
            cell4.setCellValue(note[i]);
        }
        //设置下拉框数据
        String[] arr = {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J"};
        int index = 0;
        HSSFRow row = null;
        for (int r = 0; r < downRows.length; r++) {
            String[] dlData = downData.get(r);//获取下拉对象
            int rownum = downRows[r];
            //1、设置有效性
            String strFormula = "参考数据!$" + arr[index] + "$1:$" + arr[index] + "$" + dlData.length; //Sheet2第A1到A5000作为下拉列表来源数据
            sheet3.setColumnWidth(r, 5000); //设置每列的列宽
            //设置数据有效性加载在哪个单元格上,参数分别是：从sheet3获取A1到A5000作为一个下拉的数据、起始行、终止行、起始列、终止列
            sheet2.addValidationData(ExcelUtil.setDataValidation(strFormula, 1, 5000, rownum, rownum)); //下拉列表元素很多的情况
            //2、生成sheet3内容
            for (int j = 0; j < dlData.length; j++) {
                if (index == 0) { //第1个下拉选项，直接创建行、列
                    row = sheet3.createRow(j); //创建数据行
                    sheet3.setColumnWidth(j, 5000); //设置每列的列宽
                    row.createCell(0).setCellValue(dlData[j]); //设置对应单元格的值
                } else { //非第1个下拉选项
                    int rowCount = sheet3.getLastRowNum();
                    if (j <= rowCount) { //前面创建过的行，直接获取行，创建列
                        //获取行，创建列
                        sheet3.getRow(j).createCell(index).setCellValue(dlData[j]); //设置对应单元格的值
                    } else { //未创建过的行，直接创建行、创建列
                        sheet3.setColumnWidth(j, 5000); //设置每列的列宽
                        //创建行、创建列
                        sheet3.createRow(j).createCell(index).setCellValue(dlData[j]); //设置对应单元格的值
                    }
                }
            }
            index++;
        }
//		for(int i=1; i<5000; i++) {
//			if(sheet2.getRow(i) != null) {
//				Row rowR = sheet2.getRow(i);
//				Cell cellR1 = rowR.getCell(1);
//				cellR1.setCellStyle(stringStyle);
//				cellR1.setCellType(HSSFCell.CELL_TYPE_STRING);
//				Cell cellR2 = rowR.getCell(2);
//				cellR2.setCellStyle(stringStyle);
//				cellR2.setCellType(HSSFCell.CELL_TYPE_STRING);
//				Cell cellR3 = rowR.getCell(3);
//				cellR3.setCellStyle(stringStyle);
//				cellR3.setCellType(HSSFCell.CELL_TYPE_STRING);
//			}
//		}
        //输出模板
        FileOutputStream fileOut = new FileOutputStream(file);
        wb.write(fileOut);
        fileOut.close();
        wb.close();
    }

    @Override
    public List<ReportData> findAllAreaReport() {
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 1) {
            return null;
        }
        CompanySearchDto dto = new CompanySearchDto();

        String areacode = user.getPolice().getAreacode();
        dto.setComArea(areacode);
        if (areacode.endsWith("0000")) {//省
            dto.setAreaCode(areacode.substring(0, 2) + "____");
            dto.setOrgLevel("1");
        } else if (areacode.endsWith("00")) {//市
            dto.setAreaCode(areacode.substring(0, 4) + "__");
            dto.setOrgLevel("2");
        } else {//区
            dto.setOrgLevel("3");
        }

        dto.setPath(user.getPolice().getPath());
        dto.setUserid(user.getId());
        return securityCompanyDao.findAllAreaReport(dto);
    }

    @Override
    public Map<String, String[]> findAllScaleReport() {
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 1) {
            return null;
        }
        CompanySearchDto dto = new CompanySearchDto();
        dto.setPath(user.getPolice().getPath());
        dto.setUserid(user.getId());
        List<ReportData> list = securityCompanyDao.findAllScaleReport(dto);
        Map<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ReportData rd = list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    @Override
    public Map<String, String[]> findAllTaskLevelReport() {
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 1) {
            return null;
        }
        CompanySearchDto dto = new CompanySearchDto();
        dto.setPath(user.getPolice().getPath());
        dto.setUserid(user.getId());
        List<ReportData> list = securityCompanyDao.findAllTaskLevelReport(dto);
        Map<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ReportData rd = list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    @Override
    public List<ReportData> findProfessionLevelReport(Long id) {
        User user = arsUtil.getCurrentUser();
        return securityCompanyDao.findProfessionLevelReport(id);
    }

    @Override
    public Map<String, String[]> findNativeReport(Long id) {
        User user = arsUtil.getCurrentUser();
        List<ReportData> list = securityCompanyDao.findNativeReport(id);
        Map<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ReportData rd = list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    @Override
    public Map<String, String[]> findTaskCatalogReport(Long id) {
        User user = arsUtil.getCurrentUser();
        List<ReportData> list = securityCompanyDao.findTaskCatalogReport(id);
        Map<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ReportData rd = list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    @Override
    public List<ReportData> findTaskLevelReport(Long id) {
        User user = arsUtil.getCurrentUser();
        SecurityCompany company = null;
        CompanySearchDto companySearchDto = new CompanySearchDto();
        if (user.getPlatform().equals(2)) {
            company = securityCompanyDao.findByUserid(user.getId());
        }
        //区域
        if (user == null || user.getPlatform().intValue() == 1) {
            if (company == null) {
                companySearchDto.setPath(user.getPolice().getPath());
                companySearchDto.setUserid(user.getId());
                companySearchDto.setCompanyId(id);
            }
        }
        return securityCompanyDao.findTaskLevelReportByCompany(companySearchDto);
    }


    @Override
    public List<ReportData> findSecurityPersonReport(Long id) {
        User user = arsUtil.getCurrentUser();
        CompanySearchDto dto = new CompanySearchDto();
        if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        dto.setCompanyId(id);
        return securityCompanyDao.findSecurityPersonReport(dto);
    }

    @Override
    public List<ReportData> findSecurityPersonStudyReport(Long id) {
        User user = arsUtil.getCurrentUser();
        if (user == null) {
            return null;
        }
        return securityCompanyDao.findSecurityPersonStudyReport(id);
    }

    @Override
    public Long getSecurityTotalCount(Long id) {
        User user = arsUtil.getCurrentUser();
        return securityCompanyDao.getSecurityTotalCount(id);
    }

    @Override
    public AjaxResult checkCompanyPolicy() {
        AjaxResult result = new AjaxResult();
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 2) {
            result.setSuccessful(false);
            result.setMsg("登录异常");
        } else {
            /*Map<String,Object> map = new HashMap<String,Object>();
            map.put("userid",user.getId()+"");
			map.put("webType", Constants.POLICY_WEBTYPE);
			map.put("token", Sha1Util.entryptPassword(Constants.POLICY_WEBTYPE+user.getId()));//生成密钥 当密钥相同的时候才进行插入数据
			//保存分销商
			String url = ThirdPartyURL.FENXIAO + ThirdPartyURL.CHECK_COMPANY_POLICY;
			try {
				String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map,"ARS"));
				String status = messageUtils.getStringValueByKey(resultStr, "status");
				if(StringUtil.isNotEmpty(status)&&"200".equals(status)){
					result.setSuccessful(true);
				}else{
					result.setSuccessful(false);
				}
			} catch (Exception e) {
				result.setSuccessful(false);
				result.setMsg(e.toString());
				e.printStackTrace();
			}*/

            SecurityCompany company = securityCompanyDao.findByUserid(user.getId());
            if (StringUtil.isNotEmpty(company.getOrderNo())) {
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
            }
        }
        return result;
    }

    @Override
    public List<ReportData> getStudyListDesc(Long id) {
        return securityCompanyDao.getStudyListDesc(id);
    }

    @Override
    public Long findNoPowerCount(Long id) {
        return securityCompanyDao.findNoPowerCount(id);
    }

    @Override
    public PersonStudySearchDTO personStudySearch(PersonStudySearchDTO dto) {
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 1) {
            return null;
        }

        List<PersonStudyDTO> data = securityCompanyDao.findPersonStudyList(dto);
        int rate = 0;
        for (PersonStudyDTO personStudyDTO : data) {
            rate = 0;
            for (PersonStudyDTO personStudy : data) {
                if (personStudyDTO.getPersonid() != personStudy.getPersonid()) {
                    if (personStudyDTO.getStudyprogress() > personStudy.getStudyprogress()) {
                        rate++;
                    }
                }
            }
            personStudyDTO.setRate(rate == 0 ? "0" : (rate * 100 / data.size()) + "");
        }
        Long count = securityCompanyDao.searchPersonStudyCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public void resetPwd(Long companyid) {
        User currentUser = arsUtil.getCurrentUser();
        SecurityCompany company = securityCompanyDao.findById(companyid);
        User user = company.getUser();
        user.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
        user.setUpdateTime(new Date());
        user.setUpdateBy(currentUser.getUsername());
        userDaoAop.updatePassword(user);
        company.setUpdateTime(new Date());
        securityCompanyDaoAop.update(company);
    }

    @Override
    public void deleteCompany(Long companyid) {
        User currentUser = arsUtil.getCurrentUser();
        SecurityCompany company = securityCompanyDao.findById(companyid);
        User user = company.getUser();
        /*if (user.getInit()) {
            throw new ArsException("该公司已在使用，不允许删除！");
        } else {*/
            company.setUpdateTime(new Date());
            company.setUpdateBy(currentUser.getUsername());
        //    company.setUpdateflag(true);
            securityCompanyDaoAop.delete(company);

            user.setUpdateTime(new Date());
            user.setUpdateBy(currentUser.getUsername());
          //  user.setUpdateflag(true);
            userDaoAop.delete(user);
     //   }
    }

    @Override
    public void revokeCompany(Long companyid) {
        User currentUser = arsUtil.getCurrentUser();

        ComStateChangeLog changeLog = new ComStateChangeLog();

        SecurityCompany company = securityCompanyDao.findById(companyid);

        changeLog.setComId(company.getId());
        changeLog.setComName(company.getName());
        changeLog.setOldState(company.getCompanyState());

        company.setUpdateTime(new Date());
        company.setUpdateBy(currentUser.getUsername());
        company.setCompanyState(Constants.COMPANY_STATE_4);
        securityCompanyDaoAop.revoke(company);

        changeLog.setUserId(currentUser.getId());
        changeLog.setNewState(Constants.COMPANY_STATE_4);
        changeLog.setUpdateflag(true);
        changeLog.setId(idGeneratorUtil.createID());
        changeLog.setActive(true);
        changeLog.setCreateTime(new Date());
        changeLog.setUpdateTime(new Date());
        changeLog.setUpdateBy(currentUser.getRealname());

        comStateChangeLogDao.save(changeLog);
    }

    /***
     * 根据规则生成帐号信息，如果没有填写登陆用户名，则根据规则：省区划号码+各市行政区划+保安类型企业编号01+四位号
     * @param company
     * @return
     */
    public String getNewUsername(SecurityCompany company){
        String username ="";
        //判断是否有填写登陆用户名
        if(StringUtil.isNotEmpty(company.getUsername())){
            username  = company.getUsername();
        }else{
            if(null!=company&& StringUtil.isNotEmpty(company.getAreaCode())){
                //设置默认机构类型
                if(StringUtil.isEmpty(company.getInstitutionType())){
                    company.setInstitutionType(Constants.BKT_ORGTYPE_GS);
                }
                String regexp = company.getAreaCode().substring(0,4)+company.getInstitutionType()+"01";
                //返回流水号
                Long serialNum = userDao.findByUsernameRegexp(regexp);
                if(null == serialNum || serialNum ==0L){
                    username =regexp+"0001";
                }else{
                    username =regexp+String.format("%4s", serialNum+1).replaceAll(" ", "0");
                }
            }
        }

        return username;
    }

    @Override
    public void updateCompany(SecurityCompany company) {

        //TODO #4123保安公司账号组成按保安公司所属区域的省份编码+字符串（数字or字母组合，不可特殊字符）。如：陕西省的保安公司，账号组成：sn20170713。
        //先写死陕西，后期再改为可配置的 publicSecurityLicenseNumber
        //String username = configService.findByKey(Constants.COMPANY_ACCOUNT_ROLE).getValue() + company.getPublicSecurityLicenseNumber();

         String username =getNewUsername(company);

        if (company.getId() == null) {
            company.setInit(false);
            company.setCompanyState(Constants.COMPANY_STATE_0);
            SecurityCompany dbCompany = securityCompanyDao.findByName(company.getName());
            if (dbCompany != null) {
                throw new ArsException("公司名称已存在！");
            }

            User existUser = userDao.findByUsername(username,String.valueOf(Constants.PLATFORM_COMPANY));
            if (existUser != null) {
                throw new ArsException("用户名已存在!");
            }
            User user = company.getUser();
            user.setUsername(username);
            user.setPhone(company.getUser().getPhone());
            user.setRealname(company.getName());
            user.setPhoto(company.getUser().getPhoto());
            user.setPlatform(Constants.PLATFORM_COMPANY);
            //如果数据库为空，则新增 edit 2018-06-01 subh start
            User dbUser = userDao.findById(user.getId());
            if (dbUser == null) {
                //如果数据库为空，则新增 edit 2018-06-01 subh end
                if (!StringUtil.isNotEmpty(user.getPassword())) {
                    user.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
                }
                user.setNativeCode(arsUtil.getCurrentNatvie());
                user.setInit(false);
                user.setActive(true);
                user.setCreateTime(new Date());
                user.setUpdateTime(user.getCreateTime());
                user.setUpdateflag(true);
                if (arsUtil.getCurrentUser() != null) {
                    user.setUpdateBy(arsUtil.getCurrentUser().getUsername());
                }
                user.setId(idGeneratorUtil.createID());
                userDao.save(user);
                company.setUser(user);

            } else {
                dbUser.setUpdateTime(new Date());
                dbUser.setUpdateBy(arsUtil.getCurrentUser().getUsername());
                if (dbUser != null) {
                    if (user.getActive() != null && user.getActive()) {
                        dbUser.setActive(true);
                    }
                    if (user.getInit() != null && user.getInit()) {
                        dbUser.setInit(true);
                    }
                    if (!StringUtils.isEmpty(user.getRealname())) {
                        dbUser.setRealname(user.getRealname());
                    }
                    if (!StringUtils.isEmpty(user.getPhone())) {
                        dbUser.setPhone(user.getPhone());
                    }
                    if (!StringUtils.isEmpty(user.getPhoto())) {
                        dbUser.setPhoto(user.getPhoto());
                    }
                    dbUser.setUpdateflag(true);
                    userDaoAop.update(dbUser);
                    company.setUser(dbUser);
                }
            }
        } else {


            SecurityCompany dbCompany = securityCompanyDao.findByName(company.getName());
            if (dbCompany != null && dbCompany.getId().intValue() != company.getId().intValue()) {
                throw new ArsException("公司名称已存在！");
            }

            User existUser = userDao.findByUsername(username,String.valueOf(Constants.PLATFORM_COMPANY));
            if (existUser != null && dbCompany != null && dbCompany.getUser().getId().intValue() != existUser.getId().intValue()) {
                throw new ArsException("【"+username+"】登陆用户名已存在!");
            }
            if (dbCompany == null) {
                dbCompany = securityCompanyDao.findById(company.getId());
            }
            //头像
            dbCompany.getUser().setPhoto(company.getUser().getPhoto());
            //手机号码
            dbCompany.getUser().setPhone(company.getUser().getPhone());
            //公司名称
            dbCompany.getUser().setRealname(company.getName());
            //用户名
            dbCompany.getUser().setUsername(company.getUsername());
            dbCompany.getUser().setUpdateflag(true);
            userService.saveOrUpdateCompanyUser(dbCompany.getUser(),String.valueOf(Constants.PLATFORM_COMPANY));
            company.setUser(dbCompany.getUser());
            //  如果公司修改了区域代码，需要同步修改人员的区域代码
            if (dbCompany.getAreaCode() != null && !dbCompany.getAreaCode().equalsIgnoreCase(company.getAreaCode())) {
                personDao.updateAreaCodeByCompany(company);  // 修改人员的区域代码
            }

        }

        saveOrUpdate(company);
    }

    @Override
    public void updateCompanyAccout(SecurityCompany company) {

        //TODO #4123保安公司账号组成按保安公司所属区域的省份编码+字符串（数字or字母组合，不可特殊字符）。如：陕西省的保安公司，账号组成：sn20170713。
        //先写死陕西，后期再改为可配置的 publicSecurityLicenseNumber
        //String username = configService.findByKey(Constants.COMPANY_ACCOUNT_ROLE).getValue() + company.getPublicSecurityLicenseNumber();

        String username =getNewUsername(company);

        User user = company.getUser();


        user.setUsername(username);
        user.setPhone(company.getUser().getPhone() == null ? "" : company.getUser().getPhone());
        user.setRealname(company.getName());
        user.setPhoto(company.getUser().getPhoto());
        user.setPlatform(2);

        if (StringUtils.isEmpty(user.getPhoto())) {
            if (user.getPlatform().intValue() == 1) {
                user.setPhoto("assets/images/defaultHead/police.png");
            }
        }

        if (user.getId() == null) {
            if (!StringUtil.isNotEmpty(user.getPassword())) {
                user.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
            }
            user.setNativeCode(arsUtil.getCurrentNatvie());
            user.setInit(false);
            user.setActive(true);
            user.setCreateTime(new Date());
            user.setUpdateTime(user.getCreateTime());
            if (arsUtil.getCurrentUser() != null) {
                user.setUpdateBy(arsUtil.getCurrentUser().getUsername());
            }
            userDao.save(user);
            company.setUser(user);
        } else {
            User dbUser = userDao.findById(user.getId());
            dbUser.setUpdateTime(new Date());
            dbUser.setUpdateBy(arsUtil.getCurrentUser().getUsername());
            if (dbUser != null) {
                if (user.getActive() != null && user.getActive()) {
                    dbUser.setActive(true);
                }
                if (user.getInit() != null && user.getInit()) {
                    dbUser.setInit(true);
                }
                if (!StringUtils.isEmpty(user.getRealname())) {
                    dbUser.setRealname(user.getRealname());
                }
                if (!StringUtils.isEmpty(user.getPhone())) {
                    dbUser.setPhone(user.getPhone());
                }
                if (!StringUtils.isEmpty(user.getPhoto())) {
                    dbUser.setPhoto(user.getPhoto());
                }
                userDaoAop.update(dbUser);
                company.setUser(dbUser);
            }
        }


        new Thread(() -> {
            //推送信息给分销平台保存 --liumd --start
            UserVo u = new UserVo();
            u.setOid(user.getId().toString());
            u.setcName(company.getName());
            u.setOwnedIndustry("20");
            u.setNatureManagement("3");
            if (company.getSecurityAmount() != null) {
                u.setcNum(company.getSecurityAmount().toString());
            } else {
                u.setcNum("0");
            }
            u.setBusinessAddress(company.getLocation());
            u.setBusinessAddressImg(company.getBusinessLicense());
            u.setIdType("02");
            u.setIdCard(company.getSocialCode());
            u.setTelephone(company.getCentralOfficeTel());
            //固定字段
            u.setTerminalType("1");
            u.setCompanyType("3");//1：供应商，2：分销商，3：企业（终端）
            u.setRoleName("COMMON-ONE-HEAD");//设置角色权限
            Map<String, Object> companyMap = new HashMap<String, Object>();
            companyMap.put("companyVo", u);
            companyMap.put("token", Sha1Util.entryptPassword("ARS" + company.getUser().getId()));
            // 保存分销商
            String companyUrl = ThirdPartyURL.BAILIANBAO + "/api/user/saveCompany";
            String companyData = messageUtils.packageMap(companyMap, "ARS");
            try {
                messageUtils.doPost2(companyUrl, companyData);
            } catch (Exception e) {
                e.printStackTrace();
            }
            //推送信息给分销平台保存 --liumd --end
        }).start();
    }

    @Override
    public CompanySearchDto searchForManager(CompanySearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 1) {
            return null;
        }
        if (user == null || user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        String areacode = dto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                dto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                dto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                dto.setAreaCode(areacode);
            }
        }
        CompanySearchDto resultDto = new CompanySearchDto();
        List<SecurityCompany> list = securityCompanyDao.searchForManager(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(securityCompanyDao.searchForManagerCount(dto));
        return resultDto;
    }

    @Override
    public PageResult searchForManagerList_table(Map<Object, Object> p) {
        User currentUser = arsUtil.getCurrentUser();

        if (currentUser == null || currentUser.getPlatform().intValue() != 1) {
            return null;
        }
        if (currentUser == null || currentUser.getPlatform().intValue() == 1) {
            p.put("path", currentUser.getPolice().getPath());
            p.put("userid", currentUser.getId());
        }
        /*Police police = currentUser.getPolice();
        if (police != null) {
            String areacode=police.getAreacode();
            //机构类型--分公司
            p.put("institutionType","0105");
            if (areacode.startsWith("45")){
                //广西
                p.put("province","1");
            }else if (areacode.startsWith("61")){
                // 陕西
                p.put("province","2");
            }else if (areacode.startsWith("64")){
                // 宁夏
                p.put("province","3");
            }
        }*/
        if (p.get("areaCode") != null) {
            String areacode = p.get("areaCode").toString();
            if (StringUtil.isNotEmpty(areacode)) {
                if (areacode.endsWith("0000")) {//省
                    p.put("district", areacode.substring(0, 2) + "____");
                } else if (areacode.endsWith("00")) {//市
                    p.put("district", areacode.substring(0, 4) + "__");
                } else {//区
                    p.put("district", areacode);
                }

            }
        }

        return new PageResult(securityCompanyDao.countSearchForManagerList_table(p), securityCompanyDao.searchForManagerList_table(p));
    }

    @Override
    public void exportCompanys(List<SecurityCompany> companys, File file) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("保安公司信息");
//			wb.setSheetHidden(1, true);
            //标题
            String[] handers = {"公司名称", "营业执照号", "法人", "法人手机号", "所属省市区", "公司地址", "公司类型", "注册资金"}; //列标题
            //生成sheet1内容
            HSSFRow rowFirst = sheet1.createRow(0);//第一个sheet的第一行为标题
            //样式
            CellStyle style = ExcelUtil.getCommonTitleStyle(wb);
            //写标题

            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); //设置每列的列宽
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]); //往单元格里写数据
            }
            int index = 1;
            HSSFRow row = null;
            for (SecurityCompany company : companys) {
                row = sheet1.createRow(index++);
                HSSFCell nameCell = row.createCell(0);
                nameCell.setCellStyle(style);
                nameCell.setCellValue(company.getName()); //往单元格里写数据

                HSSFCell socialCodeCell = row.createCell(1);
                socialCodeCell.setCellStyle(style);
                socialCodeCell.setCellValue(company.getSocialCode());

                HSSFCell legalPersonCell = row.createCell(2);
                legalPersonCell.setCellStyle(style);
                legalPersonCell.setCellValue(company.getLegalPerson()); //往单元格里写数据

                HSSFCell phoneCell = row.createCell(3);
                phoneCell.setCellStyle(style);
                phoneCell.setCellValue(company.getUser().getPhone()); //往单元格里写数据


                HSSFCell addressCell = row.createCell(4);
                addressCell.setCellStyle(style);
                addressCell.setCellValue(company.getProvince() + company.getCity() + company.getArea()); //往单元格里写数据

                HSSFCell locationCell = row.createCell(5);
                locationCell.setCellStyle(style);
                locationCell.setCellValue(company.getLocation()); //往单元格里写数据

                HSSFCell companyTypeCell = row.createCell(6);
                companyTypeCell.setCellStyle(style);
                if (!StringUtils.isEmpty(company.getCompanyType())) {
                    companyTypeCell.setCellValue(company.getCompanyType().equals("1") ? "合作企业" : "民营企业"); //往单元格里写数据
                }

                HSSFCell registeredMoneyCell = row.createCell(7);
                registeredMoneyCell.setCellStyle(style);
                if (!StringUtils.isEmpty(company.getRegisteredMoney())) {
                    registeredMoneyCell.setCellValue(company.getRegisteredMoney() + "万元"); //往单元格里写数据
                }

            }
            //输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportCompanysData(List<SecurityCompany> companys, File file) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("保安公司信息");
//			wb.setSheetHidden(1, true);
            //标题
            String[] handers = {"id", "native_code", "user_id", "update_time", "update_by", "active", "name", "legal_person",
                    "social_code", "central_office_name", "central_office_legal_person", "central_office_tel", "tel", "security_amount", "task_amount", "province",
                    "city", "area", "areacode", "location", "insurance_number", "emergency_agreement", "business_license", "public_security_license",
                    "init", "longitude", "latitude", "orderNo", "business_license_number", "principal", "principal_phone", "principal_id",
                    "registered_money", "fixed_assets", "turnover_year", "annual_profits", "public_security_license_number", "national", "economic_type", "company_type",
                    "human_defense_level", "risk_assessment_level", "security_association", "economic_type_legal_person", "is_subsidiary", "armed_escort_level", "security_technology_level", "rawid", "inrawid"}; //列标题
            //生成sheet1内容
            HSSFRow rowFirst = sheet1.createRow(0);//第一个sheet的第一行为标题
            //样式
            CellStyle style = ExcelUtil.getCommonTitleStyle(wb);
            //写标题

            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); //设置每列的列宽
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]); //往单元格里写数据
            }
            int index = 1;
            HSSFRow row = null;
            for (SecurityCompany company : companys) {
                row = sheet1.createRow(index++);
                HSSFCell idCell = row.createCell(0);
                idCell.setCellStyle(style);
                idCell.setCellValue(company.getId()); //往单元格里写数据

                HSSFCell native_codeCell = row.createCell(1);
                native_codeCell.setCellStyle(style);
                if (company.getNativeCode() != null) {
                    native_codeCell.setCellValue(company.getNativeCode()); //往单元格里写数据
                }

                HSSFCell user_idCell = row.createCell(2);
                user_idCell.setCellStyle(style);
                if (company.getUser().getId() != null) {
                    user_idCell.setCellValue(company.getUser().getId()); //往单元格里写数据
                }

                HSSFCell update_timeCell = row.createCell(3);
                update_timeCell.setCellStyle(style);
                if (company.getUpdateTime() != null) {
                    update_timeCell.setCellValue(DateUtil.convertDateToString(company.getCreateTime(), "yyyy-MM-dd HH:mm:ss")); //往单元格里写数据
                }

                HSSFCell update_byCell = row.createCell(4);
                update_byCell.setCellStyle(style);
                if (company.getUpdateBy() != null) {
                    update_byCell.setCellValue(company.getUpdateBy()); //往单元格里写数据
                }


                HSSFCell activeCell = row.createCell(5);
                activeCell.setCellStyle(style);
                if (company.getActive() != null) {
                    activeCell.setCellValue(company.getActive()); //往单元格里写数据
                }


                HSSFCell nameCell = row.createCell(6);
                nameCell.setCellStyle(style);
                if (company.getName() != null) {
                    nameCell.setCellValue(company.getName()); //往单元格里写数据
                }


                HSSFCell legal_personCell = row.createCell(7);
                legal_personCell.setCellStyle(style);
                if (company.getLegalPerson() != null) {
                    legal_personCell.setCellValue(company.getLegalPerson()); //往单元格里写数据
                }


                HSSFCell social_codeCell = row.createCell(8);
                social_codeCell.setCellStyle(style);
                if (company.getSocialCode() != null) {
                    social_codeCell.setCellValue(company.getSocialCode()); //往单元格里写数据
                }


                HSSFCell central_office_nameCell = row.createCell(9);
                central_office_nameCell.setCellStyle(style);
                if (company.getCentralOfficeName() != null) {
                    central_office_nameCell.setCellValue(company.getCentralOfficeName()); //往单元格里写数据
                }


                HSSFCell central_office_legal_personCell = row.createCell(10);
                central_office_legal_personCell.setCellStyle(style);
                if (company.getCentralOfficeLegalPerson() != null) {
                    central_office_legal_personCell.setCellValue(company.getCentralOfficeLegalPerson()); //往单元格里写数据
                }


                HSSFCell central_office_telCell = row.createCell(11);
                central_office_telCell.setCellStyle(style);
                if (company.getCentralOfficeTel() != null) {
                    central_office_telCell.setCellValue(company.getCentralOfficeTel()); //往单元格里写数据
                }


                HSSFCell telCell = row.createCell(12);
                telCell.setCellStyle(style);
                if (company.getTel() != null) {
                    telCell.setCellValue(company.getTel()); //往单元格里写数据
                }


                HSSFCell security_amountCell = row.createCell(13);
                security_amountCell.setCellStyle(style);
                if (company.getSecurityAmount() != null) {
                    security_amountCell.setCellValue(company.getSecurityAmount()); //往单元格里写数据
                }


                HSSFCell task_amountCell = row.createCell(14);
                task_amountCell.setCellStyle(style);
                if (company.getTaskAmount() != null) {
                    task_amountCell.setCellValue(company.getTaskAmount()); //往单元格里写数据

                }

                HSSFCell provinceCell = row.createCell(15);
                provinceCell.setCellStyle(style);
                if (company.getProvince() != null) {
                    provinceCell.setCellValue(company.getProvince()); //往单元格里写数据
                }


                HSSFCell cityCell = row.createCell(16);
                cityCell.setCellStyle(style);
                if (company.getCity() != null) {
                    cityCell.setCellValue(company.getCity()); //往单元格里写数据
                }


                HSSFCell areaCell = row.createCell(17);
                areaCell.setCellStyle(style);
                if (company.getArea() != null) {
                    areaCell.setCellValue(company.getArea()); //往单元格里写数据
                }


                HSSFCell areacodeCell = row.createCell(18);
                areacodeCell.setCellStyle(style);
                if (company.getAreaCode() != null) {
                    areacodeCell.setCellValue(company.getAreaCode()); //往单元格里写数据
                }


                HSSFCell locationCell = row.createCell(19);
                locationCell.setCellStyle(style);
                if (company.getLocation() != null) {
                    locationCell.setCellValue(company.getLocation()); //往单元格里写数据
                }


                HSSFCell insurance_numberCell = row.createCell(20);
                insurance_numberCell.setCellStyle(style);
                if (company.getInsuranceNumber() != null) {
                    insurance_numberCell.setCellValue(company.getInsuranceNumber()); //往单元格里写数据
                }


                HSSFCell emergency_agreementCell = row.createCell(21);
                emergency_agreementCell.setCellStyle(style);
                if (company.getEmergencyAgreement() != null) {
                    emergency_agreementCell.setCellValue(company.getEmergencyAgreement()); //往单元格里写数据
                }


                HSSFCell business_licenseCell = row.createCell(22);
                business_licenseCell.setCellStyle(style);
                if (company.getBusinessLicense() != null) {
                    business_licenseCell.setCellValue(company.getBusinessLicense()); //往单元格里写数据

                }

                HSSFCell public_security_licenseCell = row.createCell(23);
                public_security_licenseCell.setCellStyle(style);
                if (company.getPublicSecurityLicense() != null) {
                    public_security_licenseCell.setCellValue(company.getPublicSecurityLicense()); //往单元格里写数据

                }


                HSSFCell initCell = row.createCell(24);
                initCell.setCellStyle(style);
                if (company.getInit() != null) {
                    initCell.setCellValue(company.getInit()); //往单元格里写数据

                }


                HSSFCell longitudeCell = row.createCell(25);
                longitudeCell.setCellStyle(style);
                if (company.getLongitude() != null) {
                    longitudeCell.setCellValue(company.getLongitude()); //往单元格里写数据

                }


                HSSFCell latitudeCell = row.createCell(26);
                latitudeCell.setCellStyle(style);
                if (company.getLatitude() != null) {
                    latitudeCell.setCellValue(company.getLatitude()); //往单元格里写数据

                }


                HSSFCell orderNoCell = row.createCell(27);
                orderNoCell.setCellStyle(style);
                if (company.getOrderNo() != null) {
                    orderNoCell.setCellValue(company.getOrderNo()); //往单元格里写数据

                }


                HSSFCell business_license_numberCell = row.createCell(28);
                business_license_numberCell.setCellStyle(style);
                if (company.getBusinessLicensNnumber() != null) {
                    business_license_numberCell.setCellValue(company.getBusinessLicensNnumber()); //往单元格里写数据

                }


                HSSFCell principalCell = row.createCell(29);
                principalCell.setCellStyle(style);
                if (company.getPrincipal() != null) {
                    principalCell.setCellValue(company.getPrincipal()); //往单元格里写数据

                }


                HSSFCell principal_phoneCell = row.createCell(30);
                principal_phoneCell.setCellStyle(style);
                if (company.getPrincipalPhone() != null) {
                    principal_phoneCell.setCellValue(company.getPrincipalPhone()); //往单元格里写数据

                }


                HSSFCell principal_idCell = row.createCell(31);
                principal_idCell.setCellStyle(style);
                if (company.getPrincipalId() != null) {
                    principal_idCell.setCellValue(company.getPrincipalId()); //往单元格里写数据

                }


                HSSFCell registered_moneyCell = row.createCell(32);
                registered_moneyCell.setCellStyle(style);
                if (company.getRegisteredMoney() != null) {
                    registered_moneyCell.setCellValue(company.getRegisteredMoney().doubleValue()); //往单元格里写数据

                }


                HSSFCell fixed_assetsCell = row.createCell(33);
                fixed_assetsCell.setCellStyle(style);
                if (company.getFixedAssets() != null) {
                    fixed_assetsCell.setCellValue(company.getFixedAssets().doubleValue()); //往单元格里写数据

                }


                HSSFCell turnover_yearCell = row.createCell(34);
                turnover_yearCell.setCellStyle(style);
                if (company.getTurnoverYear() != null) {
                    turnover_yearCell.setCellValue(company.getTurnoverYear().doubleValue()); //往单元格里写数据

                }


                HSSFCell annual_profitsCell = row.createCell(35);
                annual_profitsCell.setCellStyle(style);
                if (company.getAnnualProfits() != null) {
                    annual_profitsCell.setCellValue(company.getAnnualProfits().doubleValue()); //往单元格里写数据

                }


                HSSFCell public_security_license_numberCell = row.createCell(36);
                public_security_license_numberCell.setCellStyle(style);
                if (company.getPublicSecurityLicenseNumber() != null) {
                    public_security_license_numberCell.setCellValue(company.getPublicSecurityLicenseNumber()); //往单元格里写数据

                }


                HSSFCell nationalCell = row.createCell(37);
                nationalCell.setCellStyle(style);
                if (company.getNational() != null) {
                    nationalCell.setCellValue(company.getNational()); //往单元格里写数据

                }


                HSSFCell economic_typeCell = row.createCell(38);
                economic_typeCell.setCellStyle(style);
                if (company.getPrincipal() != null) {
                    principalCell.setCellValue(company.getPrincipal()); //往单元格里写数据

                }


                HSSFCell company_typeCell = row.createCell(39);
                company_typeCell.setCellStyle(style);
                if (company.getCompanyType() != null) {
                    company_typeCell.setCellValue(company.getCompanyType()); //往单元格里写数据

                }


                HSSFCell human_defense_levelCell = row.createCell(40);
                human_defense_levelCell.setCellStyle(style);
                if (company.getHumanDefenseLevel() != null) {
                    human_defense_levelCell.setCellValue(company.getHumanDefenseLevel()); //往单元格里写数据

                }


                HSSFCell risk_assessment_levelCell = row.createCell(41);
                risk_assessment_levelCell.setCellStyle(style);
                if (company.getRiskAssessmentLevel() != null) {
                    risk_assessment_levelCell.setCellValue(company.getRiskAssessmentLevel()); //往单元格里写数据

                }


                HSSFCell security_associationCell = row.createCell(42);
                security_associationCell.setCellStyle(style);
                if (company.getSecurityAssociation() != null) {
                    security_associationCell.setCellValue(company.getSecurityAssociation()); //往单元格里写数据

                }


                HSSFCell economic_type_legal_personCell = row.createCell(43);
                economic_type_legal_personCell.setCellStyle(style);
                if (company.getEconomicTypeLegalPerson() != null) {
                    economic_type_legal_personCell.setCellValue(company.getEconomicTypeLegalPerson()); //往单元格里写数据

                }


                HSSFCell is_subsidiaryCell = row.createCell(44);
                is_subsidiaryCell.setCellStyle(style);
                if (company.getIsSubsidiary() != null) {
                    is_subsidiaryCell.setCellValue(company.getIsSubsidiary()); //往单元格里写数据

                }


                HSSFCell armed_escort_levelCell = row.createCell(45);
                armed_escort_levelCell.setCellStyle(style);
                if (company.getArmedEscortLevel() != null) {
                    armed_escort_levelCell.setCellValue(company.getArmedEscortLevel()); //往单元格里写数据

                }


                HSSFCell security_technology_levelCell = row.createCell(46);
                security_technology_levelCell.setCellStyle(style);
                if (company.getSecurityTechnologyLevel() != null) {
                    security_technology_levelCell.setCellValue(company.getSecurityTechnologyLevel()); //往单元格里写数据

                }


                HSSFCell rawidCell = row.createCell(47);
                rawidCell.setCellStyle(style);
                if (company.getRawid() != null) {
                    rawidCell.setCellValue(company.getRawid()); //往单元格里写数据
                }


                HSSFCell inrawidCell = row.createCell(48);
                inrawidCell.setCellStyle(style);
                if (company.getInrawid() != null) {
                    inrawidCell.setCellValue(company.getInrawid()); //往单元格里写数据

                }


            }
            //输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void buildCompanyTemplate(File file) throws Exception {

        User currentUser = arsUtil.getCurrentUser();
        if (currentUser != null) {

            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("保安公司信息");
            HSSFSheet sheet2 = wb.createSheet("参考数据");
            wb.setSheetHidden(1, true);

            SysareaSearchDTO searchDto = new SysareaSearchDTO();
            searchDto.setPaging(false);
            List<TreeView> nativeList = sysareaService.searchForCompany(searchDto);
            List<TreeView> trees = new ArrayList<TreeView>();
            for (TreeView treeView : nativeList) {
                int level = 0;
                getNativeChildren(trees, treeView, level);
            }

            String[] nativeArr = new String[trees.size()];
            for (int i = 0; i < trees.size(); i++) {
                nativeArr[i] = trees.get(i).getText() + "-" + trees.get(i).getCode();
            }

            //标题
            String[] handers = {"公司名称", "营业执照号码", "法人姓名", "法人手机号", "所属区域（省市区）", "公司地址", "保安服务许可证号", "注册资金（万元）"}; //列标题
            //下拉框数据
            List<String[]> downData = new ArrayList<String[]>();
            downData.add(nativeArr);
            Integer[] downRows = {4}; //下拉的列序号数组(序号从0开始)
            //生成sheet1内容
            HSSFRow rowFirst = sheet1.createRow(0);//第一个sheet的第一行为标题
            //必填样式
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle(wb);
            //非必填样式
            CellStyle style2 = ExcelUtil.getCommonTitleStyle(wb);

            //文本格式
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            //写标题
            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); //设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle);//设置单元格格式 --文本格式
                if (i <= 4) {
                    cell.setCellStyle(style1);
                } else {
                    cell.setCellStyle(style2);
                }
                cell.setCellValue(handers[i]); //往单元格里写数据
            }
            //设置下拉框数据
            String[] arr = {"A", "B", "C", "D", "E", "F", "G"};
            int index = 0;
            HSSFRow row = null;
            for (int r = 0; r < downRows.length; r++) {
                String[] dlData = downData.get(r);//获取下拉对象
                int rownum = downRows[r];
                //1、设置有效性
                String strFormula = "参考数据!$" + arr[index] + "$1:$" + arr[index] + "$" + dlData.length; //Sheet2第A1到A5000作为下拉列表来源数据
                sheet2.setColumnWidth(r, 5000); //设置每列的列宽
                //设置数据有效性加载在哪个单元格上,参数分别是：从sheet2获取A1到A5000作为一个下拉的数据、起始行、终止行、起始列、终止列
                sheet1.addValidationData(ExcelUtil.setDataValidation(strFormula, 1, 5000, rownum, rownum)); //下拉列表元素很多的情况
                //2、生成sheet2内容
                for (int j = 0; j < dlData.length; j++) {
                    if (index == 0) { //第1个下拉选项，直接创建行、列
                        row = sheet2.createRow(j); //创建数据行
                        sheet2.setColumnWidth(j, 5000); //设置每列的列宽
                        row.createCell(0).setCellValue(dlData[j]); //设置对应单元格的值
                    } else { //非第1个下拉选项
                        int rowCount = sheet2.getLastRowNum();
                        if (j <= rowCount) { //前面创建过的行，直接获取行，创建列
                            //获取行，创建列
                            sheet2.getRow(j).createCell(index).setCellValue(dlData[j]); //设置对应单元格的值
                        } else { //未创建过的行，直接创建行、创建列
                            sheet2.setColumnWidth(j, 5000); //设置每列的列宽
                            //创建行、创建列
                            sheet2.createRow(j).createCell(index).setCellValue(dlData[j]); //设置对应单元格的值
                        }
                    }
                }
                index++;
            }
//			CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
//			for(int i=1; i<5000; i++) {
//				if(sheet1.getRow(i) != null) {
//					Row rowR = sheet1.getRow(i);
//					Cell cellR1 = rowR.getCell(1);
//					cellR1.setCellStyle(stringStyle);
//					cellR1.setCellType(HSSFCell.CELL_TYPE_STRING);
//					Cell cellR2 = rowR.getCell(2);
//					cellR2.setCellStyle(stringStyle);
//					cellR2.setCellType(HSSFCell.CELL_TYPE_STRING);
//					Cell cellR3 = rowR.getCell(3);
//					cellR3.setCellStyle(stringStyle);
//					cellR3.setCellType(HSSFCell.CELL_TYPE_STRING);
//				}
//			}
            //输出模板
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        }
    }

    @Override
    public Map<String, Object> importCompany(File excel) throws Exception {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        User loginUser = arsUtil.getCurrentUser();
        if (loginUser != null && loginUser.getPlatform() == 1) {
            List<Long> saveList = new ArrayList<Long>();
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>();
            FileInputStream inStream = new FileInputStream(excel);
            Workbook workBook = WorkbookFactory.create(inStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 1;
            while (flag) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    Map<String, String> data = new HashMap<String, String>();
                    try {
                        String companyname = ExcelUtil.getCellValue(row.getCell(0));
                        data.put("companyname", companyname);

                        Cell cellsocialCode = row.getCell(1);
                        cellsocialCode.setCellType(HSSFCell.CELL_TYPE_STRING);
                        String socialCode = ExcelUtil.getCellValue(cellsocialCode);
                        data.put("socialCode", socialCode);

                        String legalPerson = ExcelUtil.getCellValue(row.getCell(2));
                        data.put("legalPerson", legalPerson);

                        Cell cellphone = row.getCell(3);
                        cellphone.setCellType(HSSFCell.CELL_TYPE_STRING);
                        String phone = ExcelUtil.getCellValue(cellphone);
                        data.put("phone", phone);

                        String area = ExcelUtil.getCellValue(row.getCell(4));
                        data.put("area", area);
                        area = area.substring(area.lastIndexOf("-") + 1);

                        String location = ExcelUtil.getCellValue(row.getCell(5));
                        data.put("location", location);

                        Cell cellpublicSecurityLicenseNumber = row.getCell(6);
                        String publicSecurityLicenseNumber = "";
                        if (cellpublicSecurityLicenseNumber != null) {
                            cellpublicSecurityLicenseNumber.setCellType(HSSFCell.CELL_TYPE_STRING);
                            publicSecurityLicenseNumber = ExcelUtil.getCellValue(cellpublicSecurityLicenseNumber);
                            data.put("publicSecurityLicenseNumber", publicSecurityLicenseNumber);
                        }
                        Cell cellregisteredMoney = row.getCell(7);
                        String registeredMoney = "";
                        if (cellregisteredMoney != null) {
                            cellregisteredMoney.setCellType(HSSFCell.CELL_TYPE_STRING);
                            registeredMoney = ExcelUtil.getCellValue(cellregisteredMoney);
                            data.put("registeredMoney", registeredMoney);
                        }

                        SysareaSearchDTO searchDto = new SysareaSearchDTO();
                        searchDto.setPaging(false);
                        List<TreeView> nativeList = sysareaService.searchForCompany(searchDto);
                        List<TreeView> trees = new ArrayList<TreeView>();
                        for (TreeView treeView : nativeList) {
                            int level = 0;
                            getNativeChildren(trees, treeView, level);
                        }
                        boolean codeflag = false;
                        for (TreeView treeView : trees) {
                            if (treeView.getCode().equals(area)) {
                                codeflag = true;
                                break;
                            }
                        }
                        if (!codeflag) {
                            throw new ArsException("所属区域超出范围");
                        }
                        User user = new User();
                        user.setPhone(phone);
                        user.setRealname(companyname);
                        user.setUsername(socialCode);
                        user.setPlatform(2);
                        user.setInit(false);
                        SecurityCompany company = new SecurityCompany();
                        company.setUser(user);

                        company.setName(companyname);
                        company.setSocialCode(socialCode);
                        company.setLegalPerson(legalPerson);
                        company.setAreaCode(area);

                        if (StringUtil.isNotEmpty(location)) {
                            company.setLocation(location);
                        }
                        if (StringUtil.isNotEmpty(publicSecurityLicenseNumber)) {
                            company.setPublicSecurityLicenseNumber(publicSecurityLicenseNumber);
                        }
                        if (StringUtil.isNotEmpty(registeredMoney)) {
                            company.setRegisteredMoney(new BigDecimal(registeredMoney));
                        }

                        logger.info("update... " + company);
                        this.updateCompany(company);

                    } catch (Exception e) {
                        if (e instanceof ArsException) {
                            data.put("errorMsg", e.getMessage());
                        } else {
                            data.put("errorMsg", "数据问题");
                        }
                        faildList.add(data);
                        logger.error("批量录入错误：" + data.get("socialCode"), e);
                    }
                } else {
                    flag = false;
                }
                i++;
            }
            if (faildList.size() > 0) {
                resultMap.put("faildFilePath", buildFaildList(faildList));
            }
            resultMap.put("successIds", saveList);
        } else {
            throw new RuntimeException("当前登录信息错误, user:" + loginUser);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> importCompanyData(File excel) throws Exception {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        User loginUser = arsUtil.getCurrentUser();
        if (loginUser != null && loginUser.getPlatform() == 1) {
            List<Long> saveList = new ArrayList<Long>();
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>();
            FileInputStream inStream = new FileInputStream(excel);
            Workbook workBook = WorkbookFactory.create(inStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 1;
            while (flag) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    Map<String, String> data = new HashMap<String, String>();
                    try {
                        String id = ExcelUtil.getCellValue(row.getCell(0));
                        data.put("id", id);

                        String native_code = ExcelUtil.getCellValue(row.getCell(1));
                        data.put("native_code", native_code);

                        String user_id = ExcelUtil.getCellValue(row.getCell(2));
                        data.put("user_id", user_id);

                        String update_time = ExcelUtil.getCellValue(row.getCell(3));
                        data.put("update_time", update_time);

                        String update_by = ExcelUtil.getCellValue(row.getCell(4));
                        data.put("update_by", update_by);

                        String active = ExcelUtil.getCellValue(row.getCell(5));
                        data.put("active", active);

                        String name = ExcelUtil.getCellValue(row.getCell(6));
                        data.put("name", name);

                        String legal_person = ExcelUtil.getCellValue(row.getCell(7));
                        data.put("legal_person", legal_person);

                        String social_code = ExcelUtil.getCellValue(row.getCell(8));
                        data.put("social_code", social_code);

                        String central_office_name = ExcelUtil.getCellValue(row.getCell(9));
                        data.put("central_office_name", central_office_name);

                        String central_office_legal_person = ExcelUtil.getCellValue(row.getCell(10));
                        data.put("central_office_legal_person", central_office_legal_person);

                        String central_office_tel = ExcelUtil.getCellValue(row.getCell(11));
                        data.put("central_office_tel", central_office_tel);

                        String tel = ExcelUtil.getCellValue(row.getCell(12));
                        data.put("tel", tel);

                        String security_amount = ExcelUtil.getCellValue(row.getCell(13));
                        data.put("security_amount", security_amount);

                        String task_amount = ExcelUtil.getCellValue(row.getCell(14));
                        data.put("task_amount", task_amount);

                        String province = ExcelUtil.getCellValue(row.getCell(15));
                        data.put("province", province);

                        String city = ExcelUtil.getCellValue(row.getCell(16));
                        data.put("city", city);

                        String area = ExcelUtil.getCellValue(row.getCell(17));
                        data.put("area", area);


                        String areacode = ExcelUtil.getCellValue(row.getCell(18));
                        data.put("areacode", areacode);

                        String location = ExcelUtil.getCellValue(row.getCell(19));
                        data.put("location", location);

                        String insurance_number = ExcelUtil.getCellValue(row.getCell(20));
                        data.put("insurance_number", insurance_number);

                        String emergency_agreement = ExcelUtil.getCellValue(row.getCell(21));
                        data.put("emergency_agreement", emergency_agreement);

                        String business_license = ExcelUtil.getCellValue(row.getCell(22));
                        data.put("business_license", business_license);

                        String public_security_license = ExcelUtil.getCellValue(row.getCell(23));
                        data.put("public_security_license", public_security_license);

                        String init = ExcelUtil.getCellValue(row.getCell(24));
                        data.put("init", init);

                        String latitude = ExcelUtil.getCellValue(row.getCell(25));
                        data.put("latitude", latitude);

                        String longitude = ExcelUtil.getCellValue(row.getCell(26));
                        data.put("longitude", longitude);

                        String orderNo = ExcelUtil.getCellValue(row.getCell(27));
                        data.put("orderNo", orderNo);

                        String business_license_number = ExcelUtil.getCellValue(row.getCell(28));
                        data.put("business_license_number", business_license_number);

                        String principal = ExcelUtil.getCellValue(row.getCell(29));
                        data.put("principal", principal);


                        String principal_phone = ExcelUtil.getCellValue(row.getCell(30));
                        data.put("principal_phone", principal_phone);

                        String principal_id = ExcelUtil.getCellValue(row.getCell(31));
                        data.put("principal_id", principal_id);

                        String registered_money = ExcelUtil.getCellValue(row.getCell(32));
                        data.put("registered_money", registered_money);

                        String fixed_assets = ExcelUtil.getCellValue(row.getCell(33));
                        data.put("fixed_assets", fixed_assets);

                        String turnover_year = ExcelUtil.getCellValue(row.getCell(34));
                        data.put("turnover_year", turnover_year);

                        String annual_profits = ExcelUtil.getCellValue(row.getCell(35));
                        data.put("annual_profits", annual_profits);

                        String public_security_license_number = ExcelUtil.getCellValue(row.getCell(36));
                        data.put("public_security_license_number", public_security_license_number);


                        String national = ExcelUtil.getCellValue(row.getCell(37));
                        data.put("national", national);

                        String economic_type = ExcelUtil.getCellValue(row.getCell(38));
                        data.put("economic_type", economic_type);

                        String company_type = ExcelUtil.getCellValue(row.getCell(39));
                        data.put("company_type", company_type);

                        String human_defense_level = ExcelUtil.getCellValue(row.getCell(40));
                        data.put("human_defense_level", human_defense_level);

                        String risk_assessment_level = ExcelUtil.getCellValue(row.getCell(41));
                        data.put("risk_assessment_level", risk_assessment_level);

                        String security_association = ExcelUtil.getCellValue(row.getCell(42));
                        data.put("security_association", security_association);

                        String economic_type_legal_person = ExcelUtil.getCellValue(row.getCell(43));
                        data.put("economic_type_legal_person", economic_type_legal_person);

                        String is_subsidiary = ExcelUtil.getCellValue(row.getCell(44));
                        data.put("is_subsidiary", is_subsidiary);

                        String armed_escort_level = ExcelUtil.getCellValue(row.getCell(45));
                        data.put("armed_escort_level", armed_escort_level);

                        String security_technology_level = ExcelUtil.getCellValue(row.getCell(46));
                        data.put("security_technology_level", security_technology_level);


                        String rawid = ExcelUtil.getCellValue(row.getCell(47));
                        data.put("rawid", rawid);

                        String inrawid = ExcelUtil.getCellValue(row.getCell(48));
                        data.put("inrawid", inrawid);

                        SecurityCompany securityCompany = new SecurityCompany();


                        if (StringUtil.isNotEmpty(id)) {
                            securityCompany.setId(Long.parseLong(id));
                        }


                        if (StringUtil.isNotEmpty(native_code)) {
                            securityCompany.setNativeCode(Long.parseLong(native_code));
                        }

                        if (StringUtil.isNotEmpty(user_id)) {
                            User user = new User();
                            user.setId(Long.parseLong(user_id));
                            securityCompany.setUser(user);
                        }


                        if (StringUtil.isNotEmpty(update_time)) {
                            securityCompany.setUpdateTime(DateUtil.convertStringToDate(update_time));
                        }

                        if (StringUtil.isNotEmpty(update_by)) {
                            securityCompany.setUpdateBy(update_by);
                        }

                        if (StringUtil.isNotEmpty(active)) {
                            securityCompany.setActive(active.equals("FALSE") ? false : true);
                        }

                        if (StringUtil.isNotEmpty(name)) {
                            securityCompany.setName(name);
                        }

                        if (StringUtil.isNotEmpty(legal_person)) {
                            securityCompany.setLegalPerson(legal_person);
                        }
                        if (StringUtil.isNotEmpty(social_code)) {
                            securityCompany.setSocialCode(social_code);
                        }
                        if (StringUtil.isNotEmpty(central_office_name)) {
                            securityCompany.setCentralOfficeName(central_office_name);
                        }
                        if (StringUtil.isNotEmpty(central_office_legal_person)) {
                            securityCompany.setCentralOfficeLegalPerson(central_office_legal_person);
                        }
                        if (StringUtil.isNotEmpty(update_by)) {
                            securityCompany.setUpdateBy(update_by);
                        }
                        if (StringUtil.isNotEmpty(update_time)) {
                            securityCompany.setUpdateTime(DateUtil.convertStringToDate(update_time));
                        }
                        if (StringUtil.isNotEmpty(central_office_tel)) {
                            securityCompany.setCentralOfficeTel(central_office_tel);
                        }
                        if (StringUtil.isNotEmpty(tel)) {
                            securityCompany.setTel(tel);
                        }
                        if (StringUtil.isNotEmpty(security_amount)) {
                            securityCompany.setSecurityAmount(Integer.parseInt(security_amount));
                        }
                        if (StringUtil.isNotEmpty(task_amount)) {
                            securityCompany.setTaskAmount(Integer.parseInt(task_amount));
                        }
                        if (StringUtil.isNotEmpty(province)) {
                            securityCompany.setProvince(province);
                        }
                        if (StringUtil.isNotEmpty(city)) {
                            securityCompany.setCity(city);
                        }
                        if (StringUtil.isNotEmpty(area)) {
                            securityCompany.setArea(area);
                        }


                        if (StringUtil.isNotEmpty(areacode)) {
                            securityCompany.setAreaCode(areacode);
                        }


                        if (StringUtil.isNotEmpty(location)) {
                            securityCompany.setLocation(location);
                        }
                        if (StringUtil.isNotEmpty(insurance_number)) {
                            securityCompany.setInsuranceNumber(insurance_number);
                        }
                        if (StringUtil.isNotEmpty(emergency_agreement)) {
                            securityCompany.setEmergencyAgreement(emergency_agreement.equals("FALSE") ? false : true);
                        }
                        if (StringUtil.isNotEmpty(business_license)) {
                            securityCompany.setBusinessLicense(business_license);
                        }
                        if (StringUtil.isNotEmpty(public_security_license)) {
                            securityCompany.setPublicSecurityLicense(public_security_license);
                        }


                        if (StringUtil.isNotEmpty(init)) {
                            securityCompany.setInit(init.equals("FALSE") ? false : true);
                        }
                        if (StringUtil.isNotEmpty(longitude)) {
                            securityCompany.setLongitude(longitude);
                        }
                        if (StringUtil.isNotEmpty(latitude)) {
                            securityCompany.setLatitude(latitude);
                        }
                        if (StringUtil.isNotEmpty(orderNo)) {
                            securityCompany.setOrderNo(orderNo);
                        }
                        if (StringUtil.isNotEmpty(business_license_number)) {
                            securityCompany.setBusinessLicensNnumber(business_license_number);
                        }


                        if (StringUtil.isNotEmpty(principal)) {
                            securityCompany.setPrincipal(principal);
                        }
                        if (StringUtil.isNotEmpty(principal_phone)) {
                            securityCompany.setPrincipalPhone(principal_phone);
                        }
                        if (StringUtil.isNotEmpty(principal_id)) {
                            securityCompany.setPrincipalId(principal_id);
                        }
                        if (StringUtil.isNotEmpty(registered_money)) {
                            securityCompany.setRegisteredMoney(new BigDecimal(registered_money));
                        }

                        if (StringUtil.isNotEmpty(fixed_assets)) {
                            securityCompany.setFixedAssets(new BigDecimal(fixed_assets));
                        }
                        if (StringUtil.isNotEmpty(turnover_year)) {
                            securityCompany.setTurnoverYear(new BigDecimal(principal_phone));
                        }
                        if (StringUtil.isNotEmpty(annual_profits)) {
                            securityCompany.setAnnualProfits(new BigDecimal(annual_profits));
                        }
                        if (StringUtil.isNotEmpty(public_security_license_number)) {
                            securityCompany.setPublicSecurityLicenseNumber(public_security_license_number);
                        }

                        if (StringUtil.isNotEmpty(national)) {
                            securityCompany.setNational(national);
                        }
                        if (StringUtil.isNotEmpty(economic_type)) {
                            securityCompany.setEconomicType(economic_type);
                        }
                        if (StringUtil.isNotEmpty(company_type)) {
                            securityCompany.setCompanyType(company_type);
                        }
                        if (StringUtil.isNotEmpty(human_defense_level)) {
                            securityCompany.setHumanDefenseLevel(human_defense_level);
                        }

                        if (StringUtil.isNotEmpty(risk_assessment_level)) {
                            securityCompany.setRiskAssessmentLevel(risk_assessment_level);
                        }
                        if (StringUtil.isNotEmpty(security_association)) {
                            securityCompany.setSecurityAssociation(security_association);
                        }
                        if (StringUtil.isNotEmpty(economic_type_legal_person)) {
                            securityCompany.setEconomicTypeLegalPerson(economic_type_legal_person);
                        }
                        if (StringUtil.isNotEmpty(is_subsidiary)) {
                            securityCompany.setIsSubsidiary(is_subsidiary);
                        }

                        if (StringUtil.isNotEmpty(armed_escort_level)) {
                            securityCompany.setArmedEscortLevel(armed_escort_level);
                        }
                        if (StringUtil.isNotEmpty(security_technology_level)) {
                            securityCompany.setSecurityTechnologyLevel(security_technology_level);
                        }


                        if (StringUtil.isNotEmpty(rawid)) {
                            securityCompany.setRawid(Long.parseLong(rawid));
                        }
                        if (StringUtil.isNotEmpty(inrawid)) {
                            securityCompany.setInrawid(Long.parseLong(inrawid));
                        }

                        logger.info("saveOrupdate... " + securityCompany);
                        boolean isSave = false;
                        if (securityCompany.getId() == null) {
                            throw new ArsException("id缺失");
                        } else {
                            SecurityCompany dbSecurityCompany=securityCompanyDao.findById(securityCompany.getId());
                            if (dbSecurityCompany==null){
                                securityCompanyDao.save(securityCompany);

                            }
//                            securityCompany.setInrawid(securityCompany.getId());
//
//                            SecurityCompany dbSecurityCompany = securityCompanyDao.findByInRawId(securityCompany.getInrawid());
//                            if (dbSecurityCompany == null) {
//                                if (securityCompany.getRawid() != null) {
//                                    dbSecurityCompany = securityCompanyDao.findById(securityCompany.getRawid());
//                                    if (dbSecurityCompany == null) {
//                                        securityCompany.setId(null);
//                                        securityCompanyDao.save(securityCompany);
//
//
//                                        /********************************注释，同步到内网时上报到部级 start edit 2018-02-24*********************************************************************/
//
//                                        /*//部级接口对接  ---保安服务公司信息
//                                        //调用webService服务
//                                        new Thread(() -> { //异步处理
//                                            try {
//                                                buildWebServiceEntity(securityCompany);
//                                            } catch (Exception e) {
//                                                e.printStackTrace();
//                                            }
//                                        }).start();
//
//                                        new Thread(() -> { //异步处理
//                                            try {
//                                                String photo = securityCompany.getUser().getPhoto();
//                                                if (StringUtil.isNotEmpty(photo) && photo.startsWith("getResource.do?path=") && StringUtil.isNotEmpty(securityCompany.getCompanyCode())) {
//                                                    //部级接口对接--照片信息上传
//                                                    //证件号码(公民身份号码/保安服务公司编码/自招单位编码/保安培训机构编码)	sfzh	50	Y	字符	证件号码+照片名称是联合主键
//                                                    //照片名称	zpxx	50	Y	字符
//                                                    //1、命名规则：证件号码.jpg，或者证件号码_编号.jpg。
//                                                    //2、保安员照片名称身份证号一样。
//                                                    //3、其他照片分类，如如果照片名称一样，更新原记录，照片名称不一样作为新记录处理。
//
//                                                    //照片内容	zpnr	500K	Y	字符	Base64,最大不能超过500K
//                                                    //照片分类	zpfl	2	Y	字符	01：保安员；02:保安服务公司；03：自招单位；04：培训单位
//                                                    String fileType = photo.substring(photo.lastIndexOf("."));
//                                                    //图片转BASE64字符串
//                                                    photo = Base64Img.encodeBase64File(photo, baseFolder);
//                                                    //BASE64字符串转图片 --测试用
//                                                    //Base64Img.GenerateImage(photo);//测试用
//                                                    Zpxxb zpxxb = new Zpxxb();
//                                                    //TODO 保安服务公司编码 没有此字段，暂用营业执照号
//                                                    zpxxb.setSfzh(securityCompany.getCompanyCode());
//                                                    zpxxb.setZpxx(securityCompany.getCompanyCode() + fileType);
//                                                    zpxxb.setZpnr(photo);
//                                                    zpxxb.setZpfl("02");//01：保安员；02:保安服务公司；03：自招单位；04：培训单位
//                                                    //调用send方法完成对接
//                                                    clientUtil.send(Constants.XXBA_ZPXXB, zpxxb);
//                                                }
//
//                                            } catch (Exception e) {
//                                                e.printStackTrace();
//                                            }
//                                        }).start();*/
//
//                                        /********************************注释，同步到内网时上报到部级 start end 2018-02-24*********************************************************************/
//                                        isSave = true;
//                                    } else {
//                                        if (securityCompany.getUpdateTime().getTime() > dbSecurityCompany.getUpdateTime().getTime()) {
//                                            securityCompany.setId(dbSecurityCompany.getId());
//                                            securityCompanyDao.update(securityCompany);
//                                            isSave = true;
//                                        }
//                                    }
//                                } else {
//                                    securityCompany.setId(null);
//                                    securityCompanyDao.save(securityCompany);
//                                    isSave = true;
//                                }
                             else {
                                if (securityCompany.getUpdateTime().getTime() > dbSecurityCompany.getUpdateTime().getTime()) {
                                    securityCompany.setId(dbSecurityCompany.getId());
                                    securityCompanyDaoAop.update(securityCompany);
                                    isSave = true;
                                }
                            }
                        }
                    } catch (Exception e) {
                        if (e instanceof ArsException) {
                            data.put("errorMsg", e.getMessage());
                        } else {
                            data.put("errorMsg", "数据问题");
                        }
                        faildList.add(data);
                        logger.error("批量录入错误：" + data.get("socialCode"), e);
                    }
                } else {
                    flag = false;
                }
                i++;
            }
            if (faildList.size() > 0) {
                resultMap.put("faildFilePath", buildFaildList(faildList));
            }
            resultMap.put("successIds", saveList);
        } else {
            throw new RuntimeException("当前登录信息错误, user:" + loginUser);
        }
        return resultMap;
    }

    private String buildFaildList(List<Map<String, String>> data) throws Exception {
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(tempFolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_保安公司导入失败记录.xls";
        String templateName = tempFolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        File file = new File(templateName);
        buildCompanyTemplate(file);
        if (file != null && file.length() > 0) {
            HSSFWorkbook workbook = new HSSFWorkbook(new FileInputStream(file));
            HSSFSheet sheet = workbook.getSheetAt(0);
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle(workbook);
            int index = 1;
            for (Map<String, String> map : data) {
                Row row = sheet.createRow(index);
                sheet.setColumnWidth(8, 5000);
                row.createCell(0).setCellValue(map.get("companyname"));
                ;
                row.createCell(1).setCellValue(map.get("socialCode"));
                row.createCell(2).setCellValue(map.get("legalPerson"));
                row.createCell(3).setCellValue(map.get("phone"));
                row.createCell(4).setCellValue(map.get("area"));
                row.createCell(5).setCellValue(map.get("location"));
                row.createCell(6).setCellValue(map.get("publicSecurityLicenseNumber"));
                row.createCell(7).setCellValue(map.get("registeredMoney"));
                Cell errorMsgCell = row.createCell(8);
                errorMsgCell.setCellStyle(style1);
                errorMsgCell.setCellValue(map.get("errorMsg"));
                index++;
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write(fileOut);
            fileOut.close();
            workbook.close();
            return "/getResource.do?path=" + fileKey;
        }
        return null;
    }

    @Override
    public void saveOrUpdateForDS(SecurityCompany securityCompany) {
        if (securityCompany.getActive() == null) {
            securityCompany.setActive(true);
        }
        if (!securityCompany.getActive()) {
            securityCompanyDaoAop.delete(securityCompany);
            return;
        }
        SecurityCompany dbSecurityCompany = findById(securityCompany.getId());
        if (dbSecurityCompany == null) {
            securityCompanyDao.save(securityCompany);
            /****************************************部级接口对接  ---保安服务公司信息 start********************************************************/
            //调用webService服务
            new Thread(() -> { //异步处理
                try {
                    buildWebServiceEntity(securityCompany);
                } catch (Exception e) {
                    logger.error(e.getMessage(),e);
                }
            }).start();

            new Thread(() -> { //异步处理
                try {
                    String photo = securityCompany.getUser().getPhoto();
                    if (StringUtil.isNotEmpty(photo) && photo.startsWith("getResource.do?path=") && StringUtil.isNotEmpty(securityCompany.getCompanyCode())) {
                        //部级接口对接--照片信息上传
                        //证件号码(公民身份号码/保安服务公司编码/自招单位编码/保安培训机构编码)	sfzh	50	Y	字符	证件号码+照片名称是联合主键
                        //照片名称	zpxx	50	Y	字符
                        //1、命名规则：证件号码.jpg，或者证件号码_编号.jpg。
                        //2、保安员照片名称身份证号一样。
                        //3、其他照片分类，如如果照片名称一样，更新原记录，照片名称不一样作为新记录处理。

                        //照片内容	zpnr	500K	Y	字符	Base64,最大不能超过500K
                        //照片分类	zpfl	2	Y	字符	01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                        String fileType = photo.substring(photo.lastIndexOf("."));
                        //图片转BASE64字符串
                        photo = Base64Img.encodeBase64File(photo, baseFolder);
                        //BASE64字符串转图片 --测试用
                        //Base64Img.GenerateImage(photo);//测试用
                        Zpxxb zpxxb = new Zpxxb();
                        zpxxb.setSfzh(securityCompany.getCompanyCode());
                        zpxxb.setZpxx(securityCompany.getCompanyCode() + fileType);
                        zpxxb.setZpnr(photo);
                        zpxxb.setZpfl("02");//01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                        //调用send方法完成对接
                        clientUtil.send(Constants.XXBA_ZPXXB, zpxxb);
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }).start();
            /****************************************部级接口对接  ---保安服务公司信息 end********************************************************/
        } else {
            if (securityCompany.getUpdateTime().getTime() > dbSecurityCompany.getUpdateTime().getTime()) {
                securityCompanyDaoAop.update(securityCompany);
            }
        }
    }

    @Override
    public SecurityCompany findByRawId(Long rawid) {
        return securityCompanyDao.findByRawId(rawid);
    }

    @Override
    public SecurityCompany findByInRawId(Long inrawid) {
        return securityCompanyDao.findByInRawId(inrawid);
    }

    @Override
    public List<SecurityCompany> searchForExportData(CompanySearchDto dto) {

        //增加区域过滤 2018年8月27日17:21:04 wjb
        if (StringUtil.isNotEmpty(dto.getAreaCode())) {
            //省
            if (dto.getAreaCode().endsWith("0000")) {
                dto.setAreaCode(dto.getAreaCode().substring(0, 2) + "____");
            } //市
            else if (dto.getAreaCode().endsWith("00")) {
                dto.setAreaCode(dto.getAreaCode().substring(0, 4) + "____");
            } //区
            else {
            }
        }
        return securityCompanyDao.searchForExportData(dto);
    }

    @Override
    public void updateExport(SecurityCompany securityCompany) {
        securityCompanyDaoAop.update(securityCompany);
    }


    /**
     * 创建WebService数据实体类
     *
     * @param company
     */
    private void buildWebServiceEntity(SecurityCompany company) throws Exception {

        logger.info("上报部级数据【保安公司】……");
        System.out.println("company==" + company.toString());
        Bagsxxb bagsxxb = new Bagsxxb();
        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        //必填
        Config config = configDao.findByKey("current_native");
        //公司编码
        map.put("bagsbm", new KeyAndDefauleVal("companyCode", company.getCompanyCode()));
        map.put("bagsmc", new KeyAndDefauleVal("name", null));
        if (config != null) {
            map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", config.getValue() + "GBF" + company.getPublicSecurityLicenseNumber()));
        } else {
            map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", "GBF" + company.getPublicSecurityLicenseNumber()));
        }
        //非必填
        map.put("gj", new KeyAndDefauleVal("national", null));
        map.put("zcdxz", new KeyAndDefauleVal("location", null));
        map.put("zczj", new KeyAndDefauleVal("registeredMoney", null));
        map.put("frsfzh", new KeyAndDefauleVal("legalPersonNo", null));
        map.put("frxm", new KeyAndDefauleVal("legalPerson", null));
        map.put("fzrsfzh", new KeyAndDefauleVal("principalId", null));
        map.put("fzrxm", new KeyAndDefauleVal("principal", null));
        map.put("fzrdh", new KeyAndDefauleVal("principalPhone", null));
        map.put("jjlx", new KeyAndDefauleVal("economicType", null));
        map.put("gdzc", new KeyAndDefauleVal("fixedAssets", null));
        map.put("nyye", new KeyAndDefauleVal("turnoverYear", null));
        map.put("nls", new KeyAndDefauleVal("annualProfits", null));
        map.put("gslx", new KeyAndDefauleVal("companyType", null));


//        map.put("rlffdj", new KeyAndDefauleVal("humanDefenseLevel", StringUtil.isNotEmpty(company.getHumanDefenseLevel()) ? Integer.parseInt(company.getHumanDefenseLevel()) : 0));
//        map.put("wzyydj", new KeyAndDefauleVal("armedEscortLevel", StringUtil.isNotEmpty(company.getArmedEscortLevel()) ? Integer.parseInt(company.getArmedEscortLevel()) : 0));
//        map.put("aqjsdj", new KeyAndDefauleVal("securityTechnologyLevel", StringUtil.isNotEmpty(company.getSecurityTechnologyLevel()) ? Integer.parseInt(company.getSecurityTechnologyLevel()) : 0));
//        map.put("fxpgdj", new KeyAndDefauleVal("riskAssessmentLevel", StringUtil.isNotEmpty(company.getRiskAssessmentLevel()) ? Integer.parseInt(company.getRiskAssessmentLevel()) : 0));
//        map.put("sfslzgs", new KeyAndDefauleVal("isSubsidiary", company.getIsSubsidiary() != null ? Integer.parseInt(company.getIsSubsidiary()) : 0));

        //无
       /* map.put("zcd", new KeyAndDefauleVal("national", ""));
        map.put("frdh", new KeyAndDefauleVal("national", ""));
        map.put("fwlx", new KeyAndDefauleVal("national", ""));
        map.put("fzjgbm", new KeyAndDefauleVal("national", ""));
        map.put("fzjgmc", new KeyAndDefauleVal("national", ""));
        map.put("fzrq", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("dxjg", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("dxrq", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("zgsmc", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("bz1", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("bz2", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("bz3", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));*/

        try {
            EntityForWebServiceUtil.copy(map, company, bagsxxb);
            logger.info("bagsxxb==" + bagsxxb.toString());

            //TODO 缺失字段
            bagsxxb.setKhsl("1");
            bagsxxb.setBgbs("1");
            bagsxxb.setZjjk("1");
            bagsxxb.setGslx("1");

            clientUtil.send(Constants.XXBA_BAGSXXB, bagsxxb);
            logger.info("上报成功保安公司……");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public CompanyReportData dataStatisticsReport(ReportDataSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }

        DecimalFormat df = new DecimalFormat("#0.00");
        Date startDate = new Date();
        Date startLastDate = new Date();
        Date endDate = new Date();
        Date endLastDate = new Date();
        if (StringUtil.isNotEmpty(searchDto.getType())) {
            if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISDAY)) {
                startDate = DateUtil.getDayBegin();
                endDate = DateUtil.getDayEnd();
                startLastDate = DateUtil.getBeginDayOfYesterday();
                endLastDate = DateUtil.getEndDayOfYesterDay();
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISWEEK)) {
                startDate = DateUtil.getBeginDayOfWeek();
                endDate = DateUtil.getEndDayOfWeek();
                startLastDate = DateUtil.getBeginDayOfLastWeek();
                endLastDate = DateUtil.getEndDayOfLastWeek();
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISMONTH)) {
                startDate = DateUtil.getBeginDayOfMonth();
                endDate = DateUtil.getEndDayOfMonth();
                startLastDate = DateUtil.getBeginDayOfLastMonth();
                endLastDate = DateUtil.getEndDayOfLastMonth();
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISYEAR)) {
                startDate = DateUtil.getBeginDayOfYear();
                endDate = DateUtil.getEndDayOfYear();
                startLastDate = DateUtil.getBeginDayOfLastYear();
                endLastDate = DateUtil.getEndDayOfLastYear();
            }
        }
        ReportDataSearchDto searchLastDto = new ReportDataSearchDto();
        searchLastDto.setType(searchDto.getType());
        searchLastDto.setAreaCode(searchDto.getAreaCode());
        CompanyReportData lastData = null;
        if (StringUtil.isNotEmpty(searchLastDto.getType()) && !searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_DIY)) {
            searchDto.setStartTime(DateUtil.convertDateToString(startDate, DateUtil.FORMAT1));
            searchDto.setEndTime(DateUtil.convertDateToString(endDate, DateUtil.FORMAT1));
            searchLastDto.setStartTime(DateUtil.convertDateToString(startLastDate, DateUtil.FORMAT1));
            searchLastDto.setEndTime(DateUtil.convertDateToString(endLastDate, DateUtil.FORMAT1));
            lastData = securityCompanyDao.dataStatisticsInitReport(searchLastDto);
        }

        CompanyReportData data = securityCompanyDao.dataStatisticsInitReport(searchDto);
        if (data == null) {
            data = new CompanyReportData();
        }
        if (StringUtil.isEmpty(searchDto.getType())) {
            List<ReportData> reportDatas = securityCompanyDao.dataStatisticsAddReport(searchDto);
            for (ReportData reportData : reportDatas) {
                if (reportData.getName().equals(DateUtil.getCurrentDate("yyyy"))) {
                    data.setThisYearTotal(reportData.getValue());
                }
                if (reportData.getName().equals(DateUtil.getLastYear())) {
                    data.setLastYearTotal(reportData.getValue());
                }
            }
            if (data.getThisYearTotal() == null) {
                data.setLastYearTotal(0l);
            }
            if (data.getLastYearTotal() == null) {
                data.setLastYearTotal(0l);
            }
            if (data.getLastYearTotal() > 0) {
                data.setLastYearRate(df.format((data.getThisYearTotal() - data.getLastYearTotal()) * 100.0 / data.getLastYearTotal()));
            } else if (data.getThisYearTotal() < 1) {
                data.setLastYearRate("0");
            } else {
                data.setLastYearRate("100");
            }
        } else {
            if (lastData != null) {
                if (lastData.getInitCount() < 1) {
                    if (data.getInitCount() < 1) {
                        data.setInitRate("0");
                    } else {
                        data.setInitRate("100");
                    }
                } else {
                    data.setInitRate(df.format((data.getInitCount() - lastData.getInitCount()) * 100.0 / lastData.getInitCount()));
                }
                if (lastData.getUnInitCount() < 1) {
                    if (data.getUnInitCount() < 1) {
                        data.setUnInitRate("0");
                    } else {
                        data.setUnInitRate("100");
                    }
                } else {
                    data.setUnInitRate(df.format((data.getUnInitCount() - lastData.getUnInitCount()) * 100.0 / lastData.getUnInitCount()));
                }
                if (lastData.getTotal() < 1) {
                    if (data.getTotal() < 1) {
                        data.setTotalRate("0");
                    } else {
                        data.setTotalRate("100");
                    }
                } else {
                    data.setTotalRate(df.format((data.getTotal() - lastData.getTotal()) * 100.0 / lastData.getTotal()));
                }
            }
        }

        return data;
    }

    @Override
    public SupervisionSearchDto supervisionSearch(SupervisionSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }

        List<SupervisionDto> supervisions = securityCompanyDao.supervisionSearch(searchDto);
        for (SupervisionDto supervisionDto : supervisions) {
            Long unPolicyCount = personDao.findUnPolicyByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setUnPolicyCount(unPolicyCount);
            supervisionDto.setPolicyCount(supervisionDto.getTotal() - unPolicyCount);

            Long approvalCount = approvalDao.findCountByUserId(supervisionDto.getUserId());
            supervisionDto.setPermitCount(approvalCount);
            Long taskCount = taskDao.findTotalByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setTaskCount(taskCount);
            Long cycleTaskCount = taskDao.findCycleCountByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setCycleTaskCount(cycleTaskCount);
            Long temporaryTaskCount = taskDao.findTemporaryCountByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setTemporaryTaskCount(temporaryTaskCount);
        }
        searchDto.setData(supervisions);
        searchDto.setTotalCount(securityCompanyDao.supervisionSearchCount(searchDto));
        return searchDto;
    }

    @Override
    public PageResult querySupervisionList(SupervisionSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());

        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }

        List<SupervisionDto> supervisions = securityCompanyDao.supervisionSearch(searchDto);
        for (SupervisionDto supervisionDto : supervisions) {
            Long unPolicyCount = personDao.findUnPolicyByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setUnPolicyCount(unPolicyCount);
            supervisionDto.setPolicyCount(supervisionDto.getTotal() - unPolicyCount);

            Long approvalCount = approvalDao.findCountByUserId(supervisionDto.getUserId());
            supervisionDto.setPermitCount(approvalCount);
            Long taskCount = taskDao.findTotalByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setTaskCount(taskCount);
            Long cycleTaskCount = taskDao.findCycleCountByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setCycleTaskCount(cycleTaskCount);
            Long temporaryTaskCount = taskDao.findTemporaryCountByCompanyId(supervisionDto.getCompanyId());
            supervisionDto.setTemporaryTaskCount(temporaryTaskCount);
        }
        return new PageResult(securityCompanyDao.supervisionSearchCount(searchDto).intValue(), supervisions);
    }

    @Override
    public Long supervisionSearchCount(SupervisionSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());

        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }
        return securityCompanyDao.supervisionSearchCount(searchDto);
    }

    @Override
    public Long dataStatisticsPersonTotalReport(SupervisionSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }
        return securityCompanyDao.dataStatisticsPersonTotalReport(searchDto);
    }

    @Override
    public Long dataStatisticsPolicyReport(SupervisionSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }
        return securityCompanyDao.dataStatisticsPolicyReport(searchDto);
    }

    @Override
    public JSONObject supervisionTotal(SupervisionSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }
        JSONObject data = new JSONObject();
        Long personTotal = securityCompanyDao.dataStatisticsPersonTotalReport(searchDto);
        Long policyTotal = securityCompanyDao.dataStatisticsPolicyReport(searchDto);
        DecimalFormat df = new DecimalFormat("#0.00");
        String policyRate = "";
        if (personTotal == null || personTotal < 1) {
            policyRate = "0";
        } else if (policyTotal == null || personTotal < 1) {
            policyRate = "0";
        } else {
            policyRate = df.format(policyTotal * 100.0 / personTotal);
        }

        data.put("companyCount", securityCompanyDao.supervisionSearchCount(searchDto));
        data.put("initCount", securityCompanyDao.dataStatisticsInitTotalReport(searchDto));
        data.put("policyRate", policyRate);

        return data;
    }

    @Override
    public JSONObject supervisionDetail(Long companyId) {
        JSONObject data = new JSONObject();
        JSONObject policyInfo = new JSONObject();
        JSONObject appInfo = new JSONObject();
        JSONObject approvalInfo = new JSONObject();
        JSONObject testInfo = new JSONObject();

        SecurityCompany company = securityCompanyDao.findById(companyId);
//		Long taskTotal = taskDao.findTotalByCompanyId(companyId);
//		Long cycleCount = taskDao.findCycleCountByCompanyId(companyId);
//		Long temporaryCount = taskDao.findTemporaryCountByCompanyId(companyId);
//		Long urgentCount = taskDao.findUrgentCountByCompanyId(companyId);
//		taskInfo.put("taskTotal", taskTotal);
//		taskInfo.put("cycleCount", cycleCount);
//		taskInfo.put("temporaryCount", temporaryCount);
//		taskInfo.put("urgentCount", urgentCount);

        TaskExecutionDto taskInfo = taskDao.findTaskExecutionReport(companyId);

        List<ReportData> approvalReports = approvalDao.getTypeGroupByUserId(company.getUser().getId());
        Long personcertificateCount = 0l;
        Long crosscompanyCount = 0l;
        Long subsidiaryCount = 0l;
        Long traincompanyCount = 0l;
        Long legalchangeCount = 0l;
        for (ReportData reportData : approvalReports) {
            if (reportData.getName().equals(BusinessType.BAYZ)) {
                personcertificateCount = reportData.getValue();
            } else if (reportData.getName().equals(BusinessType.KQYBAGS)) {
                crosscompanyCount = reportData.getValue();
            } else if (reportData.getName().equals(BusinessType.BAGSZGS)) {
                subsidiaryCount = reportData.getValue();
            } else if (reportData.getName().equals(BusinessType.PXDW)) {
                traincompanyCount = reportData.getValue();
            } else if (reportData.getName().equals(BusinessType.FRBG)) {
                legalchangeCount = reportData.getValue();
            }
        }
        approvalInfo.put("personcertificateCount", personcertificateCount);
        approvalInfo.put("crosscompanyCount", crosscompanyCount);
        approvalInfo.put("subsidiaryCount", subsidiaryCount);
        approvalInfo.put("traincompanyCount", traincompanyCount);
        approvalInfo.put("legalchangeCount", legalchangeCount);

        Long personCount = personDao.countPersonByCompanyId(companyId);
        Long initCount = personDao.countInitPersonByCompanyId(companyId);
        Long authCount = personDao.countAuthPersonByCompanyId(companyId);
        Long unAuthCount = personDao.countUnAuthPersonByCompanyId(companyId);

        appInfo.put("personCount", personCount);
        appInfo.put("initCount", initCount);
        appInfo.put("authCount", authCount);
        appInfo.put("unAuthCount", unAuthCount);

        Long unPolicyCount = personDao.findUnPolicyByCompanyId(companyId);
        Long policyCount = personCount - unPolicyCount;
        Long quotaCount = personDao.countQuotaPersonByCompanyId(companyId);
        Long unQuotaCount = policyCount - quotaCount;

        Long socialSecurityCount = personDao.countSocialSecurityPersonByCompanyId(companyId);
        Long unSocialSecurityCount = personCount - socialSecurityCount;
        String socialSecurityName = "";
        policyInfo.put("personTotal", personCount);
        policyInfo.put("policyCount", policyCount);
        policyInfo.put("unPolicyCount", unPolicyCount);
        policyInfo.put("quotaCount", quotaCount);
        policyInfo.put("unQuotaCount", unQuotaCount);
        policyInfo.put("socialSecurityCount", socialSecurityCount);
        policyInfo.put("unSocialSecurityCount", unSocialSecurityCount);
        policyInfo.put("socialSecurityName", socialSecurityName);

        TestTrainDto testTrain = securityCompanyDao.dataStatisticsTestTrainReport(companyId);
        Long noCertificateCount = securityCompanyDao.getNoCertificateCount(companyId);
        testTrain.setNoCertificateCount(noCertificateCount.toString());
        Config coninsConfig = configService.findByKey(Constants.TRAIN);
        String url = coninsConfig.getValue() + ThirdPartyURL.testTrainRport + "?companyid=" + companyId + "&trackid=8";
        try {
            String resultStr = messageUtils.getJsonByInternet(url);
            JSONObject result = (JSONObject) JSONObject.parse(resultStr);
            JSONObject resultData = (JSONObject) result.get("data");
            JsonParser parser = new JsonParser();  //创建JSON解析器
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }


        String zgzsTrainCount = "0";    //Int	N	参加资格证培训人数
        String certificateCount = "0";    //Int	N	取得证书人数
        //String noCertificateCount= "0";	//Int	N	无证书人员
        String onGuardCount = "0";    //Int	N	参加在岗培训人数（即 已实名认证人员数量）
//		String periodAvgMonth= "0";	//Int	N	每月人均学时

//		JsonObject object=(JsonObject) parser.parse(resultStr);  //创建JsonObject对象
        zgzsTrainCount = orderPersonDao.countByCompanyIdAndTrainType(companyId, "8").toString();//<!--今年 参加资格证培训人数 -->
        certificateCount = personcertificateDao.countCertificateByCompanyId(companyId).toString();
        //noCertificateCount = securityCompanyDao.getNoCertificateCount(companyId).toString();
        onGuardCount = personDao.countAuthPersonByCompanyId(companyId).toString();
//		periodAvgMonth = resultData.getString("periodAvgMonth");

        testInfo.put("zgzsTrainCount", zgzsTrainCount);
        testInfo.put("certificateCount", certificateCount);
        testInfo.put("noCertificateCount", noCertificateCount);
        testInfo.put("onGuardCount", onGuardCount);
//		testInfo.put("periodAvgMonth", periodAvgMonth);

        data.put("companyInfo", company);
        data.put("policyInfo", policyInfo);
        data.put("taskInfo", taskInfo);
        data.put("appInfo", appInfo);
        data.put("approvalInfo", approvalInfo);
        data.put("testInfo", testInfo);
        return data;
    }

    @Override
    public JSONObject companySecurityDetail(Long companyId) {
        JSONObject data = new JSONObject();

        SecurityCompany company = securityCompanyDao.findById(companyId);
        company.setSecurityAmount( securityCompanyDao.countForSecurityPerson(companyId));
        data.put("certificationCount",securityCompanyDao.countForCertifity(companyId));
        data.put("companyInfo", company);
        if (company.getUser() != null) {
            Long company_id = company.getUser().getId();
            List<SecurityCompanyInsurance> insurances = securityCompanyInsuranceDao.findByCompanyId(company_id);
            data.put("insuranceInfos", insurances);
        }
        return data;
    }

    @Override
    public void updateOperatorphone(SecurityCompany securityCompany) {
        securityCompanyDaoAop.updateOperatorphone(securityCompany);
    }


    @Override
    public List<SecurityCompany> searchForExport(String startDate) {
        return securityCompanyDao.searchForExport(startDate);
    }

    @Override
    public List<ZTree> getCompanyTree() {
        CompanySearchDto searchDto = new CompanySearchDto();
        User currentUser = arsUtil.getCurrentUser();
        // searchDto.setAreaslist(currentUser.getAreaslist());
        searchDto.setUserid(currentUser.getId());
        searchDto.setPath(currentUser.getPolice().getPath());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }
        List<ZTree> list = securityCompanyDao.getCompanyTree(searchDto);
        Map<String,Integer> countMap = new HashMap<String,Integer>();
        for(ZTree zTree: list){
            if(zTree.getType().equals("1")){
                String key = zTree.getpId();
                String key1 = key.substring(0,2)+"0000";
                String key2 = key.substring(0,4)+"00";

                Integer count = countMap.get(key);
                if(count == null){
                    count = 0;
                }

                Integer count1 = countMap.get(key1);
                if(count1 == null){
                    count1 = 0;
                }

                Integer count2 = countMap.get(key2);
                if(count2 == null){
                    count2 = 0;
                }

                if(key.endsWith("0000")){
                    countMap.put(key1,++count1);
                }else if(key.endsWith("00")){
                    countMap.put(key1,++count1);
                    countMap.put(key2,++count2);
                }else{
                    countMap.put(key,++count);
                    countMap.put(key1,++count1);
                    countMap.put(key2,++count2);
                }
            }
        }
        for(ZTree zTree: list){
            if(zTree.getType().equals("0")){
                zTree.setName(zTree.getName()+"("+countMap.get(zTree.getId()) +")");
            }
        }
        return list;
    }

    @Override
    public void batchSendMessage(List<String> phones) {
        User loginUser = arsUtil.getCurrentUser();
        if (loginUser != null) {
            SecurityCompany company = null;
            if (loginUser.getPlatform() == 2) {
                company = securityCompanyDao.findByUserid(loginUser.getId());
            }
            if (company != null) {
                MessageUtil.sendMessage(phones, Constants.NEW_USER_MESSAGE.replaceAll("%COMPANYNAME%", company.getName()), messageLogDao);
            }
        }
    }

    /**
     * 获取当前登录账号对应的公司信息
     *
     * @return
     */
    @Override
    public SecurityCompany getCurrentUserCompany() {
        User loginUser = arsUtil.getCurrentUser();
        SecurityCompany company = null;
        if (loginUser != null) {
            if (loginUser.getPlatform() == 2) {
                company = securityCompanyDao.findByUserid(loginUser.getId());
            }
        }
        return company;
    }

    /**
     * 批量导入人员
     * by llc 2018-08-20
     *
     * @param list
     */
    @Override
    public List<Map<String, String>> batchImportPerson(List<Map<String, String>> list, int batchId, User user, SecurityCompany company) {


        /*****  批量插入人员导入临时 ****/
        securityCompanyDao.insertTmpBatchImportPerson(list, batchId);
        String passWord = Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD);  // 默认密码

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("prm_batchId", batchId);
        paramMap.put("prm_companyId", company.getId());
        paramMap.put("prm_userId", user.getId());
        paramMap.put("prm_areaCode", company.getAreaCode());
        paramMap.put("prm_passWord", passWord);
        /*****  调用存储过程处理业务逻辑 ****/
        securityCompanyDao.prc_batchImportPerson(paramMap);
        String prm_success = paramMap.get("prm_success").toString();
        if (prm_success.equalsIgnoreCase("0")) {
            throw new ArsException("导入人员失败！");
        }
        /***** 查询本次校验失败的人员信息 ****/
        List<Map<String, String>> failList = securityCompanyDao.getFailList(batchId);

        /***** 删除本次导入的人员信息临时表 ****/

        securityCompanyDao.deleteTmpBatchImportPerson(batchId);
        return failList;
    }

    @Override
    public List<SecurityCompany> findDSOutList(String startDate) {
        List<SecurityCompany> companyList = securityCompanyDao.searchForExport(startDate);
        companyList.forEach(company->{
            company.setExported(true);
            securityCompanyDao.updateExportFlag(company);
        });
        return companyList;
    }

    /**
     * 批量导入
     * @param list
     */
    @Override
    public void importBatch(List<SecurityCompany> list){
        List<SecurityCompany> dbList = securityCompanyDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);

        if (list.size()>0){
            for(SecurityCompany detail:list){
                detail.setUpdateflag(false);
                try {
                    detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                }
            }
            //批量保存
            securityCompanyDaoAop.saveBatch(list);
        }
    }

    @Override
    public void searchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page) {
        arsUtil.setPoliceSearch(dto);
        page.setData(securityCompanyDao.searchForPageV2(dto));
        page.setTotal(securityCompanyDao.searchForPageV2Count(dto));
    }

    @Override
    public void situationForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page) {
        arsUtil.setPoliceSearch(dto);
        securityCompanyDao.situationForPage(dto,page);
    }
    @Override
    public void updateCertificatesPhoto(List<SecurityCompany> companys) {
        securityCompanyDao.updateCertificatesPhoto(companys);
    }

    @Override
    public List<SecurityCompany> findSubCompany(String parentId) {
        return securityCompanyDao.findSubCompany(parentId);
    }

    @Override
    public List<String> selectCompanyName(String institutionType) {
        return securityCompanyDao.selectCompanyName(institutionType);
    }

    public static void main(String[] args) {
        HttpResponse response = HttpUtil.createPost("http://v5qy.test.baibaodun.cn/v3/public/company-info")
                .contentType("application/json")
                .body(String.format("{'pageSize':'%s','pageIndex':'%s','name':'%s'}","10","1","公司")).execute();

        System.out.println(response.body());
        V5ResultDto resultDto = JSON.parseObject(response.body(), V5ResultDto.class);
        if(resultDto.isSuccess() && resultDto.getData() != null){
            V5PageDto pageDto = JSON.parseObject(JSON.toJSONString(resultDto.getData()),V5PageDto.class);
            if(pageDto.getData() != null && pageDto.getData().size() > 0){
                List<CompanyV5Dto> companyV5Dtos = JSONArray.parseArray(JSON.toJSONString(pageDto.getData()),CompanyV5Dto.class);
                for (CompanyV5Dto companyV5Dto : companyV5Dtos) {
                    System.out.println(companyV5Dto.getAddress());
                }
            }
        }
//        <CompanyV5Dto>
        System.out.println(resultDto.getStatus());
    }

    @Override
    public void publicSearchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page) {
        if(Constants.YES.equals(configUtils.getValueByKey(Constants.BJ_PUBLIC_QUERY_FORM_V5))){
            HttpResponse response = HttpUtil.createPost(configUtils.getValueByKey(Constants.V5_TENANT_URL)+"v3/public/company-info")
                    .contentType("application/json")
                    .body(String.format("{'pageSize':'%s','pageIndex':'%s','name':'%s'}",dto.getPageSize(),dto.getPageNumber(),StringUtil.isEmpty(dto.getName())?"":dto.getName()))
                    .execute();

            V5ResultDto resultDto = JSON.parseObject(response.body(), V5ResultDto.class);
            if(resultDto.isSuccess() && resultDto.getData() != null){
                V5PageDto pageDto = JSON.parseObject(JSON.toJSONString(resultDto.getData()),V5PageDto.class);
                if(pageDto.getData() != null && pageDto.getData().size() > 0){
                    List<CompanyV5Dto> companyV5Dtos = JSONArray.parseArray(JSON.toJSONString(pageDto.getData()),CompanyV5Dto.class);
                    List<CompanyDto> companyDtos = new ArrayList<>();
                    for (CompanyV5Dto companyV5Dto : companyV5Dtos) {
                        CompanyDto companyDto = new CompanyDto();
                        companyDto.setPublicSecurityLicenseNumber(companyV5Dto.getCerNo());
                        companyDto.setName(companyV5Dto.getComName());
                        companyDto.setGiveLicenseDate(companyV5Dto.getCerDate());
                        companyDto.setLegalPerson(companyV5Dto.getLegalPerson());
                        companyDto.setTel(companyV5Dto.getTel());
                        companyDto.setRegisteredMoney(StrUtil.isEmpty(companyV5Dto.getRegisteredMoney())?null:new BigDecimal(companyV5Dto.getRegisteredMoney()));
                        companyDto.setAddress(companyV5Dto.getAddress());
                        companyDto.setLocation(companyV5Dto.getLocation());
                        companyDto.setSecurityScopeType(companyV5Dto.getSecurityScopeType());
                        companyDto.setFromV5(true);
                        companyDtos.add(companyDto);
                    }

                    page.setData(companyDtos);
                    page.setTotal(pageDto.getTotal());
                    page.setTotalPage(pageDto.getTotal()/pageDto.getPageSize() + (pageDto.getTotal()%pageDto.getPageSize() > 0 ? 0:1));
                }
            }
            return;
        }
        securityCompanyDao.publicSearchForPage(dto,page);
    }
}
