package com.bcxin.ars.service.gen.impl;

import com.bcxin.ars.dao.gen.GenTableColumnDao;
import com.bcxin.ars.dao.gen.GenTableDao;
import com.bcxin.ars.dao.sys.ModuleMenuDao;
import com.bcxin.ars.dto.page.GenTablePageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gen.GenTable;
import com.bcxin.ars.model.gen.GenTableColumn;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.service.gen.GenTableService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.service.util.gen.GenUtils;
import com.bcxin.ars.service.util.gen.VelocityInitializer;
import com.bcxin.ars.service.util.gen.VelocityUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.text.StringUtils;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * 代码生成业务表Service实现类
 *
 * @author linqinglin
 * @Date 2020-08-09 08:11:23
 */
@Service
@Transactional
public class GenTableServiceImpl implements GenTableService {

    Logger logger = LoggerFactory.getLogger(GenTableServiceImpl.class);

    @Autowired
    private GenTableDao genTableDao;

    @Autowired
    private ModuleMenuDao moduleMenuDao;

    @Autowired
    private GenTableColumnDao genTableColumnDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdWorker idWorker;

    @Override
    public int delete(GenTable genTable) {
        User currentUser = arsUtil.getCurrentUser();
        genTable.setUpdateTime(new Date());
        genTable.setUpdateBy(currentUser.getUsername());
        return genTableDao.delete(genTable);
    }

    @Override
    public int save(GenTable genTable) {
        User currentUser = arsUtil.getCurrentUser();
        if(genTable.getId() == null){
            genTable.setCreateTime(new Date());
        }else{
            GenTable dbGenTable = genTableDao.findById(genTable.getId());
            BeanUtils.copyPropertiesIgnore(genTable,dbGenTable,true);
            BeanUtils.copyPropertiesIgnore(dbGenTable,genTable,false);
        }

        List<GenTableColumn> dbColumnList = genTableColumnDao.findByBatchId(genTable.getColumns());

        Map<Long, GenTableColumn> columnMap = dbColumnList.stream().collect(Collectors.toMap(GenTableColumn::getColumnId, Function.identity()));

        for (GenTableColumn genTableColumn : genTable.getColumns()){
            genTableColumn.setUpdateBy(currentUser.getUsername());
            genTableColumn.setUpdateTime(new Date());

            GenTableColumn dbGenTableColumn = columnMap.get(genTableColumn.getColumnId());
            genTableColumn.setCreateTime(dbGenTableColumn.getCreateTime());
            genTableColumn.setCreateBy(dbGenTableColumn.getCreateBy());
            genTableColumn.setTableId(dbGenTableColumn.getTableId());
            genTableColumn.setColumnName(dbGenTableColumn.getColumnName());
            genTableColumn.setColumnType(dbGenTableColumn.getColumnType());
            genTableColumn.setIsPk(dbGenTableColumn.getIsPk());
            genTableColumn.setIsIncrement(dbGenTableColumn.getIsIncrement());
            //BeanUtils.copyPropertiesIgnore(genTableColumn,dbGenTableColumn);
            genTableColumnDao.save(genTableColumn);
        }
        genTable.setUpdateBy(currentUser.getUsername());
        genTable.setUpdateTime(new Date());
        return genTableDao.save(genTable);
    }

    @Override
    public GenTable findById(Long id) {
        return genTableDao.findById(id);
    }

    @Override
    public void searchForPage(GenTablePageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        genTableDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<GenTable> list) {
        List<GenTable> dbList = genTableDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (GenTable genTable : list) {
                genTable.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        genTable.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, genTable.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            genTableDao.saveBatch(list);
        }
    }

    @Override
    public List<GenTable> findByBatchId(List<GenTable> list) {
        return genTableDao.findByBatchId(list);
    }

    /**
     * 查询据库列表
     *
     * @param tableNames 表名称组
     * @return 数据库表集合
     */
    @Override
    public List<GenTable> selectDbTableListByNames(String[] tableNames){
        return genTableDao.selectDbTableListByNames(tableNames);
    }

    @Override
    public void updateSelective(GenTable genTable) {
        User currentUser = arsUtil.getCurrentUser();
        genTable.setUpdateTime(new Date());
        genTable.setUpdateBy(currentUser.getUsername());
        genTableDao.updateSelective(genTable);
    }


    /**
     * 导入表结构
     *
     * @param tableList 导入表列表
     */
    @Override
    @Transactional
    public void importGenTable(List<GenTable> tableList){
        try{
            User currentUser = arsUtil.getCurrentUser();
            for (GenTable table : tableList){
                String tableName = table.getTableName();
                GenUtils.initTable(table,currentUser.getUsername());
                int row = genTableDao.save(table);
                if (row > 0){
                    // 保存列信息
                    List<GenTableColumn> genTableColumns = genTableColumnDao.selectDbTableColumnsByName(tableName);
                    for (GenTableColumn column : genTableColumns){
                        GenUtils.initColumnField(column, table);
                        column.setTableId(table.getTableId()+"");
                        genTableColumnDao.save(column);
                    }
                }
            }
        }
        catch (Exception e){
            throw new ArsException("导入失败：" + e.getMessage());
        }
    }

    @Override
    public void selectDbTableList(GenTable genTable, AjaxPageResponse<GenTable> page) {
        genTableDao.selectDbTableList(genTable,page);
    }

    @Override
    public Map<String, String> previewCode(Long tableId) {
        Map<String, String> dataMap = new LinkedHashMap<>();
        // 查询表信息
        GenTable table = genTableDao.findDetail(tableId);
        // 设置主键列信息
        setPkColumn(table);
        VelocityInitializer.initVelocity();

        VelocityContext context = VelocityUtils.prepareContext(table);
        setMenuInfo(context,table);

        // 获取模板列表
        List<String> templates = VelocityUtils.getTemplateList(table.getTplCategory());
        for (String template : templates){
            if(template.endsWith("sql.vm") && StringUtil.isEmpty(table.getParentMenuId())) {
                continue;
            }
            // 渲染模板
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate(template, Constants.CHARSETUTF8);
            tpl.merge(context, sw);
            dataMap.put(template, sw.toString());
        }
        return dataMap;
    }

    @Override
    public byte[] downloadCode(String tableName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        generatorCode(tableName, zip);
        IOUtils.closeQuietly(zip);
        return outputStream.toByteArray();
    }

    @Override
    public byte[] downloadCode(String[] tableNames) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        for (String tableName : tableNames){
            generatorCode(tableName, zip);
        }
        IOUtils.closeQuietly(zip);
        return outputStream.toByteArray();
    }

    /**
     * 查询表信息并生成代码
     */
    private void generatorCode(String tableName, ZipOutputStream zip){
        // 查询表信息
        GenTable table = genTableDao.selectGenTableByName(tableName);
        // 设置主键列信息
        setPkColumn(table);

        VelocityInitializer.initVelocity();

        VelocityContext context = VelocityUtils.prepareContext(table);
        setMenuInfo(context,table);

        // 获取模板列表
        List<String> templates = VelocityUtils.getTemplateList(table.getTplCategory());
        for (String template : templates){
            if(template.endsWith("sql.vm") && StringUtil.isEmpty(table.getParentMenuId())) {
                continue;
            }
            // 渲染模板
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate(template, Constants.CHARSETUTF8);
            tpl.merge(context, sw);
            try{
                // 添加到zip
                zip.putNextEntry(new ZipEntry(VelocityUtils.getFileName(template, table)));
                IOUtils.write(sw.toString(), zip, Constants.CHARSETUTF8);
                IOUtils.closeQuietly(sw);
                zip.flush();
                zip.closeEntry();
            }
            catch (IOException e){
                logger.error("渲染模板失败，表名：" + table.getTableName(), e);
            }
        }
    }

    private void setMenuInfo(VelocityContext context, GenTable table) {
        if(StringUtil.isNotEmpty(table.getParentMenuId())) {
            ModuleMenu moduleMenu = moduleMenuDao.findById(Long.parseLong(table.getParentMenuId()));
            context.put("parentMenuIds",moduleMenu.getParentIds());
            context.put("menuId",idWorker.nextId());
            context.put("viewMenuId",idWorker.nextId());
            context.put("addMenuId",idWorker.nextId());
            context.put("editMenuId",idWorker.nextId());
            context.put("removeMenuId",idWorker.nextId());
            context.put("exportMenuId",idWorker.nextId());
        }
    }

    /**
     * 设置主键列信息
     *
     * @param table 业务表信息
     */
    public void setPkColumn(GenTable table){
        for (GenTableColumn column : table.getColumns()){
            if (column.isPk()){
                table.setPkColumn(column);
                break;
            }
        }
        if (StringUtils.isNull(table.getPkColumn())){
            table.setPkColumn(table.getColumns().get(0));
        }
    }
}
