package com.bcxin.ars.service.certificate.impl;

import com.bcxin.ars.dao.certificate.TrainCertificateSnapshotDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.TrainCertificateSnapshot;
import com.bcxin.ars.service.certificate.TrainCertificateSnapshotService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * 培训公司快照保存Service层
 *
 * @author yyx
 * @Date 2020-04-24 16:23:31
 */
@Service
@Transactional
public class TrainCertificateSnapshotServiceImpl implements TrainCertificateSnapshotService {

    Logger logger = LoggerFactory.getLogger(TrainCertificateSnapshotServiceImpl.class);

    @Autowired
    private TrainCertificateSnapshotDao trainCertificateSnapshotDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
   


    @Override
    public int save(TrainCertificateSnapshot trainCertificateSnapshot) {
        User currentUser = arsUtil.getCurrentUser();
        if(trainCertificateSnapshot.getId() == null){
            trainCertificateSnapshot.setCreateTime(new Date());
        }else{
            TrainCertificateSnapshot dbQrcodeInfo = trainCertificateSnapshotDao.findByQrCodeId(trainCertificateSnapshot.getQrCodeId());
            BeanUtils.copyPropertiesIgnore(trainCertificateSnapshot,dbQrcodeInfo,true);
            BeanUtils.copyPropertiesIgnore(dbQrcodeInfo,trainCertificateSnapshot,false);
        }

        trainCertificateSnapshot.setActive(true);
        trainCertificateSnapshot.setUpdateBy(currentUser.getUsername());
        trainCertificateSnapshot.setUpdateTime(new Date());
        trainCertificateSnapshot.setUpdateflag(true);
        trainCertificateSnapshot.setAreaCode(currentUser.getPolice().getAreacode());
        return trainCertificateSnapshotDao.save(trainCertificateSnapshot);
    }

    @Override
    public TrainCertificateSnapshot findByQrCodeId(Long qrCodeId) {
        return trainCertificateSnapshotDao.findByQrCodeId(qrCodeId);
    }


    @Override
    public void importBatch(List<TrainCertificateSnapshot> list) {
        List<TrainCertificateSnapshot> dbList = trainCertificateSnapshotDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (TrainCertificateSnapshot trainCertificateSnapshot : list) {
                trainCertificateSnapshot.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        trainCertificateSnapshot.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, trainCertificateSnapshot.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            trainCertificateSnapshotDao.saveBatch(list);
        }
    }

    @Override
    public List<TrainCertificateSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return trainCertificateSnapshotDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<TrainCertificateSnapshot> findDSOutList(String startDate) {
        return trainCertificateSnapshotDao.findDSOutList(startDate);
    }

    @Override
    public List<TrainCertificateSnapshot> findByBatchId(List<TrainCertificateSnapshot> list) {
        return trainCertificateSnapshotDao.findByBatchId(list);
    }


}
