package com.bcxin.ars.service.approve.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.UserRoleDao;
import com.bcxin.ars.dao.approve.*;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.*;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.UserRole;
import com.bcxin.ars.model.approve.*;
import com.bcxin.ars.service.approve.ApproveAreaProcessService;
import com.bcxin.ars.service.util.ApprovalActivityUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author：wangcy @date：2018/01/22 0022 13:34 @description：
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ApproveAreaProcess.class,getMethodName = "updateFlagForOutToIn",getImportType = ImportType.BATCH)
public class ApproveAreaProcessServiceImpl implements ApproveAreaProcessService {

	private static final Logger logger = LoggerFactory.getLogger(ApproveAreaProcessServiceImpl.class);
	@Autowired
	private ApproveAreaProcessDao approveAreaProcessDao;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ApproveAreaProDetailDao approveAreaProDetailDao;

	@Autowired
	private ApproveAreaProDetailPerDao approveAreaProDetailPerDao;

	@Autowired
	private ApproveLinkProDetailDao approveLinkProDetailDao;

	@Autowired
	private ApproveLinkLevelDao approveLinkLevelDao;

	@Autowired
	private ApproveTempLinkRelaDao approveTempLinkRelaDao;

	@Autowired
	private ApproveTempProcessDao approveTempProcessDao;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private ApproveLinkDao approveLinkDao;

	@Autowired
	private ApproveTempDao approveTempDao;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private ConfigUtils configUtils;
	@Autowired
	private UserRoleDao userRoleDao;
	/**
	 * @Author: wangcy
	 * @Description:根据条件查询
	 * @Date: 2018/01/19 0019 15:31
	 */
	@Override
	public List<ApproveAreaProcessDto> search(ApproveAreaProcessDto approveAreaProcessDto) {
		return approveAreaProcessDao.search(approveAreaProcessDto);
	}

	/**
	 * @Author: wangcy
	 * @Description:修改或者查询
	 * @Date: 2018/01/19 0019 15:31
	 */
	@Override
	public String saveOrUpdate(ApproveAreaProcessDto approveAreaProcessDto) throws Exception {
		String failMsg = ""; // 错误消息
		User user = arsUtil.getCurrentUser();
		Long tempLinkRelaId = approveAreaProcessDto.getTempLinkRelaId();// 模板环节关联ID
		Long approveLinkLevelId = approveAreaProcessDto.getApproveLinkLevelId();// 审批环节层级Id
		String approveLevel = approveAreaProcessDto.getApproveLevel(); // 审批层级
		String linkName = "";// 环节名称
		List<ApproveAreaProDetailDto> approveAreaProDetailDtos = JSON
				.parseArray(approveAreaProcessDto.getApproveAreaProDetailDtoList(), ApproveAreaProDetailDto.class);// 审批人员列表
		List<ApproveTemp> allApproveTempList = new ArrayList<ApproveTemp>();// 模板列表
		List<ApproveTempLinkRela> allApproveTempLinkList = new ArrayList<ApproveTempLinkRela>();// 模板环节ID列表
		List<Long> approveLinkLevels = new ArrayList<Long>();// 审批环节层级ID列表
		String orgtype =approveAreaProcessDto.getApproveLevel();// 机构类型
		ApproveTempLinkRela curApproveTempLinkRela = approveTempLinkRelaDao.findById(tempLinkRelaId);
		Long linkId = curApproveTempLinkRela.getApproveLinkId();
		ApproveLink approveLink = approveLinkDao.findById(linkId);
		if (approveLink != null) {
			linkName = approveLink.getLinkName();
		}
		Long tempId = curApproveTempLinkRela.getApproveTempId();// 模板ID
		// 1、设置当前节点审批模板
		ApproveTemp curApproveTemp = new ApproveTemp();
		curApproveTemp = approveTempDao.findById(tempId);
		allApproveTempList.add(curApproveTemp);
		// 2、设置当前节点审批模板环节关联
		allApproveTempLinkList.add(curApproveTempLinkRela);
		// 3、设置当前节点审批环节层级
		approveLinkLevels.add(approveLinkLevelId);
		//审批角色
		Long roleid = 0l;
		if(curApproveTemp!=null) {
			//添加到审批人之后，默认增加审批角色
			if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_CONFESSCOMPANY)>=0) {
				roleid = 6L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_YEARREPORT)>=0) {
				roleid = 8L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_CROSSCOMPANY)>=0) {
				roleid = 5L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_LEGALCHANGE)>=0) {
				roleid = 7L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_SPONSORLICENSE)>=0) {
				roleid = 11L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_SUBSIDIARY)>=0) {
				roleid = 3L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY)>=0) {
				roleid = 2L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_CONFESSCOMPANYUNDO)>=0) {
				roleid = 10L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE)>=0) {
				roleid = 4L;
			}else if(curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_ARMTRAINORG)>=0) {
				roleid = 9L;
			}
		}
		if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {// 省级机构
			// 1、查出子模板列表
			List<ApproveTemp> approveTempCityList = approveTempDao.findByParentTempId(tempId);
			if (approveTempCityList != null && approveTempCityList.size() > 0) {
				List<ApproveTemp> deleteApproveTempCityList = new ArrayList<ApproveTemp>();
				for (ApproveTemp approveTempCity : approveTempCityList) {
					// 2、查出子模板环节关联列表
					ApproveTempLinkRela cityApproveTempLinkRela = approveTempLinkRelaDao.findByActiveTempAndLink(
							curApproveTempLinkRela.getApproveLinkId(), approveTempCity.getId());
					if (cityApproveTempLinkRela != null) {
						allApproveTempLinkList.add(cityApproveTempLinkRela);
						// 3、根据模板环节关联ID查出子模板审批环节层级ID集合
						List<ApproveLinkLevel> approveLinkLevelList = approveLinkLevelDao
								.findListTureByApproveLinkIdAndLevel(cityApproveTempLinkRela.getId(), approveLevel);
						if (approveLinkLevelList != null && approveLinkLevelList.size() > 0) {
							if (approveLinkLevelList.size() == 1) {
								approveLinkLevels.add(approveLinkLevelList.get(0).getId());
							} else {
								failMsg = "查找审批环节层次出现多条";
								logger.info(failMsg);
								return failMsg;
							}
						} else {
							failMsg = "查找不到审批环节层次信息";
							logger.info(failMsg);
							return failMsg;
						}
					} else {
						deleteApproveTempCityList.add(approveTempCity);
					}
				}
				if (deleteApproveTempCityList != null && deleteApproveTempCityList.size() > 0) {
					approveTempCityList.removeAll(deleteApproveTempCityList);
				}
				if (approveTempCityList != null) {
					allApproveTempList.addAll(approveTempCityList);
				}
			}
		}
		// 机构信息
		Police police = policeDao.findById(approveAreaProcessDto.getOrgId());

		// 循环设置各市审批人员安排
		if (allApproveTempList != null && allApproveTempList.size() > 0) {
			for (int index = 0; index < allApproveTempList.size(); index++) {
				approveLinkLevelId = approveLinkLevels.get(index);
				// 查询区域审批流程为不为空
				ApproveAreaProcess approveAreaProcess = approveAreaProcessDao
						.findByLinkLevelIdAndPoliceId(approveLinkLevelId, police.getId());
				if (approveAreaProcess == null) {
					approveAreaProcess = new ApproveAreaProcess();
					approveAreaProcess.setRegionId(police.getAreacode());
					approveAreaProcess.setPoliceId(police.getId());
					approveAreaProcess.setApproveLinkLevelId(approveLinkLevelId);
					approveAreaProcess.setApproveSetStatus(Constants.CONFIGURATION_NOT_CONFIGURED);
					approveAreaProcess.setActive(true);
					approveAreaProcess.setCreateTime(new Date());
					approveAreaProcess.setUpdateTime(new Date());
					approveAreaProcess.setRegionLevel(police.getOrgtype());
					approveAreaProcess.setPoliceCode(police.getCode());
					approveAreaProcess.setPath(police.getPath());
					approveAreaProcessDao.save(approveAreaProcess);
				} else {
					approveAreaProcess.setActive(true);
				}
				// 1无论有无新增都将区域审批流程明细和区域审批流程明细人员信息变为无效
				approveAreaProDetailDao.deleteDeatailAndPer(approveAreaProcess.getId(), user.getUsername());
				// 2新增区域审批流程明细和区域审批流程明细人员信息
				for (ApproveAreaProDetailDto approveAreaProDetailDto : approveAreaProDetailDtos) {
					// 2.1添加区域审批流程明细
					ApproveAreaProDetail approveAreaProDetail = new ApproveAreaProDetail();
					approveAreaProDetail.setCreateTime(new Date());
					approveAreaProDetail.setUpdateTime(new Date());
					approveAreaProDetail.setApproveRank(approveAreaProDetailDto.getApproveRank());
					approveAreaProDetail.setActive(true);
					approveAreaProDetail.setPositionName(approveAreaProDetailDto.getPositionName());
					approveAreaProDetail.setManyApproveRule(approveAreaProDetailDto.getManyApproveRule());
					approveAreaProDetail.setApproveAreaProId(approveAreaProcess.getId());
					approveAreaProDetailDao.save(approveAreaProDetail);
					// 2.2插入
					int i = 1; // 控制人员顺序
					List<ApproveAreaProDetailPer> approveAreaProDetailPerList = new ArrayList<>();
					//添加到审批人之后，默认增加审批角色
					List<UserRole> userRoleList = new ArrayList<>();
					for (String perId : approveAreaProDetailDto.getPerIds().split(",")) {
						ApproveAreaProDetailPer approveAreaProDetailPer = new ApproveAreaProDetailPer();
						approveAreaProDetailPer.setCreateTime(new Date());
						approveAreaProDetailPer.setUpdateTime(new Date());
						approveAreaProDetailPer.setApproveAreaProDetailId(approveAreaProDetail.getId());
						approveAreaProDetailPer.setApprovePerId(Long.parseLong(perId));
						approveAreaProDetailPer.setActive(true);
						approveAreaProDetailPer.setSeq(i++);
						approveAreaProDetailPerList.add(approveAreaProDetailPer);

						//添加到审批人之后，默认增加审批角色
						UserRole userRole = new UserRole();

						userRole.setActive(true);
						userRole.setCreateTime(new Date());
						userRole.setUpdateTime(new Date());
						userRole.setNativeCode(user.getNativeCode());
						userRole.setUpdateBy(user.getUsername());
						userRole.setUserid(Long.parseLong(perId));
						userRole.setRoleType(Constants.ROLETYPE_POLICEROLE);
						userRole.setRoleid(roleid);
						userRoleList.add(userRole);





					}
					if (approveAreaProDetailPerList.size() > 0) {
						approveAreaProDetailPerDao.batchSave(approveAreaProDetailPerList);
						//添加到审批人之后，默认增加审批角色
						userRoleDao.batchSave(userRoleList);
					}
				}

				Long tempLinkRelaIdChange = allApproveTempLinkList.get(index).getId();// 模板环节ID
				ApproveTemp approveTempChange = allApproveTempList.get(index);// 模板对象
				ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
				approveTempLinkRelaDto.setTempName(approveTempChange.getTempName());
				approveTempLinkRelaDto.setLinkName(linkName);
				if (approveTempChange != null) {
					approveTempChange.setApproveSetStatus(Constants.CONFIGURATION_CONFIGURED_DOING);
					approveTempDao.update(approveTempChange);
				}
				// 审批人员列表
				if (approveAreaProDetailDtos.size() > 0) {
					// 3如果区域审批流状态为未配置(用户新增配置流程，或者省级管理人员重置层次)
					if (StringUtil.equals(approveAreaProcess.getApproveSetStatus(),
							Constants.CONFIGURATION_NOT_CONFIGURED)) {
						ApproveTempLinkDto approveTempLink = new ApproveTempLinkDto();
						approveTempLink.setUpdateBy(user.getUsername());
						approveTempLink.setId(tempLinkRelaIdChange);
						approveTempLink.setPoliceId(police.getId());
						approveTempLink.setUpdateTime(new Date());
						approveLinkProDetailDao.deleteByApproveTempLinkIdAndPoliceId(approveTempLink);

						List<ApproveAreaProDetailDto> approveAreaProDetailDtoList = approveAreaProDetailDao
								.findListByapproveAreaProId(approveAreaProcess.getId());
						// 3.1修改区域审批流程配置状态
						approveAreaProcess.setApproveSetStatus(Constants.CONFIGURATION_CONFIGURED);
						Date date = new Date();
						approveAreaProcess.setProcessInfo(ApprovalActivityUtil.thirdJson(approveAreaProDetailDtoList,
								approveAreaProcess, police, approveTempLinkRelaDto));
						approveAreaProcess.setUpdateTime(date);
						approveAreaProcess.setEffectTime(date);
						approveAreaProcessDao.update(approveAreaProcess);
						List<ApproveProcessDto> allApproveProcessId = approveAreaProcessDao
								.findAllIdBypolice(police.getId(), tempLinkRelaIdChange);
						List<ApproveLinkProDetail> approveLinkProDetailList = new ArrayList<>();
						IdWorker idWorker = new IdWorker();
						for (ApproveProcessDto approveProcessDto : allApproveProcessId) {
							ApproveLinkProDetail approveLinkProDetail = new ApproveLinkProDetail();
							approveLinkProDetail.setId(idWorker.nextId());
							approveLinkProDetail.setActive(true);
							approveLinkProDetail.setCreateTime(new Date());
							approveLinkProDetail.setUpdateTime(new Date());
							approveLinkProDetail.setApproveAreaProId(approveProcessDto.getMinApproveAreaProcess());
							approveLinkProDetail.setTempLinkRelaId(tempLinkRelaIdChange);
							approveLinkProDetail.setRegionLevel(approveProcessDto.getMinRegionLevel());
							approveLinkProDetail.setRegionId(approveProcessDto.getMinRegionId());
							approveLinkProDetail.setPoliceCode(approveProcessDto.getMinPoliceCode());
							approveLinkProDetail.setPoliceId(approveProcessDto.getMinPoliceId());
							approveLinkProDetail.setProcessInfo(ApprovalActivityUtil.secondJson(approveProcessDto,
									approveLinkProDetail, approveTempLinkRelaDto));
							approveLinkProDetailList.add(approveLinkProDetail);
						}
						if (approveLinkProDetailList.size() > 0) {
							approveLinkProDetailDao.batchSave(approveLinkProDetailList);
						}
						// 查询该环节时候全部匹配完成
						approveLinkProDetailList = approveLinkProDetailDao.findByTempLinkRelaId(tempLinkRelaIdChange);
						List<ApproveAreaProcess> approveAreaProcesseList = approveAreaProcessDao
								.findByTempLinkRelaId(tempLinkRelaIdChange);
						if (approveLinkProDetailList.size() == approveAreaProcesseList.size()) {
							// 如果环节完成则将该环节的状态修改
							ApproveTempLinkRela approveTempLinkRela = approveTempLinkRelaDao
									.findById(tempLinkRelaIdChange);
							approveTempLinkRela.setLinkSetStatus(Constants.CONFIGURATION_CONFIGURED);
							approveTempLinkRela.setUpdateTime(new Date());
							approveTempLinkRela.setUpdateBy(user.getUsername());
							approveTempLinkRelaDao.update(approveTempLinkRela);
						}
					} else {
						List<ApproveAreaProDetailDto> approveAreaProDetailDtoList = approveAreaProDetailDao
								.findListByapproveAreaProId(approveAreaProcess.getId());
						approveAreaProcess.setProcessInfo(ApprovalActivityUtil.thirdJson(approveAreaProDetailDtoList,
								approveAreaProcess, police, approveTempLinkRelaDto));
						Date date = new Date();
						approveAreaProcess.setUpdateTime(date);
						approveAreaProcess.setEffectTime(date);
						approveAreaProcessDao.update(approveAreaProcess);
					}
				} else {
					// 将小流程状态未配置
					approveAreaProcess.setApproveSetStatus(Constants.CONFIGURATION_NOT_CONFIGURED);
					Date date = new Date();
					approveAreaProcess.setUpdateTime(date);
					approveAreaProcessDao.update(approveAreaProcess);
					// 将环节配置状态未配置
					ApproveTempLinkRela approveTempLinkRela = approveTempLinkRelaDao.findById(tempLinkRelaIdChange);
					approveTempLinkRela.setLinkSetStatus(Constants.CONFIGURATION_NOT_CONFIGURED);
					approveTempLinkRela.setUpdateTime(new Date());
					approveTempLinkRela.setUpdateBy(user.getUsername());
					approveTempLinkRelaDao.update(approveTempLinkRela);
				}
				// 生成并启动审批主流程(省级模板不启动审批主流程，市级模板才启动审批主流程)
				if (approveTempChange.getParentTempId() != null || Constants.BEIJING.equals(configUtils.getCurrentNative())) {
					failMsg = saveMainProcess(approveTempChange);
					logger.info(failMsg);
				}else if(Constants.GUANGXI.equals(configUtils.getCurrentNative())){
					if( approveTempChange.getTempCode().startsWith(Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY) || approveTempChange.getTempCode().startsWith(Constants.ACTIVITI_PROCESS_TRAINCHANGE)) {
						failMsg = saveMainProcess(approveTempChange);
						logger.info(failMsg);
					}
				}
			}
		}
		return failMsg;
	}

	@Override
	public String saveMainProcess(ApproveTemp approveTemp) throws Exception {
		// get审批流程配置ID
		Long approveTempId = approveTemp.getId();
		// 将配置信息全部改为无效
		approveTemp = approveTempDao.findById(approveTempId);
		// get流程名称
		String approveTempName = approveTemp.getTempName();
		// get唯一标识ID
		String tempCode = approveTemp.getTempCode();
		String businessTypeCode = "";

		String groupId = "";
		// 科长账号
		Config kzConfig = configDao.findByKey(Constants.KZZHID);
		if (kzConfig != null && StringUtil.isNotEmpty(kzConfig.getValue())) {
			groupId = kzConfig.getValue();
		}
		// 业务类型code
		if (tempCode.contains("-")) {
			businessTypeCode = BusinessType.getBusinessType(tempCode.split("-")[0]);
		}
		String maxApproveLevel = approveTempDao.getMaxApproveLevelByApproveTempId(approveTempId);
		String configMsg = ""; // 配置结果
		if (StringUtil.isNotEmpty(maxApproveLevel)) {
			User user = arsUtil.getCurrentUser();
			String orgtype = user.getPolice().getOrgtype(); // 当前机构类型
			String superAreaCode = ""; // 上级机构编码
			String superOrgtype = ""; // 上级机构类别

			Long policeId = user.getPolice().getId(); // 当前机构ID

			String areaCode = user.getPolice().getAreacode(); // 当前机构所在地区,地区只有6位
			if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
				// 省级
				areaCode = areaCode.substring(0, 2);
			} else if (orgtype.equals(Constants.POLICE_ORGTYPE_SHI)) {
				// 市级
				areaCode = areaCode.substring(0, 4);
				superAreaCode = areaCode.substring(0, 2) + "0000";
				superOrgtype = Constants.POLICE_ORGTYPE_SHENG;
			} else if (orgtype.equals(Constants.POLICE_ORGTYPE_QX)) {
				// 区县
				superAreaCode = areaCode.substring(0, 4) + "00";
				superOrgtype = Constants.POLICE_ORGTYPE_SHI;
			} else {
				// 派出所
				superAreaCode = areaCode;
				superOrgtype = Constants.POLICE_ORGTYPE_QX;
			}
			if (!orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
				/**
				 * 判断审批模板当前机构的所属上级机构是否都配置完成，如果未配置完成则不能启动主流程,省级机构除外
				 */
				CheckTempConfigDto checkDto = new CheckTempConfigDto();
				checkDto.setTempId(approveTempId);
				checkDto.setAreaCode(superAreaCode);
				checkDto.setOrgtype(superOrgtype);
				Long check = approveTempLinkRelaDao.checkTempConfigCompleteByOrgTypeAndCityCode(checkDto);
				if (check != null && check > 0) {
					configMsg = "模板环节上级机构未配置完成！";
					logger.info(configMsg);
					return configMsg;
				}
			}

			List<ApproveTempLinkRela> approveTempLinkRelaList = approveTempLinkRelaDao
					.findByApproveTempIdList(approveTempId);
			List<Police> policeList = new ArrayList<Police>();
			if (orgtype.equals(Constants.POLICE_ORGTYPE_PCS)) {
				// 派出所，只查询自己机构信息
				Police police = policeDao.findById(policeId);
				policeList.add(police);
			} else {
				// 非派出所，则取本级机构以及下属机构信息
				policeList = policeDao.findPoliceByOrgTypeAndLikeAreacode(maxApproveLevel, areaCode);
			}
			if (policeList != null && policeList.size() > 0) {
				List<ApproveTempProcess> approveTempProcessList = new ArrayList<>();
				for (Police police : policeList) {
					String[] policeIds = police.getPath().split("/");
					ApproveLinkProDetailDto searchDto = new ApproveLinkProDetailDto();
					searchDto.setPoliceIds(policeIds);
					List<ApproveTempLinkRelaDto> approveTempLinkRelaDtoList = new ArrayList<ApproveTempLinkRelaDto>();
					if (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0) {
						int tempLinkSize = approveTempLinkRelaList.size();
						for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
							Long tempLinkRelaId = approveTempLinkRela.getId();
							String approveLevel = approveLinkLevelDao
									.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);

							// 类型是1、报名确认， 2、缴费确认， 3、指纹获取，4、考试安排没有审批层次
							if (StringUtil.isEmpty(approveLevel)) {
								ApproveLink approveLink = approveLinkDao
										.findById(approveTempLinkRela.getApproveLinkId());
								if (approveLink != null) {
									/*
									 * 1、判断未设置环境是不是特殊节点：保安资格证特殊节点有报名确认、缴费确认、指纹获取
									 * 、考试安排。另外模板用到指派民警
									 * 2、如果不是特殊节点，则环境未配置地区则不启动整体流程
									 */
									if (StringUtils.isEmpty(approveLink.getLinkType())) {
										// 非特殊节点，则不启动整体流程
										configMsg = "审批流程未启动：存在未配置审批单位的审批环节";
										return configMsg;
									} else {
										// 特殊节点
										ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
										approveTempLinkRelaDto.setLinkName(approveLink.getLinkName());
										approveTempLinkRelaDto.setLinkType(approveLink.getLinkType());
										approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
									}
								}
							} else {
								searchDto.setTempLinkRelaId(tempLinkRelaId);
								searchDto.setApproveLevel(approveLevel);
								ApproveLinkProDetail pproveLinkProDetail = approveLinkProDetailDao
										.findListByTempLinkRelaIdAndPoliceIds(searchDto);
								if (pproveLinkProDetail != null) {
									ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
									approveTempLinkRelaDto = approveTempLinkRelaDao
											.findDtoById(pproveLinkProDetail.getTempLinkRelaId());
									approveTempLinkRelaDto.setApproveLinkProDetailId(pproveLinkProDetail.getId());
									approveTempLinkRelaDto
											.setApproveAreaProId(pproveLinkProDetail.getApproveAreaProId());
									approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
								} else {
									// 找不到流程配置信息则不继续循环，循环下一个机构
									break;
								}
							}
						}
						// 环节阶段都配置完成才可以启动主流程
						if (approveTempLinkRelaDtoList != null && approveTempLinkRelaDtoList.size() > 0
								&& tempLinkSize == approveTempLinkRelaDtoList.size()) {
							// 如果为保安服务公司年度报告备案要把最后流程的人员ID修改为annals
							if (businessTypeCode.equals(BusinessType.NDBG)) {
								List<ApproveAreaProcess> approveAreaProcessList = new ArrayList<ApproveAreaProcess>();
								ApproveAreaProcess approveAreaProcess = approveAreaProcessDao
										.findById(approveTempLinkRelaDtoList.get(approveTempLinkRelaDtoList.size() - 1)
												.getApproveAreaProId());
								if (approveAreaProcess != null) {
									approveAreaProcessList.add(approveAreaProcess);
								}
								if (approveTempLinkRelaDtoList.size() > 1) {
									approveAreaProcess = approveAreaProcessDao.findById(approveTempLinkRelaDtoList
											.get(approveTempLinkRelaDtoList.size() - 2).getApproveAreaProId());
									if (approveAreaProcess != null) {
										approveAreaProcessList.add(approveAreaProcess);
									}
								}
								ApprovalActivityUtil.thirdJsonUpdate(approveAreaProcessList);
							}
							ApproveTempProcess approveTempProcess = new ApproveTempProcess();
							approveTempProcess.setCreateTime(new Date());
							approveTempProcess.setUpdateTime(new Date());
							approveTempProcess.setActive(true);
							approveTempProcess.setApproveTempId(approveTempId);
							approveTempProcess.setRegionLevel(police.getOrgtype());
							approveTempProcess.setPoliceCode(StringUtil.isNotEmpty(police.getCode())?police.getCode().toString():"");
							approveTempProcess.setPoliceId(police.getId());
							String processID = tempCode + "-" + police.getId().toString();
							String processName = approveTempName + police.getOrgname();
							approveTempProcess.setProcessInfo(ApprovalActivityUtil.oneJson(approveTempLinkRelaDtoList,
									processID, processName, groupId));
							approveTempProcessList.add(approveTempProcess);
						}
					}
				}
				if (approveTempProcessList != null && approveTempProcessList.size() > 0) {
					approveTempProcessDao.batchSave(approveTempProcessList);
					ApproveTemp approveTempSave = approveTempDao.findById(approveTempId);
					approveTempSave.setEffectTime(new Date());
					approveTempSave.setUpdateTime(new Date());
					approveTempSave.setApproveSetStatus(Constants.CONFIGURATION_CONFIGURED);
					approveTempDao.update(approveTempSave);
				}
			} else {
				if (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0) {
					for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
						Long tempLinkRelaId = approveTempLinkRela.getId();
						String approveLevel = approveLinkLevelDao.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);
						// 类型是1、报名确认， 2、缴费确认， 3、指纹获取，4、考试安排没有审批层次
						if (StringUtil.isEmpty(approveLevel)) {
							ApproveLink approveLink = approveLinkDao.findById(approveTempLinkRela.getApproveLinkId());
							if (approveLink != null) {
								/*
								 * 1、判断未设置环境是不是特殊节点：保安资格证特殊节点有报名确认、缴费确认、指纹获取
								 * 、考试安排。另外模板用到指派民警 2、如果不是特殊节点，则环境未配置地区则不启动整体流程
								 */
								if (StringUtils.isEmpty(approveLink.getLinkType())) {
									// 非特殊节点，则不启动整体流程
									configMsg = "审批流程未启动：存在未配置审批单位的审批环节";
									return configMsg;
								}
							}
						}
					}
				}
			}
		} else {
			configMsg = "审批环节未配置";
		}
		return configMsg;
	}

	/**
	 * @Author: wangcy
	 * @Description:数据整合
	 * @Date: 2018/02/23 0023 16:48
	 */
	@Override
	public ApproveAreaProcessDataDto findDataDtoForDS() {
		ApproveAreaProcessDataDto approveAreaProcessDataDto = new ApproveAreaProcessDataDto();

		// 查询信息
		List<ApproveAreaProcess> approveAreaProcessList = approveAreaProcessDao.searchFromInToOutForExport();
		List<ApproveLinkLevel> approveLinkLevelList = approveLinkLevelDao.searchFromInToOutForExport();
		List<ApproveTempLinkRela> approveTempLinkRelaList = approveTempLinkRelaDao.searchFromInToOutForExport();

		approveAreaProcessDataDto.setApproveLinkLevelList(approveLinkLevelList);
		approveAreaProcessDataDto.setApproveAreaProcessList(approveAreaProcessList);
		approveAreaProcessDataDto.setApproveTempLinkRelaList(approveTempLinkRelaList);

		return approveAreaProcessDataDto;
	}

	@Override
	public List<ApproveOrgDto> findApproveOrgList(ApproveAreaProcessDto approveAreaProcess) {
		return approveAreaProcessDao.findApproveOrgList(approveAreaProcess);
	}

	@Override
	public List<ApproveOrgDto> findApproveOrgListBypoliceId(ApproveAreaProcessDto approveAreaProcess) {
		return approveAreaProcessDao.findApproveOrgListBypoliceId(approveAreaProcess);
	}

	@Override
	public Long getCountByTempCodeAndPoliceId(ApproveTempOrgDto approveTempOrgDto) {
		return approveAreaProcessDao.getCountByTempCodeAndPoliceId(approveTempOrgDto);
	}

	@Override
	public List<ApproveAreaProcessDto> searchProcess() {
		return approveAreaProcessDao.searchProcess();
	}

	@Override
	public void insertBatchTemp(List<ApproveAreaProcess> approveAreaProcessList) {
		approveAreaProcessDao.insertBatchTemp(approveAreaProcessList);
	}

	@Override
	public void startAllProcess() throws Exception{
		List<ApproveAreaProDetailDto> approveAreaProDetailDtoList = null;
		ApproveAreaProcess approveAreaProcess = null;
		Police police = null;
		ApproveTempLinkRela approveTempLinkRela = null;
		ApproveLink approveLink =null;
		List<ApproveProcessDto> approveProcessDtoList = null;
		String linkName = null;
		Date date = new Date();
		ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
		List<ApproveTemp> list = approveTempDao.findAll();
		for(ApproveTemp approveTemp : list){
			if(!approveTemp.getTempCode().startsWith(Constants.ACTIVITI_PROCESS_YEARREPORT_ARMED)){
				continue;
			}
			approveTempLinkRelaDto.setTempName(approveTemp.getTempName());

			List<ApproveLinkProDetail> approveLinkProDetailList = approveLinkProDetailDao.findListByTempId(approveTemp.getId());
			for(ApproveLinkProDetail approveLinkProDetail:approveLinkProDetailList){
				approveTempLinkRela = approveTempLinkRelaDao.findById(approveLinkProDetail.getTempLinkRelaId());
				approveLink = approveLinkDao.findById(approveTempLinkRela.getApproveLinkId());
				linkName = approveLink.getLinkName();
				approveTempLinkRelaDto.setLinkName(linkName);
				approveAreaProcess = approveAreaProcessDao.findById(approveLinkProDetail.getApproveAreaProId());
				if(approveAreaProcess == null || approveAreaProcess.getApproveSetStatus().equals(Constants.CONFIGURATION_NOT_CONFIGURED)){
					continue;
				}
				// 机构信息
				police = policeDao.findById(approveAreaProcess.getPoliceId());
				approveAreaProDetailDtoList = approveAreaProDetailDao.findListByapproveAreaProId(approveAreaProcess.getId());
				approveAreaProcess.setProcessInfo(ApprovalActivityUtil.thirdJson(approveAreaProDetailDtoList,
						approveAreaProcess, police, approveTempLinkRelaDto));
				approveAreaProcess.setUpdateTime(date);
				approveAreaProcess.setEffectTime(date);
				approveAreaProcessDao.update(approveAreaProcess);
				approveProcessDtoList = approveAreaProcessDao.findAllIdBypolice(police.getId(), approveTempLinkRela.getId());
				if(approveProcessDtoList != null && approveProcessDtoList.size() > 1){
					System.out.println(approveProcessDtoList.size());
				}
				for(ApproveProcessDto approveProcessDto : approveProcessDtoList){
					approveLinkProDetail.setProcessInfo(ApprovalActivityUtil.secondJson(approveProcessDto, approveLinkProDetail, approveTempLinkRelaDto));
					approveLinkProDetail.setUpdateTime(date);
					approveLinkProDetailDao.update(approveLinkProDetail);
				}
			}
			/**
			* 当前省份信息
			*/
			Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
			//北京直接启动流程
			if(provinceConfig!=null && Constants.BEIJING.equals(provinceConfig.getValue())){
				saveMainProcess(approveTemp);
			}else {
				// 生成并启动审批主流程(省级模板不启动审批主流程，市级模板才启动审批主流程)
				if (approveTemp.getParentTempId() != null) {
					saveMainProcess(approveTemp);
				}
			}
		}
	}

	@Override
	public List<ApproveAreaProcess> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return approveAreaProcessDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void updateFlagForOutToIn(List<ApproveAreaProcess> areaProcessList) {
		approveAreaProcessDao.updateFlagForOutToIn(areaProcessList);
	}

}