package com.bcxin.ars.service.appeal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/***
 * 资格证结果处理
 * @author subh
 */
@Service
public class PersoncertificateAppealHandle  implements AppealHandle {

    private static Logger logger = LoggerFactory.getLogger(PersoncertificateAppealHandle.class);

    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;

    @Autowired
    private ConfigUtils configUtils;
    @Override
    public void handle(Appeal appeal) {
        //获取保安员资格证信息
        Personcertificate personcertificate=  personcertificateDao.findById(appeal.getBusinessid());
        if(Constants.APPROVALSTATE_TG.equals(appeal.getAppealState())){
            //审批状态设置为审批中
            personcertificate.setApprovalstate(Constants.APPROVALSTATE_SHZ);
            if(Constants.BEIJING.equals(configUtils.getCurrentNative()) ||
                    Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                //北京 背景筛查设置为申诉通过
                personcertificate.setCensorStatus(Constants.CENSORSTATUS_APPEAL_PASS);
            }else {
                //背景筛查设置为通过
                personcertificate.setCensorStatus(Constants.CENSORSTATUS_PASS);
            }
            //审批原因设置为空
            personcertificate.setApprovalreason(null);
            //更新最新时间
            personcertificate.setUpdateTime(new Date());
        }else if(Constants.APPROVALSTATE_BTG.equals(appeal.getAppealState())){
            //审批状态设置为不通过
            personcertificate.setApprovalstate(Constants.APPROVALSTATE_BTG);
            if(Constants.BEIJING.equals(configUtils.getCurrentNative()) ||
                    Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                //北京 背景筛查设置为申诉不通过
                personcertificate.setCensorStatus(Constants.CENSORSTATUS_APPEAL_UNPASS);
            }else {
                //背景筛查设置为不通过
                personcertificate.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
            }
            //审批原因
            personcertificate.setApprovalreason(appeal.getAppealReson());
            //更新最新时间
            personcertificate.setUpdateTime(new Date());
        }
        personcertificateDaoAop.update(personcertificate);

        if (!configUtils.getCurrentNative().equals(Constants.SHANGXI)){
            syncToBKT(personcertificate);
        }else if (personcertificate.getCity().equals(Constants.YANAN)||
                personcertificate.getCity().equals(Constants.SHANGLUO)){
            syncToBKT(personcertificate);
        }


    }
    public void syncToBKT(Personcertificate personcertificate){
        JSONArray paramArr = new JSONArray();
        JSONObject param = new JSONObject();
        param.put("qualifyApplyId", personcertificate.getId()+"");
        param.put("backgroundStatus", personcertificate.getCensorStatus());
        param.put("approvalState", personcertificate.getApprovalstate());
        param.put("backgroundFailReason", personcertificate.getApprovalreason());
        /**
         * 背景筛查类型
         * 1. 系统自动比对
         * 2. 申诉通道
         */
        param.put("backgroundType", Constants.BACKGROUNDTYPE_APPEAL);
        paramArr.add(param);

        //TODO 背景筛查结果同步给百课堂

        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("personList", JSON.toJSONString(paramArr));
        AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_PERSONQUALIFY_CENSOR_URL,paramMap);
        if(!result.isSuccessful()){
            logger.error("【资格证报名申诉结果】"+result.getMsg());
        }
    }

    @Override
    public void handle(List<Appeal> list) {
        if(list != null && list.size() >0) {
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            List<Personcertificate> personcertificateList = new ArrayList<>();
            for (Appeal appeal : list) {
                this.handle(appeal);
                //获取等级证报名信息
                Personcertificate personcertificate=  personcertificateDao.findById(appeal.getBusinessid());
                if(Constants.APPROVALSTATE_TG.equals(appeal.getAppealState())){
                    //审批状态设置为审批中
                    personcertificate.setApprovalstate(Constants.APPROVALSTATE_SHZ);
                    if(Constants.BEIJING.equals(configUtils.getCurrentNative())
                            ||Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                        //北京 背景筛查设置为申诉通过
                        personcertificate.setCensorStatus(Constants.CENSORSTATUS_APPEAL_PASS);
                    }else {
                        //背景筛查设置为通过
                        personcertificate.setCensorStatus(Constants.CENSORSTATUS_PASS);
                    }
                    //审批原因设置为空
                    personcertificate.setApprovalreason(null);
                    //更新最新时间
                    personcertificate.setUpdateTime(new Date());
                }else if(Constants.APPROVALSTATE_BTG.equals(appeal.getAppealState())){
                    //审批状态设置为不通过
                    personcertificate.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    if(Constants.BEIJING.equals(configUtils.getCurrentNative())
                            ||Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                        //北京 背景筛查设置为申诉不通过
                        personcertificate.setCensorStatus(Constants.CENSORSTATUS_APPEAL_UNPASS);
                    }else {
                        //背景筛查设置为不通过
                        personcertificate.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
                    }
                    //审批原因
                    personcertificate.setApprovalreason(appeal.getAppealReson());
                    //更新最新时间
                    personcertificate.setUpdateTime(new Date());
                }


                param = new JSONObject();
                param.put("qualifyApplyId", personcertificate.getId()+"");
                param.put("backgroundStatus", personcertificate.getCensorStatus());
                param.put("approvalState", personcertificate.getApprovalstate());
                param.put("backgroundFailReason", personcertificate.getApprovalreason());
                /**
                 * 背景筛查类型
                 * 1. 系统自动比对
                 * 2. 申诉通道
                 */
                param.put("backgroundType", Constants.BACKGROUNDTYPE_APPEAL);

                if (!configUtils.getCurrentNative().equals(Constants.SHANGXI)){
                    paramArr.add(param);
                }else if (personcertificate.getCity().equals(Constants.YANAN)||
                        personcertificate.getCity().equals(Constants.SHANGLUO)){
                    paramArr.add(param);
                }

                //更新
                personcertificateList.add(personcertificate);
            }


            if (paramArr.size()>0){
                //TODO 背景筛查结果同步给百课堂
                Map<String,Object> paramMap = new HashMap<>();
                paramMap.put("personList", JSON.toJSONString(paramArr));
                AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_PERSONQUALIFY_CENSOR_URL,paramMap);
                if(!result.isSuccessful()){
                    logger.error("【资格证报名申诉结果】"+result.getMsg());
                }
            }


            personcertificateDaoAop.updateBatch(personcertificateList);
        }
    }
}
