package com.bcxin.ars.aspect;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Date;

@Component
@Aspect
public class JobLogAspect {
    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(JobLogAspect.class);

    @Autowired
    private JobRunLogService jobRunLogService;

    @Around("@annotation(com.abcxin.smart.validator.annotation.JobLogAnnotation)")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        JobRunLog log = new JobRunLog();
        log.setCreateTime(new Date());
        log.setActive(true);
        log.setUpdateBy("JobLogAspect");
        //前置增强开始
        Signature sig = pjp.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            logger.error("该注解只能用于方法");
            return pjp.proceed();
        }
        msig = (MethodSignature) sig;
        Object target = pjp.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        JobLogAnnotation annotation = currentMethod.getAnnotation(JobLogAnnotation.class);
        //开始时间
        long startTime = System.currentTimeMillis();
        //执行方法
        Object obj = null;
        try {
            obj = pjp.proceed();
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            log.setExceptionMsg(e.toString());
        }
        //结束时间
        long endTime = System.currentTimeMillis();
        log.setUpdateTime(new Date());
        log.setJobName(annotation.getJobClazz().getName());
        log.setRunTime(new Date());
        log.setRunTimeLength((endTime - startTime) + "ms");
        jobRunLogService.insert(log);
        return obj;
    }

}
