/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.nx.NXIntegratedBaseDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.ShareholderDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.dto.nx.NXIntegratedBaseDto;
import com.bcxin.ars.dto.nx.UpProAccept;
import com.bcxin.ars.dto.nx.UpProMaterial;
import com.bcxin.ars.dto.nx.UpProProcess;
import com.bcxin.ars.dto.nx.UpProResult;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompany;
import com.bcxin.ars.model.sb.Crosscompany;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sb.Shareholder;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.util.MD5Util;
import com.bcxin.ars.util.StringUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NXIntegratedInterfaceUtil {
    private static final Logger logger = LoggerFactory.getLogger(NXIntegratedInterfaceUtil.class);
    @Value(value="${nx_integrated_clientId}")
    private String clientId;
    @Value(value="${nx_integrated_password}")
    private String password;
    @Value(value="${nx_integrated_url}")
    private String url;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private ShareholderDao shareholderDao;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalLogDao approvalLogDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private NXIntegratedBaseDao nxIntegratedBaseDao;

    private String getMaterialName(String templateRar) {
        if (StringUtil.isEmpty((String)templateRar)) {
            return "";
        }
        String[] split = templateRar.split("\\/");
        String lastName = split[split.length - 1];
        return lastName;
    }

    private String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date == null) {
            return "";
        }
        return dateFormat.format(date);
    }

    private String getResultType(String approvalstate) {
        String str = "";
        str = approvalstate.equals("003") ? "1" : (approvalstate.equals("004") ? "0" : (approvalstate.equals("005") ? "2" : (approvalstate.equals("005") ? "3" : "2")));
        return str;
    }

    private String getProcessName(String approvalstate) {
        if (approvalstate.equals("")) {
            return "\u53d7\u7406";
        }
        return "\u529e\u7ed3";
    }

    private String getEventName(String approvalstate) {
        String str = "";
        str = approvalstate.equals("003") ? "1" : (approvalstate.equals("004") ? "2" : "9");
        return str;
    }

    private List<ApprovalLog> getApprovalLog(String id) {
        return this.approvalLogDao.findByApprovalId(id);
    }

    private Date getPromiseDate(Date createTime, String s) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(createTime);
        if (s.equals("001")) {
            ((Calendar)calendar).add(5, 10);
        } else if (s.equals("002")) {
            ((Calendar)calendar).add(5, 10);
        } else if (s.equals("003")) {
            ((Calendar)calendar).add(5, 5);
        } else if (s.equals("004")) {
            ((Calendar)calendar).add(5, 10);
        } else if (s.equals("005")) {
            ((Calendar)calendar).add(5, 7);
        } else if (s.equals("006")) {
            ((Calendar)calendar).add(5, 5);
        } else if (s.equals("007")) {
            ((Calendar)calendar).add(5, 10);
        }
        return calendar.getTime();
    }

    private String getCompanyCode(String sid) {
        List shareholders = this.shareholderDao.findBySId(sid);
        if (shareholders.size() > 0) {
            return ((Shareholder)shareholders.get(0)).getSocialCode();
        }
        return "";
    }

    private String ApplyerPageType(Integer i) {
        String str = "";
        if (i == 4) {
            str = "111";
        } else if (i == 2) {
            str = "003";
        }
        return str;
    }

    public String getApplyerType(Integer i) {
        String str = "";
        if (i == 4) {
            str = "1";
        } else if (i == 2) {
            str = "2";
        }
        return str;
    }

    public String getPoliceName(Long i) {
        return this.policeDao.findById(i).getOrgname();
    }

    public String getProjectNo(String bh) {
        int num = this.personcertificateDao.getNextVal(bh);
        return String.format("%04d", num);
    }

    public void pushAllSponsorlicense(List<Sponsorlicense> sponsorlicenses, String businessType) {
        logger.error("\u5b81\u590f\u4e00\u4f53\u5316\u5f00\u59cb\u4f20\u6570\u636e\uff0c\u7528\u6237\u540d" + this.clientId + "\uff0c\u5bc6\u7801\uff1a" + this.password + "\uff0c\u5730\u5740\uff1a" + this.url);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clientId", this.clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        for (Sponsorlicense sponsorlicense : sponsorlicenses) {
            try {
                String time = System.currentTimeMillis() + "";
                params.put("timespan", time);
                params.put("sign", MD5Util.encode((String)(this.clientId + "|" + this.password + "|" + time)));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                ArrayList<UpProMaterial> upProMaterials = new ArrayList<UpProMaterial>();
                ArrayList<UpProProcess> upProProcesses = new ArrayList<UpProProcess>();
                ArrayList upProsPecialProcedures = new ArrayList();
                String createDate = this.formatDate(sponsorlicense.getCreateTime());
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType("2");
                User user = this.userDao.findById(sponsorlicense.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(sponsorlicense.getLegalPersonNo() + "");
                upProAccept.setApplyerPageType(this.ApplyerPageType(user.getPlatform()));
                upProAccept.setApplyerType(this.getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(sponsorlicense.getDistrict() + "000000");
                upProAccept.setCatalogCode("000109001000");
                upProAccept.setCdOperation("I");
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(sponsorlicense.getPhone() + "");
                upProAccept.setDataSource("zzqgat_bafwjgxxxt");
                upProAccept.setEnterpriseName(sponsorlicense.getCompanyname() + "");
                upProAccept.setIsItemBase("0");
                upProAccept.setLocalCatalogCode("000109001000");
                upProAccept.setLocalItemCode("2b8bae2e2c8f4ae280fffc7fd7ff76ee");
                upProAccept.setLocalProjectNo("2b8bae2e2c8f4ae280fffc7fd7ff76ee");
                upProAccept.setLocalTaskCode("2b8bae2e2c8f4ae280fffc7fd7ff76ee");
                upProAccept.setOrgCode(this.getSponsorlicenseOrgCode(sponsorlicense.getCity()));
                upProAccept.setOrgName(this.getPoliceName(sponsorlicense.getOrgid()));
                String da = dFormat.format(sponsorlicense.getCreateTime());
                String ta = this.getProjectNo("seq_yth001");
                upProAccept.setProjectNo("64" + this.getSponsorlicenseTaskCode(sponsorlicense.getCity()) + da + ta);
                upProAccept.setProjectType("2");
                upProAccept.setPromiseDate(this.formatDate(this.getPromiseDate(sponsorlicense.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime("10");
                upProAccept.setRowGuid(sponsorlicense.getId() + "");
                upProAccept.setTaskCode(this.getSponsorlicenseTaskCode(sponsorlicense.getCity()));
                upProAccept.setTaskName("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bbe\u7acb\u8bb8\u53ef");
                upProAccept.setTaskVersion("1");
                upProAccept.setTaskHandleItem(this.getSponsorlicenseTaskCode(sponsorlicense.getCity()) + "01");
                upProAccept.setCompanyCode(this.getCompanyCode(sponsorlicense.getId().toString()));
                upProAccept.setHandleUserId(sponsorlicense.getUserid().toString());
                upProAccept.setFileId(this.getSponsorlicenseFileId(sponsorlicense.getCity()));
                String handleUserName = "\u6682\u65e0\u5ba1\u6279\u4eba";
                List<ApprovalLog> logList = this.getApprovalLog(sponsorlicense.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation("I");
                    upProProcess.setCdTime(this.formatDate(approvalLog.getCreateTime()));
                    upProProcess.setDataSource("zzqgat_bafwjgxxxt");
                    upProProcess.setEventEndTime(this.formatDate(approvalLog.getApprovaldate()));
                    upProProcess.setEventName(this.getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(this.formatDate(approvalLog.getCreateTime()));
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName = approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(this.getProcessName("" + approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo("64" + this.getSponsorlicenseTaskCode(sponsorlicense.getCity()) + da + ta);
                    upProProcess.setIsNeedService("1");
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }
                Approval approval = this.approvalDAO.findBybusinessidAndType(sponsorlicense.getId(), businessType);
                upProResult.setCdOperation("I");
                upProResult.setCdTime(this.formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource("zzqgat_bafwjgxxxt");
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults("0");
                upProResult.setProjectNo("64" + this.getSponsorlicenseTaskCode(sponsorlicense.getCity()) + da + ta);
                upProResult.setRemark("\u65e0");
                upProResult.setResultDate(this.formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(this.getResultType(approval.getApprovalstate()) + "");
                upProResult.setRowGuid(approval.getId().toString() + "");
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation("I");
                upProMaterial.setCdTime(this.formatDate(sponsorlicense.getCreateTime()) + "");
                upProMaterial.setDataSource("zzqgat_bafwjgxxxt");
                upProMaterial.setGetType("2");
                upProMaterial.setMaterialAttachName("\u65e0");
                upProMaterial.setMaterialName(this.getMaterialName(sponsorlicense.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64" + this.getSponsorlicenseTaskCode(sponsorlicense.getCity()) + da + ta);
                upProMaterial.setRowGuid(sponsorlicense.getId().toString() + "");
                upProMaterial.setUrl(sponsorlicense.getTemplateRar() + "");
                upProMaterial.setRemark("\u65e0");
                upProMaterials.add(upProMaterial);
                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = "";
                CloseableHttpClient httpClient = HttpClients.createDefault();
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    httpClient = HttpClients.createDefault();
                    HttpPost httpPost = new HttpPost(this.url + "/docking/tskSum/uploadTask");
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity((HttpEntity)requestEntity);
                    result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("" + sponsorlicense.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject((String)result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(sponsorlicense.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    continue;
                }
                logger.error("sponsorlicense" + sponsorlicense.getId() + "params:" + params);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getSponsorlicenseFileId(String city) {
        String str = "";
        str = city.equals("640100") ? "f740356d-9524-4828-9210-72417ca394ea" : (city.equals("640200") ? "ac53c20b-e3fa-4418-9c98-e0e378818b0c" : (city.equals("640300") ? "bc1f9ea6-833d-4969-ab6e-e09f5c1fb60f" : (city.equals("640400") ? "4d3e0ed1-7649-4e91-889d-18ab860c415b" : (city.equals("640500") ? "1c06cc84-34c5-40d2-bd82-d39e8feabae3" : "9358e436-b70a-4ec4-be4e-7a36ed833ccf"))));
        return str;
    }

    private String getSponsorlicenseTaskCode(String city) {
        String str = "";
        str = city.equals("640100") ? "1164010001008624XE3000109001000" : (city.equals("640200") ? "1164020001010727453000109001000" : (city.equals("640300") ? "11642100010127021E3000109001000" : (city.equals("640400") ? "1164220001015940213000109001000" : (city.equals("640500") ? "1164230001014477X63000109001000" : "11640000010065393W2000109001000"))));
        return str;
    }

    private String getSponsorlicenseOrgCode(String city) {
        String str = "";
        str = city.equals("640100") ? "1164010001008624XE" : (city.equals("640200") ? "116402000101072745" : (city.equals("640300") ? "11642100010127021E" : (city.equals("640400") ? "116422000101594021" : (city.equals("640500") ? "1164230001014477X6" : "11640000010065393W"))));
        return str;
    }

    public void pushAllTraincompanyapply(List<Traincompanyapply> traincompanyapplies, String businessType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clientId", this.clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        for (Traincompanyapply traincompanyapply : traincompanyapplies) {
            try {
                String time = System.currentTimeMillis() + "";
                params.put("timespan", time);
                params.put("sign", MD5Util.encode((String)(this.clientId + "|" + this.password + "|" + time)));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                ArrayList<UpProMaterial> upProMaterials = new ArrayList<UpProMaterial>();
                ArrayList<UpProProcess> upProProcesses = new ArrayList<UpProProcess>();
                ArrayList upProsPecialProcedures = new ArrayList();
                String createDate = this.formatDate(traincompanyapply.getCreateTime());
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType("2");
                User user = this.userDao.findById(traincompanyapply.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(traincompanyapply.getLegalcode() + "");
                upProAccept.setApplyerPageType(this.ApplyerPageType(user.getPlatform()));
                upProAccept.setApplyerType(this.getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(traincompanyapply.getDistrict() + "000000");
                upProAccept.setCatalogCode("000109003000");
                upProAccept.setCdOperation("I");
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(traincompanyapply.getLegalphone() + "");
                upProAccept.setDataSource("zzqgat_bafwjgxxxt");
                upProAccept.setEnterpriseName(traincompanyapply.getCompanyname() + "");
                upProAccept.setIsItemBase("0");
                upProAccept.setLocalCatalogCode("000109003000");
                upProAccept.setLocalItemCode("752d3b8d4b49481e8ebd8f7dabd3d030");
                upProAccept.setLocalProjectNo("752d3b8d4b49481e8ebd8f7dabd3d030");
                upProAccept.setLocalTaskCode("752d3b8d4b49481e8ebd8f7dabd3d030");
                upProAccept.setOrgCode("1164230001014477X6");
                upProAccept.setOrgName(this.getPoliceName(traincompanyapply.getOrgid()) + "");
                String da = dFormat.format(traincompanyapply.getCreateTime());
                String ta = this.getProjectNo("seq_yth002");
                upProAccept.setProjectNo("641164230001014477X63000109003000" + da + ta);
                upProAccept.setProjectType("2");
                upProAccept.setPromiseDate(this.formatDate(this.getPromiseDate(traincompanyapply.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime("10");
                upProAccept.setRowGuid(traincompanyapply.getId() + "");
                upProAccept.setTaskCode("1164230001014477X63000109003000");
                upProAccept.setTaskName("\u8bbe\u7acb\u4fdd\u5b89\u57f9\u8bad\u5355\u4f4d\u5ba1\u6279");
                upProAccept.setTaskVersion("1");
                upProAccept.setTaskHandleItem("1164230001014477X6300010900300001");
                upProAccept.setCompanyCode(traincompanyapply.getBusinessnumber() + "");
                upProAccept.setHandleUserId(traincompanyapply.getUserid().toString() + "");
                upProAccept.setFileId("23065a8a-2442-4754-8e4c-efc78aaa9534");
                String handleUserName = "\u6682\u65e0\u5ba1\u6279\u4eba";
                List<ApprovalLog> logList = this.getApprovalLog(traincompanyapply.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation("I");
                    upProProcess.setCdTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource("zzqgat_bafwjgxxxt");
                    upProProcess.setEventEndTime(this.formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(this.getEventName(approvalLog.getApprovalstate()) + "");
                    upProProcess.setEventStartTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName = approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(this.getProcessName("" + approvalLog.getApprovalstate()) + "");
                    upProProcess.setProjectNo("641164230001014477X63000109003000" + da + ta);
                    upProProcess.setIsNeedService("1");
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }
                Approval approval = this.approvalDAO.findBybusinessidAndType(traincompanyapply.getId(), businessType);
                upProResult.setCdOperation("I");
                upProResult.setCdTime(this.formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource("zzqgat_bafwjgxxxt");
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults("0");
                upProResult.setProjectNo("641164230001014477X63000109003000" + da + ta);
                upProResult.setRemark("\u65e0");
                upProResult.setResultDate(this.formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(this.getResultType(approval.getApprovalstate()) + "");
                upProResult.setRowGuid(approval.getId().toString() + "");
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation("I");
                upProMaterial.setCdTime(this.formatDate(traincompanyapply.getCreateTime()) + "");
                upProMaterial.setDataSource("zzqgat_bafwjgxxxt");
                upProMaterial.setGetType("2");
                upProMaterial.setMaterialAttachName("\u65e0");
                upProMaterial.setMaterialName(this.getMaterialName(traincompanyapply.getTemplateRar()) + "");
                upProMaterial.setProjectNo("641164230001014477X63000109003000" + da + ta);
                upProMaterial.setRowGuid(traincompanyapply.getId().toString() + "");
                upProMaterial.setUrl(traincompanyapply.getTemplateRar() + "");
                upProMaterial.setRemark("\u65e0");
                upProMaterials.add(upProMaterial);
                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = "";
                CloseableHttpClient httpClient = HttpClients.createDefault();
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    httpClient = HttpClients.createDefault();
                    HttpPost httpPost = new HttpPost(this.url + "/docking/tskSum/uploadTask");
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity((HttpEntity)requestEntity);
                    result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("traincompanyapply" + traincompanyapply.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject((String)result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(traincompanyapply.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    continue;
                }
                logger.error("traincompanyapply" + traincompanyapply.getId() + "params:" + params);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void pushAllSubsidiary(List<Subsidiary> subsidiaries, String businessType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clientId", this.clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        for (Subsidiary subsidiary : subsidiaries) {
            try {
                String time = System.currentTimeMillis() + "";
                params.put("timespan", time);
                params.put("sign", MD5Util.encode((String)(this.clientId + "|" + this.password + "|" + time)));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                ArrayList<UpProMaterial> upProMaterials = new ArrayList<UpProMaterial>();
                ArrayList<UpProProcess> upProProcesses = new ArrayList<UpProProcess>();
                ArrayList upProsPecialProcedures = new ArrayList();
                String createDate = this.formatDate(subsidiary.getCreateTime());
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType("2");
                User user = this.userDao.findById(subsidiary.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(subsidiary.getLegalcardnumber() + "");
                upProAccept.setApplyerPageType(this.ApplyerPageType(user.getPlatform()));
                upProAccept.setApplyerType(this.getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(subsidiary.getDistrict() + "000000");
                upProAccept.setCatalogCode("641009005001");
                upProAccept.setCdOperation("I");
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(subsidiary.getLegalphone() + "");
                upProAccept.setDataSource("zzqgat_bafwjgxxxt");
                upProAccept.setEnterpriseName(subsidiary.getCompanyname() + "");
                upProAccept.setIsItemBase("0");
                upProAccept.setLocalCatalogCode("641009005001");
                upProAccept.setLocalItemCode("14b4895679324600aac16836a9115557");
                upProAccept.setLocalProjectNo("14b4895679324600aac16836a9115557");
                upProAccept.setLocalTaskCode("14b4895679324600aac16836a9115557");
                upProAccept.setOrgCode(this.getSubsidiaryOrgCode(subsidiary.getCity()));
                upProAccept.setOrgName(this.getPoliceName(subsidiary.getOrgid()) + "");
                String da = dFormat.format(subsidiary.getCreateTime());
                String ta = this.getProjectNo("seq_yth003");
                upProAccept.setProjectNo("64" + this.getSubsidiaryTaskCode(subsidiary.getCity()) + da + ta);
                upProAccept.setProjectType("2");
                upProAccept.setPromiseDate(this.formatDate(this.getPromiseDate(subsidiary.getCreateTime(), businessType)));
                upProAccept.setPromiseTime("8");
                upProAccept.setRowGuid(subsidiary.getId() + "");
                upProAccept.setTaskCode(this.getSubsidiaryTaskCode(subsidiary.getCity()));
                upProAccept.setTaskName("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bbe\u7acb\u5206\u516c\u53f8\u3001\u81ea\u884c\u62db\u7528\u4fdd\u5b89\u5458\u5907\u6848");
                upProAccept.setTaskVersion("1");
                upProAccept.setTaskHandleItem(this.getSubsidiaryTaskHandleItem(subsidiary.getCity()));
                upProAccept.setCompanyCode(subsidiary.getCreditcode() + "");
                upProAccept.setHandleUserId(subsidiary.getUserid().toString());
                upProAccept.setFileId(this.getSubsidiaryFileId(subsidiary.getCity()));
                String handleUserName = "\u6682\u65e0\u5ba1\u6279\u4eba";
                List<ApprovalLog> logList = this.getApprovalLog(subsidiary.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation("I");
                    upProProcess.setCdTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource("zzqgat_bafwjgxxxt");
                    upProProcess.setEventEndTime(this.formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(this.getEventName(approvalLog.getApprovalstate()) + "");
                    upProProcess.setEventStartTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName = approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(this.getProcessName("" + approvalLog.getApprovalstate()) + "");
                    upProProcess.setProjectNo("64" + this.getSubsidiaryTaskCode(subsidiary.getCity()) + da + ta);
                    upProProcess.setIsNeedService("1");
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }
                Approval approval = this.approvalDAO.findBybusinessidAndType(subsidiary.getId(), businessType);
                upProResult.setCdOperation("I");
                upProResult.setCdTime(this.formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource("zzqgat_bafwjgxxxt");
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults("0");
                upProResult.setProjectNo("64" + this.getSubsidiaryTaskCode(subsidiary.getCity()) + da + ta);
                upProResult.setRemark("\u65e0");
                upProResult.setResultDate(this.formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(this.getResultType(approval.getApprovalstate()) + "");
                upProResult.setRowGuid(approval.getId().toString() + "");
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation("I");
                upProMaterial.setCdTime(this.formatDate(subsidiary.getCreateTime()) + "");
                upProMaterial.setDataSource("zzqgat_bafwjgxxxt");
                upProMaterial.setGetType("2");
                upProMaterial.setMaterialAttachName("\u65e0");
                upProMaterial.setMaterialName(this.getMaterialName(subsidiary.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64" + this.getSubsidiaryTaskCode(subsidiary.getCity()) + da + ta);
                upProMaterial.setRowGuid(subsidiary.getId().toString() + "");
                upProMaterial.setUrl(subsidiary.getTemplateRar() + "");
                upProMaterial.setRemark("\u65e0");
                upProMaterials.add(upProMaterial);
                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = "";
                CloseableHttpClient httpClient = HttpClients.createDefault();
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    httpClient = HttpClients.createDefault();
                    HttpPost httpPost = new HttpPost(this.url + "/docking/tskSum/uploadTask");
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity((HttpEntity)requestEntity);
                    result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("subsidiary" + subsidiary.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject((String)result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(subsidiary.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    continue;
                }
                logger.error("subsidiary" + subsidiary.getId() + "params:" + params);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getSubsidiaryFileId(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "af3ea75d-5414-4344-acf7-54e934466b86";
        } else if (city.equals("640200")) {
            str = "c8592fc9-03d5-4102-91bb-06f8e2674bde";
        } else if (city.equals("640300")) {
            str = "7002c6a3-03bc-4cba-ae49-8ae48841468d";
        } else if (city.equals("640400")) {
            str = "b2e7e429-038d-4b8e-9b8a-2731c2bc15a8";
        } else if (city.equals("640500")) {
            str = "75281298-b5a2-400d-93e9-0fa915e5d78e";
        }
        return str;
    }

    private String getSubsidiaryTaskHandleItem(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE364100900500101";
        } else if (city.equals("640200")) {
            str = "116402000101072745364100900500101";
        } else if (city.equals("640300")) {
            str = "11642100010127021E364100900500101";
        } else if (city.equals("640400")) {
            str = "116422000101594021364100900500101";
        } else if (city.equals("640500")) {
            str = "1164230001014477X6364100900500101";
        }
        return str;
    }

    private String getSubsidiaryTaskCode(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE3641009005001";
        } else if (city.equals("640200")) {
            str = "1164020001010727453641009005001";
        } else if (city.equals("640300")) {
            str = "11642100010127021E3641009005001";
        } else if (city.equals("640400")) {
            str = "1164220001015940213641009005001";
        } else if (city.equals("640500")) {
            str = "1164230001014477X63641009005001";
        }
        return str;
    }

    private String getSubsidiaryOrgCode(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE";
        } else if (city.equals("640200")) {
            str = "116402000101072745";
        } else if (city.equals("640300")) {
            str = "11642100010127021E";
        } else if (city.equals("640400")) {
            str = "116422000101594021";
        } else if (city.equals("640500")) {
            str = "1164230001014477X6";
        }
        return str;
    }

    public void pushAllPersoncertificate(List<Personcertificate> personcertificates, String businessType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clientId", this.clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        for (Personcertificate personcertificate : personcertificates) {
            try {
                String time = System.currentTimeMillis() + "";
                params.put("timespan", time);
                params.put("sign", MD5Util.encode((String)(this.clientId + "|" + this.password + "|" + time)));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                ArrayList<UpProMaterial> upProMaterials = new ArrayList<UpProMaterial>();
                ArrayList<UpProProcess> upProProcesses = new ArrayList<UpProProcess>();
                ArrayList upProsPecialProcedures = new ArrayList();
                String createDate = this.formatDate(personcertificate.getCreateTime());
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType("2");
                upProAccept.setApplyerName(personcertificate.getName());
                upProAccept.setApplyerPageCode(personcertificate.getCardnumber());
                upProAccept.setApplyerPageType("111");
                upProAccept.setApplyerType("1");
                upProAccept.setAreaId(personcertificate.getDistrict() + "000000");
                upProAccept.setCatalogCode("000109004000");
                upProAccept.setCdOperation("I");
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(personcertificate.getPhone() + "");
                upProAccept.setDataSource("zzqgat_bafwjgxxxt");
                upProAccept.setEnterpriseName(personcertificate.getCompanyname() + "");
                upProAccept.setIsItemBase("0");
                upProAccept.setLocalCatalogCode("000109004000");
                upProAccept.setLocalItemCode("5ccc211d17af4be888d919a44ade4aa9");
                upProAccept.setLocalProjectNo("5ccc211d17af4be888d919a44ade4aa9");
                upProAccept.setLocalTaskCode("5ccc211d17af4be888d919a44ade4aa9");
                upProAccept.setOrgCode(this.getPersoncertificateOrgCode(personcertificate.getCity()));
                upProAccept.setOrgName(personcertificate.getSzss() + "");
                String da = dFormat.format(personcertificate.getCreateTime());
                String ta = this.getProjectNo("seq_yth004");
                upProAccept.setProjectNo("64" + this.getPersoncertificateTaskCode(personcertificate.getCity()) + da + ta);
                upProAccept.setProjectType("2");
                upProAccept.setPromiseDate(this.formatDate(this.getPromiseDate(personcertificate.getCreateTime(), businessType)));
                upProAccept.setPromiseTime("7");
                upProAccept.setRowGuid(personcertificate.getId() + "");
                upProAccept.setTaskCode(this.getPersoncertificateTaskCode(personcertificate.getCity()));
                upProAccept.setTaskName("\u4fdd\u5b89\u5458\u8bc1\u6838\u53d1");
                upProAccept.setTaskVersion("1");
                upProAccept.setTaskHandleItem(this.getPersoncertificateTaskHandleItem(personcertificate.getCity()));
                upProAccept.setCompanyCode(this.getCCode(personcertificate.getCompanyid()) + "");
                upProAccept.setHandleUserId(personcertificate.getUpdateBy());
                upProAccept.setFileId(this.getPersoncertificateFileId(personcertificate.getCity()));
                String handleUserName = "\u6682\u65e0\u5ba1\u6279\u4eba";
                List<ApprovalLog> logList = this.getApprovalLog(personcertificate.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation("I");
                    upProProcess.setCdTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource("zzqgat_bafwjgxxxt");
                    upProProcess.setEventEndTime(this.formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(this.getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName = approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(this.getProcessName("" + approvalLog.getApprovalstate()) + "");
                    upProProcess.setProjectNo("64" + this.getPersoncertificateTaskCode(personcertificate.getCity()) + da + ta);
                    upProProcess.setIsNeedService("1");
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }
                upProResult.setCdOperation("I");
                upProResult.setCdTime(this.formatDate(personcertificate.getUpdateTime()) + "");
                upProResult.setDataSource("zzqgat_bafwjgxxxt");
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults("0");
                upProResult.setProjectNo("64" + this.getPersoncertificateTaskCode(personcertificate.getCity()) + da + ta);
                upProResult.setRemark("\u65e0");
                upProResult.setResultDate(this.formatDate(personcertificate.getUpdateTime()) + "");
                upProResult.setResultExplain("\u65e0");
                upProResult.setResultType(this.getResultType(personcertificate.getApprovalstate()));
                upProResult.setRowGuid(personcertificate.getId().toString() + "");
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation("I");
                upProMaterial.setCdTime(this.formatDate(personcertificate.getCreateTime()) + "");
                upProMaterial.setDataSource("zzqgat_bafwjgxxxt");
                upProMaterial.setGetType("2");
                upProMaterial.setMaterialAttachName("\u65e0");
                upProMaterial.setMaterialName("\u65e0");
                upProMaterial.setProjectNo("64" + this.getPersoncertificateTaskCode(personcertificate.getCity()) + da + ta);
                upProMaterial.setRowGuid(personcertificate.getId().toString() + "");
                upProMaterial.setUrl("\u65e0");
                upProMaterial.setRemark("\u65e0");
                upProMaterials.add(upProMaterial);
                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = "";
                CloseableHttpClient httpClient = HttpClients.createDefault();
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    httpClient = HttpClients.createDefault();
                    HttpPost httpPost = new HttpPost(this.url + "/docking/tskSum/uploadTask");
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity((HttpEntity)requestEntity);
                    result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("personcertificate" + personcertificate.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject((String)result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(personcertificate.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(personcertificate.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    continue;
                }
                logger.error("personcertificate" + personcertificate.getId() + "params:" + params);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getPersoncertificateFileId(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "db0eae61-54fb-48ab-903d-ddbddf440c70";
        } else if (city.equals("640200")) {
            str = "b38bb741-27e0-4c53-a38e-7dd0264f90ec";
        } else if (city.equals("640300")) {
            str = "ed425829-6aeb-45e2-85f6-17c6ce3992fb";
        } else if (city.equals("640400")) {
            str = "7b644499-07be-48cf-9663-b80105da818b";
        } else if (city.equals("640500")) {
            str = "e8fec3e9-ed4e-49b8-8965-ace72e1b4c23";
        }
        return str;
    }

    private String getPersoncertificateTaskHandleItem(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE300010900400001";
        } else if (city.equals("640200")) {
            str = "116402000101072745300010900400001";
        } else if (city.equals("640300")) {
            str = "11642100010127021E300010900400001";
        } else if (city.equals("640400")) {
            str = "116422000101594021300010900400001";
        } else if (city.equals("640500")) {
            str = "1164230001014477X6300010900400001";
        }
        return str;
    }

    private String getPersoncertificateTaskCode(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE3000109004000";
        } else if (city.equals("640200")) {
            str = "1164020001010727453000109004000";
        } else if (city.equals("640300")) {
            str = "11642100010127021E3000109004000";
        } else if (city.equals("640400")) {
            str = "1164220001015940213000109004000";
        } else if (city.equals("640500")) {
            str = "1164230001014477X63000109004000";
        }
        return str;
    }

    private String getPersoncertificateOrgCode(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE";
        } else if (city.equals("640200")) {
            str = "116402000101072745";
        } else if (city.equals("640300")) {
            str = "11642100010127021E";
        } else if (city.equals("640400")) {
            str = "116422000101594021";
        } else if (city.equals("640500")) {
            str = "1164230001014477X6";
        }
        return str;
    }

    public void pushAllCrosscompany(List<Crosscompany> crosscompanies, String businessType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clientId", this.clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        for (Crosscompany crosscompany : crosscompanies) {
            try {
                String time = System.currentTimeMillis() + "";
                logger.error("\u65f6\u95f4\u6233" + time);
                params.put("timespan", time);
                params.put("sign", MD5Util.encode((String)(this.clientId + "|" + this.password + "|" + time)));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                ArrayList<UpProMaterial> upProMaterials = new ArrayList<UpProMaterial>();
                ArrayList<UpProProcess> upProProcesses = new ArrayList<UpProProcess>();
                ArrayList upProsPecialProcedures = new ArrayList();
                String createDate = this.formatDate(crosscompany.getCreateTime());
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType("2");
                User user = this.userDao.findById(crosscompany.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(crosscompany.getLegalcardnumber());
                upProAccept.setApplyerPageType(this.ApplyerPageType(user.getPlatform()));
                upProAccept.setApplyerType(this.getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(crosscompany.getDistrict() + "000000");
                upProAccept.setCatalogCode("641009006001");
                upProAccept.setCdOperation("I");
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(crosscompany.getLegalphone() + "");
                upProAccept.setDataSource("zzqgat_bafwjgxxxt");
                upProAccept.setEnterpriseName(crosscompany.getCompanyname() + "");
                upProAccept.setIsItemBase("0");
                upProAccept.setLocalCatalogCode("641009006001");
                upProAccept.setLocalItemCode("413d73f5937d43039bc3f9f47a1944a7");
                upProAccept.setLocalProjectNo("413d73f5937d43039bc3f9f47a1944a7");
                upProAccept.setLocalTaskCode("413d73f5937d43039bc3f9f47a1944a7");
                upProAccept.setOrgCode(this.getCrosscompanyOrgCode(crosscompany.getCity()));
                upProAccept.setOrgName(this.getPoliceName(crosscompany.getOrgid()) + "");
                String da = dFormat.format(crosscompany.getCreateTime());
                String ta = this.getProjectNo("seq_yth005");
                upProAccept.setProjectNo("64" + this.getCrosscompanyTaskCode(crosscompany.getCity()) + da + ta);
                upProAccept.setProjectType("2");
                upProAccept.setPromiseDate(this.formatDate(this.getPromiseDate(crosscompany.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime("2");
                upProAccept.setRowGuid(crosscompany.getId() + "");
                upProAccept.setTaskCode(this.getCrosscompanyTaskCode(crosscompany.getCity()));
                upProAccept.setTaskName("\u4fdd\u5b89\u516c\u53f8\u8de8\u533a\u57df\u5f00\u5c55\u4fdd\u5b89\u670d\u52a1\u6d3b\u52a8\u5907\u6848");
                upProAccept.setTaskVersion("1");
                upProAccept.setTaskHandleItem(this.getCrosscompanyTaskHandleItem(crosscompany.getCity()));
                upProAccept.setCompanyCode(crosscompany.getCreditcode());
                upProAccept.setHandleUserId(crosscompany.getUserid().toString() + "");
                upProAccept.setFileId(this.getCrosscompanyFileId(crosscompany.getCity()));
                String handleUserName = "\u6682\u65e0\u5ba1\u6279\u4eba";
                List<ApprovalLog> logList = this.getApprovalLog(crosscompany.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation("I");
                    upProProcess.setCdTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource("zzqgat_bafwjgxxxt");
                    upProProcess.setEventEndTime(this.formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(this.getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName = approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(this.getProcessName("" + approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo("64" + this.getCrosscompanyTaskCode(crosscompany.getCity()) + da + ta);
                    upProProcess.setIsNeedService("1");
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }
                upProResult.setCdOperation("I");
                upProResult.setCdTime(this.formatDate(crosscompany.getCreateTime()) + "");
                upProResult.setDataSource("zzqgat_bafwjgxxxt");
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults("0");
                upProResult.setProjectNo("64" + this.getCrosscompanyTaskCode(crosscompany.getCity()) + da + ta);
                upProResult.setRemark("\u65e0");
                upProResult.setResultDate(this.formatDate(crosscompany.getUpdateTime()));
                upProResult.setResultExplain("\u65e0");
                upProResult.setResultType(this.getResultType(crosscompany.getApprovalstate()));
                upProResult.setRowGuid(crosscompany.getId().toString() + "");
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation("I");
                upProMaterial.setCdTime(this.formatDate(crosscompany.getCreateTime()) + "");
                upProMaterial.setDataSource("zzqgat_bafwjgxxxt");
                upProMaterial.setGetType("2");
                upProMaterial.setMaterialAttachName("\u65e0");
                upProMaterial.setMaterialName(this.getMaterialName(crosscompany.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64" + this.getCrosscompanyTaskCode(crosscompany.getCity()) + da + ta);
                upProMaterial.setRowGuid(crosscompany.getId().toString() + "");
                upProMaterial.setUrl(crosscompany.getTemplateRar() + "");
                upProMaterial.setRemark("\u65e0");
                upProMaterials.add(upProMaterial);
                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = "";
                CloseableHttpClient httpClient = HttpClients.createDefault();
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    httpClient = HttpClients.createDefault();
                    HttpPost httpPost = new HttpPost(this.url + "/docking/tskSum/uploadTask");
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity((HttpEntity)requestEntity);
                    result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("crosscompany" + crosscompany.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject((String)result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(crosscompany.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(crosscompany.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    continue;
                }
                logger.error("crosscompany" + crosscompany.getId() + "params:" + params);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getCrosscompanyFileId(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "f84b2e5e-a10e-494b-9c11-6fe5bf427f66";
        } else if (city.equals("640200")) {
            str = "7e3b7870-8305-44c3-9168-c9f16c9e1323";
        } else if (city.equals("640300")) {
            str = "eb66ba5b-e0a2-4a2d-9399-e22433c5b950";
        } else if (city.equals("640400")) {
            str = "5ca402ab-0d1c-4786-b1bc-f2dcd02b7e4f";
        } else if (city.equals("640500")) {
            str = "afcac3ef-2805-4695-b9f8-a63bf55964ca";
        }
        return str;
    }

    private String getCrosscompanyTaskHandleItem(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE364100900600101";
        } else if (city.equals("640200")) {
            str = "116402000101072745364100900600101";
        } else if (city.equals("640300")) {
            str = "11642100010127021E364100900600101";
        } else if (city.equals("640400")) {
            str = "116422000101594021364100900600101";
        } else if (city.equals("640500")) {
            str = "1164230001014477X6364100900600101";
        }
        return str;
    }

    private String getCrosscompanyTaskCode(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE3641009006001";
        } else if (city.equals("640200")) {
            str = "1164020001010727453641009006001";
        } else if (city.equals("640300")) {
            str = "11642100010127021E3641009006001";
        } else if (city.equals("640400")) {
            str = "1164220001015940213641009006001";
        } else if (city.equals("640500")) {
            str = "1164230001014477X63641009006001";
        }
        return str;
    }

    private String getCrosscompanyOrgCode(String city) {
        String str = "";
        if (city.equals("640100")) {
            str = "1164010001008624XE";
        } else if (city.equals("640200")) {
            str = "116402000101072745";
        } else if (city.equals("640300")) {
            str = "11642100010127021E";
        } else if (city.equals("640400")) {
            str = "116422000101594021";
        } else if (city.equals("640500")) {
            str = "1164230001014477X6";
        }
        return str;
    }

    public void pushAllConfesscompany(List<Confesscompany> confesscompanies, String businessType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clientId", this.clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        for (Confesscompany confesscompany : confesscompanies) {
            try {
                String time = System.currentTimeMillis() + "";
                logger.error("\u65f6\u95f4\u6233" + time);
                params.put("timespan", time);
                params.put("sign", MD5Util.encode((String)(this.clientId + "|" + this.password + "|" + time)));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                ArrayList<UpProMaterial> upProMaterials = new ArrayList<UpProMaterial>();
                ArrayList<UpProProcess> upProProcesses = new ArrayList<UpProProcess>();
                ArrayList upProsPecialProcedures = new ArrayList();
                String createDate = this.formatDate(confesscompany.getCreateTime());
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType("2");
                User user = this.userDao.findById(confesscompany.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(confesscompany.getLegalcardnumber() + "");
                upProAccept.setApplyerPageType(this.ApplyerPageType(user.getPlatform()));
                upProAccept.setApplyerType(this.getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(confesscompany.getDistrict() + "000000");
                upProAccept.setCatalogCode("641009005001");
                upProAccept.setCdOperation("I");
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(confesscompany.getLegalphone() + "");
                upProAccept.setDataSource("zzqgat_bafwjgxxxt");
                upProAccept.setEnterpriseName(confesscompany.getCompanyname() + "");
                upProAccept.setIsItemBase("0");
                upProAccept.setLocalCatalogCode("641009005001");
                upProAccept.setLocalItemCode("14b4895679324600aac16836a9115557");
                upProAccept.setLocalProjectNo("14b4895679324600aac16836a9115557");
                upProAccept.setLocalTaskCode("14b4895679324600aac16836a9115557");
                upProAccept.setOrgCode(this.getSubsidiaryOrgCode(confesscompany.getCity()));
                upProAccept.setOrgName(this.getPoliceName(confesscompany.getOrgid()) + "");
                String da = dFormat.format(confesscompany.getCreateTime());
                String ta = this.getProjectNo("seq_yth006");
                upProAccept.setProjectNo("64" + this.getSubsidiaryTaskCode(confesscompany.getCity()) + da + ta);
                upProAccept.setProjectType("2");
                upProAccept.setPromiseDate(this.formatDate(this.getPromiseDate(confesscompany.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime("8");
                upProAccept.setRowGuid(confesscompany.getId() + "");
                upProAccept.setTaskCode(this.getSubsidiaryTaskCode(confesscompany.getCity()));
                upProAccept.setTaskName("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bbe\u7acb\u5206\u516c\u53f8\u3001\u81ea\u884c\u62db\u7528\u4fdd\u5b89\u5458\u5907\u6848");
                upProAccept.setTaskVersion("1");
                upProAccept.setTaskHandleItem(this.getSubsidiaryTaskHandleItem(confesscompany.getCity()));
                upProAccept.setCompanyCode(confesscompany.getCreditcode() + "");
                upProAccept.setHandleUserId(confesscompany.getUserid().toString() + "");
                upProAccept.setFileId(this.getSubsidiaryFileId(confesscompany.getCity()));
                String handleUserName = "\u6682\u65e0\u5ba1\u6279\u4eba";
                List<ApprovalLog> logList = this.getApprovalLog(confesscompany.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation("I");
                    upProProcess.setCdTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource("zzqgat_bafwjgxxxt");
                    upProProcess.setEventEndTime(this.formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(this.getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName = approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(this.getProcessName("" + approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo("64" + this.getSubsidiaryTaskCode(confesscompany.getCity()) + da + ta);
                    upProProcess.setIsNeedService("1");
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }
                Approval approval = this.approvalDAO.findBybusinessidAndType(confesscompany.getId(), businessType);
                upProResult.setCdOperation("I");
                upProResult.setCdTime(this.formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource("zzqgat_bafwjgxxxt");
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults("0");
                upProResult.setProjectNo("64" + this.getSubsidiaryTaskCode(confesscompany.getCity()) + da + ta);
                upProResult.setRemark("\u65e0");
                upProResult.setResultDate(this.formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(this.getResultType(approval.getApprovalstate()));
                upProResult.setRowGuid(approval.getId().toString() + "");
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation("I");
                upProMaterial.setCdTime(this.formatDate(confesscompany.getCreateTime()) + "");
                upProMaterial.setDataSource("zzqgat_bafwjgxxxt");
                upProMaterial.setGetType("2");
                upProMaterial.setMaterialAttachName("\u65e0");
                upProMaterial.setMaterialName(this.getMaterialName(confesscompany.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64" + this.getSubsidiaryTaskCode(confesscompany.getCity()) + da + ta);
                upProMaterial.setRowGuid(confesscompany.getId().toString() + "");
                upProMaterial.setUrl(confesscompany.getTemplateRar() + "");
                upProMaterial.setRemark("\u65e0");
                upProMaterials.add(upProMaterial);
                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = "";
                CloseableHttpClient httpClient = HttpClients.createDefault();
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    httpClient = HttpClients.createDefault();
                    HttpPost httpPost = new HttpPost(this.url + "/docking/tskSum/uploadTask");
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity((HttpEntity)requestEntity);
                    result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("confesscompany" + confesscompany.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject((String)result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(confesscompany.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    continue;
                }
                logger.error("confesscompany" + confesscompany.getId() + "params:" + params);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void pushAllLegalchange(List<Legalchange> legalchanges, String businessType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clientId", this.clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        for (Legalchange legalchange : legalchanges) {
            try {
                String time = System.currentTimeMillis() + "";
                logger.error("\u65f6\u95f4\u6233" + time);
                params.put("timespan", time);
                params.put("sign", MD5Util.encode((String)(this.clientId + "|" + this.password + "|" + time)));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                ArrayList<UpProMaterial> upProMaterials = new ArrayList<UpProMaterial>();
                ArrayList<UpProProcess> upProProcesses = new ArrayList<UpProProcess>();
                ArrayList upProsPecialProcedures = new ArrayList();
                String createDate = this.formatDate(legalchange.getCreateTime());
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType("2");
                User user = this.userDao.findById(legalchange.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(this.getApplyerPageCode(legalchange.getCompanyid()));
                upProAccept.setApplyerPageType(this.ApplyerPageType(user.getPlatform()));
                upProAccept.setApplyerType(this.getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(this.getAreaId(legalchange.getCompanyid()) + "000000");
                upProAccept.setCatalogCode("000109002000");
                upProAccept.setCdOperation("I");
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(this.getContractMobile(legalchange.getCompanyid()));
                upProAccept.setDataSource("zzqgat_bafwjgxxxt");
                upProAccept.setEnterpriseName(legalchange.getCompanyname() + "");
                upProAccept.setIsItemBase("0");
                upProAccept.setLocalCatalogCode("000109002000");
                upProAccept.setLocalItemCode("29a66168a973456f9eee9cafb1dbcfcf");
                upProAccept.setLocalProjectNo("29a66168a973456f9eee9cafb1dbcfcf");
                upProAccept.setLocalTaskCode("29a66168a973456f9eee9cafb1dbcfcf");
                upProAccept.setOrgCode(this.getLegalchangeOrgCode(legalchange.getCity()));
                upProAccept.setOrgName(this.getPoliceName(legalchange.getOrgid()));
                String da = dFormat.format(legalchange.getCreateTime());
                String ta = this.getProjectNo("seq_yth007");
                upProAccept.setProjectNo("64" + this.getLegalchangeTaskCode(legalchange.getCity()) + da + ta);
                upProAccept.setProjectType("2");
                upProAccept.setPromiseDate(this.formatDate(this.getPromiseDate(legalchange.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime("10");
                upProAccept.setRowGuid(legalchange.getId() + "");
                upProAccept.setTaskCode(this.getLegalchangeTaskCode(legalchange.getCity()));
                upProAccept.setTaskName("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u7684\u6cd5\u5b9a\u4ee3\u8868\u4eba\u53d8\u66f4\u5ba1\u6838");
                upProAccept.setTaskVersion("1");
                upProAccept.setTaskHandleItem(this.getLegalchangeTaskCode(legalchange.getCity()) + "01");
                upProAccept.setCompanyCode(this.getCCode(legalchange.getCompanyid()));
                upProAccept.setHandleUserId(legalchange.getUserid().toString() + "");
                upProAccept.setFileId(this.getLegalchangeFileId(legalchange.getCity()));
                String handleUserName = "\u6682\u65e0\u5ba1\u6279\u4eba";
                List<ApprovalLog> logList = this.getApprovalLog(legalchange.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation("I");
                    upProProcess.setCdTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource("zzqgat_bafwjgxxxt");
                    upProProcess.setEventEndTime(this.formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(this.getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(this.formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName = approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(this.getProcessName("" + approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo("64" + this.getLegalchangeTaskCode(legalchange.getCity()) + da + ta);
                    upProProcess.setIsNeedService("1");
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }
                Approval approval = this.approvalDAO.findBybusinessidAndType(legalchange.getId(), businessType);
                upProResult.setCdOperation("I");
                upProResult.setCdTime(this.formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource("zzqgat_bafwjgxxxt");
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults("0");
                upProResult.setProjectNo("64" + this.getLegalchangeTaskCode(legalchange.getCity()) + da + ta);
                upProResult.setRemark("\u65e0");
                upProResult.setResultDate(this.formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(this.getResultType(approval.getApprovalstate()));
                upProResult.setRowGuid(approval.getId().toString() + "");
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation("I");
                upProMaterial.setCdTime(this.formatDate(legalchange.getCreateTime()) + "");
                upProMaterial.setDataSource("zzqgat_bafwjgxxxt");
                upProMaterial.setGetType("2");
                upProMaterial.setMaterialAttachName("\u65e0");
                upProMaterial.setMaterialName(this.getMaterialName(legalchange.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64" + this.getLegalchangeTaskCode(legalchange.getCity()) + da + ta);
                upProMaterial.setRowGuid(legalchange.getId().toString() + "");
                upProMaterial.setUrl(legalchange.getTemplateRar() + "");
                upProMaterial.setRemark("\u65e0");
                upProMaterials.add(upProMaterial);
                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = "";
                CloseableHttpClient httpClient = HttpClients.createDefault();
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    httpClient = HttpClients.createDefault();
                    HttpPost httpPost = new HttpPost(this.url + "/docking/tskSum/uploadTask");
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity((HttpEntity)requestEntity);
                    result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("legalchange" + legalchange.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject((String)result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(legalchange.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    this.nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    continue;
                }
                logger.error("legalchange" + legalchange.getId() + "params:" + params);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getLegalchangeFileId(String city) {
        String str = "";
        str = city.equals("640100") ? "e664e3a6-3c1e-4bed-be5c-48948b1c8852" : (city.equals("640200") ? "d5bcc0aa-dd3b-4f31-80bb-86971f65853b" : (city.equals("640300") ? "b35a0606-4e55-4a42-bbc3-5701ea76e4ac" : (city.equals("640400") ? "4a7bed02-0ab5-4d98-942d-ac43c181738b" : (city.equals("640500") ? "b6d2e0c0-8f84-465d-9a07-21405487698e" : "a047b6ec-75e6-4382-b359-2a39fe81975e"))));
        return str;
    }

    private String getLegalchangeTaskCode(String city) {
        String str = "";
        str = city.equals("640100") ? "1164010001008624XE300010900200001" : (city.equals("640200") ? "116402000101072745300010900200001" : (city.equals("640300") ? "11642100010127021E300010900200001" : (city.equals("640400") ? "116422000101594021300010900200001" : (city.equals("640500") ? "1164230001014477X6300010900200001" : "11640000010065393W200010900200001"))));
        return str;
    }

    private String getLegalchangeOrgCode(String city) {
        String str = "";
        str = city.equals("640100") ? "1164010001008624XE" : (city.equals("640200") ? "116402000101072745" : (city.equals("640300") ? "11642100010127021E" : (city.equals("640400") ? "116422000101594021" : (city.equals("640500") ? "1164230001014477X6" : "11640000010065393W"))));
        return str;
    }

    private String getApplyerPageCode(Long companyid) {
        SecurityCompany securityCompany = this.securityCompanyDao.findById(companyid);
        if (StringUtil.isEmpty((String)securityCompany.getLegalPersonNo())) {
            return "";
        }
        return securityCompany.getLegalPersonNo();
    }

    private String getCCode(Long companyid) {
        SecurityCompany securityCompany = this.securityCompanyDao.findById(companyid);
        if (StringUtil.isEmpty((String)securityCompany.getSocialCode())) {
            return "";
        }
        return securityCompany.getSocialCode();
    }

    private String getContractMobile(Long companyid) {
        SecurityCompany securityCompany = this.securityCompanyDao.findById(companyid);
        if (StringUtil.isEmpty((String)securityCompany.getTel())) {
            return "";
        }
        return securityCompany.getTel();
    }

    private String getAreaId(Long companyid) {
        SecurityCompany securityCompany = this.securityCompanyDao.findById(companyid);
        if (StringUtil.isEmpty((String)securityCompany.getAreaCode())) {
            return "";
        }
        return securityCompany.getAreaCode();
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis());
    }
}

