/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.TokenUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="configUtils")
public class ConfigUtils {
    private Logger log = LoggerFactory.getLogger(ConfigUtils.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ConfigDao configDao;
    public final String GX_IN_URL = "http://10.148.77.214:8018/ars-rest/uploadFileBjToGx.do";
    @Value(value="${time-approval-download-folder}")
    public static String spdownloadFolder;
    @Value(value="${upload-folder}")
    public String uploadFolder;
    @Value(value="${approval-download-folder}")
    public String downloadFolder;
    @Value(value="${base-folder}")
    public String baseFolder;
    @Value(value="${temp-folder}")
    public String tempfolder;
    @Value(value="${ftp-folder}")
    public String ftpFolder;
    @Value(value="${timeFlag}")
    public String timeFlag = "";
    @Value(value="${limitSize}")
    public Integer limitSize;
    @Value(value="${saas_data_host}")
    public String saas_data_host;
    @Value(value="${bkt_data_host}")
    public String bkt_data_host;
    @Value(value="${authurl}")
    public String authurl = "";
    @Value(value="${authswitch}")
    public String authswitch = "";
    @Value(value="${client_id}")
    public String client_id = "";
    @Value(value="${bj_zrr_client_id}")
    public String bj_zrr_client_id = "";
    @Value(value="${bj_zrr_client_secret}")
    public String bj_zrr_client_secret = "";
    @Value(value="${bj_zrr_singleLogin_url}")
    public String bj_zrr_singleLogin_url = "";
    @Value(value="${sysAttachmentFolder}")
    public String sysAttachmentFolder;
    @Value(value="${time-approval-download-folder}")
    public String intToOutFolder;
    @Value(value="${uploadInToOutFolder}")
    public String uploadInToOutFolder;
    public static final String REDIS_PREFIX_KEY = "config:";

    public List<Config> initConfig() {
        List configList = this.configDao.findAll();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Config config : configList) {
            map.put(this.redisUtil.REDIS_PREFIX_KEY + REDIS_PREFIX_KEY + "key_" + config.getKey(), JSON.toJSONString((Object)config));
        }
        this.redisUtil.multiSet(map);
        return configList;
    }

    public Config getConfigByKey(String key) {
        String value = "";
        try {
            value = this.redisUtil.get("config:key_" + key);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Throwable)ex);
        }
        if (value != null) {
            if (StringUtil.isNotEmpty((String)value)) {
                return (Config)JSON.parseObject((String)value, Config.class);
            }
            return null;
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)key);
        Config config = this.configDao.findByKey(key);
        if (config != null) {
            this.redisUtil.set("config:key_" + key, JSON.toJSONString((Object)config));
        } else {
            this.redisUtil.set("config:key_" + key, "", 120);
        }
        return config;
    }

    public Config findByKeyAndName(String key, String name) {
        String value = "";
        try {
            value = this.redisUtil.get("config:keyName_" + key + "_" + name);
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"config");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return (Config)JSON.parseObject((String)value, Config.class);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)(key + "_" + name));
        Config config = this.configDao.findByKeyAndName(key, name);
        if (config != null) {
            this.redisUtil.set("config:keyName_" + key + "_" + name, JSON.toJSONString((Object)config));
        }
        return config;
    }

    public List<Config> findByLikeKey(String key) {
        String value = "";
        try {
            value = this.redisUtil.get("config:likeKey_" + key);
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"config");
        }
        if (StringUtil.isNotEmpty((String)value) && !"[]".equals(value)) {
            return JSON.parseArray((String)value, Config.class);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)key);
        List configs = this.configDao.findByLikeKey(key);
        if (configs != null) {
            this.redisUtil.set("config:likeKey_" + key, JSON.toJSONString((Object)configs));
        }
        return configs;
    }

    public void updateForKey(Config config) {
        this.configDao.update(config);
        this.redisUtil.set("config:key_" + config.getKey(), JSON.toJSONString((Object)config));
    }

    public void updateForKeyName(Config config) {
        this.configDao.update(config);
        this.redisUtil.set("config:keyName_" + config.getKey() + "_" + config.getName(), JSON.toJSONString((Object)config));
    }

    public String getWebHost() {
        Config config = this.getConfigByKey("web_host");
        if (config != null) {
            return config.getValue();
        }
        return "";
    }

    public String getOnlinePreviewUrl() {
        Config config = this.getConfigByKey("online_preview_url");
        if (config != null) {
            return config.getValue();
        }
        return "";
    }

    public String getCurrentNative() {
        Config config = this.getConfigByKey("current_native");
        if (config != null) {
            return config.getValue();
        }
        return "";
    }

    public String getCurrentProvince() {
        Config config = this.getConfigByKey("current_province");
        if (config != null) {
            return config.getValue();
        }
        return "";
    }

    public String getValueByKey(String key) {
        Config config = this.getConfigByKey(key);
        if (config != null) {
            return config.getValue();
        }
        return "";
    }

    public String getCompanyAccountRole() {
        Config config = this.getConfigByKey("COMPANY_ACCOUNT_ROLE");
        if (config != null) {
            return config.getValue();
        }
        this.log.error("config\u7684COMPANY_ACCOUNT_ROLE\u672a\u914d\u7f6e");
        return "";
    }

    public String getDataSyncStartFileName(Class annotation) {
        if (annotation.equals(DataSyncAnnotation.class)) {
            return this.getCompanyAccountRole() + "_" + "ds" + "_" + "out";
        }
        return this.getCompanyAccountRole() + "_" + "ds" + "_" + "in";
    }

    public String getIntranetName() {
        if (this.isIntranet()) {
            return "in";
        }
        return "out";
    }

    public boolean isIntranet() {
        Config config = this.getConfigByKey("police");
        if (config != null) {
            if ("1".equals(config.getValue())) {
                return true;
            }
        } else {
            this.log.error("config\u7684police\u672a\u914d\u7f6e");
        }
        return false;
    }

    public String getToken() {
        String token = TokenUtil.getInstance().makeToken();
        this.redisUtil.set(token, token, 1800);
        return token;
    }

    public boolean isExistToken(String token) {
        if (StringUtil.isEmpty((String)token)) {
            return false;
        }
        String server_token = this.redisUtil.get(token);
        if (StringUtil.isEmpty((String)server_token)) {
            return false;
        }
        this.redisUtil.delete(server_token);
        return true;
    }
}

