/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.context.SecurityContext;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.huawei.HttpBuildUtil;
import com.bcxin.ars.util.huawei.RestRequest;
import com.bcxin.ars.util.huawei.RestResponse;
import com.bcxin.ars.util.redis.RedisUtil;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArsUtil {
    public static final Logger log = LoggerFactory.getLogger(ArsUtil.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ConferenceAccountDao conferenceAccountDao;
    @Autowired
    private RedisUtil redisUtil;

    public Long getCurrentNatvie() {
        return (Long)SecurityContext.currentNative.get();
    }

    public User getCurrentUser() {
        try {
            if (SecurityUtils.getSubject() != null) {
                Subject currentUser = SecurityUtils.getSubject();
                Session session = currentUser.getSession();
                User user = null;
                if (session.getAttribute((Object)"user") != null) {
                    user = (User)session.getAttribute((Object)"user");
                }
                return user;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ConferenceAccount getConferenceAccount() {
        User currentUser = this.getCurrentUser();
        ConferenceAccount account = currentUser.getConferenceAccount();
        if (account == null) {
            account = this.conferenceAccountDao.selectByUserId(currentUser.getId());
        }
        return account;
    }

    public void setCurrentUser(User user, int timeout) {
        Subject currentUser = SecurityUtils.getSubject();
        Session session = currentUser.getSession();
        session.setAttribute((Object)"user", (Object)user);
        session.setTimeout((long)timeout);
        SecurityContext.currentUser.set(user);
    }

    public void clearSecurityContext() {
        SecurityContext.currentUser.remove();
        SecurityContext.currentNative.remove();
    }

    public boolean isProvinceLevel() {
        Police police;
        User user = this.getCurrentUser();
        return user != null && (police = user.getPolice()) != null && "1".equals(police.getOrgtype());
    }

    public void setPoliceSearch_old(SearchDto searchDto) {
        Police police;
        User user = this.getCurrentUser();
        if (user != null && (police = user.getPolice()) != null) {
            String areaCode = police.getAreacode();
            if (StringUtil.isNotEmpty((String)searchDto.getAreaCode())) {
                areaCode = searchDto.getAreaCode();
            } else if ("11".equals(this.configUtils.getCurrentNative())) {
                areaCode = this.configUtils.getCurrentNative();
            }
            if (areaCode.endsWith("0000")) {
                searchDto.setAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {
                searchDto.setAreaCode(areaCode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areaCode);
            }
            searchDto.setDistrict(searchDto.getAreaCode());
            if (!"11".equals(this.configUtils.getCurrentNative())) {
                if ("4".equals(police.getOrgtype())) {
                    searchDto.setOrgId(police.getId());
                }
                searchDto.setPath(police.getPath());
                if (searchDto.isPoliceBusiness()) {
                    searchDto.setUserid(user.getId());
                }
            }
        }
    }

    public void setPoliceSearchAll(SearchDto searchDto) {
        Police police;
        User user = this.getCurrentUser();
        if (user != null && (police = user.getPolice()) != null) {
            String areaCode = police.getAreacode();
            if (StringUtil.isNotEmpty((String)searchDto.getAreaCode())) {
                areaCode = searchDto.getAreaCode();
            }
            if (areaCode.endsWith("0000")) {
                searchDto.setAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {
                searchDto.setAreaCode(areaCode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areaCode);
            }
            searchDto.setDistrict(searchDto.getAreaCode());
            if ("4".equals(police.getOrgtype())) {
                searchDto.setOrgId(police.getId());
            }
            searchDto.setPath(police.getPath());
            if (searchDto.isPoliceBusiness()) {
                searchDto.setUserid(user.getId());
            }
        }
    }

    public void setPoliceSearch(SearchDto searchDto) {
        User user = this.getCurrentUser();
        if (null == user) {
            return;
        }
        Police police = user.getPolice();
        if (user == null || police == null) {
            return;
        }
        String areaCode = null;
        if (Constants.RANKAUTH_ALL.equals(searchDto.getRankAuth()) || "1".equals(user.getIsAdmin())) {
            areaCode = this.configUtils.getCurrentProvince();
        } else {
            areaCode = police.getAreacode();
            if ("4".equals(police.getOrgtype())) {
                searchDto.setOrgId(police.getId());
            }
            searchDto.setPath(police.getPath());
            if (searchDto.isPoliceBusiness()) {
                searchDto.setUserid(user.getId());
            }
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAreaCode())) {
            areaCode = searchDto.getAreaCode();
        } else {
            searchDto.setAreasList(user.getAreasList());
        }
        if (StringUtil.isNotEmpty((String)areaCode)) {
            if (areaCode.endsWith("0000")) {
                searchDto.setAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {
                searchDto.setAreaCode(areaCode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areaCode);
            }
            searchDto.setDistrict(searchDto.getAreaCode());
        }
    }

    public String getHuaweiMeetAccessToken(String userName, String passWord, Long userId) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + "huaweiMeet" + userId;
        String accessToken = "";
        if (!this.redisUtil.hasKey(redisKey)) {
            String authorization = Base64.getEncoder().encodeToString((userName + ":" + passWord).getBytes());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("account", userName);
            map.put("clientType", 0);
            map.put("createTokenType", 0);
            String url = "https://api.meeting.huaweicloud.com/v1/usg/acs/auth/account";
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Authorization", "Basic " + authorization);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)"POST", headMap, (String)JSON.toJSONString(map), null);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            if (response.getHttpCode() == 200) {
                Map data = (Map)JSON.parseObject((String)response.getEntity(), Map.class);
                accessToken = data.get("accessToken").toString();
                String expiresIn = data.get("validPeriod").toString();
                int expiresTime = Integer.parseInt(expiresIn) - 3600;
                if (expiresTime > 0) {
                    this.redisUtil.set(redisKey, accessToken, expiresTime);
                }
            }
        } else {
            accessToken = this.redisUtil.get(redisKey);
            log.info("\u4ece\u7f13\u5b58\u4e2d\u62ffaccessToken:" + accessToken);
        }
        return accessToken;
    }

    public String getHuaweiMeetSelfAccessToken(String userName, String passWord, Long userId) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + "huaweiMeetSelf" + userId;
        String accessToken = "";
        if (!this.redisUtil.hasKey(redisKey)) {
            Map resultMap;
            String authorization = Base64.getEncoder().encodeToString((userName + ":" + passWord).getBytes());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("account", userName);
            map.put("clientType", 0);
            map.put("createTokenType", 0);
            String url = "https://api.meeting.huaweicloud.com/v1/usg/acs/auth/account";
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Authorization", "Basic " + authorization);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)"POST", headMap, (String)JSON.toJSONString(map), null);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            if (response.getHttpCode() == 200 && (resultMap = (Map)JSON.parseObject((String)response.getEntity().toString(), Map.class)) != null) {
                accessToken = resultMap.get("accessToken").toString();
                String expires_in = resultMap.get("validPeriod").toString();
                int expiresTime = Integer.parseInt(expires_in) - 3600;
                if (expiresTime > 0) {
                    this.redisUtil.set(redisKey, accessToken, expiresTime);
                }
            }
        } else {
            accessToken = this.redisUtil.get(redisKey);
            log.info("\u4ece\u7f13\u5b58\u4e2d\u62ffaccessToken:" + accessToken);
        }
        return accessToken;
    }

    public String changeNativePlace(String nativePlace) {
        if (nativePlace.endsWith("0000")) {
            return nativePlace.substring(0, 2) + "________________";
        }
        if (nativePlace.endsWith("00")) {
            return nativePlace.substring(0, 4) + "______________";
        }
        return nativePlace;
    }
}

