/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.bcxin.ars.dao.task.ComShiftDao;
import com.bcxin.ars.dao.task.ComShiftRuleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.task.ComShiftPageSearchDto;
import com.bcxin.ars.dto.task.ComShiftDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComShift;
import com.bcxin.ars.model.task.ComShiftRule;
import com.bcxin.ars.service.task.ComShiftService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ComShiftServiceImpl
implements ComShiftService {
    Logger logger = LoggerFactory.getLogger(ComShiftServiceImpl.class);
    @Autowired
    private ComShiftDao comShiftDao;
    @Autowired
    private ComShiftRuleDao comShiftRuleDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(ComShift comShift) {
        User currentUser = this.arsUtil.getCurrentUser();
        comShift.setUpdateTime(new Date());
        comShift.setUpdateBy(currentUser.getUsername());
        return this.comShiftDao.delete(comShift);
    }

    public int save(ComShiftDto comShift) {
        ComShift dbComShift;
        ComShift oldComShift;
        User currentUser = this.arsUtil.getCurrentUser();
        if (comShift.getComShiftRuleList() != null && comShift.getComShiftRuleList().size() > 0) {
            for (ComShiftRule comShiftRule : comShift.getComShiftRuleList()) {
                comShiftRule.setUpdateBy(currentUser.getUsername());
                comShiftRule.setUpdateTime(new Date());
            }
            this.comShiftRuleDao.saveBatch(comShift.getComShiftRuleList());
        }
        if (comShift.getOldShiftId() != null && (oldComShift = this.comShiftDao.findById(comShift.getOldShiftId())) != null) {
            oldComShift.setEffectEndTime(new Date());
            this.comShiftDao.save(oldComShift);
        }
        if ((dbComShift = this.comShiftDao.findById(comShift.getShiftId())) == null) {
            comShift.setCreateTime(new Date());
        } else {
            BeanUtils.copyPropertiesIgnore((Object)comShift, (Object)dbComShift, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbComShift, (Object)comShift, (Boolean)false);
        }
        comShift.setUpdateBy(currentUser.getUsername());
        comShift.setUpdateTime(new Date());
        return this.comShiftDao.save((ComShift)comShift);
    }

    public ComShift findById(Long id) {
        return this.comShiftDao.findById(id);
    }

    public void searchForPage(ComShiftPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.comShiftDao.searchForPage(dto, page);
    }

    public void importBatch(List<ComShift> list) {
        List dbList = this.comShiftDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ComShift comShift : list) {
                comShift.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    comShift.setUpdateTime(DateUtil.dateAdd((int)6, (Date)comShift.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.comShiftDao.saveBatch(list);
        }
    }

    public List<ComShift> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comShiftDao.searchForDataSynchronization(dto);
    }

    public List<ComShift> findDSOutList(String startDate) {
        return this.comShiftDao.findDSOutList(startDate);
    }

    public List<ComShift> findByBatchId(List<ComShift> list) {
        return this.comShiftDao.findByBatchId(list);
    }

    public void updateSelective(ComShift comShift) {
        User currentUser = this.arsUtil.getCurrentUser();
        comShift.setUpdateTime(new Date());
        comShift.setUpdateBy(currentUser.getUsername());
        this.comShiftDao.updateSelective(comShift);
    }
}

