/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.dao.sys.MinisterialLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.MinisterialDataType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.MinisterialLog;
import com.bcxin.ars.service.sys.MinisterialLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MinisterialLogServiceImpl
implements MinisterialLogService {
    Logger logger = LoggerFactory.getLogger(MinisterialLogServiceImpl.class);
    @Autowired
    private MinisterialLogDao ministerialLogDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(MinisterialLog ministerialLog) {
        User currentUser = this.arsUtil.getCurrentUser();
        ministerialLog.setUpdateTime(new Date());
        ministerialLog.setUpdateBy(currentUser.getUsername());
        return this.ministerialLogDao.delete(ministerialLog);
    }

    public int save(MinisterialLog ministerialLog) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (ministerialLog.getId() == null) {
            ministerialLog.setCreateTime(new Date());
        } else {
            MinisterialLog dbMinisterialLog = this.ministerialLogDao.findById(ministerialLog.getId());
            BeanUtils.copyPropertiesIgnore((Object)ministerialLog, (Object)dbMinisterialLog, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbMinisterialLog, (Object)ministerialLog, (Boolean)false);
        }
        ministerialLog.setActive(Boolean.valueOf(true));
        ministerialLog.setUpdateBy(currentUser.getUsername());
        ministerialLog.setUpdateTime(new Date());
        ministerialLog.setAreaCode(currentUser.getPolice().getAreacode());
        return this.ministerialLogDao.save(ministerialLog);
    }

    public MinisterialLog findById(Long id) {
        return this.ministerialLogDao.findById(id);
    }

    public MinisterialLog find(MinisterialLog ministerialLog) {
        return this.ministerialLogDao.find(ministerialLog);
    }

    public void importBatch(List<MinisterialLog> list) {
        List dbList = this.ministerialLogDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (MinisterialLog ministerialLog : list) {
                ministerialLog.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    ministerialLog.setUpdateTime(DateUtil.dateAdd((int)6, (Date)ministerialLog.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.ministerialLogDao.saveBatch(list);
        }
    }

    public List<MinisterialLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.ministerialLogDao.searchForDataSynchronization(dto);
    }

    public List<MinisterialLog> findDSOutList(String startDate) {
        return this.ministerialLogDao.findDSOutList(startDate);
    }

    public List<MinisterialLog> findByBatchId(List<MinisterialLog> list) {
        return this.ministerialLogDao.findByBatchId(list);
    }

    public void updateSelective(MinisterialLog ministerialLog) {
        User currentUser = this.arsUtil.getCurrentUser();
        ministerialLog.setUpdateTime(new Date());
        ministerialLog.setUpdateBy(currentUser.getUsername());
        this.ministerialLogDao.updateSelective(ministerialLog);
    }

    public List<Map> getBusinessDatas(MinisterialDataType dataType, int limit) {
        Field[] fields;
        Class entityClass = dataType.getDataClazz();
        if (!entityClass.isAnnotationPresent(MinisterialEntity.class)) {
            return null;
        }
        MinisterialEntity entityAnno = entityClass.getAnnotation(MinisterialEntity.class);
        String tableName = entityAnno.tableName();
        String extraWhere = entityAnno.extraWhere();
        StringBuilder tableColumns = new StringBuilder();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(MinisterialAttr.class)) continue;
            MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
            if (StringUtil.isNotEmpty((String)resource.DATE_FORMAT())) {
                tableColumns.append("DATE_FORMAT( t1.").append(resource.column()).append(",'").append(resource.DATE_FORMAT()).append("') as ").append(field.getName()).append(",");
                continue;
            }
            if (!resource.isSubQuery()) {
                tableColumns.append(" t1.");
            }
            tableColumns.append(resource.column()).append(" as ").append(field.getName()).append(",");
        }
        String columns = tableColumns.toString();
        columns = columns.substring(0, columns.length() - 1);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dataType", dataType.getCode());
        paramMap.put("tableName", tableName);
        paramMap.put("tableColumns", columns);
        paramMap.put("limit", limit);
        paramMap.put("extraWhere", extraWhere);
        return this.ministerialLogDao.findByType(paramMap);
    }

    public List<Map> getBusinessDatasByParam(MinisterialDataType dataType, Map paramMap) {
        Field[] fields;
        Class entityClass = dataType.getDataClazz();
        MinisterialEntity entityAnno = entityClass.getAnnotation(MinisterialEntity.class);
        String tableName = entityAnno.tableName();
        StringBuilder tableColumns = new StringBuilder();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(MinisterialAttr.class)) continue;
            MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
            if (StringUtil.isNotEmpty((String)resource.DATE_FORMAT())) {
                tableColumns.append("DATE_FORMAT( t1.").append(resource.column()).append(",'").append(resource.DATE_FORMAT()).append("') as ").append(field.getName()).append(",");
                continue;
            }
            if (!resource.isSubQuery()) {
                tableColumns.append(" t1.");
            }
            tableColumns.append(resource.column()).append(" as ").append(field.getName()).append(",");
        }
        String columns = tableColumns.toString();
        columns = columns.substring(0, columns.length() - 1);
        paramMap.put("dataType", dataType.getCode());
        paramMap.put("tableName", tableName);
        paramMap.put("tableColumns", columns);
        return this.ministerialLogDao.findByParam(paramMap);
    }

    public void saveByType(MinisterialLog ministerialLog, List subList) {
        this.ministerialLogDao.saveByType(ministerialLog, subList);
    }
}

