/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASResultDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.InterfaceLogPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.service.sys.InterfaceLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InterfaceLogServiceImpl
implements InterfaceLogService {
    Logger logger = LoggerFactory.getLogger(InterfaceLogServiceImpl.class);
    @Autowired
    private InterfaceLogDao interfaceLogDao;
    @Autowired
    private ArsUtil arsUtil;

    public InterfaceLog findById(Long id) {
        return this.interfaceLogDao.findById(id);
    }

    public AjaxResult reCall(InterfaceLog interfaceLog) {
        String msg = "";
        Boolean result = true;
        Object data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            HashMap hashMap = (HashMap)JSON.parseObject((String)interfaceLog.getParameters(), HashMap.class);
            String resultStr = HttpUtil.post((String)interfaceLog.getUrl(), (Map)hashMap);
            interfaceLog.setResult(resultStr);
            SAASResultDto resultDto = (SAASResultDto)JSONObject.parseObject((String)resultStr, SAASResultDto.class);
            if (resultDto != null && StringUtil.isNotEmpty((String)resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.BTK_IS_SUCCESS.equals(retType)) {
                    data = resultDto.getData();
                    this.logger.info("\u767e\u4fdd\u76fe\u4e0eSaas\u540c\u6b65\u6210\u529f");
                } else {
                    result = false;
                    msg = resultDto.getMsg();
                    this.logger.error(resultStr);
                    this.logger.info("\u767e\u4fdd\u76fe\u4e0eSaas\u540c\u6b65\u5931\u8d25");
                }
            } else {
                result = false;
                msg = "\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c";
                this.logger.info("\u767e\u4fdd\u76fe\u4e0eSaas\u540c\u6b65\u5931\u8d25,\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c");
            }
        }
        catch (Exception e) {
            result = false;
            this.logger.error(e.getMessage(), (Throwable)e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result.booleanValue());
        new Thread(() -> this.interfaceLogDao.update(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u767e\u4fdd\u76fe\u4e0eSaas\u540c\u6b65\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, (Object)interfaceLog.getResult());
    }

    public void searchForPage(InterfaceLogPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.interfaceLogDao.searchForPage(dto, page);
    }
}

