/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.CompanyComplaintDao;
import com.bcxin.ars.dao.supervision.CompanyComplaintDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.CompanyComplaintPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.CompanyComplaint;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.supervision.CompanyComplaintService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CompanyComplaint.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=CompanyComplaint.class, getImportType=ImportType.BATCH)
public class CompanyComplaintServiceImpl
extends BaseService
implements CompanyComplaintService {
    @Autowired
    private CompanyComplaintDao companyComplaintDao;
    @Autowired
    private CompanyComplaintDaoAop companyComplaintDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;

    public int delete(CompanyComplaint record) {
        User currentUser = this.arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return this.companyComplaintDaoAop.delete(record);
    }

    public void save(CompanyComplaint record) {
        String isInSystem;
        User currentUser = this.arsUtil.getCurrentUser();
        if (record.getId() == null) {
            record.setId(Long.valueOf(this.idWorker.nextId()));
            record.setCreateTime(new Date());
            if (StringUtil.isNotEmpty((String)record.getSignImgPath())) {
                record.setSignImgPath(this.saveBase64Img(record.getSignImgPath()));
            }
        } else {
            CompanyComplaint dbRecord = this.companyComplaintDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore((Object)record, (Object)dbRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbRecord, (Object)record, (Boolean)false);
        }
        if (!StringUtils.isEmpty((Object)(isInSystem = record.getIsInSystem())) && isInSystem.equals("2")) {
            String companyNameDefine = record.getCompanyNameDefine();
            record.setComplaintCompanyName(companyNameDefine);
            record.setCompanyId(null);
        }
        record.setActive(Boolean.valueOf(true));
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(Boolean.valueOf(true));
        record.setAreaCode(currentUser.getPolice().getAreacode());
        this.companyComplaintDaoAop.save(record);
    }

    public CompanyComplaint findById(Long id) {
        return this.companyComplaintDao.findById(id);
    }

    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        this.arsUtil.setPoliceSearch(dto);
        CompanyComplaintPageSearchDto searchDto = (CompanyComplaintPageSearchDto)dto;
        if (StringUtil.isNotEmpty((String)searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        this.companyComplaintDao.searchForPage((CompanyComplaintPageSearchDto)dto, page);
    }

    public List<CompanyComplaint> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.companyComplaintDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(List<CompanyComplaint> list) {
        ArrayList<CompanyComplaint> dbList = new ArrayList<CompanyComplaint>();
        for (CompanyComplaint companyComplaint : list) {
            CompanyComplaint companyComplaintIn = this.companyComplaintDao.findById(companyComplaint.getId());
            if (companyComplaintIn == null) {
                companyComplaint.setUpdateflag(Boolean.valueOf(false));
                continue;
            }
            if (companyComplaint.getUpdateTime().getTime() < companyComplaintIn.getUpdateTime().getTime()) {
                dbList.add(companyComplaint);
            }
            companyComplaint.setUpdateflag(Boolean.valueOf(true));
        }
        list.removeAll(dbList);
        this.companyComplaintDaoAop.saveBatch(list);
    }

    public List<CompanyComplaint> findDSOutList(String startDate) {
        return this.companyComplaintDao.findDSOutList(startDate);
    }

    public void importBatch(List<CompanyComplaint> list) {
        List dbList = this.companyComplaintDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CompanyComplaint companyComplaint : list) {
                companyComplaint.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    companyComplaint.setUpdateTime(DateUtil.dateAdd((int)6, (Date)companyComplaint.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.companyComplaintDaoAop.saveBatch(list);
        }
    }
}

