/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.extra.validation.BeanValidationResult;
import cn.hutool.extra.validation.ValidationUtil;
import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.SecurityPersonDaoAop;
import com.bcxin.ars.dao.ThirdTrainBackgroundDao;
import com.bcxin.ars.dao.appeal.AppealDao;
import com.bcxin.ars.dao.certificate.GradeCertificateDao;
import com.bcxin.ars.dao.certificate.GradeCompleteCerDao;
import com.bcxin.ars.dao.sb.GradeClassDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersonGradeDaoAop;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDaoAop;
import com.bcxin.ars.dao.sys.SubsidyConfigDao;
import com.bcxin.ars.dao.task.ComContractDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.GradeCertificateToSAASDto;
import com.bcxin.ars.dto.PersonGradeDTO;
import com.bcxin.ars.dto.PersonInfoDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.certificate.GradeAndCertificateDto;
import com.bcxin.ars.dto.sb.PersonGradeSearchDto;
import com.bcxin.ars.dto.sys.SubsidyConfigDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.enums.SubsidyCerType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.exception.ValidateException;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.ThirdTrainBackground;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.model.sb.GradeClass;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.model.sys.SubsidyConfig;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.service.certificate.GradeCompleteCerService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.PersonGradeService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.IdNumUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=PersonGrade.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=PersonGrade.class, getImportType=ImportType.BATCH, getMethodName="importBatchForDSIn2Out")
public class PersonGradeServiceImpl
extends BaseService
implements PersonGradeService {
    Logger logger = LoggerFactory.getLogger(PersonGradeServiceImpl.class);
    @Autowired
    private PersonGradeDao personGradeDao;
    @Autowired
    private PersonGradeDaoAop personGradeDaoAop;
    @Autowired
    private ComContractDao comContractDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;
    @Autowired
    private GradeCompleteCerDao gradeCompleteCerDao;
    @Autowired
    private GradeClassDao gradeClassDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private GradeCompleteCerService gradeCompleteCerService;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;
    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;
    @Autowired
    private GradeSubsidyRosterDaoAop gradeSubsidyRosterDaoAop;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private SecurityPersonDaoAop securityPersonDaoAop;
    @Autowired
    private SubsidyConfigDao subsidyConfigDao;
    @Autowired
    private GradeCertificateDao gradeCertificateDao;
    @Autowired
    private ThirdTrainBackgroundDao thirdTrainBackgroundDao;
    @Autowired
    private AppealDao appealDao;

    public void searchForPage(PersonGradeSearchDto searchDto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        this.personGradeDao.searchForPage(searchDto, page);
    }

    public void searchForPageBySubsity(PersonGradeSearchDto searchDto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        this.personGradeDao.searchForPageBySubsidy(searchDto, page);
    }

    public PersonGrade findById(Long id) {
        PersonGrade personGrade = this.personGradeDao.findById(id);
        if (personGrade.getContractId() != null) {
            personGrade.setContract(this.comContractDao.findById(personGrade.getContractId()));
        }
        personGrade.setGradeCompleteCer(this.gradeCompleteCerDao.findByPersonGradeId(personGrade.getId()));
        return personGrade;
    }

    public void save(PersonGrade personGrade) {
        SecurityCompany company;
        GradeSubsidyRoster roster;
        PersonGrade dbPersonGrade;
        ComContract contract;
        if (StringUtil.isNotEmpty((String)personGrade.getIdBackImg())) {
            personGrade.setIdBackImg(this.getPhotoPath(personGrade.getIdBackImg()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getIdFrontImg())) {
            personGrade.setIdFrontImg(this.getPhotoPath(personGrade.getIdFrontImg()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getHeadImg())) {
            personGrade.setHeadImg(this.getPhotoPath(personGrade.getHeadImg()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getMainHomeUrl())) {
            personGrade.setMainHomeUrl(this.getPhotoPath(personGrade.getMainHomeUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getSelfHomeUrl())) {
            personGrade.setSelfHomeUrl(this.getPhotoPath(personGrade.getSelfHomeUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getRegCerUrl())) {
            personGrade.setRegCerUrl(this.getPhotoPath(personGrade.getRegCerUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getGradCerUrl())) {
            personGrade.setGradCerUrl(this.getPhotoPath(personGrade.getGradCerUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getLaborTranCerUrl())) {
            personGrade.setLaborTranCerUrl(this.getPhotoPath(personGrade.getLaborTranCerUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getEmpCerUrl())) {
            personGrade.setEmpCerUrl(this.getPhotoPath(personGrade.getEmpCerUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getDischargeCerUrl())) {
            personGrade.setDischargeCerUrl(this.getPhotoPath(personGrade.getDischargeCerUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getSelfEmpCerUrl())) {
            personGrade.setSelfEmpCerUrl(this.getPhotoPath(personGrade.getSelfEmpCerUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getDemobCerUrl())) {
            personGrade.setDemobCerUrl(this.getPhotoPath(personGrade.getDemobCerUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getConversionCerUrl())) {
            personGrade.setConversionCerUrl(this.getPhotoPath(personGrade.getConversionCerUrl()));
        }
        if (StringUtil.isNotEmpty((String)personGrade.getConfirmCerUrl())) {
            personGrade.setConfirmCerUrl(this.getPhotoPath(personGrade.getConfirmCerUrl()));
        }
        if (personGrade.getContractId() != null && (contract = this.comContractDao.findById(personGrade.getContractId())) != null) {
            personGrade.setContractStart(contract.getEffectStartDate());
            personGrade.setContractEnd(contract.getEffectEndDate());
        }
        if ((dbPersonGrade = this.personGradeDao.findById(personGrade.getId())) == null) {
            personGrade.setCreateTime(new Date());
            personGrade.setNewest(Boolean.valueOf(true));
            personGrade.setInTime(new Date());
            if (StringUtil.isEmpty((String)personGrade.getMakeUp())) {
                personGrade.setMakeUp("0");
            }
            this.personGradeDaoAop.updatePast(personGrade);
        } else {
            BeanUtils.copyPropertiesIgnore((Object)personGrade, (Object)dbPersonGrade, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbPersonGrade, (Object)personGrade, (Boolean)false);
        }
        personGrade.setActive(Boolean.valueOf(true));
        personGrade.setUpdateTime(new Date());
        personGrade.setUpdateflag(Boolean.valueOf(true));
        if (StringUtil.isEmpty((String)personGrade.getMakeUp())) {
            personGrade.setMakeUp("0");
        } else if ("1".equals(personGrade.getMakeUp()) && (roster = this.gradeSubsidyRosterDao.findByIdNumAndType(personGrade.getIdNum(), Constants.SUBSIDYCERTYPE_DJZ)) != null && Constants.USED_N.equals(roster.getUsed())) {
            roster.setGradeId(personGrade.getId());
            roster.setUpdateTime(new Date());
            this.gradeSubsidyRosterDao.updateSelective(roster);
        }
        if (StringUtil.isEmpty((String)personGrade.getAreaCode()) && (company = this.securityCompanyDao.findByComId(personGrade.getComId())) != null) {
            personGrade.setAreaCode(company.getAreaCode());
            if (StringUtil.isNotEmpty((String)company.getOrgId())) {
                personGrade.setOrgId(Long.valueOf(Long.parseLong(company.getOrgId())));
            }
        }
        this.personGradeDaoAop.save(personGrade);
    }

    public void importBatch(List<PersonGrade> list) {
        List dbList = this.personGradeDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            Map dbCensorStatusMap = dbList.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            for (PersonGrade personGrade : list) {
                personGrade.setUpdateflag(Boolean.valueOf(false));
                try {
                    PersonGrade dbPersonGrade = (PersonGrade)dbCensorStatusMap.get(personGrade.getId());
                    if (dbPersonGrade == null || dbPersonGrade.getInTime().getTime() <= personGrade.getInTime().getTime()) continue;
                    personGrade.setCompareStatus(dbPersonGrade.getCompareStatus());
                    personGrade.setCompareReason(dbPersonGrade.getApprovalReason());
                    personGrade.setInTime(dbPersonGrade.getInTime());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.personGradeDaoAop.saveBatch(list);
        }
    }

    public void importBatchForDSIn2Out(List<PersonGrade> list) {
        List dbList = this.personGradeDao.findByBatchId(list);
        if (list.size() > 0) {
            ArrayList<PersonGrade> compareList = new ArrayList<PersonGrade>();
            ArrayList<PersonGrade> changeList = new ArrayList<PersonGrade>();
            Map dbCensorStatusMap = dbList.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            for (PersonGrade personGrade : list) {
                personGrade.setUpdateflag(Boolean.valueOf(false));
                try {
                    PersonGrade dbPersonGrade = (PersonGrade)dbCensorStatusMap.get(personGrade.getId());
                    if (dbPersonGrade == null || dbPersonGrade.getInTime() != null && dbPersonGrade.getInTime().getTime() >= personGrade.getInTime().getTime()) continue;
                    if (StringUtil.isEmpty((String)dbPersonGrade.getCensorStatus()) && StringUtil.isNotEmpty((String)personGrade.getCensorStatus())) {
                        param = new JSONObject();
                        param.put("gradeApplyId", (Object)(personGrade.getId() + ""));
                        param.put("backgroundStatus", (Object)personGrade.getCensorStatus());
                        param.put("approvalState", (Object)personGrade.getApprovalState());
                        param.put("backgroundFailReason", (Object)personGrade.getApprovalReason());
                        param.put("backgroundType", (Object)"1");
                        paramArr.add((Object)param);
                    }
                    if (StringUtil.isNotEmpty((String)personGrade.getCompareStatus())) {
                        compareList.add(personGrade);
                    }
                    personGrade.setUpdateTime(new Date());
                    changeList.add(personGrade);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (paramArr.size() > 0) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("personList", JSON.toJSONString((Object)paramArr));
                AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/grade/person/backgroundStatus", paramMap);
                if (!result.isSuccessful()) {
                    throw new ArsException("\u3010\u7b49\u7ea7\u8bc1\u62a5\u540d\u80cc\u666f\u7b5b\u67e5\u7ed3\u679c\u3011" + result.getMsg());
                }
            }
            if (compareList.size() > 0) {
                this.compareStatusToBKT(compareList);
            }
            if (changeList.size() > 0) {
                this.personGradeDaoAop.saveBatchForDSIn2Out(changeList);
            }
        }
    }

    public List<PersonGrade> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.personGradeDao.searchForDataSynchronization(dto);
    }

    public List<PersonGrade> findDSOutList(String startDate) {
        return this.personGradeDao.findDSOutList(startDate);
    }

    public void batchUpdate(List<PersonGrade> list) {
        List dbList = this.personGradeDao.findByBatchId(list);
        if (dbList.size() > 0) {
            Map personGradeMap = list.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            PersonGrade personGrade = null;
            for (PersonGrade dbPersonGrade : dbList) {
                ComContract contract;
                personGrade = (PersonGrade)personGradeMap.get(dbPersonGrade.getId());
                if (personGrade.getContractId() != null && (contract = this.comContractDao.findById(personGrade.getContractId())) != null) {
                    personGrade.setContractStart(contract.getEffectStartDate());
                    personGrade.setContractEnd(contract.getEffectEndDate());
                }
                BeanUtils.copyPropertiesIgnore((Object)personGrade, (Object)dbPersonGrade, (Boolean)true);
                dbPersonGrade.setUpdateTime(new Date());
                dbPersonGrade.setUpdateflag(Boolean.valueOf(true));
            }
            this.personGradeDaoAop.saveBatch(dbList);
        }
    }

    public void batchUpdateScore(List<PersonGrade> list) {
        List dbList = this.personGradeDao.findByBatchId(list);
        if (dbList.size() > 0) {
            Map personGradeMap = list.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            ArrayList<GradeCertificate> gradeCerList = new ArrayList<GradeCertificate>();
            ArrayList<GradeCompleteCer> completeCerList = new ArrayList<GradeCompleteCer>();
            GradeCertificate gradeCertificate = null;
            GradeCompleteCer completeCer = null;
            PersonGrade personGrade = null;
            SecurityCompany trainCom = null;
            SecurityPerson person = null;
            GradeClass gradeClass = null;
            ArrayList<SecurityPerson> personList = new ArrayList<SecurityPerson>();
            for (PersonGrade dbPersonGrade : dbList) {
                trainCom = this.securityCompanyDao.findByComId(dbPersonGrade.getTrainId());
                personGrade = (PersonGrade)personGradeMap.get(dbPersonGrade.getId());
                BeanUtils.copyPropertiesIgnore((Object)personGrade, (Object)dbPersonGrade, (Boolean)true);
                dbPersonGrade.setUpdateTime(new Date());
                dbPersonGrade.setUpdateflag(Boolean.valueOf(true));
                gradeClass = this.gradeClassDao.findById(dbPersonGrade.getClassId());
                if ("1".equals(personGrade.getTestStateComplete())) {
                    completeCer = this.createCompleteCer(dbPersonGrade, gradeClass, completeCerList);
                }
                if (!"1".equals(personGrade.getTestState())) continue;
                person = this.securityPersonDao.findById(dbPersonGrade.getPersonId());
                person.setProfessionLevel(dbPersonGrade.getGradeLevel());
                person.setCredential(dbPersonGrade.getCerNo());
                person.setTraincompanyname(dbPersonGrade.getTrainName());
                person.setUpdateTime(new Date());
                personList.add(person);
                gradeCertificate = this.gradeCertificateDao.findByIdNumAndGradeLevel(dbPersonGrade.getIdNum(), dbPersonGrade.getGradeLevel());
                if (gradeCertificate == null) {
                    gradeCertificate = new GradeCertificate();
                    gradeCertificate.setId(Long.valueOf(this.idWorker.nextId()));
                    gradeCertificate.setCreateTime(new Date());
                    gradeCertificate.setAppraisalGrade(dbPersonGrade.getGradeLevel());
                    gradeCertificate.setCompanyId(dbPersonGrade.getComId());
                    gradeCertificate.setCompanyName(dbPersonGrade.getComName());
                    gradeCertificate.setIdnum(dbPersonGrade.getIdNum());
                    gradeCertificate.setName(dbPersonGrade.getName());
                    gradeCertificate.setPersonGradeId(dbPersonGrade.getId());
                    gradeCertificate.setPersonId(dbPersonGrade.getPersonId());
                    gradeCertificate.setTrainId(dbPersonGrade.getTrainId());
                    gradeCertificate.setTrainOrgName(dbPersonGrade.getTrainName());
                    gradeCertificate.setProfession("\u4fdd\u5b89\u5458");
                    gradeCertificate.setAppraisalTime(gradeClass.getPracticeEndDate());
                    if (personGrade.getCheckDate() == null) {
                        gradeCertificate.setTrainTime(gradeClass.getPracticeStartDate());
                        gradeCertificate.setTrainStartTime(DateUtil.convertDateToString((Date)gradeClass.getPracticeStartDate(), (String)"yyyy-MM-dd"));
                        gradeCertificate.setTrainEndTime(DateUtil.convertDateToString((Date)gradeClass.getPracticeEndDate(), (String)"yyyy-MM-dd"));
                    } else {
                        gradeCertificate.setTrainTime(personGrade.getCheckDate());
                        gradeCertificate.setTrainStartTime(DateUtil.convertDateToString((Date)personGrade.getCheckDate(), (String)"yyyy-MM-dd"));
                        gradeCertificate.setTrainEndTime(DateUtil.getCurrentDate((String)"yyyy-MM-dd"));
                    }
                    gradeCertificate.setUserId(trainCom.getUserid());
                    gradeCertificate.setGender(IdNumUtil.getGenderByIdCard((String)dbPersonGrade.getIdNum()));
                }
                try {
                    if (StringUtil.isNotEmpty((String)dbPersonGrade.getCerDate())) {
                        gradeCertificate.setCerDate(DateUtil.convertStringToDate((String)dbPersonGrade.getCerDate()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                gradeCertificate.setCertificateNo(dbPersonGrade.getCerNo());
                gradeCertificate.setPersonId(dbPersonGrade.getPersonId());
                gradeCertificate.setUpdateTime(new Date());
                gradeCertificate.setActive(Boolean.valueOf(true));
                gradeCerList.add(gradeCertificate);
            }
            this.personGradeDaoAop.saveBatch(dbList);
            if (completeCerList.size() > 0) {
                this.gradeCompleteCerDao.saveBatch(completeCerList);
                this.sendCompleteCerToSAAS(completeCerList);
            }
            if (personList.size() > 0) {
                this.securityPersonDaoAop.updateBatch(personList);
            }
            if (gradeCerList.size() > 0) {
                this.gradeCertificateDao.saveBatch(gradeCerList);
                this.sendAppraisalCerToSAAS(gradeCerList);
            }
        }
    }

    private GradeCompleteCer createCompleteCer(PersonGrade personGrade, GradeClass gradeClass, List<GradeCompleteCer> completeCerList) {
        GradeCompleteCer completeCer = this.gradeCompleteCerDao.findByIdNum(personGrade.getIdNum(), personGrade.getGradeLevel());
        if (completeCer == null) {
            completeCer = new GradeCompleteCer();
            BeanUtils.copyPropertiesIgnore((Object)personGrade, (Object)completeCer, (Boolean)true);
            completeCer.setId(Long.valueOf(this.idWorker.nextId()));
            completeCer.setCerDate(DateUtil.getCurrentDate((String)"yyyy-MM-dd"));
            completeCer.setCerNo(this.generatorCer());
            completeCer.setGender(IdNumUtil.getGenderByIdCard((String)personGrade.getIdNum()));
            completeCer.setPersonGradeId(personGrade.getId());
            completeCer.setHeadImg(personGrade.getHeadImg());
            completeCer.setProfession("\u4fdd\u5b89\u5458");
            if (personGrade.getCheckDate() == null) {
                completeCer.setTrainStartDate(DateUtil.convertDateToString((Date)gradeClass.getPracticeStartDate(), (String)"yyyy-MM-dd"));
                completeCer.setTrainEndDate(DateUtil.convertDateToString((Date)gradeClass.getPracticeEndDate(), (String)"yyyy-MM-dd"));
            } else {
                completeCer.setTrainStartDate(DateUtil.convertDateToString((Date)personGrade.getCheckDate(), (String)"yyyy-MM-dd"));
                completeCer.setTrainEndDate(DateUtil.getCurrentDate((String)"yyyy-MM-dd"));
            }
            completeCer.setActive(Boolean.valueOf(true));
            completeCer.setCreateTime(new Date());
            completeCer.setUpdateTime(new Date());
            completeCer.setPersonId(personGrade.getPersonId());
            completeCerList.add(completeCer);
        }
        return completeCer;
    }

    public List<GradeAndCertificateDto> checkPersonRegister(Long[] personIds) {
        List list = this.personGradeDao.selectSignUpByIds(personIds);
        return list;
    }

    public List<GradeAndCertificateDto> checkPersonRegisterV2(Long[] personIds) {
        List listGrade = this.personGradeDao.selectGradeSignUpByIds(personIds);
        List listCertificate = this.personcertificateDao.selectCertificateSignUpByIds(personIds);
        listGrade.forEach(grade -> listCertificate.forEach(certificate -> {
            if (grade.getPersonId().equals(certificate.getPersonId())) {
                if (StringUtils.isNotEmpty((String)grade.getSignUpInfo())) {
                    grade.setIsSignUp("1");
                } else {
                    grade.setIsSignUp(StringUtils.isEmpty((String)certificate.getSignUpInfo()) ? "0" : "1");
                    grade.setSignUpInfo(certificate.getSignUpInfo());
                }
            }
        }));
        return listGrade;
    }

    public int checkPersonGradeCer(PersonGrade personGrade) {
        return this.personGradeDao.checkPersonGradeCer(personGrade);
    }

    private void sendCompleteCerToSAAS(List<GradeCompleteCer> cerList) {
        if (!this.configUtils.isIntranet()) {
            PersonInfoDto personDto = null;
            for (GradeCompleteCer completeCer : cerList) {
                try {
                    personDto = new PersonInfoDto();
                    personDto.setPerId(completeCer.getPersonId());
                    personDto.setCerNo(completeCer.getCerNo());
                    personDto.setLicenceOrg(completeCer.getTrainName());
                    personDto.setLicenceDate(completeCer.getCerDate());
                    personDto.setTrainOrganName(completeCer.getTrainName());
                    personDto.setTrainStartDate(completeCer.getTrainStartDate());
                    personDto.setTrainEndDate(completeCer.getTrainEndDate());
                    personDto.setPerCerLevel("0100010" + completeCer.getGradeLevel());
                    personDto.setElectronCerUrl(this.gradeCompleteCerService.getBbdH5Url(completeCer.getId().toString()));
                    AjaxResult result = this.saasInterfaceUtil.callInterface("/thirdPlat/bbd-callBack/complete-baydjjyz-approve", personDto);
                    if (result.isSuccessful()) continue;
                    throw new ArsException(completeCer.getName() + result.getMsg());
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private String generatorCer() {
        return this.configUtils.getValueByKey("current_native_short") + this.personcertificateDao.getNextVal("seq_Complete_Cer");
    }

    public void updateSelective(PersonGrade personGrade) {
        User currentUser = this.arsUtil.getCurrentUser();
        personGrade.setUpdateTime(new Date());
        personGrade.setUpdateBy(currentUser.getUsername());
        this.personGradeDaoAop.updateSelective(personGrade);
    }

    public void compareStatusToBKT(List<PersonGrade> gradeList) {
        JSONArray personList = new JSONArray();
        JSONObject perObj = null;
        for (PersonGrade personGrade : gradeList) {
            perObj = new JSONObject();
            perObj.put("gradeApplyId", (Object)(personGrade.getId() + ""));
            perObj.put("compareStatus", (Object)personGrade.getCompareStatus());
            perObj.put("compareFailReason", (Object)personGrade.getCompareReason());
            perObj.put("compareType", (Object)"1");
            personList.add((Object)perObj);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("personList", JSONArray.toJSONString((Object)personList));
            AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/grade/person/compareStatus", paramMap);
            if (result.isSuccessful()) continue;
            this.logger.error("\u3010\u7b49\u7ea7\u8bc1\u62a5\u540d\u8865\u8d34\u6bd4\u5bf9\u7ed3\u679c\u3011" + result.getMsg());
        }
    }

    public void updateCompareInfo(PersonGrade personGrade) {
        personGrade.setCompareStatus(Constants.SUBSIDYSTATUS_DBD);
        personGrade.setCompareReason("");
        personGrade.setUpdateTime(new Date());
        this.personGradeDaoAop.updateSelective(personGrade);
        GradeSubsidyRoster roster = this.gradeSubsidyRosterDao.findByGradeId(personGrade.getId());
        if (roster != null) {
            roster.setResidentNature(personGrade.getResidentType());
            roster.setResidentPlace(personGrade.getResidentPlaceType());
            roster.setCerNo(personGrade.getCerNo());
            roster.setCerDate(personGrade.getCerDate());
            roster.setCertificateNumber(personGrade.getCerNo());
            roster.setCertificateDate(personGrade.getCerDate());
            roster.setSubsidyStatus(Constants.SUBSIDYSTATUS_DBD);
            roster.setReason("");
            roster.setUpdateTime(new Date());
            roster.setUpdateflag(Boolean.valueOf(true));
            this.gradeSubsidyRosterDaoAop.updateSelective(roster);
        }
        if (StringUtil.isNotEmpty((String)personGrade.getCerNo())) {
            GradeCertificate cer = this.gradeCertificateDao.findByPersonGradeId(personGrade.getId());
            cer.setCertificateNo(personGrade.getCerNo());
            if (StringUtil.isNotEmpty((String)personGrade.getCerDate())) {
                cer.setAppraisalTime(DateUtil.convertStringToDate((String)personGrade.getCerDate()));
            }
            cer.setUpdateTime(new Date());
            this.gradeCertificateDao.update(cer);
            SecurityPerson person = this.securityPersonDao.findById(cer.getPersonId());
            if (person != null) {
                person.setCredential(personGrade.getCerNo());
                person.setUpdateTime(new Date());
                this.securityPersonDaoAop.update(person);
            }
            ArrayList<GradeCertificate> list = new ArrayList<GradeCertificate>();
            list.add(cer);
            this.sendAppraisalCerToSAAS(list);
        }
    }

    private void sendAppraisalCerToSAAS(List<GradeCertificate> list) {
        if (list != null && list.size() > 0) {
            int limit = 2000;
            int count = new Double(Math.ceil((double)list.size() * 1.0 / (double)limit)).intValue();
            List subList = null;
            for (int i = 0; i < count; ++i) {
                subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                ArrayList<GradeCertificateToSAASDto> dtoList = new ArrayList<GradeCertificateToSAASDto>();
                for (GradeCertificate gradeCer : subList) {
                    GradeCertificateToSAASDto certificateDto = new GradeCertificateToSAASDto();
                    certificateDto.setPerId(gradeCer.getPersonId());
                    certificateDto.setCerNo(gradeCer.getCertificateNo());
                    certificateDto.setPerCerLevel("0100010" + gradeCer.getAppraisalGrade());
                    certificateDto.setLicenceDate(gradeCer.getAppraisalTime() == null ? "" : DateUtil.convertDateToString((Date)gradeCer.getAppraisalTime(), (String)"yyyy-MM-dd"));
                    certificateDto.setTrainOrganName(gradeCer.getTrainOrgName());
                    dtoList.add(certificateDto);
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("bayDJZListStr", JSONArray.toJSONString(dtoList));
                this.saasInterfaceUtil.callInterface("/system/per-cer-baseinfo/complete-baydjz-approve", paramMap);
            }
        }
    }

    public AjaxResult gradeCertificateApply(String gradeCertificate) {
        SecurityCompany company;
        GradeSubsidyRoster roster;
        String idNum;
        AjaxResult validResult;
        ComContract contract;
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeCertificate).getSubject();
        PersonGradeDTO personGrade = (PersonGradeDTO)JSON.parseObject((String)subject, PersonGradeDTO.class);
        User currentUser = this.arsUtil.getCurrentUser();
        long id = this.idWorker.nextId();
        if (personGrade.getContractId() != null && (contract = this.comContractDao.findById(personGrade.getContractId())) != null) {
            personGrade.setContractStart(contract.getEffectStartDate());
            personGrade.setContractEnd(contract.getEffectEndDate());
        }
        if (!(validResult = this.validApply(idNum = personGrade.getIdNum())).isSuccessful()) {
            return validResult;
        }
        PersonGrade dbPersonGrade = this.personGradeDao.findById(personGrade.getId());
        if (dbPersonGrade == null) {
            BeanValidationResult beanValidationResult = ValidationUtil.warpValidate((Object)personGrade, (Class[])new Class[]{ThirdPartyTrain.class});
            if (!beanValidationResult.isSuccess()) {
                Set errorMessages = beanValidationResult.getErrorMessages().stream().map(BeanValidationResult.ErrorMessage::getMessage).collect(Collectors.toSet());
                throw new ValidateException(errorMessages);
            }
            personGrade.setId(Long.valueOf(id));
            personGrade.setCreateTime(new Date());
            personGrade.setNewest(Boolean.valueOf(true));
            personGrade.setInTime(new Date());
            personGrade.setNewest(Boolean.valueOf(true));
            personGrade.setGradeLevel("1");
            personGrade.setApprovalState("0");
            personGrade.setAreaCode(currentUser.getAreaCode());
            personGrade.setIdBackImg(this.getPhotoPath(personGrade.getIdBackImg()));
            personGrade.setIdFrontImg(this.getPhotoPath(personGrade.getIdFrontImg()));
            SecurityPerson person = this.securityPersonDao.findByIdCard(personGrade.getIdNum());
            personGrade.setPersonId(person.getId());
            ComContract comContract = this.comContractDao.findValidByPerId(person.getId());
            if (comContract != null) {
                personGrade.setContractStart(comContract.getEffectStartDate());
                personGrade.setContractEnd(comContract.getEffectEndDate());
            }
            this.personGradeDaoAop.updatePast((PersonGrade)personGrade);
            ThirdTrainBackground thirdTrainBackground = new ThirdTrainBackground();
            thirdTrainBackground.setId(Long.valueOf(this.idWorker.nextId()));
            thirdTrainBackground.setBusinessType("01");
            thirdTrainBackground.setRealName(personGrade.getName());
            thirdTrainBackground.setIdNumber(personGrade.getIdNum());
            thirdTrainBackground.setArsBusinessId(Long.valueOf(id));
            thirdTrainBackground.setBusinessId(personGrade.getBusinessId());
            thirdTrainBackground.setActive(Boolean.valueOf(true));
            thirdTrainBackground.setUpdateBy(currentUser.getUsername());
            thirdTrainBackground.setUpdateTime(new Date());
            thirdTrainBackground.setCreateTime(new Date());
            thirdTrainBackground.setUpdateflag(Boolean.valueOf(true));
            thirdTrainBackground.setUserid(currentUser.getId());
            int count = this.thirdTrainBackgroundDao.selectCount(thirdTrainBackground);
            if (count == 0) {
                this.thirdTrainBackgroundDao.save(thirdTrainBackground);
            }
            ajaxResult.setData((Object)JwtUtil.createJWT((String)String.valueOf(id)));
        } else {
            BeanUtils.copyPropertiesIgnore((Object)personGrade, (Object)dbPersonGrade, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbPersonGrade, (Object)personGrade, (Boolean)false);
        }
        personGrade.setActive(Boolean.valueOf(true));
        personGrade.setUpdateTime(new Date());
        personGrade.setUpdateflag(Boolean.valueOf(true));
        if (StringUtil.isEmpty((String)personGrade.getMakeUp())) {
            personGrade.setMakeUp("0");
        } else if ("1".equals(personGrade.getMakeUp()) && (roster = this.gradeSubsidyRosterDao.findByIdNumAndType(personGrade.getIdNum(), Constants.SUBSIDYCERTYPE_DJZ)) != null && Constants.USED_N.equals(roster.getUsed())) {
            roster.setGradeId(personGrade.getId());
            roster.setUpdateTime(new Date());
            this.gradeSubsidyRosterDao.updateSelective(roster);
        }
        if (StringUtil.isEmpty((String)personGrade.getAreaCode()) && (company = this.securityCompanyDao.findByComId(personGrade.getComId())) != null) {
            personGrade.setAreaCode(company.getAreaCode());
            if (StringUtil.isNotEmpty((String)company.getOrgId())) {
                personGrade.setOrgId(Long.valueOf(Long.parseLong(company.getOrgId())));
            }
        }
        personGrade.setUserid(currentUser.getId());
        this.personGradeDaoAop.save((PersonGrade)personGrade);
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult syncGradeCertificateInformation(String personGrades) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)personGrades).getSubject();
        List list = JSON.parseArray((String)subject, PersonGrade.class);
        List dbList = this.personGradeDao.findByBatchIdOnApproval(list);
        if (dbList.size() > 0) {
            Map personGradeMap = dbList.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            ArrayList<GradeSubsidyRoster> rosterList = new ArrayList<GradeSubsidyRoster>();
            ArrayList<GradeCertificate> gradeCerList = new ArrayList<GradeCertificate>();
            ArrayList<GradeCompleteCer> completeCerList = new ArrayList<GradeCompleteCer>();
            GradeCompleteCer completeCer = null;
            ArrayList<SecurityPerson> personList = new ArrayList<SecurityPerson>();
            SubsidyConfigDto dto = new SubsidyConfigDto();
            dto.setActive(Boolean.valueOf(true));
            List subsidyConfigs = this.subsidyConfigDao.findAll();
            Map subsidyConfigMap = subsidyConfigs.stream().collect(Collectors.toMap(SubsidyConfig::getBusinessType, Function.identity()));
            SubsidyConfig subsidyConfig = (SubsidyConfig)subsidyConfigMap.get(Constants.SUBSIDYBUSINESSTYPE_005);
            Integer amount = subsidyConfig.getAmount();
            SubsidyConfig platSerFeeSubsidyConfig = (SubsidyConfig)subsidyConfigMap.get(Constants.SUBSIDYBUSINESSTYPE_006);
            String subsidyBusinessType = Constants.SUBSIDYBUSINESSTYPE_001;
            String platSerFeeType = Constants.SUBSIDYBUSINESSTYPE_007;
            for (PersonGrade dbPersonGrade : dbList) {
                GradeSubsidyRoster roster;
                SecurityCompany trainCom = this.securityCompanyDao.findByComId(dbPersonGrade.getTrainId());
                PersonGrade personGrade = (PersonGrade)personGradeMap.get(dbPersonGrade.getId());
                BeanUtils.copyPropertiesIgnore((Object)personGrade, (Object)dbPersonGrade, (Boolean)true);
                dbPersonGrade.setUpdateTime(new Date());
                dbPersonGrade.setUpdateflag(Boolean.valueOf(true));
                GradeClass gradeClass = this.gradeClassDao.findById(dbPersonGrade.getClassId());
                if ("1".equals(personGrade.getTestStateComplete())) {
                    completeCer = this.createCompleteCer(dbPersonGrade, gradeClass, completeCerList);
                }
                if ("1".equals(personGrade.getTestState())) {
                    SecurityPerson person = this.securityPersonDao.findByIdCard(dbPersonGrade.getIdNum());
                    person.setProfessionLevel(dbPersonGrade.getGradeLevel());
                    person.setCredential(dbPersonGrade.getCerNo());
                    person.setTraincompanyname(dbPersonGrade.getTrainName());
                    person.setUpdateTime(new Date());
                    personList.add(person);
                    GradeCertificate gradeCertificate = this.gradeCertificateDao.findByIdNumAndGradeLevel(dbPersonGrade.getIdNum(), dbPersonGrade.getGradeLevel());
                    if (gradeCertificate == null) {
                        gradeCertificate = new GradeCertificate();
                        gradeCertificate.setId(Long.valueOf(this.idWorker.nextId()));
                        gradeCertificate.setCreateTime(new Date());
                        gradeCertificate.setAppraisalGrade(dbPersonGrade.getGradeLevel());
                        gradeCertificate.setCompanyId(dbPersonGrade.getComId());
                        gradeCertificate.setCompanyName(dbPersonGrade.getComName());
                        gradeCertificate.setIdnum(dbPersonGrade.getIdNum());
                        gradeCertificate.setName(dbPersonGrade.getName());
                        gradeCertificate.setPersonGradeId(dbPersonGrade.getId());
                        gradeCertificate.setPersonId(dbPersonGrade.getPersonId());
                        gradeCertificate.setTrainId(dbPersonGrade.getTrainId());
                        gradeCertificate.setTrainOrgName(dbPersonGrade.getTrainName());
                        gradeCertificate.setProfession("\u4fdd\u5b89\u5458");
                        gradeCertificate.setAppraisalTime(gradeClass.getPracticeEndDate());
                        if (personGrade.getCheckDate() == null) {
                            gradeCertificate.setTrainTime(gradeClass.getPracticeStartDate());
                            gradeCertificate.setTrainStartTime(DateUtil.convertDateToString((Date)gradeClass.getPracticeStartDate(), (String)"yyyy-MM-dd"));
                            gradeCertificate.setTrainEndTime(DateUtil.convertDateToString((Date)gradeClass.getPracticeEndDate(), (String)"yyyy-MM-dd"));
                        } else {
                            gradeCertificate.setTrainTime(personGrade.getCheckDate());
                            gradeCertificate.setTrainStartTime(DateUtil.convertDateToString((Date)personGrade.getCheckDate(), (String)"yyyy-MM-dd"));
                            gradeCertificate.setTrainEndTime(DateUtil.getCurrentDate((String)"yyyy-MM-dd"));
                        }
                        if (trainCom != null) {
                            gradeCertificate.setUserId(trainCom.getUserid());
                        }
                        gradeCertificate.setGender(IdNumUtil.getGenderByIdCard((String)dbPersonGrade.getIdNum()));
                    }
                    try {
                        if (StringUtil.isNotEmpty((String)dbPersonGrade.getCerDate())) {
                            gradeCertificate.setCerDate(DateUtil.convertStringToDate((String)dbPersonGrade.getCerDate()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    gradeCertificate.setCertificateNo(dbPersonGrade.getCerNo());
                    gradeCertificate.setPersonId(person.getId());
                    gradeCertificate.setUpdateTime(new Date());
                    gradeCertificate.setActive(Boolean.valueOf(true));
                    gradeCerList.add(gradeCertificate);
                }
                if (!"1".equals(personGrade.getTestStateComplete()) || (roster = this.gradeSubsidyRosterDao.findByIdNumAndType(dbPersonGrade.getIdNum(), Constants.SUBSIDYCERTYPE_DJZ)) != null && Constants.USED_Y.equals(roster.getUsed())) continue;
                if (roster == null) {
                    roster = new GradeSubsidyRoster();
                    roster.setId(Long.valueOf(this.idWorker.nextId()));
                    roster.setCreateTime(new Date());
                    roster.setGradeId(dbPersonGrade.getId());
                    roster.setActive(Boolean.valueOf(true));
                    roster.setUsed(Constants.USED_N);
                    roster.setUpdateflag(Boolean.valueOf(false));
                    roster.setSubsidyCerType(SubsidyCerType.GRADE.getCode());
                    roster.setName(dbPersonGrade.getName());
                    roster.setIdNum(dbPersonGrade.getIdNum());
                    roster.setPhone(dbPersonGrade.getPhone());
                    roster.setOrgId(dbPersonGrade.getOrgId());
                    roster.setTrainId(dbPersonGrade.getTrainId());
                    roster.setTrainName(dbPersonGrade.getTrainName());
                    roster.setCompanyId(dbPersonGrade.getComId());
                    roster.setCompanyName(dbPersonGrade.getComName());
                    roster.setResidentNature(dbPersonGrade.getResidentType());
                    roster.setResidentPlace(dbPersonGrade.getResidentPlaceType());
                    roster.setCerDate(dbPersonGrade.getCerDate());
                    roster.setCerNo(dbPersonGrade.getCerNo());
                    roster.setSubsidyType("\u4fdd\u5b89\u5458\u57f9\u8bad\u8865\u8d34");
                    roster.setSubsidyPeopleType("\u57f9\u8bad\u673a\u6784");
                    roster.setCertificateProfession("\u4fdd\u5b89\u5458");
                    roster.setCertificateGrade("\u4e94\u7ea7");
                    roster.setTrainProfession("\u4fdd\u5b89\u5458");
                    roster.setTrainGrade("\u4e94\u7ea7");
                    roster.setClassHour("161");
                    roster.setSex(IdNumUtil.getSexByIdCard((String)dbPersonGrade.getIdNum()));
                    if (dbPersonGrade.getOrgId() != null) {
                        Police police = this.policeDao.findById(dbPersonGrade.getOrgId());
                        roster.setOrgName(police.getOrgname());
                    }
                    roster.setAreaCode(dbPersonGrade.getAreaCode());
                    subsidyBusinessType = Constants.SUBSIDYBUSINESSTYPE_001;
                    platSerFeeType = Constants.SUBSIDYBUSINESSTYPE_007;
                    roster.setCertificateType("\u7ed3\u4e1a\u8bc1");
                    roster.setCompleteCerDate(completeCer.getCerDate());
                    roster.setCompleteCerNo(completeCer.getCerNo());
                    try {
                        subsidyConfig = (SubsidyConfig)subsidyConfigMap.get(subsidyBusinessType);
                        roster.setCompleteMoneyRate(subsidyConfig.getPercent());
                        roster.setCompleteMoney(subsidyConfig.getAmount().toString());
                    }
                    catch (Exception e) {
                        throw new ArsException("\u8865\u8d34\u91d1\u989d\u914d\u7f6e\u9519\u8bef");
                    }
                    if (trainCom != null) {
                        roster.setSocialCode(trainCom.getSocialCode());
                    }
                    roster.setTrainBeginDate(dbPersonGrade.getCheckDate());
                    roster.setTrainEndDate(gradeClass.getPracticeEndDate());
                    roster.setCertificateDate(completeCer.getCerDate());
                    roster.setCertificateNumber(completeCer.getCerNo());
                }
                roster.setUpdateTime(new Date());
                roster.setSubsidyStatus(Constants.SUBSIDYSTATUS_DBD);
                roster.setContractStartTime(dbPersonGrade.getContractStart());
                roster.setContractEndTime(dbPersonGrade.getContractEnd());
                roster.setInAppraisal(Boolean.valueOf(true));
                if ("1".equals(personGrade.getTestState())) {
                    subsidyBusinessType = Constants.SUBSIDYBUSINESSTYPE_002;
                    platSerFeeType = Constants.SUBSIDYBUSINESSTYPE_008;
                    try {
                        subsidyConfig = (SubsidyConfig)subsidyConfigMap.get(subsidyBusinessType);
                        roster.setAppraisalMoneyRate(subsidyConfig.getPercent());
                        roster.setAppraisalMoney(subsidyConfig.getAmount().toString());
                    }
                    catch (Exception e) {
                        throw new ArsException("\u8865\u8d34\u91d1\u989d\u914d\u7f6e\u9519\u8bef");
                    }
                    roster.setCertificateDate(dbPersonGrade.getCerDate());
                    roster.setCertificateNumber(dbPersonGrade.getCerNo());
                    roster.setCertificateType("\u6280\u80fd\u7b49\u7ea7\u8bc1");
                } else if ("0".equals(personGrade.getWrittenScore()) && "0".equals(personGrade.getOperateScore())) {
                    roster.setInAppraisal(Boolean.valueOf(false));
                }
                try {
                    subsidyConfig = (SubsidyConfig)subsidyConfigMap.get(subsidyBusinessType);
                    roster.setSubsidyMoneyRate(subsidyConfig.getPercent());
                    if (roster.getInAppraisal().booleanValue()) {
                        roster.setSubsidyMoney(String.valueOf(subsidyConfig.getAmount() + amount));
                    } else {
                        roster.setSubsidyMoney(subsidyConfig.getAmount().toString());
                    }
                }
                catch (Exception e) {
                    throw new ArsException("\u8865\u8d34\u91d1\u989d\u914d\u7f6e\u9519\u8bef");
                }
                try {
                    roster.setPlatSerFee(platSerFeeSubsidyConfig.getAmount().toString());
                }
                catch (Exception e) {
                    throw new ArsException("\u5e73\u53f0\u670d\u52a1\u8d39\u91d1\u989d\u914d\u7f6e\u9519\u8bef");
                }
                rosterList.add(roster);
            }
            this.personGradeDaoAop.saveBatch(dbList);
            if (completeCerList.size() > 0) {
                this.gradeCompleteCerDao.saveBatch(completeCerList);
                this.sendCompleteCerToSAAS(completeCerList);
            }
            if (personList.size() > 0) {
                this.securityPersonDaoAop.updateBatch(personList);
            }
            if (rosterList.size() > 0) {
                this.gradeSubsidyRosterDaoAop.saveBatch(rosterList);
            }
            if (gradeCerList.size() > 0) {
                this.gradeCertificateDao.saveBatch(gradeCerList);
                this.sendAppraisalCerToSAAS(gradeCerList);
            }
        } else {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u62a5\u540d\u5217\u8868\u4e3a\u7a7a\u6216\u80cc\u666f\u7b5b\u67e5\u672a\u901a\u8fc7");
            return ajaxResult;
        }
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    public AjaxResult cancelGradeCertificateApply(String gradeCertificateId) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeCertificateId).getSubject();
        PersonGrade personGrade = this.personGradeDao.findById(Long.valueOf(subject));
        if (personGrade == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return ajaxResult;
        }
        String censorStatus = personGrade.getCensorStatus();
        List appealList = this.appealDao.findByBusinessIdAndType(subject, "003");
        boolean isAppeal = false;
        for (Appeal appeal : appealList) {
            if (!"002".equals(appeal.getAppealState())) continue;
            isAppeal = true;
            break;
        }
        GradeClass gradeClass = this.gradeClassDao.findById(personGrade.getClassId());
        String classState = personGrade.getClassState();
        if (censorStatus != null && censorStatus.equals("0") || isAppeal || classState != null && classState.equals("1") || gradeClass != null && gradeClass.getApprovalState() != null && gradeClass.getApprovalState().equals("002")) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u80cc\u666f\u7b5b\u67e5\u4e2d\u3001\u7533\u8bc9\u4e2d\u3001\u5f00\u73ed\u5ba1\u6838\u4e2d\u3001\u5df2\u5f00\u73ed\u4e0d\u80fd\u64a4\u9500");
            return ajaxResult;
        }
        personGrade.setApprovalState("3");
        this.personGradeDaoAop.update(personGrade);
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    public AjaxResult canSignUpGradeCertificate(String idNumbers) {
        String subject = JwtUtil.parseJWT((String)idNumbers).getSubject();
        List idNumbersList = JSON.parseArray((String)subject, String.class);
        HashSet idNumbersSet = Sets.newHashSet((Iterable)idNumbersList);
        AjaxResult ajaxResult = new AjaxResult();
        if (CollectionUtil.isEmpty((Collection)idNumbersSet)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u53c2\u6570");
            return ajaxResult;
        }
        HashMap resultData = Maps.newHashMap();
        List appliedIdNumbers = this.personGradeDao.findAppliedByIdNumbers((Set)idNumbersSet);
        List resultIdNumbers = this.gradeCertificateDao.listIdNumbers((Set)idNumbersSet);
        Iterator iterator = idNumbersSet.iterator();
        while (iterator.hasNext()) {
            String idNumber;
            resultData.put(idNumber, !resultIdNumbers.contains(idNumber = (String)iterator.next()) && !appliedIdNumbers.contains(idNumber) && this.validApply(idNumber).isSuccessful());
        }
        ajaxResult.setData((Object)JwtUtil.createJWT((String)JSON.toJSONString((Object)resultData)));
        ajaxResult.setMsg("\u67e5\u8be2\u6210\u529f");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    private AjaxResult validApply(String idNum) {
        AjaxResult ajaxResult = new AjaxResult();
        ajaxResult.setSuccessful(true);
        if (StringUtil.isNotBlank((CharSequence)idNum)) {
            int age = IdNumUtil.getAgeByIdCard((String)idNum);
            if (age < 18 || age > 59) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u5e74\u9f84\u4e0d\u7b26\u5408\u8981\u6c42");
                return ajaxResult;
            }
            SecurityPerson securityPerson = this.securityPersonDao.findByIdCard(idNum);
            String credential = securityPerson.getZgcredential();
            if (StringUtil.isBlank((CharSequence)credential)) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u4fdd\u5b89\u5458\u8bc1\u4e66\u4e0d\u5b58\u5728");
                return ajaxResult;
            }
            PersonGrade personGradeInfo = this.personGradeDao.findByIdNumber(idNum);
            String approvalState = personGradeInfo.getApprovalState();
            if ("0".equals(approvalState) || "1".equals(approvalState)) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u91cd\u590d\u62a5\u540d");
                return ajaxResult;
            }
        }
        return ajaxResult;
    }
}

