/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.PerCheckRecordDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.PerCheckRecordPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.PerCheckRecord;
import com.bcxin.ars.service.sb.PerCheckRecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerCheckRecordServiceImpl
implements PerCheckRecordService {
    Logger logger = LoggerFactory.getLogger(PerCheckRecordServiceImpl.class);
    @Autowired
    private PerCheckRecordDao perCheckRecordDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(PerCheckRecord perCheckRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        perCheckRecord.setUpdateTime(new Date());
        perCheckRecord.setUpdateBy(currentUser.getUsername());
        return this.perCheckRecordDao.delete(perCheckRecord);
    }

    public int save(PerCheckRecord perCheckRecord) {
        if (perCheckRecord.getId() == null) {
            perCheckRecord.setCreateTime(new Date());
        } else {
            PerCheckRecord dbPerCheckRecord = this.perCheckRecordDao.findById(perCheckRecord.getId());
            BeanUtils.copyPropertiesIgnore((Object)perCheckRecord, (Object)dbPerCheckRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbPerCheckRecord, (Object)perCheckRecord, (Boolean)false);
        }
        perCheckRecord.setActive(Boolean.valueOf(true));
        perCheckRecord.setUpdateTime(new Date());
        perCheckRecord.setUpdateflag(Boolean.valueOf(true));
        return this.perCheckRecordDao.save(perCheckRecord);
    }

    public PerCheckRecord findById(Long id) {
        return this.perCheckRecordDao.findById(id);
    }

    public void searchForPage(PerCheckRecordPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.perCheckRecordDao.searchForPage(dto, page);
    }

    public void importBatch(List<PerCheckRecord> list) {
        List dbList = this.perCheckRecordDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PerCheckRecord perCheckRecord : list) {
                perCheckRecord.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    perCheckRecord.setUpdateTime(DateUtil.dateAdd((int)6, (Date)perCheckRecord.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.perCheckRecordDao.saveBatch(list);
        }
    }

    public List<PerCheckRecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.perCheckRecordDao.searchForDataSynchronization(dto);
    }

    public List<PerCheckRecord> findDSOutList(String startDate) {
        return this.perCheckRecordDao.findDSOutList(startDate);
    }

    public List<PerCheckRecord> findByBatchId(List<PerCheckRecord> list) {
        return this.perCheckRecordDao.findByBatchId(list);
    }

    public void updateSelective(PerCheckRecord perCheckRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        perCheckRecord.setUpdateTime(new Date());
        perCheckRecord.setUpdateBy(currentUser.getUsername());
        this.perCheckRecordDao.updateSelective(perCheckRecord);
    }
}

