/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.LegalchangeworkexperienceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.LegalchangeworkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Legalchangeworkexperience;
import com.bcxin.ars.service.sb.LegalchangeworkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Legalchangeworkexperience.class)
public class LegalchangeworkexperienceServiceImpl
implements LegalchangeworkexperienceService {
    @Autowired
    private LegalchangeworkexperienceDao workexperienceDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    public Legalchangeworkexperience findById(long id) {
        return this.workexperienceDao.findById(id);
    }

    public void saveOrUpdate(Legalchangeworkexperience workexperience) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (workexperience.getId() == null) {
            workexperience.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            workexperience.setActive(Boolean.valueOf(true));
            workexperience.setCreateTime(new Date());
            workexperience.setUpdateTime(new Date());
            workexperience.setUpdateBy(currentUser.getUsername());
            this.workexperienceDao.save(workexperience);
        } else {
            Legalchangeworkexperience dbLegalchangeworkexperience = this.workexperienceDao.findById(workexperience.getId().longValue());
            dbLegalchangeworkexperience.setUpdateTime(new Date());
            dbLegalchangeworkexperience.setCompanyname(workexperience.getCompanyname());
            dbLegalchangeworkexperience.setEnddate(workexperience.getEnddate());
            dbLegalchangeworkexperience.setPost(workexperience.getPost());
            dbLegalchangeworkexperience.setStartdate(workexperience.getStartdate());
            dbLegalchangeworkexperience.setUpdateBy(currentUser.getUsername());
            dbLegalchangeworkexperience.setUpdateTime(new Date());
            this.workexperienceDao.update(dbLegalchangeworkexperience);
        }
    }

    public LegalchangeworkexperienceSearchDto search(LegalchangeworkexperienceSearchDto dto) {
        LegalchangeworkexperienceSearchDto resultDto = new LegalchangeworkexperienceSearchDto();
        List list = this.workexperienceDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.workexperienceDao.searchCount(dto));
        return resultDto;
    }

    public void delete(Long workexperienceId) {
        User currentUser = this.arsUtil.getCurrentUser();
        Legalchangeworkexperience workexperience = this.workexperienceDao.findById(workexperienceId.longValue());
        workexperience.setUpdateBy(currentUser.getUsername());
        workexperience.setUpdateTime(new Date());
        this.workexperienceDao.delete(workexperience);
    }

    public void deleteByLegalchangeId(Long legalchangeId) {
        User currentUser = this.arsUtil.getCurrentUser();
        Legalchangeworkexperience workexperience = new Legalchangeworkexperience();
        workexperience.setLegalchangeId(legalchangeId);
        workexperience.setUpdateBy(currentUser.getUsername());
        workexperience.setUpdateTime(new Date());
        this.workexperienceDao.deleteByLegalchangeId(workexperience);
    }

    public List<Legalchangeworkexperience> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.workexperienceDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(Legalchangeworkexperience legalchangeworkexperience) {
        Legalchangeworkexperience dbLegalchangeworkexperience;
        if (legalchangeworkexperience.getActive() == null) {
            legalchangeworkexperience.setActive(Boolean.valueOf(true));
        }
        if ((dbLegalchangeworkexperience = this.workexperienceDao.findById(legalchangeworkexperience.getId().longValue())) != null) {
            if (legalchangeworkexperience.getUpdateTime().getTime() > dbLegalchangeworkexperience.getUpdateTime().getTime()) {
                this.workexperienceDao.update(legalchangeworkexperience);
            }
        } else {
            this.workexperienceDao.saveForDS(legalchangeworkexperience);
        }
    }

    public List<Legalchangeworkexperience> findByLegalchangeId(Long legalchangeId) {
        return this.workexperienceDao.findByLegalchangeId(legalchangeId);
    }
}

