/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.nxWeb.impl;

import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.nxWeb.NXWebService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DES3;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NXWebServiceImpl
implements NXWebService {
    Logger logger = LoggerFactory.getLogger(NXWebServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private LoginLogService loginLogService;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private UserDao userDao;
    @Autowired
    private RegisterpersonService registerpersonService;
    @Value(value="${message-code-timeout}")
    private int messageCodeTimeout = 2;
    @Value(value="${login-timeout}")
    private int loginTimeout = 10;
    @Value(value="${JWT_SECRET}")
    public String JWT_SECRET = "";
    @Value(value="${BLB_PARTY}")
    public String BLB_PARTY = "ARS-NC";

    public AjaxResult verifySX(String phone, String key, HttpServletRequest request) {
        AjaxResult ajaxResult;
        block9: {
            ajaxResult = new AjaxResult();
            try {
                if ("BCXIN-ARS-NX-640000".equals(DES3.decode((String)key))) {
                    User user = new User();
                    user.setPhone(phone);
                    List data = this.userDao.searchByDto(user);
                    if (data.size() == 0) {
                        AjaxResult userAjaxResult = this.registerpersonService.SXNWregister(user);
                        if (!userAjaxResult.isSuccessful()) {
                            ajaxResult.setState(Constants.STATUS_ERROR);
                            ajaxResult.setMsg("\u6ce8\u518c\u5931\u8d25");
                            throw new ArsException("\u6ce8\u518c\u5931\u8d25\uff01");
                        }
                        user.setPassword(phone.substring(phone.length() - 6, phone.length()));
                    } else {
                        user = (User)data.get(0);
                    }
                    AjaxResult loginAjaxResult = new AjaxResult();
                    try {
                        loginAjaxResult = this.webLogin(user.getUsername(), user.getPassword(), request);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setSuccessful(false);
                        ajaxResult.setMsg("\u767b\u5f55\u5931\u8d25");
                    }
                    if (!loginAjaxResult.isSuccessful()) {
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setMsg("\u767b\u5f55\u5931\u8d25");
                        ajaxResult.setSuccessful(false);
                        throw new ArsException("\u767b\u5f55\u5931\u8d25\uff01");
                    }
                    ajaxResult.setState(Constants.STATUS_SUCCESS);
                    ajaxResult.setSuccessful(true);
                    break block9;
                }
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            }
            catch (Exception e) {
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        return ajaxResult;
    }

    public AjaxResult webLogin(String username, String password, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            token.setHost(String.valueOf(4));
            try {
                currentUser.login((AuthenticationToken)token);
            }
            catch (AuthenticationException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                result.setSuccessful(false);
                result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
            }
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = this.userService.findByUsername(username, String.valueOf(4));
                System.out.println("\u5f53\u524d\u767b\u5f55\u7528\u6237\u662f\uff1a" + user.getUsername());
                user.setLoginstate(Integer.valueOf(1));
                if (user.getLoginNum() != null) {
                    user.setLoginNum(Integer.valueOf(user.getLoginNum() + 1));
                } else {
                    user.setLoginNum(Integer.valueOf(1));
                }
                user.setLoginDate(new Date());
                this.userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                this.arsUtil.setCurrentUser(user, 120000 * this.loginTimeout);
                result.setData((Object)user);
                result.setSuccessful(true);
                this.loginLogService.logIn(request);
            }
        }
        catch (UnknownAccountException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (IncorrectCredentialsException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (ExcessiveAttemptsException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u767b\u5f55\u5931\u8d25\u591a\u6b21\uff0c\u8d26\u6237\u9501\u5b9a10\u5206\u949f");
        }
        catch (AuthenticationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return result;
    }
}

